# isort:skip_file
# fmt:off
#
# this __init__.py file is generated by __generate_init.py
# do not edit it directly or testing will fail
import importlib
import logging
import sys
import typing

from .version import __version__


def _force_eager_imports() -> None:
    current_module = sys.modules[__name__]

    for attribute_set in _LAZY_IMPORT_TABLE.values():
        for attr in attribute_set:
            getattr(current_module, attr)


_LAZY_IMPORT_TABLE = {
    "authorizers": {
        "AccessTokenAuthorizer",
        "BasicAuthorizer",
        "ClientCredentialsAuthorizer",
        "NullAuthorizer",
        "RefreshTokenAuthorizer",
    },
    "client": {
        "BaseClient",
    },
    "exc": {
        "GlobusAPIError",
        "GlobusConnectionError",
        "GlobusConnectionTimeoutError",
        "GlobusError",
        "GlobusSDKUsageError",
        "GlobusTimeoutError",
        "NetworkError",
    },
    "local_endpoint": {
        "GlobusConnectPersonalOwnerInfo",
        "LocalGlobusConnectPersonal",
    },
    "response": {
        "GlobusHTTPResponse",
    },
    "services.auth": {
        "AuthAPIError",
        "AuthClient",
        "ConfidentialAppAuthClient",
        "IdentityMap",
        "NativeAppAuthClient",
        "OAuthDependentTokenResponse",
        "OAuthTokenResponse",
    },
    "services.gcs": {
        "CollectionDocument",
        "GCSAPIError",
        "GCSClient",
        "GCSRoleDocument",
        "GuestCollectionDocument",
        "MappedCollectionDocument",
        "StorageGatewayDocument",
        "StorageGatewayPolicies",
        "POSIXStoragePolicies",
        "POSIXStagingStoragePolicies",
        "BlackPearlStoragePolicies",
        "BoxStoragePolicies",
        "CephStoragePolicies",
        "GoogleDriveStoragePolicies",
        "GoogleCloudStoragePolicies",
        "OneDriveStoragePolicies",
        "AzureBlobStoragePolicies",
        "S3StoragePolicies",
        "ActiveScaleStoragePolicies",
        "IrodsStoragePolicies",
        "HPSSStoragePolicies",
    },
    "services.groups": {
        "BatchMembershipActions",
        "GroupMemberVisibility",
        "GroupPolicies",
        "GroupRequiredSignupFields",
        "GroupRole",
        "GroupsAPIError",
        "GroupsClient",
        "GroupsManager",
        "GroupVisibility",
    },
    "services.search": {
        "SearchAPIError",
        "SearchClient",
        "SearchQuery",
        "SearchScrollQuery",
    },
    "services.timer": {
        "TimerAPIError",
        "TimerClient",
        "TimerJob",
    },
    "services.transfer": {
        "ActivationRequirementsResponse",
        "DeleteData",
        "IterableTransferResponse",
        "TransferAPIError",
        "TransferClient",
        "TransferData",
    },
}

if typing.TYPE_CHECKING or sys.version_info < (3, 7):
    from .authorizers import AccessTokenAuthorizer
    from .authorizers import BasicAuthorizer
    from .authorizers import ClientCredentialsAuthorizer
    from .authorizers import NullAuthorizer
    from .authorizers import RefreshTokenAuthorizer
    from .client import BaseClient
    from .exc import GlobusAPIError
    from .exc import GlobusConnectionError
    from .exc import GlobusConnectionTimeoutError
    from .exc import GlobusError
    from .exc import GlobusSDKUsageError
    from .exc import GlobusTimeoutError
    from .exc import NetworkError
    from .local_endpoint import GlobusConnectPersonalOwnerInfo
    from .local_endpoint import LocalGlobusConnectPersonal
    from .response import GlobusHTTPResponse
    from .services.auth import AuthAPIError
    from .services.auth import AuthClient
    from .services.auth import ConfidentialAppAuthClient
    from .services.auth import IdentityMap
    from .services.auth import NativeAppAuthClient
    from .services.auth import OAuthDependentTokenResponse
    from .services.auth import OAuthTokenResponse
    from .services.gcs import CollectionDocument
    from .services.gcs import GCSAPIError
    from .services.gcs import GCSClient
    from .services.gcs import GCSRoleDocument
    from .services.gcs import GuestCollectionDocument
    from .services.gcs import MappedCollectionDocument
    from .services.gcs import StorageGatewayDocument
    from .services.gcs import StorageGatewayPolicies
    from .services.gcs import POSIXStoragePolicies
    from .services.gcs import POSIXStagingStoragePolicies
    from .services.gcs import BlackPearlStoragePolicies
    from .services.gcs import BoxStoragePolicies
    from .services.gcs import CephStoragePolicies
    from .services.gcs import GoogleDriveStoragePolicies
    from .services.gcs import GoogleCloudStoragePolicies
    from .services.gcs import OneDriveStoragePolicies
    from .services.gcs import AzureBlobStoragePolicies
    from .services.gcs import S3StoragePolicies
    from .services.gcs import ActiveScaleStoragePolicies
    from .services.gcs import IrodsStoragePolicies
    from .services.gcs import HPSSStoragePolicies
    from .services.groups import BatchMembershipActions
    from .services.groups import GroupMemberVisibility
    from .services.groups import GroupPolicies
    from .services.groups import GroupRequiredSignupFields
    from .services.groups import GroupRole
    from .services.groups import GroupsAPIError
    from .services.groups import GroupsClient
    from .services.groups import GroupsManager
    from .services.groups import GroupVisibility
    from .services.search import SearchAPIError
    from .services.search import SearchClient
    from .services.search import SearchQuery
    from .services.search import SearchScrollQuery
    from .services.timer import TimerAPIError
    from .services.timer import TimerClient
    from .services.timer import TimerJob
    from .services.transfer import ActivationRequirementsResponse
    from .services.transfer import DeleteData
    from .services.transfer import IterableTransferResponse
    from .services.transfer import TransferAPIError
    from .services.transfer import TransferClient
    from .services.transfer import TransferData

else:

    def __getattr__(name: str) -> typing.Any:
        for modname, items in _LAZY_IMPORT_TABLE.items():
            if name in items:
                mod = importlib.import_module("." + modname, __name__)
                return getattr(mod, name)

        raise AttributeError(f"module {__name__} has no attribute {name}")


__all__ = (
    "__version__",
    "_force_eager_imports",
    "AccessTokenAuthorizer",
    "BasicAuthorizer",
    "ClientCredentialsAuthorizer",
    "NullAuthorizer",
    "RefreshTokenAuthorizer",
    "BaseClient",
    "GlobusAPIError",
    "GlobusConnectionError",
    "GlobusConnectionTimeoutError",
    "GlobusError",
    "GlobusSDKUsageError",
    "GlobusTimeoutError",
    "NetworkError",
    "GlobusConnectPersonalOwnerInfo",
    "LocalGlobusConnectPersonal",
    "GlobusHTTPResponse",
    "AuthAPIError",
    "AuthClient",
    "ConfidentialAppAuthClient",
    "IdentityMap",
    "NativeAppAuthClient",
    "OAuthDependentTokenResponse",
    "OAuthTokenResponse",
    "CollectionDocument",
    "GCSAPIError",
    "GCSClient",
    "GCSRoleDocument",
    "GuestCollectionDocument",
    "MappedCollectionDocument",
    "StorageGatewayDocument",
    "StorageGatewayPolicies",
    "POSIXStoragePolicies",
    "POSIXStagingStoragePolicies",
    "BlackPearlStoragePolicies",
    "BoxStoragePolicies",
    "CephStoragePolicies",
    "GoogleDriveStoragePolicies",
    "GoogleCloudStoragePolicies",
    "OneDriveStoragePolicies",
    "AzureBlobStoragePolicies",
    "S3StoragePolicies",
    "ActiveScaleStoragePolicies",
    "IrodsStoragePolicies",
    "HPSSStoragePolicies",
    "BatchMembershipActions",
    "GroupMemberVisibility",
    "GroupPolicies",
    "GroupRequiredSignupFields",
    "GroupRole",
    "GroupsAPIError",
    "GroupsClient",
    "GroupsManager",
    "GroupVisibility",
    "SearchAPIError",
    "SearchClient",
    "SearchQuery",
    "SearchScrollQuery",
    "TimerAPIError",
    "TimerClient",
    "TimerJob",
    "ActivationRequirementsResponse",
    "DeleteData",
    "IterableTransferResponse",
    "TransferAPIError",
    "TransferClient",
    "TransferData",
)


# configure logging for a library, per python best practices:
# https://docs.python.org/3/howto/logging.html#configuring-logging-for-a-library
logging.getLogger("globus_sdk").addHandler(logging.NullHandler())
