# infusevideo-sdk

This is the Infuse Video SDK for Python.

At the moment, this is a very basic initial version that takes care of authentication, and
otherwise exposes a simple REST client. More features and documentation are going to come soon.

## Requirements
* [Python](https://www.python.org/) 3.9 or newer

## Installation
It's always advisable to setup a [virtualenv](https://docs.python.org/3/library/venv.html) when
working with third-party packages, in order to keep this package and dependencies from cluttering
the globally installed packages, and vice versa. If you do not know how to set one up, refer to the
[Python documentation on venv](https://docs.python.org/3/library/venv.html).

After creating and also activating the virtualenv, installation is as simple as

	pip install infusevideo-sdk

This will install a package named `infusevideo`, containing the SDK, into the virtualenv.

## Usage
In the current state, this is a simple wrapper around a REST/HTTP client. The `InfuseVideo` class
exposes five methods (`get`, `post`, `patch`, `put` and `delete`) indicating their respective HTTP
counterparts.

### API documentation
Please refer to [the current API documentation](https://api.infuse.video/apidoc/redoc) for an
overview of available actions on the API, request parameters and expected return values.
Authentication is already taken care of by the SDK, so that section of the API documentation may
be skipped.

### Example code
Simple code that calls the [List media](https://api.infuse.video/apidoc/redoc#operation/get_/media)
route on the Media endpoint:

	import infusevideo

	api = infusevideo.InfuseVideo()
	result = api.get("/media")
	print(result)

#### Creating a sample configuration file
Your organization ID is required when making requests to the API. This is stored in a configuration
file (normally located in the `.infusevideo/` directory in your home directory). If you have not
yet created this file, you can do so using the following code:

	import infusevideo

	yourOrganizationId = "org_abcdefgh..."
	path = infusevideo.Config.generate_sample_config(yourOrganizationId)
	print(path)

This will create a sample configuration file with a default profile using your supplied
organization ID. It will then print the path where the configuration file was created, fur future
reference. For most people, executing this step once is sufficient to use the SDK.
