from django.db import models


class AesiMethodsModelMixin(models.Model):
    def __str__(self):
        return f"{self.action_identifier[-9:]}"

    def save(self, *args, **kwargs):
        self.subject_identifier = self.ae_initial.subject_identifier
        super().save(*args, **kwargs)

    def natural_key(self):
        return (self.action_identifier,)  # noqa

    class Meta:
        abstract = True
