# grab - a Reddit download bot

This is a simple Python script to download submissions from any specified subreddit.  
All images are placed in the ~/Downloads/grab-bot/[subreddit]/[date] by default. The download path however can be changed through the GUI or config file.  
"grab.ini" is the configuration file used by the program. It will be generated with default values in case it is not present when gui.py is run.  
"downloaded.txt" lists all previously downloaded images from their subreddit. This was done to avoid downloading images multiple times in an effort to save bandwidth and make subsequent executions of the program faster.

## TODO

- [X] GUI for selecting subreddits
- [X] Change download location through GUI
- [X] Change the download limit
- [X] Change the category
- [ ] Make the GUI look better
- [ ] Create CLI options for grab.py to create config files in the terminal (Mostly done. Needs an option to show the config, remove subs and prevent duplicates)
- [ ] Automatically schedule program execution (Can be done manually with cron)
- [ ] CLI option for launching the gui

## How to use

Follow the installation instructions.  
To add subreddits open gui.py, click on the "+" Button and type in the subreddit you want to add.  
To remove a subreddit, select one from the list and click on the "-" in the top right. Click yes in the following dialog.  
Clicking ">" will expand the window to change the category, limit and download path. Clicking "Run" in the GUI will execute grab.py.  
The theme can be changed by clicking on "light" or "dark". The dark theme is still work in progress.  

If you want to use the program in the terminal without the GUI, execute grab.py with python.  
`grab.py -h` lists all available commands and their descriptions.

Setting up cron for repeated executions is covered below.

## Installation

This Python script was built for Python 3.5+.*  
To install all requirements follow the instructions below.

Arch:  
`sudo pacman -S python-pip tk`  
`pip install --user praw Pillow`  

Debian:  
`sudo apt-get install git python3-pip python3-tk python-configparser`  
`pip3 install praw Pillow`  

Fedora:  
`sudo dnf install python3 python3-wheel python3-tkinter`  
`pip install --user praw Pillow`  

Clone the repository  
`git clone https://gitlab.com/RealStickman/grab.git`

Execute the python files with `python <file>` or `python3 <file>` for Debian.

**See Configurations for systems that have been tested.*

## Known Bugs

1. ~~Some images can't be opened.~~ Fixed by using Pillow to check images after the download.
2. ~~Can't currently click "Run" in the GUI and have the program work in Debian. Launching grab.py directly works.~~ Fixed in Commit 2538a8fefe17755868b2fbd0e01d43aa7411b58f

## Configurations

Fresh install unless noted otherwise

| Distro | Python Version | Notes |
| ------ | ------ | ------ |
| Arcolinux | 3.8.5 |  |
| Fedora 32 | 3.8.5 |  |
| Debian 10 | 3.7.3 |  |

**Configurations are only tested with the master branch*

### Cron

Change the directory to the location where the grab.py file is located and execute it with python. In Debian you have to specify python3 instead of python. The change of location is done to make sure the program is initialized with the working directory where the .subr files are located.  
`cd /<directory> && python grab.py`  

Example setup for hourly execution  
`0 * * * * cd /home/<user>/scripts && python grab.py`
