# -*- coding: ISO-8859-1 -*-
#
# generated by wxGlade 0.9.3 on Thu Jun 27 21:45:40 2019
#
import copy
import os
import sys
import threading
import traceback

try:
    from math import tau
except ImportError:
    from math import pi

    tau = pi * 2

import wx
import wx.aui as aui
import wx.ribbon as RB

from .about import About
from .alignment import Alignment
from .bufferview import BufferView
from .camerainteface import CameraInterface
from .controller import Controller
from ..core.cutplanner import CutPlanner
from ..core.laseroperation import LaserOperation, CommandOperation
from .devicemanager import DeviceManager
from .icons import (
    icons8_end_50,
    icons8_opened_folder_50,
    icons8_save_50,
    icons8_laser_beam_52,
    icons8_pause_50,
    icons8_move_50,
    icons8_usb_connector_50,
    icons8_route_50,
    icons8_connected_50,
    icons8_administrative_tools_50,
    icons8_manager_50,
    icons8_camera_50,
    icons8_keyboard_50,
    icons8_comments_50,
    icons8_console_50,
    icons8_roll_50,
    icons8_fantasy_50,
    icons8_lock_50,
    icon_meerk40t,
    icons8_laser_beam_20,
    icons8_direction_20,
    icons8_vector_20,
    icons8_file_20,
    icons8_padlock_50,
)
from .imageproperty import ImageProperty
from .jobpreview import JobPreview
from .jobspooler import JobSpooler
from ..kernel import Module, Job, STATE_BUSY
from .keymap import Keymap
from ..device.lasercommandconstants import (
    COMMAND_BEEP,
    COMMAND_JOG_FINISH,
    COMMAND_JOG_SWITCH,
    COMMAND_JOG,
    COMMAND_SET_ABSOLUTE,
    COMMAND_MODE_RAPID,
    COMMAND_HOME,
    COMMAND_LASER_OFF,
    COMMAND_WAIT_FINISH,
    COMMAND_MOVE,
    COMMAND_LASER_ON,
    COMMAND_WAIT,
    COMMAND_SET_SPEED,
    COMMAND_SET_DIRECTION,
    COMMAND_MODE_PROGRAM,
    COMMAND_FUNCTION,
    REALTIME_RESET,
)
from .laserrender import (
    LaserRender,
    DRAW_MODE_FILLS,
    DRAW_MODE_GUIDES,
    DRAW_MODE_BACKGROUND,
    DRAW_MODE_GRID,
    DRAW_MODE_LASERPATH,
    DRAW_MODE_RETICLE,
    DRAW_MODE_SELECTION,
    DRAW_MODE_STROKES,
    DRAW_MODE_ICONS,
    DRAW_MODE_TREE,
    DRAW_MODE_CACHE,
    DRAW_MODE_REFRESH,
    DRAW_MODE_ANIMATE,
    DRAW_MODE_PATH,
    DRAW_MODE_IMAGE,
    DRAW_MODE_TEXT,
    DRAW_MODE_FLIPXY,
    DRAW_MODE_INVERT,
    swizzlecolor,
)
from .navigation import Navigation
from .notes import Notes
from .operationproperty import OperationProperty
from .pathproperty import PathProperty
from .preferences import Preferences
from .rasterwizard import RasterWizard
from .rotarysettings import RotarySettings
from .settings import Settings
from ..svgelements import (
    SVGImage,
    Path,
    SVGText,
    SVG_ATTR_STROKE,
    Color,
    Matrix,
    Length,
    SVGElement,
    Angle,
)
from .terminal import Terminal
from .textproperty import TextProperty
from .usbconnect import UsbConnect
from .widget import (
    Scene,
    GridWidget,
    GuideWidget,
    ReticleWidget,
    ElementsWidget,
    SelectionWidget,
    LaserPathWidget,
    RectSelectWidget,
)

"""
Laser software for the Stock-LIHUIYU laserboard.

MeerK40t (pronounced MeerKat) is a built-from-the-ground-up MIT licensed
open-source laser cutting software. See https://github.com/meerk40t/meerk40t
for full details.

wxMeerK40t is the primary gui addon for MeerK40t. It requires wxPython for the interface.
The Transformations work in Windows/OSX/Linux for wxPython 4.0+ (and likely before)

"""

MILS_IN_MM = 39.3701
MEERK40T_ISSUES = "https://github.com/meerk40t/meerk40t/issues"
MEERK40T_WEBSITE = "https://github.com/meerk40t/meerk40t"


def plugin(kernel, lifecycle):
    if lifecycle == "register":
        kernel.register("module/wxMeerK40t", wxMeerK40t)
    if lifecycle == "boot":
        kernel_root = kernel.get_context("/")
        kernel_root.open("module/wxMeerK40t")
    elif lifecycle == "ready":
        kernel_root = kernel.get_context("/")
        meerk40tgui = kernel_root.open("module/wxMeerK40t")
        kernel_root.open("window/MeerK40t", None)
        meerk40tgui.MainLoop()

class IdInc:
    """
    Id Incrementor
    """

    def __init__(self):
        self.id_highest_value = wx.ID_HIGHEST

    def new(self):
        self.id_highest_value += 1
        return self.id_highest_value


idinc = IdInc()
ID_MAIN_TOOLBAR = idinc.new()
ID_ADD_FILE = idinc.new()
ID_OPEN = idinc.new()

ID_SAVE = idinc.new()
ID_NAV = idinc.new()
ID_USB = idinc.new()
ID_CONTROLLER = idinc.new()
ID_PREFERENCES = idinc.new()
ID_DEVICES = idinc.new()
ID_CAMERA = idinc.new()
ID_CAMERA1 = idinc.new()
ID_CAMERA2 = idinc.new()
ID_CAMERA3 = idinc.new()
ID_CAMERA4 = idinc.new()
ID_CAMERA5 = idinc.new()
ID_JOB = idinc.new()
ID_PAUSE = idinc.new()

ID_SPOOLER = idinc.new()
ID_KEYMAP = idinc.new()
ID_NOTES = idinc.new()
ID_OPERATIONS = idinc.new()
ID_TERMINAL = idinc.new()
ID_ROTARY = idinc.new()
ID_RASTER = idinc.new()

ID_CUT_CONFIGURATION = idinc.new()
ID_SELECT = idinc.new()

ID_MENU_IMPORT = idinc.new()
ID_MENU_RECENT = idinc.new()
ID_MENU_ZOOM_OUT = idinc.new()
ID_MENU_ZOOM_IN = idinc.new()
ID_MENU_ZOOM_SIZE = idinc.new()

# 1 fill, 2 grids, 4 guides, 8 laserpath, 16 writer_position, 32 selection
ID_MENU_HIDE_FILLS = idinc.new()
ID_MENU_HIDE_GUIDES = idinc.new()
ID_MENU_HIDE_GRID = idinc.new()
ID_MENU_HIDE_BACKGROUND = idinc.new()
ID_MENU_HIDE_STROKES = idinc.new()
ID_MENU_HIDE_ICONS = idinc.new()
ID_MENU_HIDE_TREE = idinc.new()
ID_MENU_HIDE_LASERPATH = idinc.new()
ID_MENU_HIDE_RETICLE = idinc.new()
ID_MENU_HIDE_SELECTION = idinc.new()
ID_MENU_SCREEN_REFRESH = idinc.new()
ID_MENU_SCREEN_ANIMATE = idinc.new()
ID_MENU_SCREEN_INVERT = idinc.new()
ID_MENU_SCREEN_FLIPXY = idinc.new()
ID_MENU_PREVENT_CACHING = idinc.new()
ID_MENU_HIDE_IMAGE = idinc.new()
ID_MENU_HIDE_PATH = idinc.new()
ID_MENU_HIDE_TEXT = idinc.new()

ID_MENU_FILE0 = idinc.new()
ID_MENU_FILE1 = idinc.new()
ID_MENU_FILE2 = idinc.new()
ID_MENU_FILE3 = idinc.new()
ID_MENU_FILE4 = idinc.new()
ID_MENU_FILE5 = idinc.new()
ID_MENU_FILE6 = idinc.new()
ID_MENU_FILE7 = idinc.new()
ID_MENU_FILE8 = idinc.new()
ID_MENU_FILE9 = idinc.new()
ID_MENU_FILE_CLEAR = idinc.new()

ID_MENU_ALIGNMENT = idinc.new()
ID_MENU_KEYMAP = idinc.new()
ID_MENU_DEVICE_MANAGER = idinc.new()
ID_MENU_SETTINGS = idinc.new()
ID_MENU_ROTARY = idinc.new()
ID_MENU_NAVIGATION = idinc.new()
ID_MENU_NOTES = idinc.new()
ID_MENU_OPERATIONS = idinc.new()
ID_MENU_CONTROLLER = idinc.new()
ID_MENU_CAMERA = idinc.new()
ID_MENU_TERMINAL = idinc.new()
ID_MENU_USB = idinc.new()
ID_MENU_SPOOLER = idinc.new()
ID_MENU_JOB = idinc.new()
ID_MENU_TREE = idinc.new()

_ = wx.GetTranslation
supported_languages = (
    ("en", u"English", wx.LANGUAGE_ENGLISH),
    ("it", u"italiano", wx.LANGUAGE_ITALIAN),
    ("fr", u"franais", wx.LANGUAGE_FRENCH),
    ("de", u"Deutsch", wx.LANGUAGE_GERMAN),
    ("es", u"espaol", wx.LANGUAGE_SPANISH),
    ("zh", u"Chinese", wx.LANGUAGE_CHINESE),
)


def resource_path(relative_path):
    """ Get absolute path to resource, works for dev and for PyInstaller """
    base_path = getattr(sys, "_MEIPASS", os.path.dirname(os.path.abspath(__file__)))
    return os.path.join(base_path, relative_path)


# TODO: _buffer can be updated partially rather than fully rewritten, especially with some layering.


class MeerK40t(wx.Frame, Module, Job):
    """
    MeerK40t main window
    """

    def __init__(self, context, path, parent, *args, **kwds):
        # begin wxGlade: MeerK40t.__init__
        wx.Frame.__init__(self, parent, -1, "", style=wx.DEFAULT_FRAME_STYLE)
        Module.__init__(self, context, path)
        Job.__init__(self, job_name="refresh_scene", process=self.refresh_scene)
        self.DragAcceptFiles(True)
        self._mgr = aui.AuiManager()

        # notify AUI which frame to use
        self._mgr.SetManagedWindow(self)

        self._Buffer = None
        self.screen_refresh_is_requested = False
        self.screen_refresh_is_running = False
        self.screen_refresh_lock = threading.Lock()
        self.background_brush = wx.Brush("Grey")
        self.renderer = LaserRender(context)
        self.laserpath = [[0, 0] for i in range(1000)], [[0, 0] for i in range(1000)]
        self.laserpath_index = 0
        self.working_file = None
        self.tree = wx.TreeCtrl(
            self, wx.ID_ANY, style=wx.TR_MULTIPLE | wx.TR_HIDE_ROOT | wx.TR_HAS_BUTTONS
        )
        self.scene = wx.Panel(self, style=wx.EXPAND | wx.WANTS_CHARS)
        self.scene.SetDoubleBuffered(True)

        self._ribbon = RB.RibbonBar(self, style=RB.RIBBON_BAR_DEFAULT_STYLE)
        self.ribbon_position_aspect_ratio = True
        self.ribbon_position_ignore_update = False
        self.ribbon_position_x = 0.0
        self.ribbon_position_y = 0.0
        self.ribbon_position_h = 0.0
        self.ribbon_position_w = 0.0
        self.ribbon_position_units = 0
        self.ribbon_position_name = None
        self.__set_ribbonbar()
        stop = wx.BitmapButton(self, wx.ID_ANY, icons8_end_50.GetBitmap())
        self.Bind(
            wx.EVT_BUTTON,
            lambda e: self.context.active.interpreter.realtime_command(REALTIME_RESET),
            stop,
        )
        stop.SetBackgroundColour(wx.Colour(127, 0, 0))
        stop.SetToolTip(_("Emergency stop/reset the controller."))
        stop.SetSize(stop.GetBestSize())
        self._mgr.AddPane(stop, aui.AuiPaneInfo().Bottom())
        #
        # home = wx.BitmapButton(self, wx.ID_ANY, icons8_home_filled_50.GetBitmap())
        # self.Bind(wx.EVT_BUTTON, lambda e: self.context.console("home\n"), home)
        # self._mgr.AddPane(home, aui.AuiPaneInfo().Bottom())

        # self.auiToolBar = wx.aui.AuiToolBar(self, wx.ID_ANY, wx.DefaultPosition, wx.DefaultSize,
        #                                     wx.aui.AUI_TB_HORZ_LAYOUT)
        # self.auiToolBar.AddTool(wx.ID_ANY, u"tool", icons8_home_filled_50.GetBitmap(),
        #                         wx.NullBitmap, wx.ITEM_NORMAL, wx.EmptyString, wx.EmptyString, None)
        # self.auiToolBar.Realize()
        # self._mgr.AddPane(self.auiToolBar,
        #                   wx.aui.AuiPaneInfo().Top().CaptionVisible(False).CloseButton(False).MaximizeButton(
        #                        False).MinimizeButton(False).PinButton(False).PaneBorder(False).Movable(
        #                        False).Dock().Fixed().DockFixed(False).Floatable(False).Layer(1))

        self._mgr.AddPane(
            self._ribbon,
            aui.AuiPaneInfo()
            .Top()
            .TopDockable()
            .BottomDockable()
            .RightDockable(False)
            .LeftDockable(False)
            .MinSize(-1, 150)
            .CaptionVisible(False),
        )
        self._mgr.AddPane(
            self.tree,
            aui.AuiPaneInfo()
            .CloseButton(False)
            .Left()
            .MinSize(200, -1)
            .MaxSize(275, -1)
            .LeftDockable()
            .RightDockable()
            .BottomDockable(False)
            .TopDockable(False),
        )
        self._mgr.AddPane(self.scene, aui.AuiPaneInfo().CenterPane())

        self._mgr.Update()

        self.CenterOnScreen()
        # Menu Bar
        self.main_menubar = wx.MenuBar()
        self.__set_menubar()

        self.main_statusbar = self.CreateStatusBar(3)

        # end wxGlade

        self.Bind(wx.EVT_DROP_FILES, self.on_drop_file)

        self.previous_position = None
        self.__set_properties()
        self.__do_layout()
        self.__scene_binds()

        self.scene.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.scene.Bind(wx.EVT_KEY_DOWN, self.on_key_down)

        self.tree.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.tree.Bind(wx.EVT_KEY_DOWN, self.on_key_down)
        self.Bind(wx.EVT_KEY_UP, self.on_key_up)
        self.Bind(wx.EVT_KEY_DOWN, self.on_key_down)
        self.Bind(wx.EVT_CLOSE, self.on_close, self)
        self.scene.SetFocus()
        self.widget_scene = None
        self.pipe_state = None

        self.root = RootNode(context, self, context.elements)
        self.Bind(wx.EVT_TREE_BEGIN_DRAG, self.root.on_drag_begin_handler, self.tree)
        self.Bind(wx.EVT_TREE_END_DRAG, self.root.on_drag_end_handler, self.tree)
        self.Bind(wx.EVT_TREE_ITEM_ACTIVATED, self.root.on_item_activated, self.tree)
        self.Bind(
            wx.EVT_TREE_SEL_CHANGED, self.root.on_item_selection_changed, self.tree
        )
        self.Bind(
            wx.EVT_TREE_ITEM_RIGHT_CLICK, self.root.on_item_right_click, self.tree
        )

        self.__set_titlebar()
        self.__kernel_initialize(context)

        self.Bind(wx.EVT_SIZE, self.on_size)

        self.Show()
        self.context.schedule(self)

    def __scene_binds(self):
        self.scene.Bind(wx.EVT_PAINT, self.on_paint)
        self.scene.Bind(wx.EVT_ERASE_BACKGROUND, self.on_erase)

        self.scene.Bind(wx.EVT_MOTION, self.on_mouse_move)

        self.scene.Bind(wx.EVT_MOUSEWHEEL, self.on_mousewheel)

        self.scene.Bind(wx.EVT_MIDDLE_DOWN, self.on_mouse_middle_down)
        self.scene.Bind(wx.EVT_MIDDLE_UP, self.on_mouse_middle_up)

        self.scene.Bind(wx.EVT_LEFT_DCLICK, self.on_mouse_double_click)

        self.scene.Bind(wx.EVT_RIGHT_DOWN, self.on_right_mouse_down)
        self.scene.Bind(wx.EVT_RIGHT_UP, self.on_right_mouse_up)

        self.scene.Bind(wx.EVT_LEFT_DOWN, self.on_left_mouse_down)
        self.scene.Bind(wx.EVT_LEFT_UP, self.on_left_mouse_up)

    def __kernel_initialize(self, context):
        context.gui = self
        context._reticle_x = 0
        context._reticle_y = 0
        context.setting(int, "draw_mode", 0)
        context.setting(int, "window_width", 1200)
        context.setting(int, "window_height", 600)
        context.setting(float, "units_convert", MILS_IN_MM)
        context.setting(str, "units_name", "mm")
        context.setting(int, "units_marks", 10)
        context.setting(int, "units_index", 0)
        context.setting(bool, "mouse_zoom_invert", False)
        context.setting(bool, "print_shutdown", False)
        context.setting(int, "fps", 40)
        if context.fps <= 0:
            context.fps = 60
        if context.window_width < 300:
            context.window_width = 300
        if context.window_height < 300:
            context.window_height = 300

        context.listen("element_added", self.on_rebuild_tree_request)
        context.listen("operation_added", self.on_rebuild_tree_request)
        context.listen("element_removed", self.on_rebuild_tree_request)
        context.listen("operation_removed", self.on_rebuild_tree_request)
        context.listen("units", self.space_changed)
        context.listen("emphasized", self.on_emphasized_elements_changed)
        context.listen("modified", self.on_element_modified)
        context.listen("altered", self.on_element_alteration)

        context.listen("export-image", self.on_export_signal)
        context.listen("background", self.on_background_signal)
        context.listen("rebuild_tree", self.on_rebuild_tree_signal)
        context.listen("refresh_scene", self.on_refresh_scene)
        context.listen("element_property_update", self.on_element_update)
        context.setting(int, "bed_width", 310)  # Default Value
        context.setting(int, "bed_height", 210)  # Default Value

        context.listen("active", self.on_active_change)

        self.widget_scene = context.open("module/Scene")

        self.widget_scene.add_scenewidget(SelectionWidget(self.widget_scene, self.root))
        self.widget_scene.add_scenewidget(RectSelectWidget(self.widget_scene))
        self.widget_scene.add_scenewidget(LaserPathWidget(self.widget_scene))
        self.widget_scene.add_scenewidget(
            ElementsWidget(self.widget_scene, self.root, self.renderer)
        )
        self.widget_scene.add_scenewidget(GridWidget(self.widget_scene))
        self.widget_scene.add_interfacewidget(GuideWidget(self.widget_scene))
        self.widget_scene.add_interfacewidget(ReticleWidget(self.widget_scene))

        context.register("control/Transform", self.open_transform_dialog)
        context.register("control/Flip", self.open_flip_dialog)
        context.register("control/Path", self.open_path_dialog)
        context.register("control/Fill", self.open_fill_dialog)
        context.register("control/Stroke", self.open_stroke_dialog)
        context.register("control/FPS", self.open_fps_dialog)
        context.register(
            "control/Speedcode-Gear-Force", self.open_speedcode_gear_dialog
        )
        context.register("control/Jog Transition Test", self.run_jog_transition_test)
        context.register(
            "control/Jog Transition Switch Test", self.run_jog_transition_switch_test
        )
        context.register(
            "control/Jog Transition Finish Test", self.run_jog_transition_finish_test
        )
        context.register("control/Home and Dot", self.run_home_and_dot_test)

        def test_crash_in_thread():
            def foo():
                a = 1 / 0

            context.threaded(foo)

        context.register("control/Crash Thread", test_crash_in_thread)
        context.register("control/Clear Laserpath", self.clear_laserpath)
        context.register("control/egv export", self.egv_export)
        context.register("control/egv import", self.egv_import)

        @context.console_command("theme", help="Theming information and assignments")
        def theme(command, channel, _, args=tuple(), **kwargs):
            channel(str(wx.SystemSettings().GetColour(wx.SYS_COLOUR_WINDOW)))

        @context.console_command("rotaryview", help="Rotary View of Scene")
        def toggle_rotary_view(*args, **kwargs):
            self.toggle_rotary_view()

        @context.console_command("rotaryscale", help="Rotary Scale selected elements")
        def toggle_rotary_view(*args, **kwargs):
            self.apply_rotary_scale()

        @context.console_command("window", help="wxMeerK40 window information")
        def window(command, channel, _, args=tuple(), **kwargs):
            context = self.context
            if len(args) == 0:
                channel(_("----------"))
                channel(_("Windows Registered:"))
                for i, name in enumerate(context.match("window")):
                    channel("%d: %s" % (i + 1, name))
                channel(_("----------"))
                channel(_("Loaded Windows in Context %s:") % str(context._path))
                for i, name in enumerate(context.opened):
                    if not name.startswith("window"):
                        continue
                    module = context.opened[name]
                    channel(_("%d: %s as type of %s") % (i + 1, name, type(module)))
                channel(_("----------"))
                channel(_("Loaded Windows in Device %s:") % str(context.active._path))
                for i, name in enumerate(context.active.opened):
                    if not name.startswith("window"):
                        continue
                    module = context.active.opened[name]
                    channel(_("%d: %s as type of %s") % (i + 1, name, type(module)))
                channel(_("----------"))
            else:
                if args[0] == "open":
                    try:
                        self.context.open("window/%s" % args[1], self)
                        channel(_("Window Opened."))
                    except KeyError:
                        channel(_("No such window as %s" % args[1]))
                    except IndexError:
                        raise SyntaxError

        @context.console_command("refresh", help="wxMeerK40 refresh")
        def refresh(command, channel, _, args=tuple(), **kwargs):
            context.signal("refresh_scene")
            context.signal("rebuild_tree")
            channel(_("Refreshed."))
            return

        self.SetSize((context.window_width, context.window_height))
        self.interval = 1.0 / float(context.fps)
        self.process()

        context.setting(str, "file0", None)
        context.setting(str, "file1", None)
        context.setting(str, "file2", None)
        context.setting(str, "file3", None)
        context.setting(str, "file4", None)
        context.setting(str, "file5", None)
        context.setting(str, "file6", None)
        context.setting(str, "file7", None)
        context.setting(str, "file8", None)
        context.setting(str, "file9", None)
        self.populate_recent_menu()

        bedwidth = context.bed_width
        bedheight = context.bed_height
        bbox = (0, 0, bedwidth * MILS_IN_MM, bedheight * MILS_IN_MM)
        self.widget_scene.widget_root.focus_viewport_scene(
            bbox, self.scene.ClientSize, 0.1
        )

        def interrupt_popup():
            dlg = wx.MessageDialog(
                None,
                _("Spooling Interrupted. Press OK to Continue."),
                _("Interrupt"),
                wx.OK,
            )
            dlg.ShowModal()
            dlg.Destroy()

        def interrupt():
            yield COMMAND_WAIT_FINISH
            yield COMMAND_FUNCTION, interrupt_popup

        context.register("plan/interrupt", interrupt)

        # Registers the render-op make_raster. This is used to do cut planning.
        context.register("render-op/make_raster", self.renderer.make_raster)

    def __set_ribbonbar(self):
        home = RB.RibbonPage(
            self._ribbon,
            wx.ID_ANY,
            _("Home"),
            icons8_opened_folder_50.GetBitmap(),
        )

        toolbar_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Main"),
            style=wx.ribbon.RIBBON_PANEL_NO_AUTO_MINIMISE | RB.RIBBON_PANEL_FLEXIBLE,
        )
        toolbar = RB.RibbonButtonBar(toolbar_panel)
        self.toolbar_button_bar = toolbar
        toolbar.AddButton(ID_OPEN, _("Open"), icons8_opened_folder_50.GetBitmap(), "")
        toolbar.AddButton(ID_SAVE, _("Save"), icons8_save_50.GetBitmap(), "")
        toolbar.AddButton(ID_JOB, _("Start Job"), icons8_laser_beam_52.GetBitmap(), "")
        toolbar.AddToggleButton(ID_PAUSE, _("Pause"), icons8_pause_50.GetBitmap(), "")

        windows_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Windows"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )
        windows = RB.RibbonButtonBar(windows_panel)
        self.window_button_bar = windows
        windows.AddButton(ID_NAV, _("Navigation"), icons8_move_50.GetBitmap(), "")
        windows.AddButton(ID_USB, _("Usb"), icons8_usb_connector_50.GetBitmap(), "")
        windows.AddButton(ID_SPOOLER, _("Spooler"), icons8_route_50.GetBitmap(), "")
        windows.AddButton(
            ID_CONTROLLER, _("Controller"), icons8_connected_50.GetBitmap(), ""
        )
        windows.AddButton(
            ID_PREFERENCES,
            _("Preferences"),
            icons8_administrative_tools_50.GetBitmap(),
            "",
        )
        windows.AddButton(ID_DEVICES, _("Devices"), icons8_manager_50.GetBitmap(), "")
        if self.context.has_feature("modifier/Camera"):
            windows.AddHybridButton(
                ID_CAMERA, _("Camera"), icons8_camera_50.GetBitmap(), ""
            )

        windows.AddButton(ID_KEYMAP, _("Keymap"), icons8_keyboard_50.GetBitmap(), "")
        windows.AddButton(ID_NOTES, _("Notes"), icons8_comments_50.GetBitmap(), "")
        windows.AddButton(ID_TERMINAL, _("Terminal"), icons8_console_50.GetBitmap(), "")
        windows.AddButton(ID_ROTARY, _("Rotary"), icons8_roll_50.GetBitmap(), "")
        windows.AddButton(
            ID_RASTER, _("RasterWizard"), icons8_fantasy_50.GetBitmap(), ""
        )
        # home = RB.RibbonPage(self._ribbon, wx.ID_ANY, _("Tools"), icons8_opened_folder_50.GetBitmap(), )
        #
        # align_panel = RB.RibbonPanel(home, wx.ID_ANY, _("Align"), icons8_opened_folder_50.GetBitmap(),
        #                              style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE)
        # align = RB.RibbonButtonBar(align_panel)
        # align.AddButton(ID_DEVICES, _("Align Left"), icons8_align_left_50.GetBitmap(), "")
        # align.AddButton(ID_DEVICES, _("Align Right"), icons8_align_right_50.GetBitmap(), "")
        # align.AddButton(ID_DEVICES, _("Align Top"), icons8_align_top_50.GetBitmap(), "")
        # align.AddButton(ID_DEVICES, _("Align Bottom"), icons8_align_bottom_50.GetBitmap(), "")
        #
        # flip_panel = RB.RibbonPanel(home, wx.ID_ANY, _("Flip"), icons8_opened_folder_50.GetBitmap(),
        #                             style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE)
        # flip = RB.RibbonButtonBar(flip_panel)
        # flip.AddButton(ID_DEVICES, _("Flip Horizontal"), icons8_flip_horizontal_50.GetBitmap(), "")
        # flip.AddButton(ID_DEVICES, _("Flip Vertical"), icons8_flip_vertical_50.GetBitmap(), "")
        #
        # group_panel = RB.RibbonPanel(home, wx.ID_ANY, _("Group"), icons8_opened_folder_50.GetBitmap(),
        #                              style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE)
        # group = RB.RibbonButtonBar(group_panel)
        # group.AddButton(ID_DEVICES, _("Group"), icons8_group_objects_50.GetBitmap(), "")
        # group.AddButton(ID_DEVICES, _("Ungroup"), icons8_ungroup_objects_50.GetBitmap(), "")
        #
        # tool_panel = RB.RibbonPanel(home, wx.ID_ANY, _("Tools"), icons8_opened_folder_50.GetBitmap(),
        #                             style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE)
        # tool = RB.RibbonButtonBar(tool_panel)
        # tool.AddButton(ID_DEVICES, _("Set Position"), icons8_place_marker_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Oval"), icons8_oval_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Circle"), icons8_circle_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Polygon"), icons8_polygon_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Polyline"), icons8_polyline_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Rectangle"), icons8_rectangular_50.GetBitmap(), "")
        # tool.AddButton(ID_DEVICES, _("Text"), icons8_type_50.GetBitmap(), "")

        home = RB.RibbonPage(
            self._ribbon,
            wx.ID_ANY,
            _("Position"),
            icons8_opened_folder_50.GetBitmap(),
        )
        position_panel = RB.RibbonPanel(
            home,
            wx.ID_ANY,
            _("Position"),
            icons8_opened_folder_50.GetBitmap(),
            style=RB.RIBBON_PANEL_NO_AUTO_MINIMISE,
        )

        self.text_x = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.text_y = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.text_w = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.button_aspect_ratio = wx.BitmapButton(
            position_panel, wx.ID_ANY, icons8_lock_50.GetBitmap()
        )
        self.text_h = wx.TextCtrl(
            position_panel, wx.ID_ANY, "", style=wx.TE_PROCESS_ENTER
        )
        self.combo_box_units = wx.ComboBox(
            position_panel,
            wx.ID_ANY,
            choices=["mm", "cm", "inch", "mil", "%"],
            style=wx.CB_DROPDOWN | wx.CB_READONLY,
        )

        self.button_aspect_ratio.SetSize(self.button_aspect_ratio.GetBestSize())
        self.combo_box_units.SetSelection(0)

        sizer_panel = wx.BoxSizer(wx.HORIZONTAL)
        sizer_units = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "Units:"), wx.HORIZONTAL
        )
        sizer_h = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "H:"), wx.HORIZONTAL
        )
        sizer_w = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "W:"), wx.HORIZONTAL
        )
        sizer_y = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "Y:"), wx.HORIZONTAL
        )
        sizer_x = wx.StaticBoxSizer(
            wx.StaticBox(position_panel, wx.ID_ANY, "X:"), wx.HORIZONTAL
        )
        sizer_x.Add(self.text_x, 1, 0, 0)
        sizer_panel.Add(sizer_x, 0, 0, 0)
        sizer_y.Add(self.text_y, 1, 0, 0)
        sizer_panel.Add(sizer_y, 0, 0, 0)
        sizer_w.Add(self.text_w, 1, 0, 0)
        sizer_panel.Add(sizer_w, 0, 0, 0)
        sizer_panel.Add(self.button_aspect_ratio, 0, 0, 0)
        sizer_h.Add(self.text_h, 1, 0, 0)
        sizer_panel.Add(sizer_h, 0, 0, 0)
        sizer_units.Add(self.combo_box_units, 0, 0, 0)
        sizer_panel.Add(sizer_units, 0, 0, 0)
        position_panel.SetSizer(sizer_panel)
        self._ribbon.Realize()

        self.Bind(wx.EVT_TEXT, self.on_text_x, self.text_x)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_pos_enter, self.text_x)
        self.Bind(wx.EVT_TEXT, self.on_text_y, self.text_y)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_pos_enter, self.text_y)
        self.Bind(wx.EVT_TEXT, self.on_text_w, self.text_w)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_dim_enter, self.text_w)
        self.Bind(wx.EVT_BUTTON, self.on_button_aspect_ratio, self.button_aspect_ratio)
        self.Bind(wx.EVT_TEXT, self.on_text_h, self.text_h)
        self.Bind(wx.EVT_TEXT_ENTER, self.on_text_dim_enter, self.text_h)
        self.Bind(wx.EVT_COMBOBOX, self.on_combo_box_units, self.combo_box_units)

        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_open, id=ID_OPEN)
        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_save, id=ID_SAVE)
        toolbar.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/JobPreview", self, "0"),
            id=ID_JOB,
        )
        toolbar.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_click_pause, id=ID_PAUSE)
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context._kernel.active_device.open(
                "window/UsbConnect", self
            ),
            id=ID_USB,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context._kernel.active_device.open(
                "window/Controller", self
            ),
            id=ID_CONTROLLER,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context._kernel.active_device.open(
                "window/Preferences", self
            ),
            id=ID_PREFERENCES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context._kernel.active_device.open("window/Rotary", self),
            id=ID_ROTARY,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context._kernel.active_device.open(
                "window/JobSpooler", self
            ),
            id=ID_SPOOLER,
        )
        windows.Bind(RB.EVT_RIBBONBUTTONBAR_CLICKED, self.on_camera_click, id=ID_CAMERA)
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/Navigation", self),
            id=ID_NAV,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/DeviceManager", self),
            id=ID_DEVICES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/Keymap", self),
            id=ID_KEYMAP,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/Notes", self),
            id=ID_NOTES,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/Terminal", self),
            id=ID_TERMINAL,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/Operations", self),
            id=ID_OPERATIONS,
        )
        windows.Bind(
            RB.EVT_RIBBONBUTTONBAR_CLICKED,
            lambda v: self.context.open("window/RasterWizard", self),
            id=ID_RASTER,
        )
        if self.context.has_feature("modifier/Camera"):
            windows.Bind(
                RB.EVT_RIBBONBUTTONBAR_DROPDOWN_CLICKED,
                self.on_camera_dropdown,
                id=ID_CAMERA,
            )

            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA1)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA2)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA3)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA4)
            self.Bind(wx.EVT_MENU, self.on_camera_click, id=ID_CAMERA5)
        self.context.setting(int, "units_index", 0)
        self.ribbon_position_units = self.context.units_index
        self.update_ribbon_position()

    def on_camera_dropdown(self, event):
        menu = wx.Menu()
        menu.Append(ID_CAMERA1, "Camera %d" % 1)
        menu.Append(ID_CAMERA2, "Camera %d" % 2)
        menu.Append(ID_CAMERA3, "Camera %d" % 3)
        menu.Append(ID_CAMERA4, "Camera %d" % 4)
        menu.Append(ID_CAMERA5, "Camera %d" % 5)
        event.PopupMenu(menu)

    def on_camera_click(self, event):
        eid = event.GetId()
        self.context.setting(int, "camera_default", 1)
        if eid == ID_CAMERA1:
            self.context.camera_default = 1
        elif eid == ID_CAMERA2:
            self.context.camera_default = 2
        elif eid == ID_CAMERA3:
            self.context.camera_default = 3
        elif eid == ID_CAMERA4:
            self.context.camera_default = 4
        elif eid == ID_CAMERA5:
            self.context.camera_default = 5

        v = self.context.camera_default
        self.context.console("camwin %d\n" % v)

    def __set_menubar(self):
        wxglade_tmp_menu = wx.Menu()

        wxglade_tmp_menu.Append(wx.ID_NEW, _("New"), "")
        wxglade_tmp_menu.Append(wx.ID_OPEN, _("Open Project"), "")
        self.recent_file_menu = wx.Menu()
        wxglade_tmp_menu.AppendSubMenu(self.recent_file_menu, _("Recent"))
        wxglade_tmp_menu.Append(ID_MENU_IMPORT, _("Import File"), "")
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(wx.ID_SAVE, _("Save"), "")
        wxglade_tmp_menu.Append(wx.ID_SAVEAS, _("Save As"), "")
        wxglade_tmp_menu.AppendSeparator()

        wxglade_tmp_menu.Append(wx.ID_EXIT, _("Exit"), "")
        self.main_menubar.Append(wxglade_tmp_menu, _("File"))
        wxglade_tmp_menu = wx.Menu()

        wxglade_tmp_menu.Append(ID_MENU_ZOOM_OUT, _("Zoom Out"), "")
        wxglade_tmp_menu.Append(ID_MENU_ZOOM_IN, _("Zoom In"), "")
        wxglade_tmp_menu.Append(ID_MENU_ZOOM_SIZE, _("Zoom To Size"), "")
        wxglade_tmp_menu.AppendSeparator()
        wxglade_tmp_menu.Append(ID_MENU_HIDE_GRID, _("Hide Grid"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_BACKGROUND, _("Hide Background"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_GUIDES, _("Hide Guides"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_HIDE_PATH, _("Hide Paths"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_IMAGE, _("Hide Images"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_TEXT, _("Hide Text"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_FILLS, _("Hide Fills"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_STROKES, _("Hide Strokes"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_LASERPATH, _("Hide Laserpath"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_RETICLE, _("Hide Reticle"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_HIDE_SELECTION, _("Hide Selection"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_HIDE_ICONS, _("Hide Icons"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_HIDE_TREE, _("Hide Tree"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(
            ID_MENU_PREVENT_CACHING, _("Do Not Cache Image"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_SCREEN_REFRESH, _("Do Not Refresh"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(
            ID_MENU_SCREEN_ANIMATE, _("Do Not Animate"), "", wx.ITEM_CHECK
        )
        wxglade_tmp_menu.Append(ID_MENU_SCREEN_INVERT, _("Invert"), "", wx.ITEM_CHECK)
        wxglade_tmp_menu.Append(ID_MENU_SCREEN_FLIPXY, _("Flip XY"), "", wx.ITEM_CHECK)

        self.main_menubar.Append(wxglade_tmp_menu, _("View"))
        wxglade_tmp_menu = wx.Menu()
        self.main_menubar.view = wxglade_tmp_menu
        self.main_menubar.preferences = wxglade_tmp_menu.Append(
            wx.ID_PREFERENCES, _("Preferences"), ""
        )
        self.main_menubar.settings = wxglade_tmp_menu.Append(
            ID_MENU_SETTINGS, _("Settings"), ""
        )
        self.main_menubar.rotary = wxglade_tmp_menu.Append(
            ID_MENU_ROTARY, _("Rotary Settings"), ""
        )
        self.main_menubar.keymap = wxglade_tmp_menu.Append(
            ID_MENU_KEYMAP, _("Keymap Settings"), ""
        )
        self.main_menubar.devices = wxglade_tmp_menu.Append(
            ID_MENU_DEVICE_MANAGER, _("Device Manager"), ""
        )
        self.main_menubar.alignment = wxglade_tmp_menu.Append(
            ID_MENU_ALIGNMENT, _("Alignment Ally"), ""
        )
        if self.context.has_feature("modifier/Camera"):
            self.main_menubar.camera = wxglade_tmp_menu.Append(
                ID_MENU_CAMERA, _("Camera"), ""
            )
        self.main_menubar.terminal = wxglade_tmp_menu.Append(
            ID_MENU_TERMINAL, _("Terminal"), ""
        )
        self.main_menubar.navigation = wxglade_tmp_menu.Append(
            ID_MENU_NAVIGATION, _("Navigation"), ""
        )
        self.main_menubar.controller = wxglade_tmp_menu.Append(
            ID_MENU_CONTROLLER, _("Controller"), ""
        )
        self.main_menubar.notes = wxglade_tmp_menu.Append(ID_MENU_NOTES, _("Notes"), "")
        self.main_menubar.usb = wxglade_tmp_menu.Append(ID_MENU_USB, _("USB"), "")
        self.main_menubar.jobspooler = wxglade_tmp_menu.Append(
            ID_MENU_SPOOLER, _("Job Spooler"), ""
        )
        self.main_menubar.jobpreview = wxglade_tmp_menu.Append(
            ID_MENU_JOB, _("Execute Job"), ""
        )

        self.main_menubar.Append(wxglade_tmp_menu, _("Windows"))

        wxglade_tmp_menu = wx.Menu()
        wxglade_tmp_menu.Append(wx.ID_HELP, _("Webpage"), "")
        wxglade_tmp_menu.Append(wx.ID_ABOUT, _("About"), "")
        self.main_menubar.Append(wxglade_tmp_menu, _("Help"))

        self.SetMenuBar(self.main_menubar)
        # Menu Bar end

        self.Bind(wx.EVT_MENU, self.on_click_new, id=wx.ID_NEW)
        self.Bind(wx.EVT_MENU, self.on_click_open, id=wx.ID_OPEN)
        self.Bind(wx.EVT_MENU, self.on_click_open, id=ID_MENU_IMPORT)
        self.Bind(wx.EVT_MENU, self.on_click_save, id=wx.ID_SAVE)
        self.Bind(wx.EVT_MENU, self.on_click_save_as, id=wx.ID_SAVEAS)

        self.Bind(wx.EVT_MENU, self.on_click_exit, id=wx.ID_EXIT)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_out, id=ID_MENU_ZOOM_OUT)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_in, id=ID_MENU_ZOOM_IN)
        self.Bind(wx.EVT_MENU, self.on_click_zoom_size, id=ID_MENU_ZOOM_SIZE)

        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_GRID), id=ID_MENU_HIDE_GRID
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_BACKGROUND),
            id=ID_MENU_HIDE_BACKGROUND,
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_GUIDES), id=ID_MENU_HIDE_GUIDES
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_PATH), id=ID_MENU_HIDE_PATH
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_IMAGE), id=ID_MENU_HIDE_IMAGE
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_TEXT), id=ID_MENU_HIDE_TEXT
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_FILLS), id=ID_MENU_HIDE_FILLS
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_LASERPATH),
            id=ID_MENU_HIDE_LASERPATH,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_RETICLE),
            id=ID_MENU_HIDE_RETICLE,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_SELECTION),
            id=ID_MENU_HIDE_SELECTION,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_STROKES),
            id=ID_MENU_HIDE_STROKES,
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_ICONS), id=ID_MENU_HIDE_ICONS
        )
        self.Bind(
            wx.EVT_MENU, self.toggle_draw_mode(DRAW_MODE_TREE), id=ID_MENU_HIDE_TREE
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_CACHE),
            id=ID_MENU_PREVENT_CACHING,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_REFRESH),
            id=ID_MENU_SCREEN_REFRESH,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_ANIMATE),
            id=ID_MENU_SCREEN_ANIMATE,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_INVERT),
            id=ID_MENU_SCREEN_INVERT,
        )
        self.Bind(
            wx.EVT_MENU,
            self.toggle_draw_mode(DRAW_MODE_FLIPXY),
            id=ID_MENU_SCREEN_FLIPXY,
        )

        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/About", self),
            id=wx.ID_ABOUT,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Alignment", self),
            id=ID_MENU_ALIGNMENT,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Terminal", self),
            id=ID_MENU_TERMINAL,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/DeviceManager", self),
            id=ID_MENU_DEVICE_MANAGER,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Keymap", self),
            id=ID_MENU_KEYMAP,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Settings", self),
            id=ID_MENU_SETTINGS,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Notes", self),
            id=ID_MENU_NOTES,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/Navigation", self),
            id=ID_MENU_NAVIGATION,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.open("window/JobPreview", self, "0"),
            id=ID_MENU_JOB,
        )
        if self.context.has_feature("modifier/Camera"):
            self.Bind(
                wx.EVT_MENU,
                lambda v: self.context.open("window/CameraInterface", self),
                id=ID_MENU_CAMERA,
            )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.active.open("window/Preferences", self),
            id=wx.ID_PREFERENCES,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.active.open("window/Rotary", self),
            id=ID_MENU_ROTARY,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.active.open("window/Controller", self),
            id=ID_MENU_CONTROLLER,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.active.open("window/UsbConnect", self),
            id=ID_MENU_USB,
        )
        self.Bind(
            wx.EVT_MENU,
            lambda v: self.context.active.open("window/JobSpooler", self),
            id=ID_MENU_SPOOLER,
        )

        self.Bind(wx.EVT_MENU, self.launch_webpage, id=wx.ID_HELP)

        self.add_language_menu()

        self.context.setting(int, "draw_mode", 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_FILLS)
        m.Check(self.context.draw_mode & DRAW_MODE_FILLS != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_GUIDES)
        m.Check(self.context.draw_mode & DRAW_MODE_GUIDES != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_BACKGROUND)
        m.Check(self.context.draw_mode & DRAW_MODE_BACKGROUND != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_GRID)
        m.Check(self.context.draw_mode & DRAW_MODE_GRID != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_LASERPATH)
        m.Check(self.context.draw_mode & DRAW_MODE_LASERPATH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_RETICLE)
        m.Check(self.context.draw_mode & DRAW_MODE_RETICLE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_SELECTION)
        m.Check(self.context.draw_mode & DRAW_MODE_SELECTION != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_STROKES)
        m.Check(self.context.draw_mode & DRAW_MODE_STROKES != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_ICONS)
        m.Check(self.context.draw_mode & DRAW_MODE_ICONS != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_TREE)
        m.Check(self.context.draw_mode & DRAW_MODE_TREE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_PREVENT_CACHING)
        m.Check(self.context.draw_mode & DRAW_MODE_CACHE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_REFRESH)
        m.Check(self.context.draw_mode & DRAW_MODE_REFRESH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_ANIMATE)
        m.Check(self.context.draw_mode & DRAW_MODE_ANIMATE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_PATH)
        m.Check(self.context.draw_mode & DRAW_MODE_PATH != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_IMAGE)
        m.Check(self.context.draw_mode & DRAW_MODE_IMAGE != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_HIDE_TEXT)
        m.Check(self.context.draw_mode & DRAW_MODE_TEXT != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_FLIPXY)
        m.Check(self.context.draw_mode & DRAW_MODE_FLIPXY != 0)
        m = self.GetMenuBar().FindItemById(ID_MENU_SCREEN_INVERT)
        m.Check(self.context.draw_mode & DRAW_MODE_INVERT != 0)

    def add_language_menu(self):
        if os.path.exists(resource_path("../locale")) or os.path.exists(
            resource_path("./locale")
        ):
            wxglade_tmp_menu = wx.Menu()
            i = 0
            for lang in supported_languages:
                language_code, language_name, language_index = lang
                m = wxglade_tmp_menu.Append(wx.ID_ANY, language_name, "", wx.ITEM_RADIO)
                if i == self.context.language:
                    m.Check(True)

                def language_update(q):
                    return lambda e: self.context.app.update_language(q)

                self.Bind(wx.EVT_MENU, language_update(i), id=m.GetId())
                if (
                    not (
                        os.path.exists(resource_path("../locale/%s" % language_code))
                        or os.path.exists(resource_path("./locale/%s" % language_code))
                    )
                    and i != 0
                ):
                    m.Enable(False)
                i += 1
            self.main_menubar.Append(wxglade_tmp_menu, _("Languages"))

    def on_close(self, event):
        if self.state == 5:
            event.Veto()
        else:
            self._mgr.UnInit()
            self.state = 5
            self.context.console("shutdown\n")
            # self.context.close(self.name)
            event.Skip()  # Call destroy as regular.

    def on_active_change(self, old_active, context_active):
        if old_active is not None:
            old_active.unlisten("pipe;error", self.on_usb_error)
            old_active.unlisten("pipe;usb_status", self.on_usb_state_text)
            old_active.unlisten("pipe;thread", self.on_pipe_state)
            old_active.unlisten("spooler;thread", self.on_spooler_state)
            old_active.unlisten("interpreter;position", self.update_position)
            old_active.unlisten("interpreter;mode", self.on_interpreter_mode)
            old_active.unlisten("bed_size", self.bed_changed)
        if context_active is not None:
            context_active.listen("pipe;error", self.on_usb_error)
            context_active.listen("pipe;usb_status", self.on_usb_state_text)
            context_active.listen("pipe;thread", self.on_pipe_state)
            context_active.listen("spooler;thread", self.on_spooler_state)
            context_active.listen("interpreter;position", self.update_position)
            context_active.listen("interpreter;mode", self.on_interpreter_mode)
            context_active.listen("bed_size", self.bed_changed)
            self.main_menubar.Enable(ID_MENU_ROTARY, True)
            self.main_menubar.Enable(ID_MENU_USB, True)
            self.main_menubar.Enable(ID_MENU_CONTROLLER, True)
            self.main_menubar.Enable(wx.ID_PREFERENCES, True)
            self.main_menubar.Enable(ID_MENU_SPOOLER, True)
            self.window_button_bar.EnableButton(ID_CONTROLLER, True)
            self.window_button_bar.EnableButton(ID_PREFERENCES, True)
            self.window_button_bar.EnableButton(ID_ROTARY, True)
            self.window_button_bar.EnableButton(ID_SPOOLER, True)
            self.window_button_bar.EnableButton(ID_USB, True)
        else:
            self.main_menubar.Enable(ID_MENU_ROTARY, False)
            self.main_menubar.Enable(ID_MENU_USB, False)
            self.main_menubar.Enable(ID_MENU_CONTROLLER, False)
            self.main_menubar.Enable(wx.ID_PREFERENCES, False)
            self.main_menubar.Enable(ID_MENU_SPOOLER, False)
            self.window_button_bar.EnableButton(ID_CONTROLLER, False)
            self.window_button_bar.EnableButton(ID_PREFERENCES, False)
            self.window_button_bar.EnableButton(ID_ROTARY, False)
            self.window_button_bar.EnableButton(ID_SPOOLER, False)
            self.window_button_bar.EnableButton(ID_USB, False)

    def finalize(self, *args, **kwargs):
        context = self.context

        if context.print_shutdown:
            context.channel("shutdown").watch(print)

        context.unschedule(self)
        self.screen_refresh_lock.acquire()  # calling shutdown live locks here since it's already shutting down.

        context.unlisten("element_added", self.on_rebuild_tree_request)
        context.unlisten("operation_added", self.on_rebuild_tree_request)
        context.unlisten("element_removed", self.on_rebuild_tree_request)
        context.unlisten("operation_removed", self.on_rebuild_tree_request)
        context.unlisten("units", self.space_changed)
        context.unlisten("emphasized", self.on_emphasized_elements_changed)
        context.unlisten("modified", self.on_element_modified)
        context.unlisten("altered", self.on_element_alteration)

        context.unlisten("export-image", self.on_export_signal)
        context.unlisten("background", self.on_background_signal)
        context.unlisten("rebuild_tree", self.on_rebuild_tree_signal)
        context.unlisten("refresh_scene", self.on_refresh_scene)
        context.unlisten("element_property_update", self.on_element_update)

        context.unlisten("active", self.on_active_change)
        try:
            self.Close()
        except RuntimeError:
            pass

    def set_fps(self, fps):
        if fps == 0:
            fps = 1
        self.context.fps = fps
        self.interval = 1.0 / float(self.context.fps)

    def on_element_update(self, *args):
        """
        Called by 'element_property_update' when the properties of an element are changed.

        :param args:
        :return:
        """
        if self.root is not None:
            self.root.on_element_update(*args)

    def on_rebuild_tree_request(self, *args):
        """
        Called by various functions, sends a rebuild_tree signal.
        This is to prevent multiple events from overtaxing the rebuild.

        :param args:
        :return:
        """
        self.context.signal("rebuild_tree")

    def on_rebuild_tree_signal(self, *args):
        """
        Called by 'rebuild_tree' signal. To refresh tree directly

        :param args:
        :return:
        """
        if self.context.draw_mode & DRAW_MODE_TREE != 0:
            self.root.gui.tree.Hide()
            return
        else:
            self.root.gui.tree.Show()
        self.root.rebuild_tree()
        self.request_refresh()

    def on_refresh_scene(self, *args):
        """
        Called by 'refresh_scene' change. To refresh tree.

        :param args:
        :return:
        """
        self.request_refresh()

    def on_usb_error(self, value):
        dlg = wx.MessageDialog(
            None,
            _("All attempts to connect to USB have failed."),
            _("Usb Connection Problem."),
            wx.OK | wx.ICON_WARNING,
        )
        dlg.ShowModal()
        dlg.Destroy()

    def on_usb_state_text(self, value):
        self.main_statusbar.SetStatusText(_("Usb: %s") % value, 0)

    def on_pipe_state(self, state):
        if state == self.pipe_state:
            return
        self.pipe_state = state

        self.main_statusbar.SetStatusText(
            _("Controller: %s") % self.context._kernel.get_text_thread_state(state), 1
        )
        self.toolbar_button_bar.ToggleButton(ID_PAUSE, state == STATE_BUSY)

    def on_spooler_state(self, value):
        self.main_statusbar.SetStatusText(
            _("Spooler: %s") % self.context.get_text_thread_state(value), 2
        )

    def on_interpreter_mode(self, state):
        if state == 0:
            self.background_brush = wx.Brush("Grey")
        else:
            self.background_brush = wx.Brush("Red")
        self.request_refresh_for_animation()

    def on_export_signal(self, frame):
        image_width, image_height, frame = frame
        if frame is not None:
            elements = self.context.elements
            from PIL import Image

            img = Image.fromarray(frame)
            obj = SVGImage()
            obj.image = img
            obj.image_width = image_width
            obj.image_height = image_height
            elements.add_elem(obj)

    def on_background_signal(self, background):
        background = wx.Bitmap.FromBuffer(*background)
        self.widget_scene.signal("background", background)
        self.request_refresh()

    def __set_titlebar(self):
        device_text = ""
        device_name = ""
        device_version = ""
        if self.context is not None:
            device_version = self.context.device_version
            device_name = str(self.context.device_name)
        self.SetTitle(_("%s v%s") % (device_name, device_version))

    def __set_properties(self):
        # begin wxGlade: MeerK40t.__set_properties
        self.__set_titlebar()
        self.main_statusbar.SetStatusWidths([-1] * self.main_statusbar.GetFieldsCount())
        _icon = wx.NullIcon
        _icon.CopyFromBitmap(icon_meerk40t.GetBitmap())
        self.SetIcon(_icon)
        # statusbar fields
        main_statusbar_fields = ["Status"]
        for i in range(len(main_statusbar_fields)):
            self.main_statusbar.SetStatusText(main_statusbar_fields[i], i)
        self.tree.SetMaxSize((275, -1))

    def __do_layout(self):
        # main_sizer = wx.BoxSizer(wx.VERTICAL)
        # main_sizer.Add(self._ribbon, 0, wx.EXPAND, 0)
        # widget_sizer = wx.BoxSizer(wx.HORIZONTAL)
        # widget_sizer.Add(self.tree, 1, wx.EXPAND, 0)
        # widget_sizer.Add(self.scene, 5, wx.EXPAND, 0)
        # main_sizer.Add(widget_sizer, 8, wx.EXPAND, 0)
        # self.SetSizer(main_sizer)
        # self._mgr.Update()
        self.Layout()

    def populate_recent_menu(self):
        for i in range(self.recent_file_menu.MenuItemCount):
            self.recent_file_menu.Remove(self.recent_file_menu.FindItemByPosition(0))
        context = self.context
        if context.file0 is not None and len(context.file0):
            self.recent_file_menu.Append(ID_MENU_FILE0, context.file0, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file0), id=ID_MENU_FILE0)
        if context.file1 is not None and len(context.file1):
            self.recent_file_menu.Append(ID_MENU_FILE1, context.file1, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file1), id=ID_MENU_FILE1)
        if context.file2 is not None and len(context.file2):
            self.recent_file_menu.Append(ID_MENU_FILE2, context.file2, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file2), id=ID_MENU_FILE2)
        if context.file3 is not None and len(context.file3):
            self.recent_file_menu.Append(ID_MENU_FILE3, context.file3, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file3), id=ID_MENU_FILE3)
        if context.file4 is not None and len(context.file4):
            self.recent_file_menu.Append(ID_MENU_FILE4, context.file4, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file4), id=ID_MENU_FILE4)
        if context.file5 is not None and len(context.file5):
            self.recent_file_menu.Append(ID_MENU_FILE5, context.file5, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file5), id=ID_MENU_FILE5)
        if context.file6 is not None and len(context.file6):
            self.recent_file_menu.Append(ID_MENU_FILE6, context.file6, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file6), id=ID_MENU_FILE6)
        if context.file7 is not None and len(context.file7):
            self.recent_file_menu.Append(ID_MENU_FILE7, context.file7, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file7), id=ID_MENU_FILE7)
        if context.file8 is not None and len(context.file8):
            self.recent_file_menu.Append(ID_MENU_FILE8, context.file8, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file8), id=ID_MENU_FILE8)
        if context.file9 is not None and len(context.file9):
            self.recent_file_menu.Append(ID_MENU_FILE9, context.file9, "")
            self.Bind(wx.EVT_MENU, lambda e: self.load(context.file9), id=ID_MENU_FILE9)
        if self.recent_file_menu.MenuItemCount != 0:
            self.recent_file_menu.Append(ID_MENU_FILE_CLEAR, _("Clear Recent"), "")
            self.Bind(wx.EVT_MENU, lambda e: self.clear_recent(), id=ID_MENU_FILE_CLEAR)

    def clear_recent(self):
        for i in range(10):
            try:
                setattr(self.context, "file" + str(i), "")
            except IndexError:
                break
        self.populate_recent_menu()

    def save_recent(self, pathname):
        recent = list()
        for i in range(10):
            recent.append(getattr(self.context, "file" + str(i)))
        recent = [r for r in recent if r is not None and r != pathname and len(r) > 0]
        recent.insert(0, pathname)
        for i in range(10):
            try:
                setattr(self.context, "file" + str(i), recent[i])
            except IndexError:
                break
        self.populate_recent_menu()

    def load(self, pathname):
        self.context.setting(bool, "auto_note", True)
        self.context.setting(bool, "uniform_svg", False)
        self.context.setting(float, "svg_ppi", 96.0)
        with wx.BusyInfo(_("Loading File...")):
            n = self.context.elements.note
            results = self.context.load(
                pathname,
                channel=self.context.channel("load"),
                svg_ppi=self.context.svg_ppi,
            )
            if results is not None:
                elements, pathname, basename = results
                self.save_recent(pathname)
                self.context.classify(elements)
                if n != self.context.elements.note and self.context.auto_note:
                    self.context.open("window/Notes", self)
                try:
                    if (
                        self.context.uniform_svg and pathname.lower().endswith("svg")
                    ) or (len(elements) > 0 and "meerK40t" in elements[0].values):
                        self.working_file = pathname
                except AttributeError:
                    pass
                return True
            return False

    def on_drop_file(self, event):
        """
        Drop file handler

        Accepts multiple files drops.
        """
        accepted = 0
        rejected = 0
        rejected_files = []
        for pathname in event.GetFiles():
            if self.load(pathname):
                accepted += 1
            else:
                rejected += 1
                rejected_files.append(pathname)
        if rejected != 0:
            reject = "\n".join(rejected_files)
            err_msg = _("Some files were unrecognized:\n%s") % reject
            dlg = wx.MessageDialog(
                None, err_msg, _("Error encountered"), wx.OK | wx.ICON_ERROR
            )
            dlg.ShowModal()
            dlg.Destroy()

    def on_paint(self, event):
        try:
            if self._Buffer is None:
                self.update_buffer_ui_thread()
            wx.BufferedPaintDC(self.scene, self._Buffer)
        except RuntimeError:
            pass

    def set_buffer(self):
        width, height = self.scene.ClientSize
        if width <= 0:
            width = 1
        if height <= 0:
            height = 1
        self._Buffer = wx.Bitmap(width, height)

    def on_size(self, event):
        if self.context is None:
            return
        self.Layout()
        self.context.window_width, self.context.window_height = self.Size
        self.widget_scene.signal("guide")
        self.request_refresh()

    def update_position(self, pos):
        self.laserpath[0][self.laserpath_index][0] = pos[0]
        self.laserpath[0][self.laserpath_index][1] = pos[1]
        self.laserpath[1][self.laserpath_index][0] = pos[2]
        self.laserpath[1][self.laserpath_index][1] = pos[3]
        self.context._reticle_x = pos[2]
        self.context._reticle_y = pos[3]
        self.laserpath_index += 1
        self.laserpath_index %= len(self.laserpath[0])
        # self.request_refresh()
        self.request_refresh_for_animation()

    def space_changed(self, *args):
        self.ribbon_position_units = self.context.units_index
        self.update_ribbon_position()
        self.widget_scene.signal("grid")
        self.widget_scene.signal("guide")
        self.request_refresh()

    def bed_changed(self, *args):
        self.widget_scene.signal("grid")
        # self.widget_scene.signal('guide')
        self.request_refresh()

    def on_emphasized_elements_changed(self, *args):
        self.update_ribbon_position()
        self.clear_laserpath()
        self.root.select_in_tree_by_selected()
        self.request_refresh()

    def on_element_alteration(self, *args):
        self.context.signal("rebuild_tree")

    def on_element_modified(self, *args):
        self.update_ribbon_position()

    def clear_laserpath(self):
        self.laserpath = [[0, 0] for i in range(1000)], [[0, 0] for i in range(1000)]
        self.laserpath_index = 0

    def on_erase(self, event):
        pass

    def request_refresh_for_animation(self):
        """Called on the various signals trying to animate the screen."""
        try:
            if self.context.draw_mode & DRAW_MODE_ANIMATE == 0:
                self.request_refresh()
        except AttributeError:
            pass

    def request_refresh(self):
        """Request an update to the scene."""
        try:
            if self.context.draw_mode & DRAW_MODE_REFRESH == 0:
                self.screen_refresh_is_requested = True
        except AttributeError:
            pass

    def refresh_scene(self):
        """Called by the Scheduler at a given the specified framerate."""
        if self.screen_refresh_is_requested and not self.screen_refresh_is_running:
            self.screen_refresh_is_running = True
            if self.screen_refresh_lock.acquire(timeout=1):
                if not wx.IsMainThread():
                    wx.CallAfter(self._refresh_in_ui)
                else:
                    self._refresh_in_ui()
            else:
                self.screen_refresh_is_requested = False
                self.screen_refresh_is_running = False

    def _refresh_in_ui(self):
        """Called by refresh_scene() in the UI thread."""
        if self.context is None:
            return
        self.update_buffer_ui_thread()
        self.scene.Refresh()
        self.scene.Update()
        self.screen_refresh_is_requested = False
        self.screen_refresh_is_running = False
        self.screen_refresh_lock.release()

    def update_buffer_ui_thread(self):
        """Performs the redraw of the data in the UI thread."""
        dm = self.context.draw_mode
        if self._Buffer is None or self._Buffer.GetSize() != self.scene.ClientSize:
            self.set_buffer()
        dc = wx.MemoryDC()
        dc.SelectObject(self._Buffer)
        dc.SetBackground(self.background_brush)
        dc.Clear()
        w, h = dc.Size
        if dm & DRAW_MODE_FLIPXY != 0:
            dc.SetUserScale(-1, -1)
            dc.SetLogicalOrigin(w, h)
        gc = wx.GraphicsContext.Create(dc)
        gc.Size = dc.Size

        gc.laserpath = self.laserpath
        font = wx.Font(14, wx.SWISS, wx.NORMAL, wx.BOLD)
        gc.SetFont(font, wx.BLACK)
        if self.widget_scene is not None:
            self.widget_scene.draw(gc)
        if dm & DRAW_MODE_INVERT != 0:
            dc.Blit(0, 0, w, h, dc, 0, 0, wx.SRC_INVERT)
        gc.Destroy()
        del dc

    # Mouse Events.

    def on_mousewheel(self, event):
        if self.scene.HasCapture():
            return
        rotation = event.GetWheelRotation()
        if self.context.mouse_zoom_invert:
            rotation = -rotation
        if rotation > 1:
            self.widget_scene.event(event.GetPosition(), "wheelup")
        elif rotation < -1:
            self.widget_scene.event(event.GetPosition(), "wheeldown")

    def on_mouse_middle_down(self, event):
        self.scene.SetFocus()
        if not self.scene.HasCapture():
            self.scene.CaptureMouse()
        self.widget_scene.event(event.GetPosition(), "middledown")

    def on_mouse_middle_up(self, event):
        if self.scene.HasCapture():
            self.scene.ReleaseMouse()
        self.widget_scene.event(event.GetPosition(), "middleup")

    def on_left_mouse_down(self, event):
        self.scene.SetFocus()
        if not self.scene.HasCapture():
            self.scene.CaptureMouse()
        self.widget_scene.event(event.GetPosition(), "leftdown")

    def on_left_mouse_up(self, event):
        if self.scene.HasCapture():
            self.scene.ReleaseMouse()
        self.widget_scene.event(event.GetPosition(), "leftup")

    def on_mouse_double_click(self, event):
        if self.scene.HasCapture():
            return
        self.widget_scene.event(event.GetPosition(), "doubleclick")

    def on_mouse_move(self, event):
        if not event.Dragging():
            self.widget_scene.event(event.GetPosition(), "hover")
            return
        self.widget_scene.event(event.GetPosition(), "move")

    def on_right_mouse_down(self, event):
        self.scene.SetFocus()
        self.widget_scene.event(event.GetPosition(), "rightdown")

    def on_right_mouse_up(self, event):
        self.widget_scene.event(event.GetPosition(), "rightup")

    def on_focus_lost(self, event):
        self.context.console("-laser\nend\n")
        # event.Skip()

    def on_key_down(self, event):
        keyvalue = get_key_name(event)
        keymap = self.context.keymap
        if keyvalue in keymap:
            action = keymap[keyvalue]
            self.context.console(action + "\n")
        else:
            event.Skip()

    def on_key_up(self, event):
        keyvalue = get_key_name(event)
        keymap = self.context.keymap
        if keyvalue in keymap:
            action = keymap[keyvalue]
            if action.startswith("+"):
                # Keyup commands only trigger if the down command started with +
                action = "-" + action[1:]
                self.context.console(action + "\n")
        else:
            event.Skip()

    def update_ribbon_position(self):
        p = self.context
        elements = p.elements
        bounds = elements.bounds()
        self.text_w.Enable(bounds is not None)
        self.text_h.Enable(bounds is not None)
        self.text_x.Enable(bounds is not None)
        self.text_y.Enable(bounds is not None)
        self.button_aspect_ratio.Enable(bounds is not None)
        if bounds is None:
            self.ribbon_position_ignore_update = True
            self.combo_box_units.SetSelection(self.ribbon_position_units)
            self.ribbon_position_ignore_update = False
            return
        x0, y0, x1, y1 = bounds
        conversion, name, index = (39.37, "mm", 0)
        if self.ribbon_position_units == 2:
            conversion, name, index = (1000.0, "in", 2)
        elif self.ribbon_position_units == 3:
            conversion, name, index = (1.0, "mil", 3)
        elif self.ribbon_position_units == 1:
            conversion, name, index = (393.7, "cm", 1)
        elif self.ribbon_position_units == 0:
            conversion, name, index = (39.37, "mm", 0)
        self.ribbon_position_name = name
        self.ribbon_position_x = x0 / conversion
        self.ribbon_position_y = y0 / conversion
        self.ribbon_position_w = (x1 - x0) / conversion
        self.ribbon_position_h = (y1 - y0) / conversion
        self.ribbon_position_ignore_update = True
        if self.ribbon_position_units != 4:
            self.text_x.SetValue("%.2f" % self.ribbon_position_x)
            self.text_y.SetValue("%.2f" % self.ribbon_position_y)
            self.text_w.SetValue("%.2f" % self.ribbon_position_w)
            self.text_h.SetValue("%.2f" % self.ribbon_position_h)
        else:
            self.text_x.SetValue("%.2f" % 100)
            self.text_y.SetValue("%.2f" % 100)
            self.text_w.SetValue("%.2f" % 100)
            self.text_h.SetValue("%.2f" % 100)
        self.combo_box_units.SetSelection(self.ribbon_position_units)
        self.ribbon_position_ignore_update = False

    def on_text_x(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            if self.ribbon_position_units != 4:
                self.ribbon_position_x = float(self.text_x.GetValue())
        except ValueError:
            pass

    def on_text_y(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            if self.ribbon_position_units != 4:
                self.ribbon_position_y = float(self.text_y.GetValue())
        except ValueError:
            pass

    def on_text_w(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            new = float(self.text_w.GetValue())
            old = self.ribbon_position_w
            if self.ribbon_position_units == 4:
                ratio = new / 100.0
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_h.SetValue("%.2f" % (ratio * 100))
                    self.ribbon_position_ignore_update = False
            else:
                ratio = new / old
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_h.SetValue("%.2f" % (self.ribbon_position_h * ratio))
                    self.ribbon_position_ignore_update = False
        except (ValueError, ZeroDivisionError):
            pass

    def on_button_aspect_ratio(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        if self.ribbon_position_aspect_ratio:
            self.button_aspect_ratio.SetBitmap(icons8_padlock_50.GetBitmap())
        else:
            self.button_aspect_ratio.SetBitmap(icons8_lock_50.GetBitmap())
        self.ribbon_position_aspect_ratio = not self.ribbon_position_aspect_ratio

    def on_text_h(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        try:
            new = float(self.text_h.GetValue())
            old = self.ribbon_position_h
            if self.ribbon_position_units == 4:
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_w.SetValue("%.2f" % (new))
                    self.ribbon_position_ignore_update = False
            else:
                if self.ribbon_position_aspect_ratio:
                    self.ribbon_position_ignore_update = True
                    self.text_w.SetValue(
                        "%.2f" % (self.ribbon_position_w * (new / old))
                    )
                    self.ribbon_position_ignore_update = False
        except (ValueError, ZeroDivisionError):
            pass

    def on_text_dim_enter(self, event):
        if self.ribbon_position_units == 4:
            ratio_w = float(self.text_w.GetValue()) / 100.0
            ratio_h = float(self.text_h.GetValue()) / 100.0
            self.ribbon_position_w *= ratio_w
            self.ribbon_position_h *= ratio_h
        else:
            w = float(self.text_w.GetValue())
            h = float(self.text_h.GetValue())
            self.ribbon_position_w = w
            self.ribbon_position_h = h
        self.context.console(
            "resize %f%s %f%s %f%s %f%s\n"
            % (
                self.ribbon_position_x,
                self.ribbon_position_name,
                self.ribbon_position_y,
                self.ribbon_position_name,
                self.ribbon_position_w,
                self.ribbon_position_name,
                self.ribbon_position_h,
                self.ribbon_position_name,
            )
        )
        self.update_ribbon_position()

    def on_text_pos_enter(self, event):
        if self.ribbon_position_units == 4:
            ratio_x = float(self.text_x.GetValue()) / 100.0
            ratio_y = float(self.text_y.GetValue()) / 100.0
            self.ribbon_position_x *= ratio_x
            self.ribbon_position_y *= ratio_y
        else:
            x = float(self.text_x.GetValue())
            y = float(self.text_y.GetValue())
            self.ribbon_position_x = x
            self.ribbon_position_y = y
        self.context.open("module", "Console").write(
            "resize %f%s %f%s %f%s %f%s\n"
            % (
                self.ribbon_position_x,
                self.ribbon_position_name,
                self.ribbon_position_y,
                self.ribbon_position_name,
                self.ribbon_position_w,
                self.ribbon_position_name,
                self.ribbon_position_h,
                self.ribbon_position_name,
            )
        )
        self.update_ribbon_position()

    def on_combo_box_units(self, event):  # wxGlade: MyFrame.<event_handler>
        if self.ribbon_position_ignore_update:
            return
        self.ribbon_position_units = self.combo_box_units.GetSelection()
        self.update_ribbon_position()

    def on_click_new(self, event):  # wxGlade: MeerK40t.<event_handler>
        context = self.context
        self.working_file = None
        context.elements.clear_all()
        self.clear_laserpath()
        self.request_refresh()
        self.context.signal("rebuild_tree", 0)

    def on_click_open(self, event):  # wxGlade: MeerK40t.<event_handler>
        # This code should load just specific project files rather than all importable formats.
        files = self.context.load_types()
        with wx.FileDialog(
            self, _("Open"), wildcard=files, style=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
            self.load(pathname)

    def on_click_pause(self, event):
        self.context.console("control Realtime Pause_Resume\n")

    def on_click_save(self, event):
        if self.working_file is None:
            self.on_click_save_as(event)
        else:
            self.context.save(self.working_file)

    def on_click_save_as(self, event):
        files = self.context.save_types()
        with wx.FileDialog(
            self,
            "Save Project",
            wildcard=files,
            style=wx.FD_SAVE | wx.FD_OVERWRITE_PROMPT,
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
            if not pathname.lower().endswith(".svg"):
                pathname += ".svg"
            self.context.save(pathname)
            self.working_file = pathname

    def on_click_exit(self, event):  # wxGlade: MeerK40t.<event_handler>
        try:
            self.Close()
        except RuntimeError:
            pass

    def on_click_zoom_out(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoomout button press
        """
        m = self.scene.ClientSize / 2
        self.widget_scene.widget_root.scene_widget.scene_post_scale(
            1.0 / 1.5, 1.0 / 1.5, m[0], m[1]
        )
        self.request_refresh()

    def on_click_zoom_in(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoomin button press
        """
        m = self.scene.ClientSize / 2
        self.widget_scene.widget_root.scene_widget.scene_post_scale(
            1.5, 1.5, m[0], m[1]
        )
        self.request_refresh()

    def on_click_zoom_size(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Zoom size button press.
        """
        elements = self.context.elements
        bbox = elements.bounds()
        if bbox is None:
            bedwidth = self.context.bed_width
            bedheight = self.context.bed_height
            bbox = (0, 0, bedwidth * MILS_IN_MM, bedheight * MILS_IN_MM)
        self.widget_scene.widget_root.focus_viewport_scene(bbox, self.scene.ClientSize)

    def toggle_draw_mode(self, bits):
        """
        Toggle the draw mode.
        :param bits: Bit to toggle.
        :return: Toggle function.
        """

        def toggle(event):
            self.context.draw_mode ^= bits
            self.context.signal("draw_mode", self.context.draw_mode)
            self.request_refresh()

        return toggle

    def open_speedcode_gear_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter Forced Gear"), _("Gear Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            value = dlg.GetValue()
            if value in ("0", "1", "2", "3", "4"):
                self.context._stepping_force = int(value)
            else:
                self.context._stepping_force = None
        dlg.Destroy()

    def open_fps_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter FPS Limit"), _("FPS Limit Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            fps = dlg.GetValue()
            try:
                self.set_fps(int(fps))
            except ValueError:
                pass
        dlg.Destroy()

    def open_transform_dialog(self):
        dlg = wx.TextEntryDialog(
            self,
            _(
                "Enter SVG Transform Instruction e.g. 'scale(1.49, 1, $x, $y)', rotate, translate, etc..."
            ),
            _("Transform Entry"),
            "",
        )
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            p = self.context
            context_root = self.context.get_context("/")
            m = str(dlg.GetValue())
            m = m.replace("$x", str(p.current_x))
            m = m.replace("$y", str(p.current_y))
            mx = Matrix(m)
            wmils = p.bed_width * 39.37
            hmils = p.bed_height * 39.37
            mx.render(ppi=1000, width=wmils, height=hmils)
            if mx.is_identity():
                dlg.Destroy()
                dlg = wx.MessageDialog(
                    None,
                    _("The entered command does nothing."),
                    _("Non-Useful Matrix."),
                    wx.OK | wx.ICON_WARNING,
                )
                result = dlg.ShowModal()
                dlg.Destroy()
            else:
                for element in context_root.elements.elems():
                    try:
                        element *= mx
                        element.modified()
                    except AttributeError:
                        pass

    def open_fill_dialog(self):
        context = self.context
        elements = context.elements
        first_selected = elements.first_element(selected=True)
        if first_selected is None:
            return
        data = wx.ColourData()
        if first_selected.fill is not None and first_selected.fill != "none":
            data.SetColour(wx.Colour(swizzlecolor(first_selected.fill)))
        dlg = wx.ColourDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            rgb = color.GetRGB()
            color = swizzlecolor(rgb)
            color = Color(color, 1.0)
            for elem in elements.elems(emphasized=True):
                elem.fill = color
                elem.altered()

    def open_stroke_dialog(self):
        context = self.context
        elements = context.elements
        first_selected = elements.first_element(emphasized=True)
        if first_selected is None:
            return
        data = wx.ColourData()
        if first_selected.stroke is not None and first_selected.stroke != "none":
            data.SetColour(wx.Colour(swizzlecolor(first_selected.stroke)))
        dlg = wx.ColourDialog(self, data)
        if dlg.ShowModal() == wx.ID_OK:
            data = dlg.GetColourData()
            color = data.GetColour()
            rgb = color.GetRGB()
            color = swizzlecolor(rgb)
            color = Color(color, 1.0)
            for elem in elements.elems(emphasized=True):
                elem.stroke = color
                elem.altered()

    def open_flip_dialog(self):
        dlg = wx.TextEntryDialog(
            self,
            _(
                "Material must be jigged at 0,0 either home or home offset.\nHow wide is your material (give units: in, mm, cm, px, etc)?"
            ),
            _("Double Side Flip"),
            "",
        )
        dlg.SetValue("")
        if dlg.ShowModal() == wx.ID_OK:
            p = self.context
            context = p
            wmils = p.bed_width * MILS_IN_MM
            hmils = p.bed_height * MILS_IN_MM
            length = Length(dlg.GetValue()).value(ppi=1000.0, relative_length=wmils)
            mx = Matrix()
            mx.post_scale(-1.0, 1, length / 2.0, 0)
            for element in context.elements.elems(emphasized=True):
                try:
                    element *= mx
                    element.modified()
                except AttributeError:
                    pass
        dlg.Destroy()

    def open_path_dialog(self):
        dlg = wx.TextEntryDialog(self, _("Enter SVG Path Data"), _("Path Entry"), "")
        dlg.SetValue("")

        if dlg.ShowModal() == wx.ID_OK:
            context = self.context
            path = Path(dlg.GetValue())
            path.stroke = "blue"
            p = abs(path)
            context.elements.add_elem(p)
            self.context.classify(p)
        dlg.Destroy()

    def egv_import(self):
        pathname = None
        files = "*.egv"
        with wx.FileDialog(
            self,
            _("Import EGV"),
            wildcard=files,
            style=wx.FD_OPEN | wx.FD_FILE_MUST_EXIST,
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
        if pathname is None:
            return
        with wx.BusyInfo(_("Loading File...")):
            self.context.console("egv_import %s\n" % pathname)
            return

    def egv_export(self):
        pathname = None
        files = "*.egv"
        with wx.FileDialog(
            self, _("Export EGV"), wildcard=files, style=wx.FD_SAVE
        ) as fileDialog:
            if fileDialog.ShowModal() == wx.ID_CANCEL:
                return  # the user changed their mind
            pathname = fileDialog.GetPath()
        if pathname is None:
            return
        with wx.BusyInfo(_("Saving File...")):
            self.context.console("egv_export %s\n" % pathname)
            return

    def apply_rotary_scale(self):
        kernel = self.context._kernel
        sx = self.context.scale_x
        sy = self.context.scale_y
        p = self.context

        mx = Matrix("scale(%f, %f, %f, %f)" % (sx, sy, p.current_x, p.current_y))
        for element in kernel.elements.elems():
            try:
                element *= mx
                element.modified()
            except AttributeError:
                pass

    def toggle_rotary_view(self):
        if self._rotary_view:
            self.widget_scene.rotary_stretch()
        else:
            self.widget_scene.rotary_unstretch()
        self._rotary_view = not self._rotary_view

    def run_jog_transition_finish_test(self):
        return self.run_jog_transition_test(COMMAND_JOG_FINISH)

    def run_jog_transition_switch_test(self):
        return self.run_jog_transition_test(COMMAND_JOG_SWITCH)

    def run_jog_transition_test(self, command=COMMAND_JOG):
        """ "
        The Jog Transition Test is intended to test the jogging
        """

        def jog_transition_test():
            yield COMMAND_SET_ABSOLUTE
            yield COMMAND_MODE_RAPID
            yield COMMAND_HOME
            yield COMMAND_LASER_OFF
            yield COMMAND_WAIT_FINISH
            yield COMMAND_MOVE, 3000, 3000
            yield COMMAND_WAIT_FINISH
            yield COMMAND_LASER_ON
            yield COMMAND_WAIT, 0.05
            yield COMMAND_LASER_OFF
            yield COMMAND_WAIT_FINISH

            yield COMMAND_SET_SPEED, 10.0

            def pos(i):
                if i < 3:
                    x = 200
                elif i < 6:
                    x = -200
                else:
                    x = 0
                if i % 3 == 0:
                    y = 200
                elif i % 3 == 1:
                    y = -200
                else:
                    y = 0
                return x, y

            for q in range(8):
                top = q & 1
                left = q & 2
                x_val = q & 3
                yield COMMAND_SET_DIRECTION, top, left, x_val, not x_val
                yield COMMAND_MODE_PROGRAM
                for j in range(9):
                    jx, jy = pos(j)
                    for k in range(9):
                        kx, ky = pos(k)
                        yield COMMAND_MOVE, 3000, 3000
                        yield COMMAND_MOVE, 3000 + jx, 3000 + jy
                        yield command, 3000 + jx + kx, 3000 + jy + ky
                yield COMMAND_MOVE, 3000, 3000
                yield COMMAND_MODE_RAPID
                yield COMMAND_WAIT_FINISH
                yield COMMAND_LASER_ON
                yield COMMAND_WAIT, 0.05
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH

        self.context.spooler.job(jog_transition_test)

    def run_home_and_dot_test(self):
        def home_dot_test():
            for i in range(25):
                yield COMMAND_SET_ABSOLUTE
                yield COMMAND_MODE_RAPID
                yield COMMAND_HOME
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH
                yield COMMAND_MOVE, 3000, 3000
                yield COMMAND_WAIT_FINISH
                yield COMMAND_LASER_ON
                yield COMMAND_WAIT, 0.05
                yield COMMAND_LASER_OFF
                yield COMMAND_WAIT_FINISH
            yield COMMAND_HOME
            yield COMMAND_WAIT_FINISH

        self.context.spooler.job(home_dot_test)

    def launch_webpage(self, event):  # wxGlade: MeerK40t.<event_handler>
        """
        Launch webpage

        :param event:
        :return:
        """
        import webbrowser

        webbrowser.open(MEERK40T_WEBSITE, new=0, autoraise=True)


NODE_ROOT = 0
NODE_OPERATION_BRANCH = 10
NODE_OPERATION = 11
NODE_OPERATION_ELEMENT = 12
NODE_ELEMENTS_BRANCH = 20
NODE_ELEMENT = 21
NODE_FILES_BRANCH = 30
NODE_FILE_FILE = 31
NODE_FILE_ELEMENT = 32


class Node(list):
    """
    Generic Node Type for use with RootNode
    Creating the object registers the position in the tree according to the parent and root.
    Deleting the object deregisters the node in the tree.
    """

    def __init__(self, node_type, data_object, parent, root, pos=None, name=None):
        list.__init__(self)
        self.parent = parent
        self.root = root
        self.object = data_object
        self.type = node_type
        self.name = name
        if name is None:
            if self.name is None:
                try:
                    self.name = self.object.id
                    if self.name is None:
                        self.name = str(self.object)
                except AttributeError:
                    self.name = str(self.object)
        else:
            self.name = name
        self.type = node_type
        parent.append(self)
        self.filepath = None
        try:
            self.bounds = data_object.bbox()
        except AttributeError:
            self.bounds = None
        parent_item = parent.item
        tree = root.tree
        if pos is None:
            item = tree.AppendItem(parent_item, self.name)
        else:
            item = tree.InsertItem(parent_item, pos, self.name)
        self.item = item
        if id(data_object) in self.root.tree_lookup:
            self.root.tree_lookup[id(data_object)].append(self)
        else:
            self.root.tree_lookup[id(data_object)] = [self]
        tree.SetItemData(self.item, self)
        try:
            stroke = data_object.values[SVG_ATTR_STROKE]
            color = wx.Colour(swizzlecolor(Color(stroke).value))
            tree.SetItemTextColour(item, color)
        except AttributeError:
            pass
        except KeyError:
            pass
        except TypeError:
            pass
        self.set_icon()
        root.notify_added(self)

    def __str__(self):
        return "Node(%s, %d)" % (str(self.item), self.type)

    def __repr__(self):
        return "Node(%d, %s, %s, %s)" % (
            self.type,
            str(self.object),
            str(self.parent),
            str(self.root),
        )

    def update_name(self):
        self.name = None
        try:
            self.name = self.object.id
        except AttributeError:
            pass
        if self.name is None:
            self.name = str(self.object)
        self.root.tree.SetItemText(self.item, self.name)
        try:
            stroke = self.object.values[SVG_ATTR_STROKE]
            color = wx.Colour(swizzlecolor(Color(stroke).value))
            self.root.tree.SetItemTextColour(self.item, color)
        except AttributeError:
            pass
        try:
            color = self.object.color
            c = wx.Colour(swizzlecolor(Color(color)))
            self.root.tree.SetItemTextColour(self.item, c)
        except AttributeError:
            pass

    def remove_node(self):
        for q in self:
            q.remove_node()
        root = self.root
        links = root.tree_lookup[id(self.object)]
        links.remove(self)
        self.parent.remove(self)
        try:
            root.tree.Delete(self.item)
        except RuntimeError:
            return
        root.notify_removed(self)
        self.item = None
        self.parent = None
        self.root = None
        self.type = -1

    def move_node(self, new_parent, pos=None):
        tree = self.root.tree
        item = self.item
        image = tree.GetItemImage(item)
        data = tree.GetItemData(item)
        color = tree.GetItemTextColour(item)
        tree.Delete(item)
        if pos is None:
            self.item = tree.AppendItem(new_parent.item, self.name)
        else:
            self.item = tree.InsertItem(new_parent.item, pos, self.name)
        item = self.item
        tree.SetItemImage(item, image)
        tree.SetItemData(item, data)
        tree.SetItemTextColour(item, color)

    def __eq__(self, other):
        return other is self

    def set_color(self, color=None):
        root = self.root
        item = self.item
        tree = root.tree
        if color is None:
            tree.SetItemTextColour(item, None)
        else:
            tree.SetItemTextColour(item, wx.Colour(swizzlecolor(color)))

    def set_icon(self, icon=None):
        root = self.root
        drawmode = self.root.gui.context.draw_mode
        if drawmode & DRAW_MODE_ICONS != 0:
            return
        item = self.item
        data_object = self.object
        tree = root.tree
        if icon is None:
            if isinstance(data_object, SVGImage):
                image = self.root.renderer.make_thumbnail(
                    data_object.image, width=20, height=20
                )
                image_id = self.root.tree_images.Add(bitmap=image)
                tree.SetItemImage(item, image=image_id)
            if isinstance(data_object, (Path, SVGText)):
                image = self.root.renderer.make_raster(
                    data_object, data_object.bbox(), width=20, height=20, bitmap=True
                )
                if image is not None:
                    image_id = self.root.tree_images.Add(bitmap=image)
                    tree.SetItemImage(item, image=image_id)
                    tree.Update()
        else:
            image_id = self.root.tree_images.Add(bitmap=icon)
            tree.SetItemImage(item, image=image_id)

    def bbox(self):
        return CutPlanner.bounding_box(self.object)

    def objects_of_children(self, types):
        if isinstance(self.object, types):
            yield self.object
        for q in self:
            for o in q.objects_of_children(types):
                yield o

    def contains_path(self):
        if isinstance(self.object, Path):
            return True
        for q in self:
            if q.contains_path():
                return True
        return False

    def contains_image(self):
        if isinstance(self.object, SVGImage):
            return True
        for q in self:
            if q.contains_image():
                return True
        return False

    def contains_text(self):
        if isinstance(self.object, SVGText):
            return True
        for q in self:
            if q.contains_text():
                return True
        return False


class RootNode(list):
    """ "Nodes are the presentation layer used to wrap the LaserOperations and the SVGElement classes. Stored in the
    elements. This serves to help with menu creation, naming, drag and drop.

    The tree is structured with three main sub-elements of the RootNode, these are the Operations, the Elements, and
    the files. The primary distinction between the items within elements is that an item appears twice in the tree with
    different highlighting, selection, and interactions.

    The Operations each contain a list of elements they run in order and are stored within each operation.

    Elements store the scene's graphics elements. The Elements are stored in their order. Changes in this structure
    should reflect those changes back to structure of elements.

    Deleting an element from the tree should remove that element from any operation using it.

    Deleting an operation should make no change to the graphical elements structure.

    All the nodes store a reference to their given tree item. So that a determination can be made when those items have
    changed and provide piecemeal updates to the tree.
    """

    def __init__(self, context, gui, elements):
        list.__init__(self)
        self.root = self
        self.parent = self
        self.object = "Project"
        self.name = "Project"
        self.type = NODE_ROOT

        self.context = context
        self.gui = gui
        self.tree = gui.tree
        self.renderer = gui.renderer
        self.elements = elements

        self.item = None
        self.dragging_node = None
        self.dragging_parent = None
        self.tree_images = None
        self.tree_lookup = None
        self.node_elements = None
        self.node_operations = None
        self.node_files = None
        self.do_not_select = False
        self.context.signal("rebuild_tree")

    def refresh_tree(self, node=None):
        """Any tree elements currently displaying wrong data as per elements should be updated to display
        the proper values and contexts and icons. This will not happen for any elements currently within
        a closed branch."""
        if node is None:
            node = self.root.item
        if node is None:
            return
        tree = self.tree

        child, cookie = tree.GetFirstChild(node)
        while child.IsOk():
            child_node = self.tree.GetItemData(child)
            element = child_node.object
            tree.SetItemBackgroundColour(child, None)
            try:
                if element.highlighted:
                    tree.SetItemBackgroundColour(child, wx.YELLOW)
                elif element.emphasized:
                    tree.SetItemBackgroundColour(child, wx.CYAN)
                elif element.selected:
                    tree.SetItemBackgroundColour(child, wx.RED)
            except AttributeError:
                pass
            self.refresh_tree(child)
            child, cookie = tree.GetNextChild(node, cookie)

    def rebuild_tree(self):
        context = self.context
        elements = context.elements
        self.tree.DeleteAllItems()
        self.tree_images = wx.ImageList()
        self.tree_images.Create(width=20, height=20)
        self.tree_lookup = {}
        self.tree.SetImageList(self.tree_images)
        self.item = self.tree.AddRoot(self.name)
        self.node_operations = Node(
            NODE_OPERATION_BRANCH,
            elements._operations,
            self,
            self,
            name=_("Operations"),
        )
        self.node_operations.set_icon(icons8_laser_beam_20.GetBitmap())
        self.build_tree(self.node_operations, list(elements.ops()))
        for n in self.node_operations:
            try:
                op = n.object.operation
            except AttributeError:
                op = None
            if op in ("Raster", "Image"):
                n.set_icon(icons8_direction_20.GetBitmap())
            else:
                n.set_icon(icons8_laser_beam_20.GetBitmap())
            try:
                c = n.object.color
                n.set_color(c)
            except AttributeError:
                pass

        self.node_elements = Node(
            NODE_ELEMENTS_BRANCH, elements._elements, self, self, name=_("Elements")
        )
        self.node_elements.set_icon(icons8_vector_20.GetBitmap())
        self.build_tree(self.node_elements, list(elements.elems()))

        self.node_files = Node(
            NODE_FILES_BRANCH, elements.files(), self, self, name=_("Files")
        )
        self.node_files.set_icon(icons8_file_20.GetBitmap())
        self.build_tree(self.node_files, elements.files())

        for n in self.node_files:
            n.set_icon(icons8_file_20.GetBitmap())

        self.tree.ExpandAll()

    def build_tree(self, parent_node, objects):
        if isinstance(objects, list):
            for obj in objects:
                node = Node(parent_node.type + 1, obj, parent_node, self)
                self.build_tree(node, obj)
        elif isinstance(objects, dict):
            for obj_key, obj_value in objects.items():
                node = Node(parent_node.type + 1, obj_key, parent_node, self)
                node.filepath = obj_key
                if not isinstance(obj_value, (list, dict)):
                    obj_value = [obj_value]
                self.build_tree(node, obj_value)

    def notify_added(self, node):
        pass

    def notify_removed(self, node):
        pass

    def notify_tree_data_change(self):
        self.context.signal("rebuild_tree", 0)

    def notify_tree_data_cleared(self):
        self.context.signal("rebuild_tree", 0)

    def on_element_update(self, *args):
        element = args[0]
        try:
            nodes = self.tree_lookup[id(element)]
            for node in nodes:
                node.update_name()
        except KeyError:
            pass

    def on_drag_begin_handler(self, event):
        """
        Drag handler begin for the tree.

        :param event:
        :return:
        """
        self.dragging_node = None

        drag_item = event.GetItem()
        if drag_item is None:
            event.Skip()
            return
        if drag_item.ID is None:
            event.Skip()
            return
        if not drag_item.IsOk():
            event.Skip()
            return
        node_data = self.tree.GetItemData(drag_item)
        if (
            node_data.type == NODE_ELEMENTS_BRANCH
            or node_data.type == NODE_OPERATION_BRANCH
            or node_data.type == NODE_FILES_BRANCH
            or node_data.type == NODE_FILE_ELEMENT
            or node_data.type == NODE_FILE_FILE
        ):
            event.Skip()
            return
        self.dragging_node = node_data
        event.Allow()

    def on_drag_end_handler(self, event):
        """
        Drag end handler for the tree

        :param event:
        :return:
        """
        if self.dragging_node is None:
            event.Skip()
            return
        drag_node = self.dragging_node
        self.dragging_node = None

        drop_item = event.GetItem()
        if drop_item is None:
            event.Skip()
            return
        if drop_item.ID is None:
            event.Skip()
            return

        drop_node = self.tree.GetItemData(drop_item)
        if drop_node is None or drop_node == drag_node:
            event.Skip()
            return
        if drag_node.type == NODE_ELEMENT:
            if drop_node.type == NODE_OPERATION:
                # Dragging element into operation adds that element to the op.
                drop_node.object.insert(0, drag_node.object)
                self.notify_tree_data_change()
                event.Allow()
                return
            elif drop_node.type == NODE_ELEMENT:
                # Dragging element into element.
                if drag_node.parent is drop_node.parent:
                    # Dragging and dropping within the same parent puts insert on other side.
                    drag_index = drag_node.parent.index(drag_node)
                    drag_node.parent.object[drag_index] = None
                    drop_index = drop_node.parent.index(drop_node)
                    if drag_index > drop_index:
                        drop_node.parent.object.insert(drop_index, drag_node.object)
                    else:
                        drop_node.parent.object.insert(drop_index + 1, drag_node.object)
                else:
                    drag_index = drag_node.parent.index(drag_node)
                    drag_node.parent.object[drag_index] = None

                    drop_index = drop_node.parent.index(drop_node)
                    drop_node.parent.object.insert(drop_index, drag_node.object)

                nodes = [n for n in drag_node.parent.object if n is not None]
                drag_node.parent.object.clear()
                drag_node.parent.object.extend(nodes)
                self.notify_tree_data_change()
                event.Allow()
                return
            elif drop_node.type == NODE_OPERATION_ELEMENT:
                drop_index = drop_node.parent.object.index(drop_node.object)
                drop_node.parent.object.insert(drop_index, drag_node.object)
                event.Allow()
                self.notify_tree_data_change()
                return
            elif drop_node.type == NODE_OPERATION_BRANCH:
                obj = drag_node.object
                self.context.classify([obj])
                event.Allow()
                self.notify_tree_data_change()
        elif drag_node.type == NODE_OPERATION_ELEMENT:
            if drop_node.type == NODE_OPERATION:
                # Dragging from op element to operation.
                drag_index = drag_node.parent.index(drag_node)
                drag_node.parent.object[drag_index] = None
                drop_node.object.append(drag_node.object)
                nodes = [
                    op_elem
                    for op_elem in drag_node.parent.object
                    if op_elem is not None
                ]
                drag_node.parent.object.clear()
                drag_node.parent.object.extend(nodes)
                event.Allow()
                self.notify_tree_data_change()
                return
            if drop_node.type == NODE_OPERATION_ELEMENT:
                if drag_node.parent is drop_node.parent:
                    # Dragging and dropping within the same parent puts insert on other side.
                    drag_index = drag_node.parent.index(drag_node)
                    drag_node.parent.object[drag_index] = None
                    drop_index = drop_node.parent.index(drop_node)
                    if drag_index > drop_index:
                        drop_node.parent.object.insert(drop_index, drag_node.object)
                    else:
                        drop_node.parent.object.insert(drop_index + 1, drag_node.object)
                else:
                    drag_index = drag_node.parent.index(drag_node)
                    drag_node.parent.object[drag_index] = None

                    drop_index = drop_node.parent.index(drop_node)
                    drop_node.parent.object.insert(drop_index, drag_node.object)

                nodes = [n for n in drag_node.parent.object if n is not None]
                drag_node.parent.object.clear()
                drag_node.parent.object.extend(nodes)

                event.Allow()
                self.notify_tree_data_change()
                return
        elif drag_node.type == NODE_OPERATION:
            if drop_node.type == NODE_OPERATION:
                # Dragging operation to different operation.
                ops = drop_node.parent
                drop_pos = ops.index(drop_node)
                drag_pos = ops.index(drag_node)
                ops.object[drag_pos] = None
                if drag_pos > drop_pos:
                    ops.object.insert(drop_pos, drag_node.object)
                else:
                    ops.object.insert(drop_pos + 1, drag_node.object)

                nodes = [n for n in ops.object if n is not None]
                ops.object.clear()
                ops.object.extend(nodes)
                event.Allow()
                self.notify_tree_data_change()
                return
            elif drop_node.type == NODE_OPERATION_BRANCH:
                # Dragging operation to op branch.
                pass

    def on_item_right_click(self, event):
        """
        Right click of element in tree.

        :param event:
        :return:
        """
        item = event.GetItem()
        if item is None:
            return
        node = self.tree.GetItemData(item)

        self.root.create_menu(self.gui, node)

    def on_item_activated(self, event):
        """
        Tree item is double-clicked. Launches PropertyWindow associated with that object.

        :param event:
        :return:
        """
        item = event.GetItem()
        node = self.tree.GetItemData(item)
        self.activated_node(node)

    def activated_node(self, node):
        if node is not None:
            self.activated_object(node.object)

    def activate_selected_node(self):
        self.activated_object(self.elements.first_element(selected=True))

    def activated_object(self, obj):
        if obj is None:
            return
        if isinstance(obj, LaserOperation):
            self.context.open("window/OperationProperty", self.gui, obj)
        elif isinstance(obj, Path):
            self.context.open("window/PathProperty", self.gui, obj)
        elif isinstance(obj, SVGText):
            self.context.open("window/TextProperty", self.gui, obj)
        elif isinstance(obj, SVGImage):
            self.context.open("window/ImageProperty", self.gui, obj)
        elif isinstance(obj, SVGElement):
            self.context.open("window/PathProperty", self.gui, obj)

    def on_item_selection_changed(self, event):
        """
        Tree menu item is changed. Modify the selection.

        :param event:
        :return:
        """
        if self.do_not_select:
            return
        selected = [
            self.tree.GetItemData(item).object for item in self.tree.GetSelections()
        ]
        self.elements.set_selected(selected)
        self.refresh_tree()
        self.gui.request_refresh()
        event.Allow()

    def select_in_tree_by_selected(self):
        """
        :return:
        """
        self.do_not_select = True
        for e in self.elements.elems():
            try:
                nodes = self.tree_lookup[id(e)]
                for n in nodes:
                    if n.type == NODE_ELEMENT:
                        self.tree.SelectItem(n.item, e.selected)
            except (KeyError, TypeError):
                self.context.signal("rebuild_tree", 0)
                break
        self.refresh_tree()
        self.gui.request_refresh()
        self.do_not_select = False

    def contains(self, box, x, y=None):
        if y is None:
            y = x[1]
            x = x[0]
        return box[0] <= x <= box[2] and box[1] <= y <= box[3]

    def create_menu(self, gui, node):
        """
        Create menu items. This is used for both the scene and the tree to create menu items.

        :param gui: Gui used to create menu items.
        :param node: The Node clicked on for the generated menu.
        :return:
        """
        if node is None:
            return
        if isinstance(node, SVGElement):
            # If this is called with an SVGElement rather than a Node. Convert them.
            match_object = node
            node = None
            for element in self.node_elements:
                if element.object is match_object:
                    node = element
                    break
        if node is None:
            return
        menu = wx.Menu()
        if isinstance(node, RootNode):
            return
        elements = self.elements

        t = node.type
        selections = [self.tree_lookup[id(e)] for e in elements.elems(emphasized=True)]
        locked = False
        try:
            if node.object.lock:
                locked = True
        except (AttributeError, ValueError):
            pass

        def combined(*args):
            for listv in args:
                for itemv in listv:
                    yield itemv

        selections = [s for s in combined(*selections) if s.type == t]
        if t == NODE_OPERATION:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_execute(node),
                menu.Append(wx.ID_ANY, _("Execute Job"), "", wx.ITEM_NORMAL),
            )
        if t == NODE_OPERATION_BRANCH:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_console("operation * delete"),
                menu.Append(wx.ID_ANY, _("Clear All"), "", wx.ITEM_NORMAL),
            )
        if t == NODE_FILES_BRANCH:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_clear_all_files_branch(node),
                menu.Append(wx.ID_ANY, _("Clear All"), "", wx.ITEM_NORMAL),
            )
        if t == NODE_ELEMENTS_BRANCH:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_console("element * delete"),
                menu.Append(wx.ID_ANY, _("Clear All"), "", wx.ITEM_NORMAL),
            )
        if t == NODE_OPERATION:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_clear_all_operation(node),
                menu.Append(wx.ID_ANY, _("Clear All"), "", wx.ITEM_NORMAL),
            )
        if t in (NODE_OPERATION, NODE_ELEMENT, NODE_FILE_FILE, NODE_OPERATION_ELEMENT):
            gui.Bind(
                wx.EVT_MENU,
                self.menu_remove(node),
                menu.Append(
                    wx.ID_ANY, _("Remove: %s") % str(node.name)[:10], "", wx.ITEM_NORMAL
                ),
            )
        if t in (NODE_ELEMENT, NODE_OPERATION_ELEMENT) and len(selections) > 1:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_console("element delete"),
                menu.Append(
                    wx.ID_ANY,
                    _("Remove: %d objects") % len(selections),
                    "",
                    wx.ITEM_NORMAL,
                ),
            )
        if t == NODE_OPERATION_ELEMENT:
            duplicate_menu_eop = wx.Menu()
            for i in range(1, 10):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_duplicate_element_op(node, i),
                    duplicate_menu_eop.Append(
                        wx.ID_ANY, _("Make %d copies.") % i, "", wx.ITEM_NORMAL
                    ),
                )
            menu.AppendSubMenu(duplicate_menu_eop, _("Clone Reference"))
            duplicate_menu_eop = wx.Menu()
            for i in range(1, 10):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_duplicate(node, i),
                    duplicate_menu_eop.Append(
                        wx.ID_ANY, _("Make %d copies.") % i, "", wx.ITEM_NORMAL
                    ),
                )
            menu.AppendSubMenu(duplicate_menu_eop, _("Duplicate"))
        if (
            t in (NODE_OPERATION, NODE_ELEMENTS_BRANCH, NODE_OPERATION_BRANCH)
            and len(node) > 1
        ):
            gui.Bind(
                wx.EVT_MENU,
                self.menu_reverse_order(node),
                menu.Append(wx.ID_ANY, _("Reverse Layer Order"), "", wx.ITEM_NORMAL),
            )
        if t == NODE_ROOT:
            pass
        elif t == NODE_OPERATION_BRANCH:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_reclassify_operations(node),
                menu.Append(wx.ID_ANY, _("Refresh Classification"), "", wx.ITEM_NORMAL),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.load_default(),
                menu.Append(
                    wx.ID_ANY, _("Set Other/Blue/Red Classify"), "", wx.ITEM_NORMAL
                ),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.load_default2(),
                menu.Append(
                    wx.ID_ANY, _("Set Basic Classification"), "", wx.ITEM_NORMAL
                ),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(LaserOperation()),
                menu.Append(wx.ID_ANY, _("Add Operation"), "", wx.ITEM_NORMAL),
            )
            special_op_menu = wx.Menu()
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(
                    CommandOperation("Home", COMMAND_HOME)
                ),
                special_op_menu.Append(wx.ID_ANY, _("Add Home"), "", wx.ITEM_NORMAL),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(
                    CommandOperation("Beep", COMMAND_BEEP)
                ),
                special_op_menu.Append(wx.ID_ANY, _("Add Beep"), "", wx.ITEM_NORMAL),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(
                    CommandOperation("Origin", COMMAND_MOVE, 0, 0)
                ),
                special_op_menu.Append(
                    wx.ID_ANY, _("Add Move Origin"), "", wx.ITEM_NORMAL
                ),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(
                    CommandOperation(
                        "Interrupt",
                        COMMAND_FUNCTION,
                        self.context.console_function("interrupt\n"),
                    )
                ),
                special_op_menu.Append(
                    wx.ID_ANY, _("Add Interrupt"), "", wx.ITEM_NORMAL
                ),
            )
            gui.Bind(
                wx.EVT_MENU,
                lambda e: self.context.elements.add_op(
                    CommandOperation(
                        "Shutdown",
                        COMMAND_FUNCTION,
                        self.context.console_function("shutdown\n"),
                    )
                ),
                special_op_menu.Append(
                    wx.ID_ANY, _("Add Shutdown"), "", wx.ITEM_NORMAL
                ),
            )
            menu.AppendSubMenu(special_op_menu, _("Special Operations"))
        elif t == NODE_ELEMENTS_BRANCH:
            gui.Bind(
                wx.EVT_MENU,
                self.menu_reclassify_operations(node),
                menu.Append(wx.ID_ANY, _("Reclassify Operations"), "", wx.ITEM_NORMAL),
            )
        elif t == NODE_FILES_BRANCH:
            pass
        elif t == NODE_OPERATION:
            operation_convert_submenu = wx.Menu()
            for name in ("Raster", "Engrave", "Cut"):
                menu_op = operation_convert_submenu.Append(
                    wx.ID_ANY, _("Convert %s") % name, "", wx.ITEM_NORMAL
                )
                gui.Bind(wx.EVT_MENU, self.menu_convert_operation(node, name), menu_op)
            menu.AppendSubMenu(operation_convert_submenu, _("Convert Operation"))
            gui.Bind(
                wx.EVT_MENU,
                self.menu_duplicate_operation(node),
                menu.Append(wx.ID_ANY, _("Duplicate Operation"), "", wx.ITEM_NORMAL),
            )
            duplicate_menu = wx.Menu()
            gui.Bind(
                wx.EVT_MENU,
                self.menu_passes(node, 1),
                duplicate_menu.Append(wx.ID_ANY, _("Add 1 pass."), "", wx.ITEM_NORMAL),
            )
            for i in range(2, 10):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_passes(node, i),
                    duplicate_menu.Append(
                        wx.ID_ANY, _("Add %d passes.") % i, "", wx.ITEM_NORMAL
                    ),
                )
            menu.AppendSubMenu(duplicate_menu, _("Passes"))
            if node.object.operation in ("Raster", "Image"):
                raster_step_menu = wx.Menu()
                for i in range(1, 10):
                    menu_item = raster_step_menu.Append(
                        wx.ID_ANY, _("Step %d") % i, "", wx.ITEM_RADIO
                    )
                    gui.Bind(
                        wx.EVT_MENU, self.menu_raster_step_operation(node, i), menu_item
                    )
                    step = float(node.object.settings.raster_step)
                    if i == step:
                        menu_item.Check(True)
                menu.AppendSubMenu(raster_step_menu, _("Step"))
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_raster(node),
                    menu.Append(wx.ID_ANY, _("Make Raster Image"), "", wx.ITEM_NORMAL),
                )
        elif t == NODE_FILE_FILE:
            if node.filepath is not None:
                name = os.path.basename(node.filepath)
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_reload(node),
                    menu.Append(wx.ID_ANY, _("Reload %s") % name, "", wx.ITEM_NORMAL),
                )
        elif t == NODE_ELEMENT:
            duplicate_menu = wx.Menu()
            for i in range(1, 10):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_duplicate(node, i),
                    duplicate_menu.Append(
                        wx.ID_ANY, _("Make %d copies.") % i, "", wx.ITEM_NORMAL
                    ),
                )
            menu.AppendSubMenu(duplicate_menu, _("Duplicate"))
        if t in (NODE_ELEMENTS_BRANCH, NODE_ELEMENT):
            if isinstance(node.object, SVGElement):
                if not locked:
                    gui.Bind(
                        wx.EVT_MENU,
                        self.menu_console("reset"),
                        menu.Append(
                            wx.ID_ANY, _("Reset User Changes"), "", wx.ITEM_NORMAL
                        ),
                    )
        if t == NODE_ELEMENT:
            if isinstance(node.object, SVGElement):
                path_scale_sub_menu = wx.Menu()
                for i in range(1, 25):
                    gui.Bind(
                        wx.EVT_MENU,
                        self.menu_scale(node, 6.0 / float(i)),
                        path_scale_sub_menu.Append(
                            wx.ID_ANY,
                            _("Scale %.0f%%") % (600.0 / float(i)),
                            "",
                            wx.ITEM_NORMAL,
                        ),
                    )
                if not locked:
                    menu.AppendSubMenu(path_scale_sub_menu, _("Scale"))

                path_rotate_sub_menu = wx.Menu()
                for i in range(2, 13):
                    angle = Angle.turns(1.0 / float(i))
                    gui.Bind(
                        wx.EVT_MENU,
                        self.menu_rotate(node, 1.0 / float(i)),
                        path_rotate_sub_menu.Append(
                            wx.ID_ANY,
                            _(u"Rotate turn/%d, %.0f°") % (i, angle.as_degrees),
                            "",
                            wx.ITEM_NORMAL,
                        ),
                    )
                for i in range(2, 13):
                    angle = Angle.turns(1.0 / float(i))
                    gui.Bind(
                        wx.EVT_MENU,
                        self.menu_rotate(node, -1.0 / float(i)),
                        path_rotate_sub_menu.Append(
                            wx.ID_ANY,
                            _(u"Rotate turn/%d, -%.0f°") % (i, angle.as_degrees),
                            "",
                            wx.ITEM_NORMAL,
                        ),
                    )
                if not locked:
                    menu.AppendSubMenu(path_rotate_sub_menu, _("Rotate"))
                if not locked:
                    gui.Bind(
                        wx.EVT_MENU,
                        self.menu_console("reify"),
                        menu.Append(
                            wx.ID_ANY, _("Reify User Changes"), "", wx.ITEM_NORMAL
                        ),
                    )
            if isinstance(node.object, Path):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("element subpath"),
                    menu.Append(wx.ID_ANY, _("Break Subpaths"), "", wx.ITEM_NORMAL),
                )
            if isinstance(node.object, SVGImage):
                raster_step_menu = wx.Menu()
                for i in range(1, 10):
                    menu_item = raster_step_menu.Append(
                        wx.ID_ANY, _("Step %d") % i, "", wx.ITEM_RADIO
                    )
                    gui.Bind(
                        wx.EVT_MENU, self.menu_raster_step_image(node, i), menu_item
                    )
                    if "raster_step" in node.object.values:
                        step = float(node.object.values["raster_step"])
                    else:
                        step = 1.0
                    if i == step:
                        m = node.object.transform
                        if m.a == step or m.b == 0.0 or m.c == 0.0 or m.d == step:
                            menu_item.Check(True)
                menu.AppendSubMenu(raster_step_menu, _("Step"))
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image resample"),
                    menu.Append(wx.ID_ANY, _("Actualize Pixels"), "", wx.ITEM_NORMAL),
                )
                raster_zdepth_menu = wx.Menu()

                for i in range(2, 10):
                    menu_item = raster_zdepth_menu.Append(
                        wx.ID_ANY, _("Divide Into %d Images") % i, "", wx.ITEM_NORMAL
                    )
                    gui.Bind(wx.EVT_MENU, self.menu_raster_zdepth(node, i), menu_item)
                if not locked:
                    menu.AppendSubMenu(raster_zdepth_menu, _("ZDepth Divide"))

                image_menu = wx.Menu()
                try:
                    if locked:
                        gui.Bind(
                            wx.EVT_MENU,
                            self.menu_console("image unlock"),
                            image_menu.Append(
                                wx.ID_ANY, _("Unlock Manipulations"), "", wx.ITEM_NORMAL
                            ),
                        )
                except (ValueError, AttributeError):
                    pass
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image dither"),
                    image_menu.Append(
                        wx.ID_ANY, _("Dither to 1 bit"), "", wx.ITEM_NORMAL
                    ),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image invert"),
                    image_menu.Append(wx.ID_ANY, _("Invert Image"), "", wx.ITEM_NORMAL),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image mirror"),
                    image_menu.Append(
                        wx.ID_ANY, _("Mirror Horizontal"), "", wx.ITEM_NORMAL
                    ),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image flip"),
                    image_menu.Append(
                        wx.ID_ANY, _("Flip Vertical"), "", wx.ITEM_NORMAL
                    ),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image cw"),
                    image_menu.Append(wx.ID_ANY, _("Rotate CW"), "", wx.ITEM_NORMAL),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image ccw"),
                    image_menu.Append(wx.ID_ANY, _("Rotate CCW"), "", wx.ITEM_NORMAL),
                )
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_console("image save output.png"),
                    image_menu.Append(
                        wx.ID_ANY, _("Save output.png"), "", wx.ITEM_NORMAL
                    ),
                )
                if image_menu.MenuItemCount != 0:
                    menu.AppendSubMenu(image_menu, _("Image"))

                try:
                    raster_wizard_menu = wx.Menu()
                    for script in self.context._kernel.match("raster_script"):
                        script = script[14:]
                        menu_item = raster_wizard_menu.Append(
                            wx.ID_ANY,
                            _("RasterWizard: %s") % script,
                            "",
                            wx.ITEM_NORMAL,
                        )
                        gui.Bind(
                            wx.EVT_MENU,
                            self.menu_console("window open RasterWizard %s" % script),
                            menu_item,
                        )
                    menu.AppendSubMenu(raster_wizard_menu, _("RasterWizard"))
                except KeyError:
                    pass
                try:
                    raster_wizard_apply_menu = wx.Menu()
                    for script in self.context._kernel.match("raster_script"):
                        script = script[14:]
                        menu_item = raster_wizard_apply_menu.Append(
                            wx.ID_ANY, _("Apply: %s") % script, "", wx.ITEM_NORMAL
                        )
                        gui.Bind(
                            wx.EVT_MENU,
                            self.menu_console("image wizard %s\n" % script),
                            menu_item,
                        )
                    menu.AppendSubMenu(
                        raster_wizard_apply_menu, _("Apply Raster Script")
                    )
                except KeyError:
                    pass
            if isinstance(node.object, SVGText):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_convert_text(node),
                    menu.Append(wx.ID_ANY, _("Convert to Raster"), "", wx.ITEM_NORMAL),
                )
            if hasattr(node.object, "as_elements"):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_convert_elements(node),
                    menu.Append(wx.ID_ANY, _("Convert to SVG"), "", wx.ITEM_NORMAL),
                )
            if hasattr(node.object, "generate"):
                gui.Bind(
                    wx.EVT_MENU,
                    self.menu_move_to_operations(node),
                    menu.Append(
                        wx.ID_ANY, _("Process as Operation"), "", wx.ITEM_NORMAL
                    ),
                )
        if menu.MenuItemCount != 0:
            gui.PopupMenu(menu)
            menu.Destroy()

    def menu_console(self, console_command):
        """
        Default menu item to send a console command.

        Automatically adds '\n'.

        :param console_command: command to send to console.
        :return: function that executes the provided command.
        """

        def specific(event):
            self.context.console("%s\n" % console_command)

        return specific

    def menu_raster_step_operation(self, node, step_value):
        """
        Change raster step values of operation

        :param node:
        :param step_value:
        :return:
        """

        def specific(event):
            element = node.object
            element.raster_step = step_value
            self.context.signal("element_property_update", node.object)

        return specific

    def menu_raster_step_image(self, node, step_value):
        """
        Change raster step values of subelements.

        :param node:
        :param step_value:
        :return:
        """

        def specific(event):
            element = node.object
            element.values["raster_step"] = str(step_value)
            m = element.transform
            tx = m.e
            ty = m.f
            element.transform = Matrix.scale(float(step_value), float(step_value))
            element.transform.post_translate(tx, ty)
            element.modified()
            self.context.signal("element_property_update", node.object)
            self.root.gui.request_refresh()

        return specific

    def menu_raster_zdepth(self, node, divide=7):
        """
        Subdivides an image into a zdepth image set.

        :param node: SVGImage node.
        :return: zdepth function
        """

        def specific(event):
            element = node.object
            if not isinstance(element, SVGImage):
                return
            if element.image.mode != "RGBA":
                element.image = element.image.convert("RGBA")
            band = 255 / divide
            for i in range(0, divide):
                threshold_min = i * band
                threshold_max = threshold_min + band
                self.context.console(
                    "image threshold %f %f\n" % (threshold_min, threshold_max)
                )

        return specific

    def menu_raster(self, node):
        """
        Convert a vector element into a raster element.

        :param node:
        :return:
        """

        def specific(event):
            context = self.context
            elements = context.elements
            renderer = self.renderer
            child_objects = list(node.objects_of_children(SVGElement))
            bounds = CutPlanner.bounding_box(child_objects)
            if bounds is None:
                return None
            step = float(node.object.settings.raster_step)
            if step == 0:
                step = 1.0
            xmin, ymin, xmax, ymax = bounds

            image = renderer.make_raster(
                child_objects,
                bounds,
                width=(xmax - xmin),
                height=(ymax - ymin),
                step=step,
            )
            image_element = SVGImage(image=image)
            image_element.transform.post_scale(step, step)
            image_element.transform.post_translate(xmin, ymin)
            image_element.values["raster_step"] = step

            elements.add_elem(image_element)
            node.object.clear()
            self.build_tree(self.node_elements, image_element)
            node.object.append(image_element)
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_rotate(self, node, value):
        """
        Menu to rotate an element.

        :param node:
        :param value:
        :return:
        """

        value *= tau

        def specific(event):
            bounds = CutPlanner.bounding_box(node.parent)
            center_x = (bounds[2] + bounds[0]) / 2.0
            center_y = (bounds[3] + bounds[1]) / 2.0
            self.context.console("rotate %frad %f %f\n" % (value, center_x, center_y))

        return specific

    def menu_scale(self, node, value):
        """
        Menu scale.

        :param node:
        :param value:
        :return:
        """

        def specific(event):
            center_x, center_y = self.elements.center()
            self.context.console(
                "scale %f %f %f %f\n" % (value, value, center_x, center_y)
            )

        return specific

    def menu_reload(self, node):
        """
        Menu to reload the element from the file on disk.

        :param node:
        :return:
        """

        def specific(event):
            filepath = node.filepath
            self.elements.clear_elements_and_operations()
            self.gui.load(filepath)

        return specific

    def menu_remove(self, remove_node):
        """
        Menu to remove an element from the scene.

        :param remove_node:
        :return:
        """

        def specific(event):
            context = self.context
            elements = context.elements
            node = remove_node
            if node.type == NODE_ELEMENT:
                self.context.console("element delete\n")
            elif node.type == NODE_OPERATION:
                self.context.console("operation delete\n")
            elif node.type == NODE_FILE_FILE:
                # Removing file can only have 1 copy.
                elements.remove_files([node.filepath])
            elif node.type == NODE_OPERATION_ELEMENT:
                # Operation_element can occur many times in the same operation node.
                index = node.parent.index(node)
                op = node.parent.object
                if index == -1:
                    op.remove(node.object)
                else:
                    del op[index]
            self.elements.set_selected(None)
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_clear_all_operation(self, node):
        def specific(event):
            context = self.context
            elements = context.elements
            for op in elements.ops(emphasized=True):
                op.clear()
                self.context.signal("rebuild_tree", 0)

        return specific

    def menu_clear_all_files_branch(self, node):
        def specific(event):
            context = self.context
            elements = context.elements
            elements.clear_files()
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_duplicate_element_op(self, node, copies):
        def specific(event):
            node.parent.object.extend([node.object] * copies)
            node.parent.object.modified()
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_duplicate(self, node, copies):
        """
        Menu to duplicate elements.

        :param node:
        :return:
        """

        def specific(event):
            context = self.context
            elements = context.elements
            adding_elements = [
                copy.copy(e)
                for e in list(self.elements.elems(emphasized=True)) * copies
            ]
            elements.add_elems(adding_elements)
            elements.classify(adding_elements)
            elements.set_selected(None)

        return specific

    def menu_passes(self, node, copies):
        """
        Menu to duplicate operation element nodes

        :param node:
        :return:
        """

        def specific(event):
            op = node.object
            adding_elements = list(op) * copies
            op.extend(adding_elements)
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_execute(self, node):
        """
        Menu to launch Execute Job for the particular element.

        :param node:
        :return:
        """

        def open_jobinfo_window(event):
            self.context.open("window/JobPreview", self.gui, "0", selected=True)

        return open_jobinfo_window

    def menu_reverse_order(self, node):
        """
        Menu to return and reverse order of the element to the scene.

        :param node:
        :return:
        """
        context = self.context
        elements = context.elements

        def specific(event):
            t = node.type
            if t == NODE_ELEMENTS_BRANCH:
                context.elements._elements.reverse()
            elif t == NODE_OPERATION_BRANCH:
                context.elements._operations.reverse()
            elif t == NODE_OPERATION:
                for op in elements.ops(emphasized=True):
                    op.reverse()
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_reclassify_operations(self, node):
        def specific(event):
            context = node.root.context
            elements = context.elements
            elements.remove_elements_from_operations(list(elements.elems()))
            elements.classify(list(elements.elems()))
            self.context.signal("rebuild_tree", 0)

        return specific

    def menu_convert_operation(self, node, name):
        def specific(event):
            node.object.operation = name
            self.context.signal("element_property_update", node.object)

        return specific

    def menu_duplicate_operation(self, node):
        def specific(event):
            op = LaserOperation(node.object)
            op.clear()
            op.extend(node.object)
            self.context.elements.add_op(op)

        return specific

    def menu_convert_elements(self, node):
        def specific(event):
            self.context.elements.add_elems(node.object.as_elements())

        return specific

    def menu_move_to_operations(self, node):
        def specific(event):
            self.context.elements.add_op(node.object)

        return specific

    def menu_convert_text(self, node):
        def specific(event):
            raise NotImplementedError

        return specific


def get_key_name(event):
    keyvalue = ""
    if event.ControlDown():
        keyvalue += "control+"
    if event.AltDown():
        keyvalue += "alt+"
    if event.ShiftDown():
        keyvalue += "shift+"
    if event.MetaDown():
        keyvalue += "meta+"
    key = event.GetKeyCode()
    if key == wx.WXK_CONTROL:
        return
    if key == wx.WXK_ALT:
        return
    if key == wx.WXK_SHIFT:
        return
    if key == wx.WXK_F1:
        keyvalue += "f1"
    elif key == wx.WXK_F2:
        keyvalue += "f2"
    elif key == wx.WXK_F3:
        keyvalue += "f3"
    elif key == wx.WXK_F4:
        keyvalue += "f4"
    elif key == wx.WXK_F5:
        keyvalue += "f5"
    elif key == wx.WXK_F6:
        keyvalue += "f6"
    elif key == wx.WXK_F7:
        keyvalue += "f7"
    elif key == wx.WXK_F8:
        keyvalue += "f8"
    elif key == wx.WXK_F9:
        keyvalue += "f9"
    elif key == wx.WXK_F10:
        keyvalue += "f10"
    elif key == wx.WXK_F11:
        keyvalue += "f11"
    elif key == wx.WXK_F12:
        keyvalue += "f12"
    elif key == wx.WXK_F13:
        keyvalue += "f13"
    elif key == wx.WXK_F14:
        keyvalue += "f14"
    elif key == wx.WXK_F15:
        keyvalue += "f15"
    elif key == wx.WXK_F16:
        keyvalue += "f16"
    elif key == wx.WXK_ADD:
        keyvalue += "+"
    elif key == wx.WXK_END:
        keyvalue += "end"
    elif key == wx.WXK_NUMPAD0:
        keyvalue += "numpad0"
    elif key == wx.WXK_NUMPAD1:
        keyvalue += "numpad1"
    elif key == wx.WXK_NUMPAD2:
        keyvalue += "numpad2"
    elif key == wx.WXK_NUMPAD3:
        keyvalue += "numpad3"
    elif key == wx.WXK_NUMPAD4:
        keyvalue += "numpad4"
    elif key == wx.WXK_NUMPAD5:
        keyvalue += "numpad5"
    elif key == wx.WXK_NUMPAD6:
        keyvalue += "numpad6"
    elif key == wx.WXK_NUMPAD7:
        keyvalue += "numpad7"
    elif key == wx.WXK_NUMPAD8:
        keyvalue += "numpad8"
    elif key == wx.WXK_NUMPAD9:
        keyvalue += "numpad9"
    elif key == wx.WXK_NUMPAD_ADD:
        keyvalue += "numpad_add"
    elif key == wx.WXK_NUMPAD_SUBTRACT:
        keyvalue += "numpad_subtract"
    elif key == wx.WXK_NUMPAD_MULTIPLY:
        keyvalue += "numpad_multiply"
    elif key == wx.WXK_NUMPAD_DIVIDE:
        keyvalue += "numpad_divide"
    elif key == wx.WXK_NUMPAD_DECIMAL:
        keyvalue += "numpad."
    elif key == wx.WXK_NUMPAD_ENTER:
        keyvalue += "numpad_enter"
    elif key == wx.WXK_NUMPAD_RIGHT:
        keyvalue += "numpad_right"
    elif key == wx.WXK_NUMPAD_LEFT:
        keyvalue += "numpad_left"
    elif key == wx.WXK_NUMPAD_UP:
        keyvalue += "numpad_up"
    elif key == wx.WXK_NUMPAD_DOWN:
        keyvalue += "numpad_down"
    elif key == wx.WXK_NUMPAD_DELETE:
        keyvalue += "numpad_delete"
    elif key == wx.WXK_NUMPAD_INSERT:
        keyvalue += "numpad_insert"
    elif key == wx.WXK_NUMPAD_PAGEUP:
        keyvalue += "numpad_pgup"
    elif key == wx.WXK_NUMPAD_PAGEDOWN:
        keyvalue += "numpad_pgdn"
    elif key == wx.WXK_NUMLOCK:
        keyvalue += "numlock"
    elif key == wx.WXK_SCROLL:
        keyvalue += "scroll"
    elif key == wx.WXK_HOME:
        keyvalue += "home"
    elif key == wx.WXK_DOWN:
        keyvalue += "down"
    elif key == wx.WXK_UP:
        keyvalue += "up"
    elif key == wx.WXK_RIGHT:
        keyvalue += "right"
    elif key == wx.WXK_LEFT:
        keyvalue += "left"
    elif key == wx.WXK_ESCAPE:
        keyvalue += "escape"
    elif key == wx.WXK_BACK:
        keyvalue += "back"
    elif key == wx.WXK_PAUSE:
        keyvalue += "pause"
    elif key == wx.WXK_PAGEDOWN:
        keyvalue += "pagedown"
    elif key == wx.WXK_PAGEUP:
        keyvalue += "pageup"
    elif key == wx.WXK_PRINT:
        keyvalue += "print"
    elif key == wx.WXK_RETURN:
        keyvalue += "return"
    elif key == wx.WXK_SPACE:
        keyvalue += "space"
    elif key == wx.WXK_TAB:
        keyvalue += "tab"
    elif key == wx.WXK_DELETE:
        keyvalue += "delete"
    elif key == wx.WXK_INSERT:
        keyvalue += "insert"
    else:
        keyvalue += chr(key)
    return keyvalue.lower()


class wxMeerK40t(wx.App, Module):
    """
    wxMeerK40t is the wx.App main class and a qualified Module for the MeerK40t kernel.
    Running MeerK40t without the wxMeerK40t gui is both possible and reasonable. This should not change the way the
    underlying code runs. It should just be a series of frames held together with the kernel.
    """

    def __init__(self, context, path):
        wx.App.__init__(self, 0)
        Module.__init__(self, context, path)
        self.locale = None
        self.Bind(wx.EVT_CLOSE, self.on_app_close)
        self.Bind(wx.EVT_QUERY_END_SESSION, self.on_app_close)  # MAC DOCK QUIT.
        self.Bind(wx.EVT_END_SESSION, self.on_app_close)
        self.Bind(wx.EVT_END_PROCESS, self.on_app_close)
        # This catches events when the app is asked to activate by some other process
        self.Bind(wx.EVT_ACTIVATE_APP, self.OnActivate)

    def on_app_close(self, event):
        try:
            if self.context is not None:
                self.context.stop()
        except AttributeError:
            pass

    def OnInit(self):
        return True

    def BringWindowToFront(self):
        try:  # it's possible for this event to come when the frame is closed
            self.GetTopWindow().Raise()
        except:
            pass

    def OnActivate(self, event):
        # if this is an activate event, rather than something else, like iconize.
        if event.GetActive():
            self.BringWindowToFront()
        event.Skip()

    def MacReopenApp(self):
        """Called when the doc icon is clicked, and ???"""
        self.BringWindowToFront()

    def MacNewFile(self):
        try:
            if self.context is not None:
                self.context.elements.clear_all()
        except AttributeError:
            pass

    def MacPrintFile(self, file_path):
        pass

    def MacOpenFile(self, filename):
        try:
            if self.context is not None:
                self.context.load(os.path.realpath(filename))
        except AttributeError:
            pass

    def MacOpenFiles(self, filenames):
        try:
            if self.context is not None:
                for filename in filenames:
                    self.context.load(os.path.realpath(filename))
        except AttributeError:
            pass

    @staticmethod
    def sub_register(device):
        device.register("window/MeerK40t", MeerK40t)
        device.register("module/Scene", Scene)
        device.register("window/PathProperty", PathProperty)
        device.register("window/TextProperty", TextProperty)
        device.register("window/ImageProperty", ImageProperty)
        device.register("window/OperationProperty", OperationProperty)
        device.register("window/Controller", Controller)
        device.register("window/Preferences", Preferences)
        device.register("window/CameraInterface", CameraInterface)
        device.register("window/Terminal", Terminal)
        device.register("window/Settings", Settings)
        device.register("window/Rotary", RotarySettings)
        device.register("window/Alignment", Alignment)
        device.register("window/About", About)
        device.register("window/DeviceManager", DeviceManager)
        device.register("window/Keymap", Keymap)
        device.register("window/UsbConnect", UsbConnect)
        device.register("window/Navigation", Navigation)
        device.register("window/Notes", Notes)
        device.register("window/JobSpooler", JobSpooler)
        device.register("window/JobPreview", JobPreview)
        device.register("window/BufferView", BufferView)
        device.register("window/RasterWizard", RasterWizard)

    def run_later(self, command, *args):
        if wx.IsMainThread():
            command(*args)
        else:
            wx.CallAfter(command, *args)

    def initialize(self, *args, **kwargs):
        context = self.context
        wx.Locale.AddCatalogLookupPathPrefix(resource_path("locale"))
        context._kernel.run_later = self.run_later
        context._kernel.translation = wx.GetTranslation
        context._kernel.set_config(wx.Config("MeerK40t"))
        context.app = self  # Registers self as kernel.app

        context.setting(int, "language", None)
        context.register("control/Delete Settings", self.clear_control)
        language = context.language
        if language is not None and language != 0:
            self.update_language(language)

    def clear_control(self):
        kernel = self.context._kernel
        if kernel.config is not None:
            kernel.config.DeleteAll()
            kernel.config = None
            kernel.shutdown()

    def update_language(self, lang):
        """
        Update language to the requested language.
        """
        context = self.context
        try:
            language_code, language_name, language_index = supported_languages[lang]
        except (IndexError, ValueError):
            return
        context.language = lang

        if self.locale:
            assert sys.getrefcount(self.locale) <= 2
            del self.locale
        self.locale = wx.Locale(language_index)
        if self.locale.IsOk():
            self.locale.AddCatalog("meerk40t")
        else:
            self.locale = None
        context.signal("language", (lang, language_code, language_name, language_index))


# end of class MeerK40tGui
def send_file_to_developers(filename):
    """
    Sends crash log to a server using rfc1341 7.2 The multipart Content-Type
    https://www.w3.org/Protocols/rfc1341/7_2_Multipart.html

    :param filename: filename to send. (must be text/plain)
    :return:
    """
    import socket
    with open(filename, 'r') as f:
        data = f.read()
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        ipaddr = socket.gethostbyname('api.anonfiles.com')
        s.connect((ipaddr, 80))
        boundary = '----------------meerk40t-boundary'
        file_head = list()
        file_head.append('--' + boundary)
        file_head.append('Content-Disposition: form-data; name="file"; filename="%s"' % filename)
        file_head.append('Content-Type: text/plain')
        file_head.append('')
        part = "\x0D\x0A".join(file_head)
        terminal = '--' + boundary + '--'
        payload = '\x0D\x0A'.join((part, data, terminal, ''))
        http_req = list()
        http_req.append("POST /upload?token=630f908431136ef4 HTTP/1.1")
        http_req.append("Host: api.anonfiles.com")
        http_req.append("User-Agent: meerk40t/0.0.1")
        http_req.append("Accept: */*")
        http_req.append("Content-Length: %d" % (len(payload)))
        http_req.append("Content-Type: multipart/form-data; boundary=%s" % boundary)
        http_req.append('')
        header = "\x0D\x0A".join(http_req)
        request = '\x0D\x0A'.join((header, payload))
        s.send(bytes(request, 'utf-8'))
        response = s.recv(4096)
        response = response.decode('utf-8')
        print(response)
        s.close()
    if response is None or len(response) == 0:
        http_code = "No Response."
    else:
        http_code = response.split('\n')[0]

    if http_code.startswith('HTTP/1.1 200 OK'):
        http_code = response.split('\n')[0]
        dlg = wx.MessageDialog(
            None,
            _("We got your message. Thank you for helping\n\n") + str(http_code),
            _("Thanks"),
            wx.OK,
        )
        dlg.ShowModal()
        dlg.Destroy()
    else:

        dlg = wx.MessageDialog(
            None,
            _("We're sorry, that didn't work. Raise an issue on the github please.\n\n The log file will be in your working directory.\n" + MEERK40T_ISSUES + '\n\n' + str(http_code)),
            _("Thanks"),
            wx.OK,
        )
        dlg.ShowModal()
        dlg.Destroy()


def handleGUIException(exc_type, exc_value, exc_traceback):
    """
    Handler for errors. Save error to a file, and create dialog.

    :param exc_type:
    :param exc_value:
    :param exc_traceback:
    :return:
    """
    error_log = "MeerK40t crash log. Version: %s on %s\n" % ("0.7.0", sys.platform)
    error_log += "".join(traceback.format_exception(exc_type, exc_value, exc_traceback))
    print(error_log)
    try:
        import datetime

        filename = "MeerK40t-{date:%Y-%m-%d_%H_%M_%S}.txt".format(
            date=datetime.datetime.now()
        )
    except:  # I already crashed once, if there's another here just ignore it.
        filename = "MeerK40t-Crash.txt"

    try:
        with open(filename, "w") as file:
            # Crash logs are not translated.
            file.write(error_log)
            print(file)
    except:  # I already crashed once, if there's another here just ignore it.
        pass

    # Ask to send file.
    message = """
    Good news MeerK40t User! MeerK40t encountered an crash!
    
    You now have the ability to help meerk40t's development by sending us the log.
    
    Send the following data to the MeerK40t team?
    ------
    """
    message += error_log
    answer = wx.MessageBox(message, _("Crash Detected! Send Log?"),
                        wx.YES_NO | wx.CANCEL, None)
    if answer == wx.YES:
        send_file_to_developers(filename)

sys.excepthook = handleGUIException
