import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location (region or zone) in which the cluster master will be created, as well as the default node location.
     *
     * If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#location DataGoogleContainerCluster#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The name of the cluster, unique within the project and location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#name DataGoogleContainerCluster#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html#project DataGoogleContainerCluster#project}
     *
     * @stability stable
     */
    readonly project?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAddonsConfigCloudrunConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabled(): any;
    /**
     * @stability stable
     */
    get loadBalancerType(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAddonsConfigHorizontalPodAutoscaling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAddonsConfigHttpLoadBalancing extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAddonsConfigNetworkPolicyConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAddonsConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cloudrunConfig(): any;
    /**
     * @stability stable
     */
    get horizontalPodAutoscaling(): any;
    /**
     * @stability stable
     */
    get httpLoadBalancing(): any;
    /**
     * @stability stable
     */
    get networkPolicyConfig(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterAuthenticatorGroupsConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get securityGroup(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterClusterAutoscalingAutoProvisioningDefaults extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    get serviceAccount(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterClusterAutoscalingResourceLimits extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maximum(): number;
    /**
     * @stability stable
     */
    get minimum(): number;
    /**
     * @stability stable
     */
    get resourceType(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterClusterAutoscaling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoProvisioningDefaults(): any;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get resourceLimits(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterDatabaseEncryption extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    get state(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterDefaultSnatStatus extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get disabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterIpAllocationPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clusterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get clusterSecondaryRangeName(): string;
    /**
     * @stability stable
     */
    get servicesIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get servicesSecondaryRangeName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterLoggingConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableComponents(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMaintenancePolicyDailyMaintenanceWindow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get duration(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMaintenancePolicyMaintenanceExclusion extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    get exclusionName(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMaintenancePolicyRecurringWindow extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    get recurrence(): string;
    /**
     * @stability stable
     */
    get startTime(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMaintenancePolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dailyMaintenanceWindow(): any;
    /**
     * @stability stable
     */
    get maintenanceExclusion(): any;
    /**
     * @stability stable
     */
    get recurringWindow(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMasterAuthClientCertificateConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get issueClientCertificate(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMasterAuth extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get clientCertificate(): string;
    /**
     * @stability stable
     */
    get clientCertificateConfig(): any;
    /**
     * @stability stable
     */
    get clientKey(): string;
    /**
     * @stability stable
     */
    get clusterCaCertificate(): string;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfigCidrBlocks extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cidrBlock(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMasterAuthorizedNetworksConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cidrBlocks(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterMonitoringConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableComponents(): string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNetworkPolicy extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get provider(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    get gpuPartitionSize(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): any;
    /**
     * @stability stable
     */
    get enableSecureBoot(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodeConfigTaint extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get effect(): string;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get nodeMetadata(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodeConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    get guestAccelerator(): any;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get localSsdCount(): number;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    get metadata(): any;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    get preemptible(): any;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): any;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get taint(): any;
    /**
     * @stability stable
     */
    get workloadMetadataConfig(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolAutoscaling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxNodeCount(): number;
    /**
     * @stability stable
     */
    get minNodeCount(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolManagement extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoRepair(): any;
    /**
     * @stability stable
     */
    get autoUpgrade(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolNodeConfigGuestAccelerator extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    get gpuPartitionSize(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolNodeConfigShieldedInstanceConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): any;
    /**
     * @stability stable
     */
    get enableSecureBoot(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolNodeConfigTaint extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get effect(): string;
    /**
     * @stability stable
     */
    get key(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolNodeConfigWorkloadMetadataConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    get nodeMetadata(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolNodeConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    get guestAccelerator(): any;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get localSsdCount(): number;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    get metadata(): any;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    get preemptible(): any;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): any;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    get taint(): any;
    /**
     * @stability stable
     */
    get workloadMetadataConfig(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePoolUpgradeSettings extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get maxSurge(): number;
    /**
     * @stability stable
     */
    get maxUnavailable(): number;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterNodePool extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get autoscaling(): any;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    /**
     * @stability stable
     */
    get management(): any;
    /**
     * @stability stable
     */
    get maxPodsPerNode(): number;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get namePrefix(): string;
    /**
     * @stability stable
     */
    get nodeConfig(): any;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    get nodeLocations(): string[];
    /**
     * @stability stable
     */
    get upgradeSettings(): any;
    /**
     * @stability stable
     */
    get version(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterPodSecurityPolicyConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterPrivateClusterConfigMasterGlobalAccessConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterPrivateClusterConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enablePrivateEndpoint(): any;
    /**
     * @stability stable
     */
    get enablePrivateNodes(): any;
    /**
     * @stability stable
     */
    get masterGlobalAccessConfig(): any;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    get peeringName(): string;
    /**
     * @stability stable
     */
    get privateEndpoint(): string;
    /**
     * @stability stable
     */
    get publicEndpoint(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterReleaseChannel extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get channel(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterResourceUsageExportConfigBigqueryDestination extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get datasetId(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterResourceUsageExportConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get bigqueryDestination(): any;
    /**
     * @stability stable
     */
    get enableNetworkEgressMetering(): any;
    /**
     * @stability stable
     */
    get enableResourceConsumptionMetering(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterVerticalPodAutoscaling extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get enabled(): any;
}
/**
 * @stability stable
 */
export declare class DataGoogleContainerClusterWorkloadIdentityConfig extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityNamespace(): string;
    /**
     * @stability stable
     */
    get workloadPool(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html google_container_cluster}.
 *
 * @stability stable
 */
export declare class DataGoogleContainerCluster extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/container_cluster.html google_container_cluster} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleContainerClusterConfig);
    /**
     * @stability stable
     */
    addonsConfig(index: string): DataGoogleContainerClusterAddonsConfig;
    /**
     * @stability stable
     */
    authenticatorGroupsConfig(index: string): DataGoogleContainerClusterAuthenticatorGroupsConfig;
    /**
     * @stability stable
     */
    clusterAutoscaling(index: string): DataGoogleContainerClusterClusterAutoscaling;
    /**
     * @stability stable
     */
    get clusterIpv4Cidr(): string;
    /**
     * @stability stable
     */
    databaseEncryption(index: string): DataGoogleContainerClusterDatabaseEncryption;
    /**
     * @stability stable
     */
    get datapathProvider(): string;
    /**
     * @stability stable
     */
    get defaultMaxPodsPerNode(): number;
    /**
     * @stability stable
     */
    defaultSnatStatus(index: string): DataGoogleContainerClusterDefaultSnatStatus;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get enableAutopilot(): any;
    /**
     * @stability stable
     */
    get enableBinaryAuthorization(): any;
    /**
     * @stability stable
     */
    get enableIntranodeVisibility(): any;
    /**
     * @stability stable
     */
    get enableKubernetesAlpha(): any;
    /**
     * @stability stable
     */
    get enableLegacyAbac(): any;
    /**
     * @stability stable
     */
    get enableShieldedNodes(): any;
    /**
     * @stability stable
     */
    get enableTpu(): any;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    /**
     * @stability stable
     */
    ipAllocationPolicy(index: string): DataGoogleContainerClusterIpAllocationPolicy;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    loggingConfig(index: string): DataGoogleContainerClusterLoggingConfig;
    /**
     * @stability stable
     */
    get loggingService(): string;
    /**
     * @stability stable
     */
    maintenancePolicy(index: string): DataGoogleContainerClusterMaintenancePolicy;
    /**
     * @stability stable
     */
    masterAuth(index: string): DataGoogleContainerClusterMasterAuth;
    /**
     * @stability stable
     */
    masterAuthorizedNetworksConfig(index: string): DataGoogleContainerClusterMasterAuthorizedNetworksConfig;
    /**
     * @stability stable
     */
    get masterVersion(): string;
    /**
     * @stability stable
     */
    get minMasterVersion(): string;
    /**
     * @stability stable
     */
    monitoringConfig(index: string): DataGoogleContainerClusterMonitoringConfig;
    /**
     * @stability stable
     */
    get monitoringService(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    networkPolicy(index: string): DataGoogleContainerClusterNetworkPolicy;
    /**
     * @stability stable
     */
    get networkingMode(): string;
    /**
     * @stability stable
     */
    nodeConfig(index: string): DataGoogleContainerClusterNodeConfig;
    /**
     * @stability stable
     */
    get nodeLocations(): string[];
    /**
     * @stability stable
     */
    nodePool(index: string): DataGoogleContainerClusterNodePool;
    /**
     * @stability stable
     */
    get nodeVersion(): string;
    /**
     * @stability stable
     */
    get operation(): string;
    /**
     * @stability stable
     */
    podSecurityPolicyConfig(index: string): DataGoogleContainerClusterPodSecurityPolicyConfig;
    /**
     * @stability stable
     */
    privateClusterConfig(index: string): DataGoogleContainerClusterPrivateClusterConfig;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    releaseChannel(index: string): DataGoogleContainerClusterReleaseChannel;
    /**
     * @stability stable
     */
    get removeDefaultNodePool(): any;
    /**
     * @stability stable
     */
    resourceLabels(key: string): string;
    /**
     * @stability stable
     */
    resourceUsageExportConfig(index: string): DataGoogleContainerClusterResourceUsageExportConfig;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get servicesIpv4Cidr(): string;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    get tpuIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    verticalPodAutoscaling(index: string): DataGoogleContainerClusterVerticalPodAutoscaling;
    /**
     * @stability stable
     */
    workloadIdentityConfig(index: string): DataGoogleContainerClusterWorkloadIdentityConfig;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
