import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleKmsSecretCiphertextConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext.html#crypto_key DataGoogleKmsSecretCiphertext#crypto_key}.
     *
     * @stability stable
     */
    readonly cryptoKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext.html#plaintext DataGoogleKmsSecretCiphertext#plaintext}.
     *
     * @stability stable
     */
    readonly plaintext: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext.html google_kms_secret_ciphertext}.
 *
 * @stability stable
 */
export declare class DataGoogleKmsSecretCiphertext extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/kms_secret_ciphertext.html google_kms_secret_ciphertext} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleKmsSecretCiphertextConfig);
    /**
     * @stability stable
     */
    get ciphertext(): string;
    private _cryptoKey?;
    /**
     * @stability stable
     */
    get cryptoKey(): string;
    /**
     * @stability stable
     */
    set cryptoKey(value: string);
    /**
     * @stability stable
     */
    get cryptoKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _plaintext?;
    /**
     * @stability stable
     */
    get plaintext(): string;
    /**
     * @stability stable
     */
    set plaintext(value: string);
    /**
     * @stability stable
     */
    get plaintextInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
