# Spikeometric - Linear Non-Linear Cascade Spiking Neural Networks with PyTorch Geometric

The spikeometric package is a framework for simulating spiking neural networks (SNNs) using generalized linear models (GLMs) and Linear-Nonlinear-Poisson models (LNPs) in Python. It is built on top of the [PyTorch Geometric](https://pytorch-geometric.readthedocs.io/en/latest/) package and makes use of their powerful graph neural network (GNN) modules and efficient graph representation. It is designed to be fast, flexible and easy to use, and is intended for research purposes.

# Install
Before installing `spikeometric` you will need to download versions of PyTorch and PyTorch Geometric that work with your hardware. When you have done that (for example in a conda environment), you are ready to download spikeometric with:

    pip install spikeometric

# Documentation

For more information about the package and a full API reference check out our [documentation](https://spikeometric.readthedocs.io/en/latest/).

# How to contribute
We welcome contributions from users and developers. If you find bugs, please report an issue on github.
If you would like to contribute to new features you can either find an issue you would like to work on, or fork this project and develop something great. 
Send pull request for review. We will respond as soon as possible.
