from .queries import get_db_from,fetch_any_combo
from .call_log_data import get_signature_from_log_id
def get_transaction_from(columnNames='*',searchColumn=None,searchValue=None,count=False):
    return get_db_from('transactions',columnNames=columnNames,searchColumn=searchColumn,searchValue=searchValue)
def count_transactions_for_pair(pair_id):
    return get_transaction_from(searchColumn="pair_id",searchValue=pair_id,count=True)
def get_transaction_from_signature(signature):
    return get_transaction_from(searchColumn="signature",searchValue=signature)
def get_transaction_from_txn_id(txn_id):
    return get_transaction_from(searchColumn="id",searchValue=txn_id)
def get_transaction_from_log_id(log_id):
    signature = get_signature_from_log_id(log_id)
    return get_transaction_from_signature(signature)
def get_all_txns_from_pair_id(pair_id):
    return get_transaction_from(searchColumn="pair_id",searchValue=pair_id)
def get_transactions(txn_id=None,log_id=None,signature=None,pair_id=None):
    if pair_id:
        return get_all_txns_from_pair_id(pair_id)
    if txn_id:
        return get_transaction_from_txn_id(txn_id)
    if log_id:
        return get_transaction_from_log_id(log_id)
    if signature:
        return get_transaction_from_signature(signature)

