/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.returntypes.DiVector;
import java.util.stream.Collector;

public class InterpolationMeasure {
    public final DiVector measure;
    public final DiVector distances;
    public final DiVector probMass;
    protected final int dimensions;
    protected final int sampleSize;

    public InterpolationMeasure(int dimensions, int sampleSize) {
        CommonUtils.checkArgument(dimensions > 0, "dimensions must be greater than 0");
        this.sampleSize = sampleSize;
        this.dimensions = dimensions;
        this.measure = new DiVector(dimensions);
        this.distances = new DiVector(dimensions);
        this.probMass = new DiVector(dimensions);
    }

    public InterpolationMeasure(InterpolationMeasure base) {
        this.sampleSize = base.sampleSize;
        this.dimensions = base.dimensions;
        this.measure = new DiVector(base.measure);
        this.distances = new DiVector(base.distances);
        this.probMass = new DiVector(base.probMass);
    }

    private InterpolationMeasure(int sampleSize, DiVector measure, DiVector distances, DiVector probMass) {
        CommonUtils.checkArgument(measure.getDimensions() == distances.getDimensions(), "measure.getDimensions() should be equal to distances.getDimensions()");
        CommonUtils.checkArgument(measure.getDimensions() == probMass.getDimensions(), "measure.getDimensions() should be equal to probMass.getDimensions()");
        this.sampleSize = sampleSize;
        this.dimensions = measure.getDimensions();
        this.measure = measure;
        this.distances = distances;
        this.probMass = probMass;
    }

    public static InterpolationMeasure addToLeft(InterpolationMeasure left, InterpolationMeasure right) {
        CommonUtils.checkNotNull(left, "left must not be null");
        CommonUtils.checkNotNull(right, "right must not be null");
        CommonUtils.checkArgument(left.dimensions == right.dimensions, "dimensions must be the same");
        DiVector.addToLeft(left.distances, right.distances);
        DiVector.addToLeft(left.measure, right.measure);
        DiVector.addToLeft(left.probMass, right.probMass);
        return left;
    }

    public static Collector<InterpolationMeasure, InterpolationMeasure, InterpolationMeasure> collector(int dimensions, int sampleSize, int numberOfTrees) {
        return Collector.of(() -> new InterpolationMeasure(dimensions, sampleSize), InterpolationMeasure::addToLeft, InterpolationMeasure::addToLeft, result -> result.scale(1.0 / (double)numberOfTrees), new Collector.Characteristics[0]);
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public InterpolationMeasure scale(double z) {
        return new InterpolationMeasure(this.sampleSize, this.measure.scale(z), this.distances.scale(z), this.probMass.scale(z));
    }
}

