"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomResource = exports.CustomResourceProvider = void 0;
const core = require("@aws-cdk/core");
/**
 * Represents a provider for an AWS CloudFormation custom resources.
 */
class CustomResourceProvider {
    /**
     * @param serviceToken the ServiceToken which contains the ARN for this provider.
     */
    constructor(serviceToken) {
        this.serviceToken = serviceToken;
    }
    /**
     * The Lambda provider that implements this custom resource.
     *
     * We recommend using a lambda.SingletonFunction for this.
     */
    static fromLambda(handler) {
        return new CustomResourceProvider(handler.functionArn);
    }
    /**
     * The SNS Topic for the provider that implements this custom resource.
     */
    static fromTopic(topic) {
        return new CustomResourceProvider(topic.topicArn);
    }
    /**
     * Use AWS Lambda as a provider.
     * @deprecated use `fromLambda`
     */
    static lambda(handler) { return this.fromLambda(handler); }
    /**
     * Use an SNS topic as the provider.
     * @deprecated use `fromTopic`
     */
    static topic(topic) { return this.fromTopic(topic); }
    bind(_) {
        return { serviceToken: this.serviceToken };
    }
}
exports.CustomResourceProvider = CustomResourceProvider;
/**
 * Deprecated.
 * @deprecated use `core.CustomResource`
 */
class CustomResource extends core.CustomResource {
    constructor(scope, id, props) {
        super(scope, id, {
            pascalCaseProperties: true,
            properties: props.properties,
            removalPolicy: props.removalPolicy,
            resourceType: props.resourceType,
            serviceToken: core.Lazy.stringValue({ produce: () => props.provider.bind(this).serviceToken }),
        });
    }
}
exports.CustomResource = CustomResource;
//# sourceMappingURL=data:application/json;base64,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