"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone Provider': {
        'HostedZoneProvider will return context values if availble'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', { env: { account: '12345', region: 'us-east-1' } });
            const filter = { domainName: 'test.com' };
            lib_1.HostedZone.fromLookup(stack, 'Ref', filter);
            const missing = assert_1.SynthUtils.synthesize(stack).assembly.manifest.missing;
            test.ok(missing && missing.length === 1);
            const fakeZone = {
                Id: "/hostedzone/11111111111111",
                Name: "example.com.",
                CallerReference: "TestLates-PublicZo-OESZPDFV7G6A",
                Config: {
                    Comment: "CDK created",
                    PrivateZone: false
                },
                ResourceRecordSetCount: 3
            };
            const stack2 = new cdk.Stack(undefined, 'TestStack', { env: { account: '12345', region: 'us-east-1' } });
            stack2.node.setContext(missing[0].key, fakeZone);
            const cdkZoneProps = {
                hostedZoneId: fakeZone.Id,
                zoneName: 'example.com',
            };
            const cdkZone = lib_1.HostedZone.fromHostedZoneAttributes(stack2, 'MyZone', cdkZoneProps);
            // WHEN
            const zoneRef = lib_1.HostedZone.fromLookup(stack2, 'MyZoneProvider', filter);
            // THEN
            test.deepEqual(zoneRef.hostedZoneId, cdkZone.hostedZoneId);
            test.done();
        },
    }
};
//# sourceMappingURL=data:application/json;base64,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