# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AzurePrivatelinkConnectionApprovalArgs', 'AzurePrivatelinkConnectionApproval']

@pulumi.input_type
class AzurePrivatelinkConnectionApprovalArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 endpoint_ip_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AzurePrivatelinkConnectionApproval resource.
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] endpoint_ip_address: IP address of Azure private endpoint
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        if endpoint_ip_address is not None:
            pulumi.set(__self__, "endpoint_ip_address", endpoint_ip_address)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of Azure private endpoint
        """
        return pulumi.get(self, "endpoint_ip_address")

    @endpoint_ip_address.setter
    def endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address", value)


@pulumi.input_type
class _AzurePrivatelinkConnectionApprovalState:
    def __init__(__self__, *,
                 endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 privatelink_connection_id: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AzurePrivatelinkConnectionApproval resources.
        :param pulumi.Input[str] endpoint_ip_address: IP address of Azure private endpoint
        :param pulumi.Input[str] privatelink_connection_id: Privatelink connection id
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: Privatelink connection state
        """
        if endpoint_ip_address is not None:
            pulumi.set(__self__, "endpoint_ip_address", endpoint_ip_address)
        if privatelink_connection_id is not None:
            pulumi.set(__self__, "privatelink_connection_id", privatelink_connection_id)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        IP address of Azure private endpoint
        """
        return pulumi.get(self, "endpoint_ip_address")

    @endpoint_ip_address.setter
    def endpoint_ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_ip_address", value)

    @property
    @pulumi.getter(name="privatelinkConnectionId")
    def privatelink_connection_id(self) -> Optional[pulumi.Input[str]]:
        """
        Privatelink connection id
        """
        return pulumi.get(self, "privatelink_connection_id")

    @privatelink_connection_id.setter
    def privatelink_connection_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "privatelink_connection_id", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Privatelink connection state
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class AzurePrivatelinkConnectionApproval(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Azure privatelink approve resource waits for an aiven privatelink connection on a service and approves it with associated endpoint IP

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint_ip_address: IP address of Azure private endpoint
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AzurePrivatelinkConnectionApprovalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Azure privatelink approve resource waits for an aiven privatelink connection on a service and approves it with associated endpoint IP

        :param str resource_name: The name of the resource.
        :param AzurePrivatelinkConnectionApprovalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AzurePrivatelinkConnectionApprovalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 endpoint_ip_address: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AzurePrivatelinkConnectionApprovalArgs.__new__(AzurePrivatelinkConnectionApprovalArgs)

            __props__.__dict__["endpoint_ip_address"] = endpoint_ip_address
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["privatelink_connection_id"] = None
            __props__.__dict__["state"] = None
        super(AzurePrivatelinkConnectionApproval, __self__).__init__(
            'aiven:index/azurePrivatelinkConnectionApproval:AzurePrivatelinkConnectionApproval',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            endpoint_ip_address: Optional[pulumi.Input[str]] = None,
            privatelink_connection_id: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'AzurePrivatelinkConnectionApproval':
        """
        Get an existing AzurePrivatelinkConnectionApproval resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] endpoint_ip_address: IP address of Azure private endpoint
        :param pulumi.Input[str] privatelink_connection_id: Privatelink connection id
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: Privatelink connection state
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AzurePrivatelinkConnectionApprovalState.__new__(_AzurePrivatelinkConnectionApprovalState)

        __props__.__dict__["endpoint_ip_address"] = endpoint_ip_address
        __props__.__dict__["privatelink_connection_id"] = privatelink_connection_id
        __props__.__dict__["project"] = project
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        return AzurePrivatelinkConnectionApproval(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="endpointIpAddress")
    def endpoint_ip_address(self) -> pulumi.Output[Optional[str]]:
        """
        IP address of Azure private endpoint
        """
        return pulumi.get(self, "endpoint_ip_address")

    @property
    @pulumi.getter(name="privatelinkConnectionId")
    def privatelink_connection_id(self) -> pulumi.Output[str]:
        """
        Privatelink connection id
        """
        return pulumi.get(self, "privatelink_connection_id")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Privatelink connection state
        """
        return pulumi.get(self, "state")

