# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetBillingGroupResult',
    'AwaitableGetBillingGroupResult',
    'get_billing_group',
    'get_billing_group_output',
]

@pulumi.output_type
class GetBillingGroupResult:
    """
    A collection of values returned by getBillingGroup.
    """
    def __init__(__self__, account_id=None, address_lines=None, billing_currency=None, billing_emails=None, billing_extra_text=None, card_id=None, city=None, company=None, country_code=None, id=None, name=None, state=None, vat_id=None, zip_code=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if address_lines and not isinstance(address_lines, list):
            raise TypeError("Expected argument 'address_lines' to be a list")
        pulumi.set(__self__, "address_lines", address_lines)
        if billing_currency and not isinstance(billing_currency, str):
            raise TypeError("Expected argument 'billing_currency' to be a str")
        pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails and not isinstance(billing_emails, list):
            raise TypeError("Expected argument 'billing_emails' to be a list")
        pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text and not isinstance(billing_extra_text, str):
            raise TypeError("Expected argument 'billing_extra_text' to be a str")
        pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if card_id and not isinstance(card_id, str):
            raise TypeError("Expected argument 'card_id' to be a str")
        pulumi.set(__self__, "card_id", card_id)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if company and not isinstance(company, str):
            raise TypeError("Expected argument 'company' to be a str")
        pulumi.set(__self__, "company", company)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if vat_id and not isinstance(vat_id, str):
            raise TypeError("Expected argument 'vat_id' to be a str")
        pulumi.set(__self__, "vat_id", vat_id)
        if zip_code and not isinstance(zip_code, str):
            raise TypeError("Expected argument 'zip_code' to be a str")
        pulumi.set(__self__, "zip_code", zip_code)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        Account id
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[str]:
        """
        Address lines
        """
        return pulumi.get(self, "address_lines")

    @property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> str:
        """
        Billing currency
        """
        return pulumi.get(self, "billing_currency")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Sequence[str]:
        """
        Billing contact emails
        """
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> str:
        """
        Billing extra text
        """
        return pulumi.get(self, "billing_extra_text")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> str:
        """
        Credit card id
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        City
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def company(self) -> str:
        """
        Company name
        """
        return pulumi.get(self, "company")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        Country code
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Billing Group name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> str:
        """
        VAT id
        """
        return pulumi.get(self, "vat_id")

    @property
    @pulumi.getter(name="zipCode")
    def zip_code(self) -> str:
        """
        Zip Code
        """
        return pulumi.get(self, "zip_code")


class AwaitableGetBillingGroupResult(GetBillingGroupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBillingGroupResult(
            account_id=self.account_id,
            address_lines=self.address_lines,
            billing_currency=self.billing_currency,
            billing_emails=self.billing_emails,
            billing_extra_text=self.billing_extra_text,
            card_id=self.card_id,
            city=self.city,
            company=self.company,
            country_code=self.country_code,
            id=self.id,
            name=self.name,
            state=self.state,
            vat_id=self.vat_id,
            zip_code=self.zip_code)


def get_billing_group(name: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBillingGroupResult:
    """
    The Billing Group data source provides information about the existing Aiven Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_billing_group(name="<BILLING_GROUP_NAME>")
    ```


    :param str name: Billing Group name
    """
    __args__ = dict()
    __args__['name'] = name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getBillingGroup:getBillingGroup', __args__, opts=opts, typ=GetBillingGroupResult).value

    return AwaitableGetBillingGroupResult(
        account_id=__ret__.account_id,
        address_lines=__ret__.address_lines,
        billing_currency=__ret__.billing_currency,
        billing_emails=__ret__.billing_emails,
        billing_extra_text=__ret__.billing_extra_text,
        card_id=__ret__.card_id,
        city=__ret__.city,
        company=__ret__.company,
        country_code=__ret__.country_code,
        id=__ret__.id,
        name=__ret__.name,
        state=__ret__.state,
        vat_id=__ret__.vat_id,
        zip_code=__ret__.zip_code)


@_utilities.lift_output_func(get_billing_group)
def get_billing_group_output(name: Optional[pulumi.Input[str]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBillingGroupResult]:
    """
    The Billing Group data source provides information about the existing Aiven Account.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    foo = aiven.get_billing_group(name="<BILLING_GROUP_NAME>")
    ```


    :param str name: Billing Group name
    """
    ...
