# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetClickhouseDatabaseResult',
    'AwaitableGetClickhouseDatabaseResult',
    'get_clickhouse_database',
    'get_clickhouse_database_output',
]

@pulumi.output_type
class GetClickhouseDatabaseResult:
    """
    A collection of values returned by getClickhouseDatabase.
    """
    def __init__(__self__, id=None, name=None, project=None, service_name=None, termination_protection=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if termination_protection and not isinstance(termination_protection, bool):
            raise TypeError("Expected argument 'termination_protection' to be a bool")
        pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Clickhouse database. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> bool:
        return pulumi.get(self, "termination_protection")


class AwaitableGetClickhouseDatabaseResult(GetClickhouseDatabaseResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetClickhouseDatabaseResult(
            id=self.id,
            name=self.name,
            project=self.project,
            service_name=self.service_name,
            termination_protection=self.termination_protection)


def get_clickhouse_database(name: Optional[str] = None,
                            project: Optional[str] = None,
                            service_name: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetClickhouseDatabaseResult:
    """
    The Clickhouse database data source provides information about the existing Aiven Clickhouse Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    clickhouse_db = aiven.get_clickhouse_database(project=aiven_clickhouse["ch"]["project"],
        service_name=aiven_clickhouse["ch"]["service_name"],
        name="my-ch-db")
    ```


    :param str name: The name of the Clickhouse database. This property cannot be changed, doing so forces recreation of the resource.
    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['project'] = project
    __args__['serviceName'] = service_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getClickhouseDatabase:getClickhouseDatabase', __args__, opts=opts, typ=GetClickhouseDatabaseResult).value

    return AwaitableGetClickhouseDatabaseResult(
        id=__ret__.id,
        name=__ret__.name,
        project=__ret__.project,
        service_name=__ret__.service_name,
        termination_protection=__ret__.termination_protection)


@_utilities.lift_output_func(get_clickhouse_database)
def get_clickhouse_database_output(name: Optional[pulumi.Input[str]] = None,
                                   project: Optional[pulumi.Input[str]] = None,
                                   service_name: Optional[pulumi.Input[str]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetClickhouseDatabaseResult]:
    """
    The Clickhouse database data source provides information about the existing Aiven Clickhouse Database.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    clickhouse_db = aiven.get_clickhouse_database(project=aiven_clickhouse["ch"]["project"],
        service_name=aiven_clickhouse["ch"]["service_name"],
        name="my-ch-db")
    ```


    :param str name: The name of the Clickhouse database. This property cannot be changed, doing so forces recreation of the resource.
    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
