# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetKafkaSchemaResult',
    'AwaitableGetKafkaSchemaResult',
    'get_kafka_schema',
    'get_kafka_schema_output',
]

@pulumi.output_type
class GetKafkaSchemaResult:
    """
    A collection of values returned by getKafkaSchema.
    """
    def __init__(__self__, compatibility_level=None, id=None, project=None, schema=None, service_name=None, subject_name=None, version=None):
        if compatibility_level and not isinstance(compatibility_level, str):
            raise TypeError("Expected argument 'compatibility_level' to be a str")
        pulumi.set(__self__, "compatibility_level", compatibility_level)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if service_name and not isinstance(service_name, str):
            raise TypeError("Expected argument 'service_name' to be a str")
        pulumi.set(__self__, "service_name", service_name)
        if subject_name and not isinstance(subject_name, str):
            raise TypeError("Expected argument 'subject_name' to be a str")
        pulumi.set(__self__, "subject_name", subject_name)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="compatibilityLevel")
    def compatibility_level(self) -> str:
        """
        Kafka Schemas compatibility level. The possible values are `BACKWARD`, `BACKWARD_TRANSITIVE`, `FORWARD`, `FORWARD_TRANSITIVE`, `FULL`, `FULL_TRANSITIVE` and `NONE`.
        """
        return pulumi.get(self, "compatibility_level")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Kafka Schema configuration should be a valid Avro Schema JSON format.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> str:
        """
        Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="subjectName")
    def subject_name(self) -> str:
        """
        The Kafka Schema Subject name. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "subject_name")

    @property
    @pulumi.getter
    def version(self) -> int:
        """
        Kafka Schema configuration version.
        """
        return pulumi.get(self, "version")


class AwaitableGetKafkaSchemaResult(GetKafkaSchemaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKafkaSchemaResult(
            compatibility_level=self.compatibility_level,
            id=self.id,
            project=self.project,
            schema=self.schema,
            service_name=self.service_name,
            subject_name=self.subject_name,
            version=self.version)


def get_kafka_schema(project: Optional[str] = None,
                     service_name: Optional[str] = None,
                     subject_name: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKafkaSchemaResult:
    """
    The Kafka Schema data source provides information about the existing Aiven Kafka Schema.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.get_kafka_schema_configuration(project=aiven_project["kafka-schemas-project1"]["project"],
        service_name=aiven_service["kafka-service1"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str subject_name: The Kafka Schema Subject name. This property cannot be changed, doing so forces recreation of the resource.
    """
    __args__ = dict()
    __args__['project'] = project
    __args__['serviceName'] = service_name
    __args__['subjectName'] = subject_name
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getKafkaSchema:getKafkaSchema', __args__, opts=opts, typ=GetKafkaSchemaResult).value

    return AwaitableGetKafkaSchemaResult(
        compatibility_level=__ret__.compatibility_level,
        id=__ret__.id,
        project=__ret__.project,
        schema=__ret__.schema,
        service_name=__ret__.service_name,
        subject_name=__ret__.subject_name,
        version=__ret__.version)


@_utilities.lift_output_func(get_kafka_schema)
def get_kafka_schema_output(project: Optional[pulumi.Input[str]] = None,
                            service_name: Optional[pulumi.Input[str]] = None,
                            subject_name: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKafkaSchemaResult]:
    """
    The Kafka Schema data source provides information about the existing Aiven Kafka Schema.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    config = aiven.get_kafka_schema_configuration(project=aiven_project["kafka-schemas-project1"]["project"],
        service_name=aiven_service["kafka-service1"]["service_name"])
    ```


    :param str project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str service_name: Specifies the name of the service that this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
    :param str subject_name: The Kafka Schema Subject name. This property cannot be changed, doing so forces recreation of the resource.
    """
    ...
