# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetProjectResult',
    'AwaitableGetProjectResult',
    'get_project',
    'get_project_output',
]

@pulumi.output_type
class GetProjectResult:
    """
    A collection of values returned by getProject.
    """
    def __init__(__self__, account_id=None, add_account_owners_admin_access=None, available_credits=None, billing_address=None, billing_currency=None, billing_emails=None, billing_extra_text=None, billing_group=None, ca_cert=None, card_id=None, copy_from_project=None, country_code=None, default_cloud=None, estimated_balance=None, id=None, payment_method=None, project=None, technical_emails=None, use_source_project_billing_group=None, vat_id=None):
        if account_id and not isinstance(account_id, str):
            raise TypeError("Expected argument 'account_id' to be a str")
        pulumi.set(__self__, "account_id", account_id)
        if add_account_owners_admin_access and not isinstance(add_account_owners_admin_access, bool):
            raise TypeError("Expected argument 'add_account_owners_admin_access' to be a bool")
        pulumi.set(__self__, "add_account_owners_admin_access", add_account_owners_admin_access)
        if available_credits and not isinstance(available_credits, str):
            raise TypeError("Expected argument 'available_credits' to be a str")
        pulumi.set(__self__, "available_credits", available_credits)
        if billing_address and not isinstance(billing_address, str):
            raise TypeError("Expected argument 'billing_address' to be a str")
        pulumi.set(__self__, "billing_address", billing_address)
        if billing_currency and not isinstance(billing_currency, str):
            raise TypeError("Expected argument 'billing_currency' to be a str")
        pulumi.set(__self__, "billing_currency", billing_currency)
        if billing_emails and not isinstance(billing_emails, list):
            raise TypeError("Expected argument 'billing_emails' to be a list")
        pulumi.set(__self__, "billing_emails", billing_emails)
        if billing_extra_text and not isinstance(billing_extra_text, str):
            raise TypeError("Expected argument 'billing_extra_text' to be a str")
        pulumi.set(__self__, "billing_extra_text", billing_extra_text)
        if billing_group and not isinstance(billing_group, str):
            raise TypeError("Expected argument 'billing_group' to be a str")
        pulumi.set(__self__, "billing_group", billing_group)
        if ca_cert and not isinstance(ca_cert, str):
            raise TypeError("Expected argument 'ca_cert' to be a str")
        pulumi.set(__self__, "ca_cert", ca_cert)
        if card_id and not isinstance(card_id, str):
            raise TypeError("Expected argument 'card_id' to be a str")
        pulumi.set(__self__, "card_id", card_id)
        if copy_from_project and not isinstance(copy_from_project, str):
            raise TypeError("Expected argument 'copy_from_project' to be a str")
        pulumi.set(__self__, "copy_from_project", copy_from_project)
        if country_code and not isinstance(country_code, str):
            raise TypeError("Expected argument 'country_code' to be a str")
        pulumi.set(__self__, "country_code", country_code)
        if default_cloud and not isinstance(default_cloud, str):
            raise TypeError("Expected argument 'default_cloud' to be a str")
        pulumi.set(__self__, "default_cloud", default_cloud)
        if estimated_balance and not isinstance(estimated_balance, str):
            raise TypeError("Expected argument 'estimated_balance' to be a str")
        pulumi.set(__self__, "estimated_balance", estimated_balance)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if payment_method and not isinstance(payment_method, str):
            raise TypeError("Expected argument 'payment_method' to be a str")
        pulumi.set(__self__, "payment_method", payment_method)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if technical_emails and not isinstance(technical_emails, list):
            raise TypeError("Expected argument 'technical_emails' to be a list")
        pulumi.set(__self__, "technical_emails", technical_emails)
        if use_source_project_billing_group and not isinstance(use_source_project_billing_group, bool):
            raise TypeError("Expected argument 'use_source_project_billing_group' to be a bool")
        pulumi.set(__self__, "use_source_project_billing_group", use_source_project_billing_group)
        if vat_id and not isinstance(vat_id, str):
            raise TypeError("Expected argument 'vat_id' to be a str")
        pulumi.set(__self__, "vat_id", vat_id)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        An optional property to link a project to already an existing account by using account ID. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="addAccountOwnersAdminAccess")
    def add_account_owners_admin_access(self) -> bool:
        """
        If account_id is set, grant account owner team admin access to the new project. The default value is `true`.
        """
        return pulumi.get(self, "add_account_owners_admin_access")

    @property
    @pulumi.getter(name="availableCredits")
    def available_credits(self) -> str:
        """
        The amount of platform credits available to the project. This could be your free trial or other promotional credits.
        """
        return pulumi.get(self, "available_credits")

    @property
    @pulumi.getter(name="billingAddress")
    def billing_address(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Billing name and address of the project.
        """
        return pulumi.get(self, "billing_address")

    @property
    @pulumi.getter(name="billingCurrency")
    def billing_currency(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Billing currency.
        """
        return pulumi.get(self, "billing_currency")

    @property
    @pulumi.getter(name="billingEmails")
    def billing_emails(self) -> Sequence[str]:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Billing contact emails of the project.
        """
        return pulumi.get(self, "billing_emails")

    @property
    @pulumi.getter(name="billingExtraText")
    def billing_extra_text(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Extra text to be included in all project invoices, e.g. purchase order or cost center number.
        """
        return pulumi.get(self, "billing_extra_text")

    @property
    @pulumi.getter(name="billingGroup")
    def billing_group(self) -> str:
        """
        The id of the billing group that is linked to this project. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "billing_group")

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> str:
        """
        The CA certificate of the project. This is required for configuring clients that connect to certain services like Kafka.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="cardId")
    def card_id(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Either the full card UUID or the last 4 digits of the card. As the full UUID is not shown in the UI it is typically easier to use the last 4 digits to identify the card. This can be omitted if `copy_from_project` is used to copy billing info from another project.
        """
        return pulumi.get(self, "card_id")

    @property
    @pulumi.getter(name="copyFromProject")
    def copy_from_project(self) -> str:
        """
        is the name of another project used to copy billing information and some other project attributes like technical contacts from. This is mostly relevant when an existing project has billing type set to invoice and that needs to be copied over to a new project. (Setting billing is otherwise not allowed over the API.) This only has effect when the project is created. To set up proper dependencies please refer to this variable as a reference.
        """
        return pulumi.get(self, "copy_from_project")

    @property
    @pulumi.getter(name="countryCode")
    def country_code(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** Billing country code of the project.
        """
        return pulumi.get(self, "country_code")

    @property
    @pulumi.getter(name="defaultCloud")
    def default_cloud(self) -> str:
        """
        Defines the default cloud provider and region where services are hosted. This can be changed freely after the project is created. This will not affect existing services.
        """
        return pulumi.get(self, "default_cloud")

    @property
    @pulumi.getter(name="estimatedBalance")
    def estimated_balance(self) -> str:
        """
        The current accumulated bill for this project in the current billing period.
        """
        return pulumi.get(self, "estimated_balance")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="paymentMethod")
    def payment_method(self) -> str:
        """
        The method of invoicing used for payments for this project, e.g. `card`.
        """
        return pulumi.get(self, "payment_method")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="technicalEmails")
    def technical_emails(self) -> Sequence[str]:
        """
        Defines the email addresses that will receive alerts about upcoming maintenance updates or warnings about service instability. It is  good practice to keep this up-to-date to be aware of any potential issues with your project.
        """
        return pulumi.get(self, "technical_emails")

    @property
    @pulumi.getter(name="useSourceProjectBillingGroup")
    def use_source_project_billing_group(self) -> bool:
        """
        Use the same billing group that is used in source project.
        """
        return pulumi.get(self, "use_source_project_billing_group")

    @property
    @pulumi.getter(name="vatId")
    def vat_id(self) -> str:
        """
        **DEPRECATED Please use aiven*billing*group resource to set this value.** EU VAT Identification Number.
        """
        return pulumi.get(self, "vat_id")


class AwaitableGetProjectResult(GetProjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProjectResult(
            account_id=self.account_id,
            add_account_owners_admin_access=self.add_account_owners_admin_access,
            available_credits=self.available_credits,
            billing_address=self.billing_address,
            billing_currency=self.billing_currency,
            billing_emails=self.billing_emails,
            billing_extra_text=self.billing_extra_text,
            billing_group=self.billing_group,
            ca_cert=self.ca_cert,
            card_id=self.card_id,
            copy_from_project=self.copy_from_project,
            country_code=self.country_code,
            default_cloud=self.default_cloud,
            estimated_balance=self.estimated_balance,
            id=self.id,
            payment_method=self.payment_method,
            project=self.project,
            technical_emails=self.technical_emails,
            use_source_project_billing_group=self.use_source_project_billing_group,
            vat_id=self.vat_id)


def get_project(project: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProjectResult:
    """
    The Project data source provides information about the existing Aiven Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myproject = aiven.get_project(project="<PROJECT_NAME>")
    ```


    :param str project: Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    __args__ = dict()
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getProject:getProject', __args__, opts=opts, typ=GetProjectResult).value

    return AwaitableGetProjectResult(
        account_id=__ret__.account_id,
        add_account_owners_admin_access=__ret__.add_account_owners_admin_access,
        available_credits=__ret__.available_credits,
        billing_address=__ret__.billing_address,
        billing_currency=__ret__.billing_currency,
        billing_emails=__ret__.billing_emails,
        billing_extra_text=__ret__.billing_extra_text,
        billing_group=__ret__.billing_group,
        ca_cert=__ret__.ca_cert,
        card_id=__ret__.card_id,
        copy_from_project=__ret__.copy_from_project,
        country_code=__ret__.country_code,
        default_cloud=__ret__.default_cloud,
        estimated_balance=__ret__.estimated_balance,
        id=__ret__.id,
        payment_method=__ret__.payment_method,
        project=__ret__.project,
        technical_emails=__ret__.technical_emails,
        use_source_project_billing_group=__ret__.use_source_project_billing_group,
        vat_id=__ret__.vat_id)


@_utilities.lift_output_func(get_project)
def get_project_output(project: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProjectResult]:
    """
    The Project data source provides information about the existing Aiven Project.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myproject = aiven.get_project(project="<PROJECT_NAME>")
    ```


    :param str project: Defines the name of the project. Name must be globally unique (between all Aiven customers) and cannot be changed later without destroying and re-creating the project, including all sub-resources.
    """
    ...
