# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetServiceIntegrationEndpointResult',
    'AwaitableGetServiceIntegrationEndpointResult',
    'get_service_integration_endpoint',
    'get_service_integration_endpoint_output',
]

@pulumi.output_type
class GetServiceIntegrationEndpointResult:
    """
    A collection of values returned by getServiceIntegrationEndpoint.
    """
    def __init__(__self__, datadog_user_configs=None, endpoint_config=None, endpoint_name=None, endpoint_type=None, external_aws_cloudwatch_logs_user_configs=None, external_aws_cloudwatch_metrics_user_configs=None, external_elasticsearch_logs_user_configs=None, external_google_cloud_logging_user_configs=None, external_kafka_user_configs=None, external_schema_registry_user_configs=None, id=None, jolokia_user_configs=None, project=None, prometheus_user_configs=None, rsyslog_user_configs=None, signalfx_user_configs=None):
        if datadog_user_configs and not isinstance(datadog_user_configs, list):
            raise TypeError("Expected argument 'datadog_user_configs' to be a list")
        pulumi.set(__self__, "datadog_user_configs", datadog_user_configs)
        if endpoint_config and not isinstance(endpoint_config, dict):
            raise TypeError("Expected argument 'endpoint_config' to be a dict")
        pulumi.set(__self__, "endpoint_config", endpoint_config)
        if endpoint_name and not isinstance(endpoint_name, str):
            raise TypeError("Expected argument 'endpoint_name' to be a str")
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type and not isinstance(endpoint_type, str):
            raise TypeError("Expected argument 'endpoint_type' to be a str")
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        if external_aws_cloudwatch_logs_user_configs and not isinstance(external_aws_cloudwatch_logs_user_configs, list):
            raise TypeError("Expected argument 'external_aws_cloudwatch_logs_user_configs' to be a list")
        pulumi.set(__self__, "external_aws_cloudwatch_logs_user_configs", external_aws_cloudwatch_logs_user_configs)
        if external_aws_cloudwatch_metrics_user_configs and not isinstance(external_aws_cloudwatch_metrics_user_configs, list):
            raise TypeError("Expected argument 'external_aws_cloudwatch_metrics_user_configs' to be a list")
        pulumi.set(__self__, "external_aws_cloudwatch_metrics_user_configs", external_aws_cloudwatch_metrics_user_configs)
        if external_elasticsearch_logs_user_configs and not isinstance(external_elasticsearch_logs_user_configs, list):
            raise TypeError("Expected argument 'external_elasticsearch_logs_user_configs' to be a list")
        pulumi.set(__self__, "external_elasticsearch_logs_user_configs", external_elasticsearch_logs_user_configs)
        if external_google_cloud_logging_user_configs and not isinstance(external_google_cloud_logging_user_configs, list):
            raise TypeError("Expected argument 'external_google_cloud_logging_user_configs' to be a list")
        pulumi.set(__self__, "external_google_cloud_logging_user_configs", external_google_cloud_logging_user_configs)
        if external_kafka_user_configs and not isinstance(external_kafka_user_configs, list):
            raise TypeError("Expected argument 'external_kafka_user_configs' to be a list")
        pulumi.set(__self__, "external_kafka_user_configs", external_kafka_user_configs)
        if external_schema_registry_user_configs and not isinstance(external_schema_registry_user_configs, list):
            raise TypeError("Expected argument 'external_schema_registry_user_configs' to be a list")
        pulumi.set(__self__, "external_schema_registry_user_configs", external_schema_registry_user_configs)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if jolokia_user_configs and not isinstance(jolokia_user_configs, list):
            raise TypeError("Expected argument 'jolokia_user_configs' to be a list")
        pulumi.set(__self__, "jolokia_user_configs", jolokia_user_configs)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if prometheus_user_configs and not isinstance(prometheus_user_configs, list):
            raise TypeError("Expected argument 'prometheus_user_configs' to be a list")
        pulumi.set(__self__, "prometheus_user_configs", prometheus_user_configs)
        if rsyslog_user_configs and not isinstance(rsyslog_user_configs, list):
            raise TypeError("Expected argument 'rsyslog_user_configs' to be a list")
        pulumi.set(__self__, "rsyslog_user_configs", rsyslog_user_configs)
        if signalfx_user_configs and not isinstance(signalfx_user_configs, list):
            raise TypeError("Expected argument 'signalfx_user_configs' to be a list")
        pulumi.set(__self__, "signalfx_user_configs", signalfx_user_configs)

    @property
    @pulumi.getter(name="datadogUserConfigs")
    def datadog_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointDatadogUserConfigResult']:
        """
        Datadog specific user configurable settings
        """
        return pulumi.get(self, "datadog_user_configs")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> Mapping[str, str]:
        """
        Integration endpoint specific backend configuration
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        Name of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Type of the service integration endpoint
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="externalAwsCloudwatchLogsUserConfigs")
    def external_aws_cloudwatch_logs_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalAwsCloudwatchLogsUserConfigResult']:
        """
        external AWS CloudWatch Logs specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_logs_user_configs")

    @property
    @pulumi.getter(name="externalAwsCloudwatchMetricsUserConfigs")
    def external_aws_cloudwatch_metrics_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalAwsCloudwatchMetricsUserConfigResult']:
        """
        External AWS cloudwatch mertrics specific user configurable settings
        """
        return pulumi.get(self, "external_aws_cloudwatch_metrics_user_configs")

    @property
    @pulumi.getter(name="externalElasticsearchLogsUserConfigs")
    def external_elasticsearch_logs_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalElasticsearchLogsUserConfigResult']:
        """
        external elasticsearch specific user configurable settings
        """
        return pulumi.get(self, "external_elasticsearch_logs_user_configs")

    @property
    @pulumi.getter(name="externalGoogleCloudLoggingUserConfigs")
    def external_google_cloud_logging_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalGoogleCloudLoggingUserConfigResult']:
        """
        external Google Cloud Logginig specific user configurable settings
        """
        return pulumi.get(self, "external_google_cloud_logging_user_configs")

    @property
    @pulumi.getter(name="externalKafkaUserConfigs")
    def external_kafka_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalKafkaUserConfigResult']:
        """
        external Kafka specific user configurable settings
        """
        return pulumi.get(self, "external_kafka_user_configs")

    @property
    @pulumi.getter(name="externalSchemaRegistryUserConfigs")
    def external_schema_registry_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointExternalSchemaRegistryUserConfigResult']:
        """
        External schema registry specific user configurable settings
        """
        return pulumi.get(self, "external_schema_registry_user_configs")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="jolokiaUserConfigs")
    def jolokia_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointJolokiaUserConfigResult']:
        """
        Jolokia specific user configurable settings
        """
        return pulumi.get(self, "jolokia_user_configs")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Project the service integration endpoint belongs to
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="prometheusUserConfigs")
    def prometheus_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointPrometheusUserConfigResult']:
        """
        Prometheus specific user configurable settings
        """
        return pulumi.get(self, "prometheus_user_configs")

    @property
    @pulumi.getter(name="rsyslogUserConfigs")
    def rsyslog_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointRsyslogUserConfigResult']:
        """
        rsyslog specific user configurable settings
        """
        return pulumi.get(self, "rsyslog_user_configs")

    @property
    @pulumi.getter(name="signalfxUserConfigs")
    def signalfx_user_configs(self) -> Sequence['outputs.GetServiceIntegrationEndpointSignalfxUserConfigResult']:
        """
        Signalfx specific user configurable settings
        """
        return pulumi.get(self, "signalfx_user_configs")


class AwaitableGetServiceIntegrationEndpointResult(GetServiceIntegrationEndpointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServiceIntegrationEndpointResult(
            datadog_user_configs=self.datadog_user_configs,
            endpoint_config=self.endpoint_config,
            endpoint_name=self.endpoint_name,
            endpoint_type=self.endpoint_type,
            external_aws_cloudwatch_logs_user_configs=self.external_aws_cloudwatch_logs_user_configs,
            external_aws_cloudwatch_metrics_user_configs=self.external_aws_cloudwatch_metrics_user_configs,
            external_elasticsearch_logs_user_configs=self.external_elasticsearch_logs_user_configs,
            external_google_cloud_logging_user_configs=self.external_google_cloud_logging_user_configs,
            external_kafka_user_configs=self.external_kafka_user_configs,
            external_schema_registry_user_configs=self.external_schema_registry_user_configs,
            id=self.id,
            jolokia_user_configs=self.jolokia_user_configs,
            project=self.project,
            prometheus_user_configs=self.prometheus_user_configs,
            rsyslog_user_configs=self.rsyslog_user_configs,
            signalfx_user_configs=self.signalfx_user_configs)


def get_service_integration_endpoint(endpoint_name: Optional[str] = None,
                                     project: Optional[str] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServiceIntegrationEndpointResult:
    """
    The Service Integration Endpoint data source provides information about the existing Aiven Service Integration Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myendpoint = aiven.get_service_integration_endpoint(project=aiven_project["myproject"]["project"],
        endpoint_name="<ENDPOINT_NAME>")
    ```


    :param str endpoint_name: Name of the service integration endpoint
    :param str project: Project the service integration endpoint belongs to
    """
    __args__ = dict()
    __args__['endpointName'] = endpoint_name
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('aiven:index/getServiceIntegrationEndpoint:getServiceIntegrationEndpoint', __args__, opts=opts, typ=GetServiceIntegrationEndpointResult).value

    return AwaitableGetServiceIntegrationEndpointResult(
        datadog_user_configs=__ret__.datadog_user_configs,
        endpoint_config=__ret__.endpoint_config,
        endpoint_name=__ret__.endpoint_name,
        endpoint_type=__ret__.endpoint_type,
        external_aws_cloudwatch_logs_user_configs=__ret__.external_aws_cloudwatch_logs_user_configs,
        external_aws_cloudwatch_metrics_user_configs=__ret__.external_aws_cloudwatch_metrics_user_configs,
        external_elasticsearch_logs_user_configs=__ret__.external_elasticsearch_logs_user_configs,
        external_google_cloud_logging_user_configs=__ret__.external_google_cloud_logging_user_configs,
        external_kafka_user_configs=__ret__.external_kafka_user_configs,
        external_schema_registry_user_configs=__ret__.external_schema_registry_user_configs,
        id=__ret__.id,
        jolokia_user_configs=__ret__.jolokia_user_configs,
        project=__ret__.project,
        prometheus_user_configs=__ret__.prometheus_user_configs,
        rsyslog_user_configs=__ret__.rsyslog_user_configs,
        signalfx_user_configs=__ret__.signalfx_user_configs)


@_utilities.lift_output_func(get_service_integration_endpoint)
def get_service_integration_endpoint_output(endpoint_name: Optional[pulumi.Input[str]] = None,
                                            project: Optional[pulumi.Input[str]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetServiceIntegrationEndpointResult]:
    """
    The Service Integration Endpoint data source provides information about the existing Aiven Service Integration Endpoint.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_aiven as aiven

    myendpoint = aiven.get_service_integration_endpoint(project=aiven_project["myproject"]["project"],
        endpoint_name="<ENDPOINT_NAME>")
    ```


    :param str endpoint_name: Name of the service integration endpoint
    :param str project: Project the service integration endpoint belongs to
    """
    ...
