# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ProjectVpcArgs', 'ProjectVpc']

@pulumi.input_type
class ProjectVpcArgs:
    def __init__(__self__, *,
                 cloud_name: pulumi.Input[str],
                 network_cidr: pulumi.Input[str],
                 project: pulumi.Input[str]):
        """
        The set of arguments for constructing a ProjectVpc resource.
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        pulumi.set(__self__, "cloud_name", cloud_name)
        pulumi.set(__self__, "network_cidr", network_cidr)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Input[str]:
        """
        Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> pulumi.Input[str]:
        """
        Network address range used by the VPC like 192.168.0.0/24
        """
        return pulumi.get(self, "network_cidr")

    @network_cidr.setter
    def network_cidr(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_cidr", value)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _ProjectVpcState:
    def __init__(__self__, *,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 network_cidr: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ProjectVpc resources.
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: State of the VPC. The possible values are `APPROVED`, `ACTIVE`, `DELETING` and `DELETED`.
        """
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if network_cidr is not None:
            pulumi.set(__self__, "network_cidr", network_cidr)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> Optional[pulumi.Input[str]]:
        """
        Network address range used by the VPC like 192.168.0.0/24
        """
        return pulumi.get(self, "network_cidr")

    @network_cidr.setter
    def network_cidr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_cidr", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        State of the VPC. The possible values are `APPROVED`, `ACTIVE`, `DELETING` and `DELETED`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class ProjectVpc(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 network_cidr: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The Project VPC resource allows the creation and management of Aiven Project VPCs.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProjectVpcArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Project VPC resource allows the creation and management of Aiven Project VPCs.

        :param str resource_name: The name of the resource.
        :param ProjectVpcArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProjectVpcArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 network_cidr: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProjectVpcArgs.__new__(ProjectVpcArgs)

            if cloud_name is None and not opts.urn:
                raise TypeError("Missing required property 'cloud_name'")
            __props__.__dict__["cloud_name"] = cloud_name
            if network_cidr is None and not opts.urn:
                raise TypeError("Missing required property 'network_cidr'")
            __props__.__dict__["network_cidr"] = network_cidr
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["state"] = None
        super(ProjectVpc, __self__).__init__(
            'aiven:index/projectVpc:ProjectVpc',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            network_cidr: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'ProjectVpc':
        """
        Get an existing ProjectVpc resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cloud_name: Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] network_cidr: Network address range used by the VPC like 192.168.0.0/24
        :param pulumi.Input[str] project: Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        :param pulumi.Input[str] state: State of the VPC. The possible values are `APPROVED`, `ACTIVE`, `DELETING` and `DELETED`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ProjectVpcState.__new__(_ProjectVpcState)

        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["network_cidr"] = network_cidr
        __props__.__dict__["project"] = project
        __props__.__dict__["state"] = state
        return ProjectVpc(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[str]:
        """
        Defines where the cloud provider and region where the service is hosted in. See the Service resource for additional information. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter(name="networkCidr")
    def network_cidr(self) -> pulumi.Output[str]:
        """
        Network address range used by the VPC like 192.168.0.0/24
        """
        return pulumi.get(self, "network_cidr")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Identifies the project this resource belongs to. To set up proper dependencies please refer to this variable as a reference. This property cannot be changed, doing so forces recreation of the resource.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the VPC. The possible values are `APPROVED`, `ACTIVE`, `DELETING` and `DELETED`.
        """
        return pulumi.get(self, "state")

