# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServiceArgs', 'Service']

@pulumi.input_type
class ServiceArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 service_type: pulumi.Input[str],
                 cassandra_user_config: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']] = None,
                 clickhouse_user_config: Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']] = None,
                 flink_user_config: Optional[pulumi.Input['ServiceFlinkUserConfigArgs']] = None,
                 flinks: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]] = None,
                 grafana_user_config: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']] = None,
                 influxdb_user_config: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']] = None,
                 kafka_user_config: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql_user_config: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']] = None,
                 opensearch_user_config: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']] = None,
                 pg_user_config: Optional[pulumi.Input['ServicePgUserConfigArgs']] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis_user_config: Optional[pulumi.Input['ServiceRedisUserConfigArgs']] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Service resource.
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input['ServiceCassandraUserConfigArgs'] cassandra_user_config: Cassandra user configurable settings
        :param pulumi.Input['ServiceClickhouseUserConfigArgs'] clickhouse_user_config: Clickhouse user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[str] disk_space: The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        :param pulumi.Input['ServiceElasticsearchUserConfigArgs'] elasticsearch_user_config: Elasticsearch user configurable settings
        :param pulumi.Input['ServiceFlinkUserConfigArgs'] flink_user_config: Flink user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]] flinks: Flink specific server provided values
        :param pulumi.Input['ServiceGrafanaUserConfigArgs'] grafana_user_config: Grafana user configurable settings
        :param pulumi.Input['ServiceInfluxdbUserConfigArgs'] influxdb_user_config: Influxdb user configurable settings
        :param pulumi.Input['ServiceKafkaConnectUserConfigArgs'] kafka_connect_user_config: Kafka*connect user configurable settings
        :param pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: Kafka*mirrormaker user configurable settings
        :param pulumi.Input['ServiceKafkaUserConfigArgs'] kafka_user_config: Kafka user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]] kafkas: Kafka specific server provided values
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input['ServiceMysqlUserConfigArgs'] mysql_user_config: Mysql user configurable settings
        :param pulumi.Input['ServiceOpensearchUserConfigArgs'] opensearch_user_config: Opensearch user configurable settings
        :param pulumi.Input['ServicePgUserConfigArgs'] pg_user_config: Pg user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input['ServiceRedisUserConfigArgs'] redis_user_config: Redis user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "service_name", service_name)
        pulumi.set(__self__, "service_type", service_type)
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if clickhouse_user_config is not None:
            pulumi.set(__self__, "clickhouse_user_config", clickhouse_user_config)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if disk_space is not None:
            pulumi.set(__self__, "disk_space", disk_space)
        if elasticsearch_user_config is not None:
            pulumi.set(__self__, "elasticsearch_user_config", elasticsearch_user_config)
        if flink_user_config is not None:
            pulumi.set(__self__, "flink_user_config", flink_user_config)
        if flinks is not None:
            pulumi.set(__self__, "flinks", flinks)
        if grafana_user_config is not None:
            pulumi.set(__self__, "grafana_user_config", grafana_user_config)
        if influxdb_user_config is not None:
            pulumi.set(__self__, "influxdb_user_config", influxdb_user_config)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if kafka_user_config is not None:
            pulumi.set(__self__, "kafka_user_config", kafka_user_config)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if mysql_user_config is not None:
            pulumi.set(__self__, "mysql_user_config", mysql_user_config)
        if opensearch_user_config is not None:
            pulumi.set(__self__, "opensearch_user_config", opensearch_user_config)
        if pg_user_config is not None:
            pulumi.set(__self__, "pg_user_config", pg_user_config)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if redis_user_config is not None:
            pulumi.set(__self__, "redis_user_config", redis_user_config)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if static_ips is not None:
            pulumi.set(__self__, "static_ips", static_ips)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Input[str]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]:
        """
        Cassandra user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter(name="clickhouseUserConfig")
    def clickhouse_user_config(self) -> Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']]:
        """
        Clickhouse user configurable settings
        """
        return pulumi.get(self, "clickhouse_user_config")

    @clickhouse_user_config.setter
    def clickhouse_user_config(self, value: Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']]):
        pulumi.set(self, "clickhouse_user_config", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter(name="diskSpace")
    def disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @disk_space.setter
    def disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space", value)

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]:
        """
        Elasticsearch user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @elasticsearch_user_config.setter
    def elasticsearch_user_config(self, value: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]):
        pulumi.set(self, "elasticsearch_user_config", value)

    @property
    @pulumi.getter(name="flinkUserConfig")
    def flink_user_config(self) -> Optional[pulumi.Input['ServiceFlinkUserConfigArgs']]:
        """
        Flink user configurable settings
        """
        return pulumi.get(self, "flink_user_config")

    @flink_user_config.setter
    def flink_user_config(self, value: Optional[pulumi.Input['ServiceFlinkUserConfigArgs']]):
        pulumi.set(self, "flink_user_config", value)

    @property
    @pulumi.getter
    def flinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]]:
        """
        Flink specific server provided values
        """
        return pulumi.get(self, "flinks")

    @flinks.setter
    def flinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]]):
        pulumi.set(self, "flinks", value)

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]:
        """
        Grafana user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @grafana_user_config.setter
    def grafana_user_config(self, value: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]):
        pulumi.set(self, "grafana_user_config", value)

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]:
        """
        Influxdb user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @influxdb_user_config.setter
    def influxdb_user_config(self, value: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]):
        pulumi.set(self, "influxdb_user_config", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]:
        """
        Kafka*connect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]:
        """
        Kafka*mirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]:
        """
        Kafka user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @kafka_user_config.setter
    def kafka_user_config(self, value: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]):
        pulumi.set(self, "kafka_user_config", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]]:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]:
        """
        Mysql user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @mysql_user_config.setter
    def mysql_user_config(self, value: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]):
        pulumi.set(self, "mysql_user_config", value)

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]:
        """
        Opensearch user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @opensearch_user_config.setter
    def opensearch_user_config(self, value: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]):
        pulumi.set(self, "opensearch_user_config", value)

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> Optional[pulumi.Input['ServicePgUserConfigArgs']]:
        """
        Pg user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @pg_user_config.setter
    def pg_user_config(self, value: Optional[pulumi.Input['ServicePgUserConfigArgs']]):
        pulumi.set(self, "pg_user_config", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> Optional[pulumi.Input['ServiceRedisUserConfigArgs']]:
        """
        Redis user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @redis_user_config.setter
    def redis_user_config(self, value: Optional[pulumi.Input['ServiceRedisUserConfigArgs']]):
        pulumi.set(self, "redis_user_config", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @static_ips.setter
    def static_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_ips", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


@pulumi.input_type
class _ServiceState:
    def __init__(__self__, *,
                 cassandra_user_config: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCassandraArgs']]]] = None,
                 clickhouse_user_config: Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']] = None,
                 clickhouses: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceClickhouseArgs']]]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 components: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 disk_space_cap: Optional[pulumi.Input[str]] = None,
                 disk_space_default: Optional[pulumi.Input[str]] = None,
                 disk_space_step: Optional[pulumi.Input[str]] = None,
                 disk_space_used: Optional[pulumi.Input[str]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceElasticsearchArgs']]]] = None,
                 flink_user_config: Optional[pulumi.Input['ServiceFlinkUserConfigArgs']] = None,
                 flinks: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]] = None,
                 grafana_user_config: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']] = None,
                 grafanas: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGrafanaArgs']]]] = None,
                 influxdb_user_config: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfluxdbArgs']]]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']] = None,
                 kafka_connects: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaConnectArgs']]]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']] = None,
                 kafka_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaMirrormakerArgs']]]] = None,
                 kafka_user_config: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql_user_config: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMysqlArgs']]]] = None,
                 opensearch_user_config: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']] = None,
                 opensearches: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOpensearchArgs']]]] = None,
                 pg_user_config: Optional[pulumi.Input['ServicePgUserConfigArgs']] = None,
                 pgs: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePgArgs']]]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRediArgs']]]] = None,
                 redis_user_config: Optional[pulumi.Input['ServiceRedisUserConfigArgs']] = None,
                 service_host: Optional[pulumi.Input[str]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_password: Optional[pulumi.Input[str]] = None,
                 service_port: Optional[pulumi.Input[int]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 service_uri: Optional[pulumi.Input[str]] = None,
                 service_username: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Service resources.
        :param pulumi.Input['ServiceCassandraUserConfigArgs'] cassandra_user_config: Cassandra user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceCassandraArgs']]] cassandras: Cassandra specific server provided values
        :param pulumi.Input['ServiceClickhouseUserConfigArgs'] clickhouse_user_config: Clickhouse user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceClickhouseArgs']]] clickhouses: Clickhouse specific server provided values
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]] components: Service component information objects
        :param pulumi.Input[str] disk_space: The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        :param pulumi.Input[str] disk_space_cap: The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        :param pulumi.Input[str] disk_space_default: The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        :param pulumi.Input[str] disk_space_step: The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        :param pulumi.Input[str] disk_space_used: Disk space that service is currently using
        :param pulumi.Input['ServiceElasticsearchUserConfigArgs'] elasticsearch_user_config: Elasticsearch user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceElasticsearchArgs']]] elasticsearches: Elasticsearch specific server provided values
        :param pulumi.Input['ServiceFlinkUserConfigArgs'] flink_user_config: Flink user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]] flinks: Flink specific server provided values
        :param pulumi.Input['ServiceGrafanaUserConfigArgs'] grafana_user_config: Grafana user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceGrafanaArgs']]] grafanas: Grafana specific server provided values
        :param pulumi.Input['ServiceInfluxdbUserConfigArgs'] influxdb_user_config: Influxdb user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceInfluxdbArgs']]] influxdbs: InfluxDB specific server provided values
        :param pulumi.Input['ServiceKafkaConnectUserConfigArgs'] kafka_connect_user_config: Kafka*connect user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceKafkaConnectArgs']]] kafka_connects: Kafka Connect specific server provided values
        :param pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs'] kafka_mirrormaker_user_config: Kafka*mirrormaker user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceKafkaMirrormakerArgs']]] kafka_mirrormakers: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input['ServiceKafkaUserConfigArgs'] kafka_user_config: Kafka user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]] kafkas: Kafka specific server provided values
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input['ServiceMysqlUserConfigArgs'] mysql_user_config: Mysql user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceMysqlArgs']]] mysqls: MySQL specific server provided values
        :param pulumi.Input['ServiceOpensearchUserConfigArgs'] opensearch_user_config: Opensearch user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServiceOpensearchArgs']]] opensearches: Opensearch specific server provided values
        :param pulumi.Input['ServicePgUserConfigArgs'] pg_user_config: Pg user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input['ServicePgArgs']]] pgs: PostgreSQL specific server provided values
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[Sequence[pulumi.Input['ServiceRediArgs']]] redis: Redis specific server provided values
        :param pulumi.Input['ServiceRedisUserConfigArgs'] redis_user_config: Redis user configurable settings
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: Service port
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` and `RUNNING`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        if cassandra_user_config is not None:
            pulumi.set(__self__, "cassandra_user_config", cassandra_user_config)
        if cassandras is not None:
            pulumi.set(__self__, "cassandras", cassandras)
        if clickhouse_user_config is not None:
            pulumi.set(__self__, "clickhouse_user_config", clickhouse_user_config)
        if clickhouses is not None:
            pulumi.set(__self__, "clickhouses", clickhouses)
        if cloud_name is not None:
            pulumi.set(__self__, "cloud_name", cloud_name)
        if components is not None:
            pulumi.set(__self__, "components", components)
        if disk_space is not None:
            pulumi.set(__self__, "disk_space", disk_space)
        if disk_space_cap is not None:
            pulumi.set(__self__, "disk_space_cap", disk_space_cap)
        if disk_space_default is not None:
            pulumi.set(__self__, "disk_space_default", disk_space_default)
        if disk_space_step is not None:
            pulumi.set(__self__, "disk_space_step", disk_space_step)
        if disk_space_used is not None:
            pulumi.set(__self__, "disk_space_used", disk_space_used)
        if elasticsearch_user_config is not None:
            pulumi.set(__self__, "elasticsearch_user_config", elasticsearch_user_config)
        if elasticsearches is not None:
            pulumi.set(__self__, "elasticsearches", elasticsearches)
        if flink_user_config is not None:
            pulumi.set(__self__, "flink_user_config", flink_user_config)
        if flinks is not None:
            pulumi.set(__self__, "flinks", flinks)
        if grafana_user_config is not None:
            pulumi.set(__self__, "grafana_user_config", grafana_user_config)
        if grafanas is not None:
            pulumi.set(__self__, "grafanas", grafanas)
        if influxdb_user_config is not None:
            pulumi.set(__self__, "influxdb_user_config", influxdb_user_config)
        if influxdbs is not None:
            pulumi.set(__self__, "influxdbs", influxdbs)
        if kafka_connect_user_config is not None:
            pulumi.set(__self__, "kafka_connect_user_config", kafka_connect_user_config)
        if kafka_connects is not None:
            pulumi.set(__self__, "kafka_connects", kafka_connects)
        if kafka_mirrormaker_user_config is not None:
            pulumi.set(__self__, "kafka_mirrormaker_user_config", kafka_mirrormaker_user_config)
        if kafka_mirrormakers is not None:
            pulumi.set(__self__, "kafka_mirrormakers", kafka_mirrormakers)
        if kafka_user_config is not None:
            pulumi.set(__self__, "kafka_user_config", kafka_user_config)
        if kafkas is not None:
            pulumi.set(__self__, "kafkas", kafkas)
        if maintenance_window_dow is not None:
            pulumi.set(__self__, "maintenance_window_dow", maintenance_window_dow)
        if maintenance_window_time is not None:
            pulumi.set(__self__, "maintenance_window_time", maintenance_window_time)
        if mysql_user_config is not None:
            pulumi.set(__self__, "mysql_user_config", mysql_user_config)
        if mysqls is not None:
            pulumi.set(__self__, "mysqls", mysqls)
        if opensearch_user_config is not None:
            pulumi.set(__self__, "opensearch_user_config", opensearch_user_config)
        if opensearches is not None:
            pulumi.set(__self__, "opensearches", opensearches)
        if pg_user_config is not None:
            pulumi.set(__self__, "pg_user_config", pg_user_config)
        if pgs is not None:
            pulumi.set(__self__, "pgs", pgs)
        if plan is not None:
            pulumi.set(__self__, "plan", plan)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if project_vpc_id is not None:
            pulumi.set(__self__, "project_vpc_id", project_vpc_id)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_user_config is not None:
            pulumi.set(__self__, "redis_user_config", redis_user_config)
        if service_host is not None:
            pulumi.set(__self__, "service_host", service_host)
        if service_integrations is not None:
            pulumi.set(__self__, "service_integrations", service_integrations)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if service_password is not None:
            pulumi.set(__self__, "service_password", service_password)
        if service_port is not None:
            pulumi.set(__self__, "service_port", service_port)
        if service_type is not None:
            pulumi.set(__self__, "service_type", service_type)
        if service_uri is not None:
            pulumi.set(__self__, "service_uri", service_uri)
        if service_username is not None:
            pulumi.set(__self__, "service_username", service_username)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if static_ips is not None:
            pulumi.set(__self__, "static_ips", static_ips)
        if termination_protection is not None:
            pulumi.set(__self__, "termination_protection", termination_protection)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]:
        """
        Cassandra user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @cassandra_user_config.setter
    def cassandra_user_config(self, value: Optional[pulumi.Input['ServiceCassandraUserConfigArgs']]):
        pulumi.set(self, "cassandra_user_config", value)

    @property
    @pulumi.getter
    def cassandras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCassandraArgs']]]]:
        """
        Cassandra specific server provided values
        """
        return pulumi.get(self, "cassandras")

    @cassandras.setter
    def cassandras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceCassandraArgs']]]]):
        pulumi.set(self, "cassandras", value)

    @property
    @pulumi.getter(name="clickhouseUserConfig")
    def clickhouse_user_config(self) -> Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']]:
        """
        Clickhouse user configurable settings
        """
        return pulumi.get(self, "clickhouse_user_config")

    @clickhouse_user_config.setter
    def clickhouse_user_config(self, value: Optional[pulumi.Input['ServiceClickhouseUserConfigArgs']]):
        pulumi.set(self, "clickhouse_user_config", value)

    @property
    @pulumi.getter
    def clickhouses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceClickhouseArgs']]]]:
        """
        Clickhouse specific server provided values
        """
        return pulumi.get(self, "clickhouses")

    @clickhouses.setter
    def clickhouses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceClickhouseArgs']]]]):
        pulumi.set(self, "clickhouses", value)

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @cloud_name.setter
    def cloud_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_name", value)

    @property
    @pulumi.getter
    def components(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @components.setter
    def components(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceComponentArgs']]]]):
        pulumi.set(self, "components", value)

    @property
    @pulumi.getter(name="diskSpace")
    def disk_space(self) -> Optional[pulumi.Input[str]]:
        """
        The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @disk_space.setter
    def disk_space(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space", value)

    @property
    @pulumi.getter(name="diskSpaceCap")
    def disk_space_cap(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        """
        return pulumi.get(self, "disk_space_cap")

    @disk_space_cap.setter
    def disk_space_cap(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_cap", value)

    @property
    @pulumi.getter(name="diskSpaceDefault")
    def disk_space_default(self) -> Optional[pulumi.Input[str]]:
        """
        The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        """
        return pulumi.get(self, "disk_space_default")

    @disk_space_default.setter
    def disk_space_default(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_default", value)

    @property
    @pulumi.getter(name="diskSpaceStep")
    def disk_space_step(self) -> Optional[pulumi.Input[str]]:
        """
        The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        """
        return pulumi.get(self, "disk_space_step")

    @disk_space_step.setter
    def disk_space_step(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_step", value)

    @property
    @pulumi.getter(name="diskSpaceUsed")
    def disk_space_used(self) -> Optional[pulumi.Input[str]]:
        """
        Disk space that service is currently using
        """
        return pulumi.get(self, "disk_space_used")

    @disk_space_used.setter
    def disk_space_used(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_space_used", value)

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]:
        """
        Elasticsearch user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @elasticsearch_user_config.setter
    def elasticsearch_user_config(self, value: Optional[pulumi.Input['ServiceElasticsearchUserConfigArgs']]):
        pulumi.set(self, "elasticsearch_user_config", value)

    @property
    @pulumi.getter
    def elasticsearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceElasticsearchArgs']]]]:
        """
        Elasticsearch specific server provided values
        """
        return pulumi.get(self, "elasticsearches")

    @elasticsearches.setter
    def elasticsearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearches", value)

    @property
    @pulumi.getter(name="flinkUserConfig")
    def flink_user_config(self) -> Optional[pulumi.Input['ServiceFlinkUserConfigArgs']]:
        """
        Flink user configurable settings
        """
        return pulumi.get(self, "flink_user_config")

    @flink_user_config.setter
    def flink_user_config(self, value: Optional[pulumi.Input['ServiceFlinkUserConfigArgs']]):
        pulumi.set(self, "flink_user_config", value)

    @property
    @pulumi.getter
    def flinks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]]:
        """
        Flink specific server provided values
        """
        return pulumi.get(self, "flinks")

    @flinks.setter
    def flinks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceFlinkArgs']]]]):
        pulumi.set(self, "flinks", value)

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]:
        """
        Grafana user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @grafana_user_config.setter
    def grafana_user_config(self, value: Optional[pulumi.Input['ServiceGrafanaUserConfigArgs']]):
        pulumi.set(self, "grafana_user_config", value)

    @property
    @pulumi.getter
    def grafanas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGrafanaArgs']]]]:
        """
        Grafana specific server provided values
        """
        return pulumi.get(self, "grafanas")

    @grafanas.setter
    def grafanas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceGrafanaArgs']]]]):
        pulumi.set(self, "grafanas", value)

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]:
        """
        Influxdb user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @influxdb_user_config.setter
    def influxdb_user_config(self, value: Optional[pulumi.Input['ServiceInfluxdbUserConfigArgs']]):
        pulumi.set(self, "influxdb_user_config", value)

    @property
    @pulumi.getter
    def influxdbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfluxdbArgs']]]]:
        """
        InfluxDB specific server provided values
        """
        return pulumi.get(self, "influxdbs")

    @influxdbs.setter
    def influxdbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceInfluxdbArgs']]]]):
        pulumi.set(self, "influxdbs", value)

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]:
        """
        Kafka*connect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @kafka_connect_user_config.setter
    def kafka_connect_user_config(self, value: Optional[pulumi.Input['ServiceKafkaConnectUserConfigArgs']]):
        pulumi.set(self, "kafka_connect_user_config", value)

    @property
    @pulumi.getter(name="kafkaConnects")
    def kafka_connects(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaConnectArgs']]]]:
        """
        Kafka Connect specific server provided values
        """
        return pulumi.get(self, "kafka_connects")

    @kafka_connects.setter
    def kafka_connects(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaConnectArgs']]]]):
        pulumi.set(self, "kafka_connects", value)

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]:
        """
        Kafka*mirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @kafka_mirrormaker_user_config.setter
    def kafka_mirrormaker_user_config(self, value: Optional[pulumi.Input['ServiceKafkaMirrormakerUserConfigArgs']]):
        pulumi.set(self, "kafka_mirrormaker_user_config", value)

    @property
    @pulumi.getter(name="kafkaMirrormakers")
    def kafka_mirrormakers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaMirrormakerArgs']]]]:
        """
        Kafka MirrorMaker 2 specific server provided values
        """
        return pulumi.get(self, "kafka_mirrormakers")

    @kafka_mirrormakers.setter
    def kafka_mirrormakers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaMirrormakerArgs']]]]):
        pulumi.set(self, "kafka_mirrormakers", value)

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]:
        """
        Kafka user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @kafka_user_config.setter
    def kafka_user_config(self, value: Optional[pulumi.Input['ServiceKafkaUserConfigArgs']]):
        pulumi.set(self, "kafka_user_config", value)

    @property
    @pulumi.getter
    def kafkas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]]:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafkas")

    @kafkas.setter
    def kafkas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceKafkaArgs']]]]):
        pulumi.set(self, "kafkas", value)

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> Optional[pulumi.Input[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @maintenance_window_dow.setter
    def maintenance_window_dow(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_dow", value)

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @maintenance_window_time.setter
    def maintenance_window_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintenance_window_time", value)

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]:
        """
        Mysql user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @mysql_user_config.setter
    def mysql_user_config(self, value: Optional[pulumi.Input['ServiceMysqlUserConfigArgs']]):
        pulumi.set(self, "mysql_user_config", value)

    @property
    @pulumi.getter
    def mysqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMysqlArgs']]]]:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysqls")

    @mysqls.setter
    def mysqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceMysqlArgs']]]]):
        pulumi.set(self, "mysqls", value)

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]:
        """
        Opensearch user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @opensearch_user_config.setter
    def opensearch_user_config(self, value: Optional[pulumi.Input['ServiceOpensearchUserConfigArgs']]):
        pulumi.set(self, "opensearch_user_config", value)

    @property
    @pulumi.getter
    def opensearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOpensearchArgs']]]]:
        """
        Opensearch specific server provided values
        """
        return pulumi.get(self, "opensearches")

    @opensearches.setter
    def opensearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceOpensearchArgs']]]]):
        pulumi.set(self, "opensearches", value)

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> Optional[pulumi.Input['ServicePgUserConfigArgs']]:
        """
        Pg user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @pg_user_config.setter
    def pg_user_config(self, value: Optional[pulumi.Input['ServicePgUserConfigArgs']]):
        pulumi.set(self, "pg_user_config", value)

    @property
    @pulumi.getter
    def pgs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServicePgArgs']]]]:
        """
        PostgreSQL specific server provided values
        """
        return pulumi.get(self, "pgs")

    @pgs.setter
    def pgs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServicePgArgs']]]]):
        pulumi.set(self, "pgs", value)

    @property
    @pulumi.getter
    def plan(self) -> Optional[pulumi.Input[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @plan.setter
    def plan(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "plan", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @project_vpc_id.setter
    def project_vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_vpc_id", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRediArgs']]]]:
        """
        Redis specific server provided values
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceRediArgs']]]]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> Optional[pulumi.Input['ServiceRedisUserConfigArgs']]:
        """
        Redis user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @redis_user_config.setter
    def redis_user_config(self, value: Optional[pulumi.Input['ServiceRedisUserConfigArgs']]):
        pulumi.set(self, "redis_user_config", value)

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> Optional[pulumi.Input[str]]:
        """
        Service hostname
        """
        return pulumi.get(self, "service_host")

    @service_host.setter
    def service_host(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_host", value)

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @service_integrations.setter
    def service_integrations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ServiceServiceIntegrationArgs']]]]):
        pulumi.set(self, "service_integrations", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> Optional[pulumi.Input[str]]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @service_password.setter
    def service_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_password", value)

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> Optional[pulumi.Input[int]]:
        """
        Service port
        """
        return pulumi.get(self, "service_port")

    @service_port.setter
    def service_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_port", value)

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> Optional[pulumi.Input[str]]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @service_type.setter
    def service_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_type", value)

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @service_uri.setter
    def service_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_uri", value)

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> Optional[pulumi.Input[str]]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @service_username.setter
    def service_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_username", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` and `RUNNING`.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @static_ips.setter
    def static_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "static_ips", value)

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> Optional[pulumi.Input[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

    @termination_protection.setter
    def termination_protection(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "termination_protection", value)


class Service(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
                 clickhouse_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceClickhouseUserConfigArgs']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
                 flink_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceFlinkUserConfigArgs']]] = None,
                 flinks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceFlinkArgs']]]]] = None,
                 grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
                 influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
                 kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
                 opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
                 pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        The Service resource allows the creation and management of Aiven Services.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']] cassandra_user_config: Cassandra user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceClickhouseUserConfigArgs']] clickhouse_user_config: Clickhouse user configurable settings
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[str] disk_space: The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']] elasticsearch_user_config: Elasticsearch user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceFlinkUserConfigArgs']] flink_user_config: Flink user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceFlinkArgs']]]] flinks: Flink specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']] grafana_user_config: Grafana user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']] influxdb_user_config: Influxdb user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka*connect user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Kafka*mirrormaker user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']] kafka_user_config: Kafka user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]]] kafkas: Kafka specific server provided values
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']] mysql_user_config: Mysql user configurable settings
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']] opensearch_user_config: Opensearch user configurable settings
        :param pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']] pg_user_config: Pg user configurable settings
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']] redis_user_config: Redis user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The Service resource allows the creation and management of Aiven Services.

        :param str resource_name: The name of the resource.
        :param ServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
                 clickhouse_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceClickhouseUserConfigArgs']]] = None,
                 cloud_name: Optional[pulumi.Input[str]] = None,
                 disk_space: Optional[pulumi.Input[str]] = None,
                 elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
                 flink_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceFlinkUserConfigArgs']]] = None,
                 flinks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceFlinkArgs']]]]] = None,
                 grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
                 influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
                 kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
                 kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
                 kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
                 kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]]]] = None,
                 maintenance_window_dow: Optional[pulumi.Input[str]] = None,
                 maintenance_window_time: Optional[pulumi.Input[str]] = None,
                 mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
                 opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
                 pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
                 plan: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 project_vpc_id: Optional[pulumi.Input[str]] = None,
                 redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
                 service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 service_type: Optional[pulumi.Input[str]] = None,
                 static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 termination_protection: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceArgs.__new__(ServiceArgs)

            __props__.__dict__["cassandra_user_config"] = cassandra_user_config
            __props__.__dict__["clickhouse_user_config"] = clickhouse_user_config
            __props__.__dict__["cloud_name"] = cloud_name
            __props__.__dict__["disk_space"] = disk_space
            __props__.__dict__["elasticsearch_user_config"] = elasticsearch_user_config
            __props__.__dict__["flink_user_config"] = flink_user_config
            __props__.__dict__["flinks"] = flinks
            __props__.__dict__["grafana_user_config"] = grafana_user_config
            __props__.__dict__["influxdb_user_config"] = influxdb_user_config
            __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
            __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
            __props__.__dict__["kafka_user_config"] = kafka_user_config
            __props__.__dict__["kafkas"] = kafkas
            __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
            __props__.__dict__["maintenance_window_time"] = maintenance_window_time
            __props__.__dict__["mysql_user_config"] = mysql_user_config
            __props__.__dict__["opensearch_user_config"] = opensearch_user_config
            __props__.__dict__["pg_user_config"] = pg_user_config
            __props__.__dict__["plan"] = plan
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__.__dict__["project"] = project
            __props__.__dict__["project_vpc_id"] = project_vpc_id
            __props__.__dict__["redis_user_config"] = redis_user_config
            __props__.__dict__["service_integrations"] = service_integrations
            if service_name is None and not opts.urn:
                raise TypeError("Missing required property 'service_name'")
            __props__.__dict__["service_name"] = service_name
            if service_type is None and not opts.urn:
                raise TypeError("Missing required property 'service_type'")
            __props__.__dict__["service_type"] = service_type
            __props__.__dict__["static_ips"] = static_ips
            __props__.__dict__["termination_protection"] = termination_protection
            __props__.__dict__["cassandras"] = None
            __props__.__dict__["clickhouses"] = None
            __props__.__dict__["components"] = None
            __props__.__dict__["disk_space_cap"] = None
            __props__.__dict__["disk_space_default"] = None
            __props__.__dict__["disk_space_step"] = None
            __props__.__dict__["disk_space_used"] = None
            __props__.__dict__["elasticsearches"] = None
            __props__.__dict__["grafanas"] = None
            __props__.__dict__["influxdbs"] = None
            __props__.__dict__["kafka_connects"] = None
            __props__.__dict__["kafka_mirrormakers"] = None
            __props__.__dict__["mysqls"] = None
            __props__.__dict__["opensearches"] = None
            __props__.__dict__["pgs"] = None
            __props__.__dict__["redis"] = None
            __props__.__dict__["service_host"] = None
            __props__.__dict__["service_password"] = None
            __props__.__dict__["service_port"] = None
            __props__.__dict__["service_uri"] = None
            __props__.__dict__["service_username"] = None
            __props__.__dict__["state"] = None
        super(Service, __self__).__init__(
            'aiven:index/service:Service',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cassandra_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']]] = None,
            cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceCassandraArgs']]]]] = None,
            clickhouse_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceClickhouseUserConfigArgs']]] = None,
            clickhouses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceClickhouseArgs']]]]] = None,
            cloud_name: Optional[pulumi.Input[str]] = None,
            components: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComponentArgs']]]]] = None,
            disk_space: Optional[pulumi.Input[str]] = None,
            disk_space_cap: Optional[pulumi.Input[str]] = None,
            disk_space_default: Optional[pulumi.Input[str]] = None,
            disk_space_step: Optional[pulumi.Input[str]] = None,
            disk_space_used: Optional[pulumi.Input[str]] = None,
            elasticsearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']]] = None,
            elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']]]]] = None,
            flink_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceFlinkUserConfigArgs']]] = None,
            flinks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceFlinkArgs']]]]] = None,
            grafana_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']]] = None,
            grafanas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']]]]] = None,
            influxdb_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']]] = None,
            influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']]]]] = None,
            kafka_connect_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']]] = None,
            kafka_connects: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']]]]] = None,
            kafka_mirrormaker_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']]] = None,
            kafka_mirrormakers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']]]]] = None,
            kafka_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']]] = None,
            kafkas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]]]] = None,
            maintenance_window_dow: Optional[pulumi.Input[str]] = None,
            maintenance_window_time: Optional[pulumi.Input[str]] = None,
            mysql_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']]] = None,
            mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceMysqlArgs']]]]] = None,
            opensearch_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']]] = None,
            opensearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']]]]] = None,
            pg_user_config: Optional[pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']]] = None,
            pgs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePgArgs']]]]] = None,
            plan: Optional[pulumi.Input[str]] = None,
            project: Optional[pulumi.Input[str]] = None,
            project_vpc_id: Optional[pulumi.Input[str]] = None,
            redis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceRediArgs']]]]] = None,
            redis_user_config: Optional[pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']]] = None,
            service_host: Optional[pulumi.Input[str]] = None,
            service_integrations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            service_password: Optional[pulumi.Input[str]] = None,
            service_port: Optional[pulumi.Input[int]] = None,
            service_type: Optional[pulumi.Input[str]] = None,
            service_uri: Optional[pulumi.Input[str]] = None,
            service_username: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            static_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            termination_protection: Optional[pulumi.Input[bool]] = None) -> 'Service':
        """
        Get an existing Service resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServiceCassandraUserConfigArgs']] cassandra_user_config: Cassandra user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceCassandraArgs']]]] cassandras: Cassandra specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceClickhouseUserConfigArgs']] clickhouse_user_config: Clickhouse user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceClickhouseArgs']]]] clickhouses: Clickhouse specific server provided values
        :param pulumi.Input[str] cloud_name: Cloud the service runs in
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceComponentArgs']]]] components: Service component information objects
        :param pulumi.Input[str] disk_space: The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        :param pulumi.Input[str] disk_space_cap: The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        :param pulumi.Input[str] disk_space_default: The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        :param pulumi.Input[str] disk_space_step: The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        :param pulumi.Input[str] disk_space_used: Disk space that service is currently using
        :param pulumi.Input[pulumi.InputType['ServiceElasticsearchUserConfigArgs']] elasticsearch_user_config: Elasticsearch user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceElasticsearchArgs']]]] elasticsearches: Elasticsearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceFlinkUserConfigArgs']] flink_user_config: Flink user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceFlinkArgs']]]] flinks: Flink specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceGrafanaUserConfigArgs']] grafana_user_config: Grafana user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceGrafanaArgs']]]] grafanas: Grafana specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceInfluxdbUserConfigArgs']] influxdb_user_config: Influxdb user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceInfluxdbArgs']]]] influxdbs: InfluxDB specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaConnectUserConfigArgs']] kafka_connect_user_config: Kafka*connect user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaConnectArgs']]]] kafka_connects: Kafka Connect specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerUserConfigArgs']] kafka_mirrormaker_user_config: Kafka*mirrormaker user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaMirrormakerArgs']]]] kafka_mirrormakers: Kafka MirrorMaker 2 specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceKafkaUserConfigArgs']] kafka_user_config: Kafka user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceKafkaArgs']]]] kafkas: Kafka specific server provided values
        :param pulumi.Input[str] maintenance_window_dow: Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        :param pulumi.Input[str] maintenance_window_time: Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        :param pulumi.Input[pulumi.InputType['ServiceMysqlUserConfigArgs']] mysql_user_config: Mysql user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceMysqlArgs']]]] mysqls: MySQL specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceOpensearchUserConfigArgs']] opensearch_user_config: Opensearch user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceOpensearchArgs']]]] opensearches: Opensearch specific server provided values
        :param pulumi.Input[pulumi.InputType['ServicePgUserConfigArgs']] pg_user_config: Pg user configurable settings
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServicePgArgs']]]] pgs: PostgreSQL specific server provided values
        :param pulumi.Input[str] plan: Subscription plan
        :param pulumi.Input[str] project: Target project
        :param pulumi.Input[str] project_vpc_id: Identifier of the VPC the service should be in, if any
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceRediArgs']]]] redis: Redis specific server provided values
        :param pulumi.Input[pulumi.InputType['ServiceRedisUserConfigArgs']] redis_user_config: Redis user configurable settings
        :param pulumi.Input[str] service_host: Service hostname
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ServiceServiceIntegrationArgs']]]] service_integrations: Service integrations to specify when creating a service. Not applied after initial service creation
        :param pulumi.Input[str] service_name: Service name
        :param pulumi.Input[str] service_password: Password used for connecting to the service, if applicable
        :param pulumi.Input[int] service_port: Service port
        :param pulumi.Input[str] service_type: Service type code
        :param pulumi.Input[str] service_uri: URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        :param pulumi.Input[str] service_username: Username used for connecting to the service, if applicable
        :param pulumi.Input[str] state: Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` and `RUNNING`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] static_ips: Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        :param pulumi.Input[bool] termination_protection: Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceState.__new__(_ServiceState)

        __props__.__dict__["cassandra_user_config"] = cassandra_user_config
        __props__.__dict__["cassandras"] = cassandras
        __props__.__dict__["clickhouse_user_config"] = clickhouse_user_config
        __props__.__dict__["clickhouses"] = clickhouses
        __props__.__dict__["cloud_name"] = cloud_name
        __props__.__dict__["components"] = components
        __props__.__dict__["disk_space"] = disk_space
        __props__.__dict__["disk_space_cap"] = disk_space_cap
        __props__.__dict__["disk_space_default"] = disk_space_default
        __props__.__dict__["disk_space_step"] = disk_space_step
        __props__.__dict__["disk_space_used"] = disk_space_used
        __props__.__dict__["elasticsearch_user_config"] = elasticsearch_user_config
        __props__.__dict__["elasticsearches"] = elasticsearches
        __props__.__dict__["flink_user_config"] = flink_user_config
        __props__.__dict__["flinks"] = flinks
        __props__.__dict__["grafana_user_config"] = grafana_user_config
        __props__.__dict__["grafanas"] = grafanas
        __props__.__dict__["influxdb_user_config"] = influxdb_user_config
        __props__.__dict__["influxdbs"] = influxdbs
        __props__.__dict__["kafka_connect_user_config"] = kafka_connect_user_config
        __props__.__dict__["kafka_connects"] = kafka_connects
        __props__.__dict__["kafka_mirrormaker_user_config"] = kafka_mirrormaker_user_config
        __props__.__dict__["kafka_mirrormakers"] = kafka_mirrormakers
        __props__.__dict__["kafka_user_config"] = kafka_user_config
        __props__.__dict__["kafkas"] = kafkas
        __props__.__dict__["maintenance_window_dow"] = maintenance_window_dow
        __props__.__dict__["maintenance_window_time"] = maintenance_window_time
        __props__.__dict__["mysql_user_config"] = mysql_user_config
        __props__.__dict__["mysqls"] = mysqls
        __props__.__dict__["opensearch_user_config"] = opensearch_user_config
        __props__.__dict__["opensearches"] = opensearches
        __props__.__dict__["pg_user_config"] = pg_user_config
        __props__.__dict__["pgs"] = pgs
        __props__.__dict__["plan"] = plan
        __props__.__dict__["project"] = project
        __props__.__dict__["project_vpc_id"] = project_vpc_id
        __props__.__dict__["redis"] = redis
        __props__.__dict__["redis_user_config"] = redis_user_config
        __props__.__dict__["service_host"] = service_host
        __props__.__dict__["service_integrations"] = service_integrations
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["service_password"] = service_password
        __props__.__dict__["service_port"] = service_port
        __props__.__dict__["service_type"] = service_type
        __props__.__dict__["service_uri"] = service_uri
        __props__.__dict__["service_username"] = service_username
        __props__.__dict__["state"] = state
        __props__.__dict__["static_ips"] = static_ips
        __props__.__dict__["termination_protection"] = termination_protection
        return Service(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="cassandraUserConfig")
    def cassandra_user_config(self) -> pulumi.Output[Optional['outputs.ServiceCassandraUserConfig']]:
        """
        Cassandra user configurable settings
        """
        return pulumi.get(self, "cassandra_user_config")

    @property
    @pulumi.getter
    def cassandras(self) -> pulumi.Output[Sequence['outputs.ServiceCassandra']]:
        """
        Cassandra specific server provided values
        """
        return pulumi.get(self, "cassandras")

    @property
    @pulumi.getter(name="clickhouseUserConfig")
    def clickhouse_user_config(self) -> pulumi.Output[Optional['outputs.ServiceClickhouseUserConfig']]:
        """
        Clickhouse user configurable settings
        """
        return pulumi.get(self, "clickhouse_user_config")

    @property
    @pulumi.getter
    def clickhouses(self) -> pulumi.Output[Sequence['outputs.ServiceClickhouse']]:
        """
        Clickhouse specific server provided values
        """
        return pulumi.get(self, "clickhouses")

    @property
    @pulumi.getter(name="cloudName")
    def cloud_name(self) -> pulumi.Output[Optional[str]]:
        """
        Cloud the service runs in
        """
        return pulumi.get(self, "cloud_name")

    @property
    @pulumi.getter
    def components(self) -> pulumi.Output[Sequence['outputs.ServiceComponent']]:
        """
        Service component information objects
        """
        return pulumi.get(self, "components")

    @property
    @pulumi.getter(name="diskSpace")
    def disk_space(self) -> pulumi.Output[Optional[str]]:
        """
        The disk space of the service, possible values depend on the service type, the cloud provider and the project. Reducing will result in the service rebalancing.
        """
        return pulumi.get(self, "disk_space")

    @property
    @pulumi.getter(name="diskSpaceCap")
    def disk_space_cap(self) -> pulumi.Output[str]:
        """
        The maximum disk space of the service, possible values depend on the service type, the cloud provider and the project.
        """
        return pulumi.get(self, "disk_space_cap")

    @property
    @pulumi.getter(name="diskSpaceDefault")
    def disk_space_default(self) -> pulumi.Output[str]:
        """
        The default disk space of the service, possible values depend on the service type, the cloud provider and the project. Its also the minimum value for `disk_space`
        """
        return pulumi.get(self, "disk_space_default")

    @property
    @pulumi.getter(name="diskSpaceStep")
    def disk_space_step(self) -> pulumi.Output[str]:
        """
        The default disk space step of the service, possible values depend on the service type, the cloud provider and the project. `disk_space` needs to increment from `disk_space_default` by increments of this size.
        """
        return pulumi.get(self, "disk_space_step")

    @property
    @pulumi.getter(name="diskSpaceUsed")
    def disk_space_used(self) -> pulumi.Output[str]:
        """
        Disk space that service is currently using
        """
        return pulumi.get(self, "disk_space_used")

    @property
    @pulumi.getter(name="elasticsearchUserConfig")
    def elasticsearch_user_config(self) -> pulumi.Output[Optional['outputs.ServiceElasticsearchUserConfig']]:
        """
        Elasticsearch user configurable settings
        """
        return pulumi.get(self, "elasticsearch_user_config")

    @property
    @pulumi.getter
    def elasticsearches(self) -> pulumi.Output[Sequence['outputs.ServiceElasticsearch']]:
        """
        Elasticsearch specific server provided values
        """
        return pulumi.get(self, "elasticsearches")

    @property
    @pulumi.getter(name="flinkUserConfig")
    def flink_user_config(self) -> pulumi.Output[Optional['outputs.ServiceFlinkUserConfig']]:
        """
        Flink user configurable settings
        """
        return pulumi.get(self, "flink_user_config")

    @property
    @pulumi.getter
    def flinks(self) -> pulumi.Output[Sequence['outputs.ServiceFlink']]:
        """
        Flink specific server provided values
        """
        return pulumi.get(self, "flinks")

    @property
    @pulumi.getter(name="grafanaUserConfig")
    def grafana_user_config(self) -> pulumi.Output[Optional['outputs.ServiceGrafanaUserConfig']]:
        """
        Grafana user configurable settings
        """
        return pulumi.get(self, "grafana_user_config")

    @property
    @pulumi.getter
    def grafanas(self) -> pulumi.Output[Sequence['outputs.ServiceGrafana']]:
        """
        Grafana specific server provided values
        """
        return pulumi.get(self, "grafanas")

    @property
    @pulumi.getter(name="influxdbUserConfig")
    def influxdb_user_config(self) -> pulumi.Output[Optional['outputs.ServiceInfluxdbUserConfig']]:
        """
        Influxdb user configurable settings
        """
        return pulumi.get(self, "influxdb_user_config")

    @property
    @pulumi.getter
    def influxdbs(self) -> pulumi.Output[Sequence['outputs.ServiceInfluxdb']]:
        """
        InfluxDB specific server provided values
        """
        return pulumi.get(self, "influxdbs")

    @property
    @pulumi.getter(name="kafkaConnectUserConfig")
    def kafka_connect_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaConnectUserConfig']]:
        """
        Kafka*connect user configurable settings
        """
        return pulumi.get(self, "kafka_connect_user_config")

    @property
    @pulumi.getter(name="kafkaConnects")
    def kafka_connects(self) -> pulumi.Output[Sequence['outputs.ServiceKafkaConnect']]:
        """
        Kafka Connect specific server provided values
        """
        return pulumi.get(self, "kafka_connects")

    @property
    @pulumi.getter(name="kafkaMirrormakerUserConfig")
    def kafka_mirrormaker_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaMirrormakerUserConfig']]:
        """
        Kafka*mirrormaker user configurable settings
        """
        return pulumi.get(self, "kafka_mirrormaker_user_config")

    @property
    @pulumi.getter(name="kafkaMirrormakers")
    def kafka_mirrormakers(self) -> pulumi.Output[Sequence['outputs.ServiceKafkaMirrormaker']]:
        """
        Kafka MirrorMaker 2 specific server provided values
        """
        return pulumi.get(self, "kafka_mirrormakers")

    @property
    @pulumi.getter(name="kafkaUserConfig")
    def kafka_user_config(self) -> pulumi.Output[Optional['outputs.ServiceKafkaUserConfig']]:
        """
        Kafka user configurable settings
        """
        return pulumi.get(self, "kafka_user_config")

    @property
    @pulumi.getter
    def kafkas(self) -> pulumi.Output[Sequence['outputs.ServiceKafka']]:
        """
        Kafka specific server provided values
        """
        return pulumi.get(self, "kafkas")

    @property
    @pulumi.getter(name="maintenanceWindowDow")
    def maintenance_window_dow(self) -> pulumi.Output[Optional[str]]:
        """
        Day of week when maintenance operations should be performed. One monday, tuesday, wednesday, etc.
        """
        return pulumi.get(self, "maintenance_window_dow")

    @property
    @pulumi.getter(name="maintenanceWindowTime")
    def maintenance_window_time(self) -> pulumi.Output[Optional[str]]:
        """
        Time of day when maintenance operations should be performed. UTC time in HH:mm:ss format.
        """
        return pulumi.get(self, "maintenance_window_time")

    @property
    @pulumi.getter(name="mysqlUserConfig")
    def mysql_user_config(self) -> pulumi.Output[Optional['outputs.ServiceMysqlUserConfig']]:
        """
        Mysql user configurable settings
        """
        return pulumi.get(self, "mysql_user_config")

    @property
    @pulumi.getter
    def mysqls(self) -> pulumi.Output[Sequence['outputs.ServiceMysql']]:
        """
        MySQL specific server provided values
        """
        return pulumi.get(self, "mysqls")

    @property
    @pulumi.getter(name="opensearchUserConfig")
    def opensearch_user_config(self) -> pulumi.Output[Optional['outputs.ServiceOpensearchUserConfig']]:
        """
        Opensearch user configurable settings
        """
        return pulumi.get(self, "opensearch_user_config")

    @property
    @pulumi.getter
    def opensearches(self) -> pulumi.Output[Sequence['outputs.ServiceOpensearch']]:
        """
        Opensearch specific server provided values
        """
        return pulumi.get(self, "opensearches")

    @property
    @pulumi.getter(name="pgUserConfig")
    def pg_user_config(self) -> pulumi.Output[Optional['outputs.ServicePgUserConfig']]:
        """
        Pg user configurable settings
        """
        return pulumi.get(self, "pg_user_config")

    @property
    @pulumi.getter
    def pgs(self) -> pulumi.Output[Sequence['outputs.ServicePg']]:
        """
        PostgreSQL specific server provided values
        """
        return pulumi.get(self, "pgs")

    @property
    @pulumi.getter
    def plan(self) -> pulumi.Output[Optional[str]]:
        """
        Subscription plan
        """
        return pulumi.get(self, "plan")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        """
        Target project
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="projectVpcId")
    def project_vpc_id(self) -> pulumi.Output[Optional[str]]:
        """
        Identifier of the VPC the service should be in, if any
        """
        return pulumi.get(self, "project_vpc_id")

    @property
    @pulumi.getter
    def redis(self) -> pulumi.Output[Sequence['outputs.ServiceRedi']]:
        """
        Redis specific server provided values
        """
        return pulumi.get(self, "redis")

    @property
    @pulumi.getter(name="redisUserConfig")
    def redis_user_config(self) -> pulumi.Output[Optional['outputs.ServiceRedisUserConfig']]:
        """
        Redis user configurable settings
        """
        return pulumi.get(self, "redis_user_config")

    @property
    @pulumi.getter(name="serviceHost")
    def service_host(self) -> pulumi.Output[str]:
        """
        Service hostname
        """
        return pulumi.get(self, "service_host")

    @property
    @pulumi.getter(name="serviceIntegrations")
    def service_integrations(self) -> pulumi.Output[Optional[Sequence['outputs.ServiceServiceIntegration']]]:
        """
        Service integrations to specify when creating a service. Not applied after initial service creation
        """
        return pulumi.get(self, "service_integrations")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Service name
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter(name="servicePassword")
    def service_password(self) -> pulumi.Output[str]:
        """
        Password used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_password")

    @property
    @pulumi.getter(name="servicePort")
    def service_port(self) -> pulumi.Output[int]:
        """
        Service port
        """
        return pulumi.get(self, "service_port")

    @property
    @pulumi.getter(name="serviceType")
    def service_type(self) -> pulumi.Output[str]:
        """
        Service type code
        """
        return pulumi.get(self, "service_type")

    @property
    @pulumi.getter(name="serviceUri")
    def service_uri(self) -> pulumi.Output[str]:
        """
        URI for connecting to the service. Service specific info is under "kafka", "pg", etc.
        """
        return pulumi.get(self, "service_uri")

    @property
    @pulumi.getter(name="serviceUsername")
    def service_username(self) -> pulumi.Output[str]:
        """
        Username used for connecting to the service, if applicable
        """
        return pulumi.get(self, "service_username")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Service state. One of `POWEROFF`, `REBALANCING`, `REBUILDING` and `RUNNING`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="staticIps")
    def static_ips(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Static IPs that are going to be associated with this service. Please assign a value using the 'toset' function. Once a static ip resource is in the 'assigned' state it cannot be unbound from the node again
        """
        return pulumi.get(self, "static_ips")

    @property
    @pulumi.getter(name="terminationProtection")
    def termination_protection(self) -> pulumi.Output[Optional[bool]]:
        """
        Prevent service from being deleted. It is recommended to have this enabled for all services.
        """
        return pulumi.get(self, "termination_protection")

