# Getting Started with AutoTrader


## Installation

AutoTrader can be installed in two ways; through [PyPI](https://pypi.org/) or by cloning the repository directly.

### PyPI Install
The easiest way to get AutoTrader is by running the following command. It is recommended method of installation.

```
pip install autotrader
```

### Clone from GitHub
If you are interested in developing AutoTrader, or would like to view the source code while you work, cloning from 
GitHub is the way to get AutoTrader. In this method, clone the [Github repository](https://github.com/kieran-mackle/AutoTrader) 
onto your machine and run the `setup.py` file to install.

```
git clone https://github.com/kieran-mackle/AutoTrader
cd AutoTrader
python3 -m pip install ./
```

```{tip}
If you plan on developing AutoTrader, you can also perform an [editable install](https://www.python.org/dev/peps/pep-0660/) to avoid re-installing the source code each time you make a change.
```



### Demo Repository
To make getting started with AutoTrader even easier, download the demo repository from
[here](https://github.com/kieran-mackle/autotrader-demo). This repo contains example strategies, config files, 
run files and everything else you might need.

```
git clone https://github.com/kieran-mackle/autotrader-demo/ 
```
