"""add attribute tables

Revision ID: 1583f2de9f39
Revises: 9495d7cb31ec
Create Date: 2021-09-23 20:27:24.421568

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '1583f2de9f39'
down_revision = '9495d7cb31ec'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('attribute_boolean',
    sa.Column('attribute_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('value', sa.Boolean(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=False),
    sa.Column('field_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['field_id'], ['field.field_id'], name=op.f('fk_attribute_boolean_field_id_field')),
    sa.ForeignKeyConstraint(['product_id'], ['products.product_id'], name=op.f('fk_attribute_boolean_product_id_products')),
    sa.PrimaryKeyConstraint('attribute_id', name=op.f('pk_attribute_boolean'))
    )
    op.create_table('attribute_float',
    sa.Column('attribute_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('value', sa.Float(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=False),
    sa.Column('field_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['field_id'], ['field.field_id'], name=op.f('fk_attribute_float_field_id_field')),
    sa.ForeignKeyConstraint(['product_id'], ['products.product_id'], name=op.f('fk_attribute_float_product_id_products')),
    sa.PrimaryKeyConstraint('attribute_id', name=op.f('pk_attribute_float'))
    )
    op.create_table('attribute_integer',
    sa.Column('attribute_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('value', sa.Integer(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=False),
    sa.Column('field_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['field_id'], ['field.field_id'], name=op.f('fk_attribute_integer_field_id_field')),
    sa.ForeignKeyConstraint(['product_id'], ['products.product_id'], name=op.f('fk_attribute_integer_product_id_products')),
    sa.PrimaryKeyConstraint('attribute_id', name=op.f('pk_attribute_integer'))
    )
    op.create_table('attribute_time',
    sa.Column('attribute_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=True),
    sa.Column('value', sa.Time(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=False),
    sa.Column('field_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['field_id'], ['field.field_id'], name=op.f('fk_attribute_time_field_id_field')),
    sa.ForeignKeyConstraint(['product_id'], ['products.product_id'], name=op.f('fk_attribute_time_product_id_products')),
    sa.PrimaryKeyConstraint('attribute_id', name=op.f('pk_attribute_time'))
    )
    with op.batch_alter_table('attribute_date', schema=None) as batch_op:
        batch_op.add_column(sa.Column('field_id', sa.Integer(), nullable=True))
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=True)
        batch_op.create_foreign_key(batch_op.f('fk_attribute_date_field_id_field'), 'field', ['field_id'], ['field_id'])

    with op.batch_alter_table('attribute_date_time', schema=None) as batch_op:
        batch_op.add_column(sa.Column('field_id', sa.Integer(), nullable=True))
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=True)
        batch_op.create_foreign_key(batch_op.f('fk_attribute_date_time_field_id_field'), 'field', ['field_id'], ['field_id'])

    with op.batch_alter_table('attribute_unicode_text', schema=None) as batch_op:
        batch_op.add_column(sa.Column('field_id', sa.Integer(), nullable=True))
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=True)
        batch_op.create_foreign_key(batch_op.f('fk_attribute_unicode_text_field_id_field'), 'field', ['field_id'], ['field_id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('attribute_unicode_text', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_unicode_text_field_id_field'), type_='foreignkey')
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.drop_column('field_id')

    with op.batch_alter_table('attribute_date_time', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_date_time_field_id_field'), type_='foreignkey')
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.drop_column('field_id')

    with op.batch_alter_table('attribute_date', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_attribute_date_field_id_field'), type_='foreignkey')
        batch_op.alter_column('name',
               existing_type=sa.TEXT(),
               nullable=False)
        batch_op.drop_column('field_id')

    op.drop_table('attribute_time')
    op.drop_table('attribute_integer')
    op.drop_table('attribute_float')
    op.drop_table('attribute_boolean')
    # ### end Alembic commands ###
