"""add tables github_

Revision ID: 3f6526e7e5ff
Revises: d5e539d43045
Create Date: 2020-12-17 11:24:16.122319

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '3f6526e7e5ff'
down_revision = 'd5e539d43045'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('github_accepted_orgs',
    sa.Column('org_id', sa.Integer(), nullable=False),
    sa.Column('login', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('org_id')
    )
    op.create_table('github_users',
    sa.Column('user_id', sa.Integer(), nullable=False),
    sa.Column('login', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('user_id')
    )
    op.create_table('github_org_memberships',
    sa.Column('entry_id', sa.Integer(), nullable=False),
    sa.Column('org_id', sa.Integer(), nullable=False),
    sa.Column('member_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['member_id'], ['github_users.user_id'], ),
    sa.ForeignKeyConstraint(['org_id'], ['github_accepted_orgs.org_id'], ),
    sa.PrimaryKeyConstraint('entry_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('github_org_memberships')
    op.drop_table('github_users')
    op.drop_table('github_accepted_orgs')
    # ### end Alembic commands ###
