"""add a field "git_hub_id" to github_users

Revision ID: 9f22f713c4ea
Revises: 2b15f740eed9
Create Date: 2021-01-04 15:12:40.931081

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '9f22f713c4ea'
down_revision = '2b15f740eed9'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('github_users', schema=None) as batch_op:
        batch_op.add_column(sa.Column('git_hub_id', sa.Text(), nullable=False))
        batch_op.create_unique_constraint(batch_op.f('uq_github_users_git_hub_id'), ['git_hub_id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('github_users', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('uq_github_users_git_hub_id'), type_='unique')
        batch_op.drop_column('git_hub_id')

    # ### end Alembic commands ###
