"""add fields to products

Revision ID: babb78f6f6b3
Revises: c090bba0e451
Create Date: 2021-02-25 13:30:06.303180

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'babb78f6f6b3'
down_revision = 'c090bba0e451'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('products', schema=None) as batch_op:
        batch_op.add_column(sa.Column('posting_git_hub_user_id', sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column('updating_git_hub_user_id', sa.Integer(), nullable=True))
        batch_op.create_foreign_key(batch_op.f('fk_products_posting_git_hub_user_id_github_users'), 'github_users', ['posting_git_hub_user_id'], ['user_id'])
        batch_op.create_foreign_key(batch_op.f('fk_products_updating_git_hub_user_id_github_users'), 'github_users', ['updating_git_hub_user_id'], ['user_id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('products', schema=None) as batch_op:
        batch_op.drop_constraint(batch_op.f('fk_products_updating_git_hub_user_id_github_users'), type_='foreignkey')
        batch_op.drop_constraint(batch_op.f('fk_products_posting_git_hub_user_id_github_users'), type_='foreignkey')
        batch_op.drop_column('updating_git_hub_user_id')
        batch_op.drop_column('posting_git_hub_user_id')

    # ### end Alembic commands ###
