"""re-initialize migration

Revision ID: cc64c8ef2115
Revises: 
Create Date: 2020-05-20 19:58:21.088239

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'cc64c8ef2115'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('product_relation_types',
    sa.Column('type_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('type_id')
    )
    op.create_index(op.f('ix_product_relation_types_name'), 'product_relation_types', ['name'], unique=True)
    op.create_table('product_types',
    sa.Column('type_id', sa.Integer(), nullable=False),
    sa.Column('name', sa.Text(), nullable=False),
    sa.PrimaryKeyConstraint('type_id')
    )
    op.create_index(op.f('ix_product_types_name'), 'product_types', ['name'], unique=True)
    op.create_table('products',
    sa.Column('product_id', sa.Integer(), nullable=False),
    sa.Column('type_id', sa.Integer(), nullable=True),
    sa.Column('name', sa.Text(), nullable=False),
    sa.Column('contact', sa.Text(), nullable=True),
    sa.Column('date_produced', sa.Date(), nullable=True),
    sa.Column('produced_by', sa.Text(), nullable=True),
    sa.Column('date_posted', sa.Date(), nullable=True),
    sa.Column('posted_by', sa.Text(), nullable=True),
    sa.Column('date_updated', sa.Date(), nullable=True),
    sa.Column('updated_by', sa.Text(), nullable=True),
    sa.Column('note', sa.Text(), nullable=True),
    sa.ForeignKeyConstraint(['type_id'], ['product_types.type_id'], ),
    sa.PrimaryKeyConstraint('product_id'),
    sa.UniqueConstraint('type_id', 'name', name='_type_id_name')
    )
    op.create_table('product_file_paths',
    sa.Column('path_id', sa.Integer(), nullable=False),
    sa.Column('path', sa.Text(), nullable=True),
    sa.Column('note', sa.Text(), nullable=True),
    sa.Column('product_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['product_id'], ['products.product_id'], ),
    sa.PrimaryKeyConstraint('path_id')
    )
    op.create_table('product_relations',
    sa.Column('relation_id', sa.Integer(), nullable=False),
    sa.Column('type_id', sa.Integer(), nullable=True),
    sa.Column('self_product_id', sa.Integer(), nullable=True),
    sa.Column('other_product_id', sa.Integer(), nullable=True),
    sa.Column('reverse_relation_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['other_product_id'], ['products.product_id'], ),
    sa.ForeignKeyConstraint(['reverse_relation_id'], ['product_relations.relation_id'], ),
    sa.ForeignKeyConstraint(['self_product_id'], ['products.product_id'], ),
    sa.ForeignKeyConstraint(['type_id'], ['product_relation_types.type_id'], ),
    sa.PrimaryKeyConstraint('relation_id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('product_relations')
    op.drop_table('product_file_paths')
    op.drop_table('products')
    op.drop_index(op.f('ix_product_types_name'), table_name='product_types')
    op.drop_table('product_types')
    op.drop_index(op.f('ix_product_relation_types_name'), table_name='product_relation_types')
    op.drop_table('product_relation_types')
    # ### end Alembic commands ###
