"""GraphQL queries as strings

"""

from .fragments import (  # noqa: F401
    FRAGMENT_FIELD,
    FRAGMENT_FIELD_CONNECTION,
    FRAGMENT_PRODUCT,
    FRAGMENT_PRODUCT_SHALLOW,
    FRAGMENT_PRODUCT_CONNECTION,
    FRAGMENT_PRODUCT_CONNECTION_SHALLOW,
    FRAGMENT_PRODUCT_RELATION_TYPE,
    FRAGMENT_PRODUCT_RELATION_TYPE_CONNECTION,
    FRAGMENT_PRODUCT_RELATION,
    FRAGMENT_PRODUCT_RELATION_CONNECTION,
    FRAGMENT_PRODUCT_TYPE,
    FRAGMENT_PRODUCT_TYPE_CONNECTION,
)

from .queries import (  # noqa: F401
    QUERY_ALL_FIELDS,
    QUERY_ALL_PRODUCTS,
    QUERY_ALL_PRODUCTS_SHALLOW,
    QUERY_ALL_PRODUCTS_TOTAL_COUNT,
    QUERY_ALL_PRODUCT_FILE_PATHS,
    QUERY_ALL_PRODUCT_RELATIONS,
    QUERY_ALL_PRODUCT_RELATIONS_TOTAL_COUNT,
    QUERY_ALL_PRODUCT_RELATION_TYPES,
    QUERY_ALL_PRODUCT_RELATION_TYPES_TOTAL_COUNT,
    QUERY_ALL_PRODUCT_TYPES,
    QUERY_FIELD,
    QUERY_PRODUCT,
    QUERY_PRODUCT_SHALLOW,
    QUERY_PRODUCT_RELATION,
    QUERY_PRODUCT_RELATION_TYPE,
    QUERY_PRODUCT_TYPE,
)

from .mutations import (  # noqa: F401
    MUTATION_CREATE_PRODUCT,
    MUTATION_DELETE_PRODUCT,
    MUTATION_UPDATE_PRODUCT,
    MUTATION_CREATE_PRODUCT_RELATION_TYPES,
    MUTATION_UPDATE_PRODUCT_RELATION_TYPE,
    MUTATION_DELETE_PRODUCT_RELATION_TYPES,
    MUTATION_CREATE_PRODUCT_RELATION,
    MUTATION_DELETE_PRODUCT_RELATION,
    MUTATION_CREATE_PRODUCT_TYPE,
    MUTATION_UPDATE_PRODUCT_TYPE,
    MUTATION_DELETE_PRODUCT_TYPE,
    MUTATION_CREATE_FIELD,
    MUTATION_UPDATE_FIELD,
    MUTATION_DELETE_FIELD,
)
