"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Instance = exports.InstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "InstanceProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosInstance; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::Instance`
 */
class Instance extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::Instance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosInstance = new apigateway_generated_1.RosInstance(this, id, {
            instanceName: props.instanceName,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            instanceSpec: props.instanceSpec,
            httpsPolicy: props.httpsPolicy,
            zoneId: props.zoneId,
            pricingCycle: props.pricingCycle,
            chargeType: props.chargeType === undefined || props.chargeType === null ? 'PostPaid' : props.chargeType,
            duration: props.duration,
            autoPay: props.autoPay,
            tags: props.tags,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosInstance;
        this.attrEgressIpv6Enable = rosInstance.attrEgressIpv6Enable;
        this.attrInstanceId = rosInstance.attrInstanceId;
        this.attrInstanceType = rosInstance.attrInstanceType;
        this.attrInternetEgressAddress = rosInstance.attrInternetEgressAddress;
        this.attrSupportIpv6 = rosInstance.attrSupportIpv6;
        this.attrVpcEgressAddress = rosInstance.attrVpcEgressAddress;
        this.attrVpcIntranetEnable = rosInstance.attrVpcIntranetEnable;
        this.attrVpcSlbIntranetEnable = rosInstance.attrVpcSlbIntranetEnable;
    }
}
exports.Instance = Instance;
//# sourceMappingURL=data:application/json;base64,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