"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PluginAttachment = exports.PluginAttachmentProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const apigateway_generated_1 = require("./apigateway.generated");
Object.defineProperty(exports, "PluginAttachmentProperty", { enumerable: true, get: function () { return apigateway_generated_1.RosPluginAttachment; } });
/**
 * A ROS resource type:  `ALIYUN::ApiGateway::PluginAttachment`
 */
class PluginAttachment extends ros.Resource {
    /**
     * Create a new `ALIYUN::ApiGateway::PluginAttachment`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPluginAttachment = new apigateway_generated_1.RosPluginAttachment(this, id, {
            stageName: props.stageName,
            pluginId: props.pluginId,
            apiId: props.apiId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPluginAttachment;
        this.attrApiId = rosPluginAttachment.attrApiId;
        this.attrPluginId = rosPluginAttachment.attrPluginId;
    }
}
exports.PluginAttachment = PluginAttachment;
//# sourceMappingURL=data:application/json;base64,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