"use strict";
const assert_1 = require("@aws-cdk/assert");
const cdk = require("@aws-cdk/core");
const lib_1 = require("../lib");
module.exports = {
    'Hosted Zone Provider': {
        'HostedZoneProvider will return context values if available'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '12345', region: 'us-east-1' },
            });
            const filter = { domainName: 'test.com' };
            lib_1.HostedZone.fromLookup(stack, 'Ref', filter);
            const missing = assert_1.SynthUtils.synthesize(stack).assembly.manifest.missing;
            test.ok(missing && missing.length === 1);
            const fakeZoneId = '11111111111111';
            const fakeZone = {
                Id: `/hostedzone/${fakeZoneId}`,
                Name: 'example.com.',
                CallerReference: 'TestLates-PublicZo-OESZPDFV7G6A',
                Config: {
                    Comment: 'CDK created',
                    PrivateZone: false,
                },
                ResourceRecordSetCount: 3,
            };
            const stack2 = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '12345', region: 'us-east-1' },
            });
            stack2.node.setContext(missing[0].key, fakeZone);
            // WHEN
            const zoneRef = lib_1.HostedZone.fromLookup(stack2, 'MyZoneProvider', filter);
            // THEN
            test.deepEqual(zoneRef.hostedZoneId, fakeZoneId);
            test.done();
        },
        'HostedZoneProvider will return context values if available when using plain hosted zone id'(test) {
            // GIVEN
            const stack = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '12345', region: 'us-east-1' },
            });
            const filter = { domainName: 'test.com' };
            lib_1.HostedZone.fromLookup(stack, 'Ref', filter);
            const missing = assert_1.SynthUtils.synthesize(stack).assembly.manifest.missing;
            test.ok(missing && missing.length === 1);
            const fakeZoneId = '11111111111111';
            const fakeZone = {
                Id: `/hostedzone/${fakeZoneId}`,
                Name: 'example.com.',
                CallerReference: 'TestLates-PublicZo-OESZPDFV7G6A',
                Config: {
                    Comment: 'CDK created',
                    PrivateZone: false,
                },
                ResourceRecordSetCount: 3,
            };
            const stack2 = new cdk.Stack(undefined, 'TestStack', {
                env: { account: '12345', region: 'us-east-1' },
            });
            stack2.node.setContext(missing[0].key, fakeZone);
            const zone = lib_1.HostedZone.fromLookup(stack2, 'MyZoneProvider', filter);
            // WHEN
            const zoneId = zone.hostedZoneId;
            // THEN
            test.deepEqual(fakeZoneId, zoneId);
            test.done();
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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