"use strict";
const cdk = require("@aws-cdk/core");
const util = require("../lib/util");
module.exports = {
    'throws when zone name ending with a \'.\''(test) {
        test.throws(() => util.validateZoneName('zone.name.'), /trailing dot/);
        test.done();
    },
    'accepts a valid domain name'(test) {
        const domainName = 'amazonaws.com';
        util.validateZoneName(domainName);
        test.done();
    },
    'providedName ending with a dot returns the name'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com.';
        const qualified = util.determineFullyQualifiedDomainName(providedName, {
            hostedZoneId: 'fakeId',
            zoneName: 'ignored',
            hostedZoneArn: 'arn:aws:route53:::hostedzone/fakeId',
            stack,
            node: stack.node,
        });
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that matches zoneName returns providedName with a trailing dot'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com';
        const qualified = util.determineFullyQualifiedDomainName(providedName, {
            hostedZoneId: 'fakeId',
            zoneName: 'test.domain.com.',
            hostedZoneArn: 'arn:aws:route53:::hostedzone/fakeId',
            stack,
            node: stack.node,
        });
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that ends with zoneName returns providedName with a trailing dot'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test.domain.com';
        const qualified = util.determineFullyQualifiedDomainName(providedName, {
            hostedZoneId: 'fakeId',
            zoneName: 'domain.com.',
            hostedZoneArn: 'arn:aws:route53:::hostedzone/fakeId',
            stack,
            node: stack.node,
        });
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
    'providedName that does not match zoneName concatenates providedName and zoneName'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const providedName = 'test';
        const qualified = util.determineFullyQualifiedDomainName(providedName, {
            hostedZoneId: 'fakeId',
            zoneName: 'domain.com.',
            hostedZoneArn: 'arn:aws:route53:::hostedzone/fakeId',
            stack,
            node: stack.node,
        });
        // THEN
        test.equal(qualified, 'test.domain.com.');
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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