"""
This type stub file was generated by pyright.
"""

import asyncio
import anthropic
from abc import abstractmethod
from dataclasses import dataclass
from logging import Logger
from typing import Awaitable, Callable, List, Optional, Type
from uuid import UUID
from anthropic.types import Message, MessageParam, ModelParam

MsgFailureHandler = Callable[['Conv', str, Message], Awaitable[Optional[Conv]]]
MsgHandler = Callable[['Conv', Message], Awaitable[Optional[Conv]]]
def usermsg(msg: str) -> MessageParam:
  ...

def systemmsg(msg: str) -> MessageParam:
  ...

async def default_msg_handler(conv: Conv, message: Message) -> Optional[Conv]:
  ...

async def default_msg_failure_handler(conv: Conv, finish_reason: str, message: Message) -> Optional[Conv]:
  ...

def parsedMsgToParam(msg: Message): # -> MessageParam:
  ...

class ConvListener:
  log: Logger
  def __init__(self, log: Logger) -> None:
    ...
  
  @abstractmethod
  def before_run(self, conv_id: UUID, msgs: List[MessageParam]) -> None:
    ...
  
  @abstractmethod
  def after_run(self, conv_id: UUID, msg: Message) -> None:
    ...
  


class DefaultConvListener(ConvListener):
  def __init__(self, log: Logger) -> None:
    ...
  
  def before_run(self, conv_id: UUID, msgs: List[MessageParam]) -> None:
    ...
  
  def after_run(self, conv_id: UUID, msg: Message) -> None:
    ...
  


class StructuredOuputError(Exception):
  raw: str
  def __init__(self, raw: str) -> None:
    ...
  


@dataclass
class Conv:
  client: anthropic.AsyncAnthropic
  messages: List[MessageParam]
  msg_handler: MsgHandler
  tools: List | None
  _sem: asyncio.Semaphore
  _log: Logger
  _conv_id: UUID
  model: ModelParam
  temperature: float
  response_format: Type | None
  msg_failure_handler: MsgFailureHandler = ...
  reasoning_effort: str = ...
  _listener_msg_idx: int = ...
  _listener: Optional[ConvListener] = ...
  def clone(self, msgs: List[MessageParam]) -> Conv:
    ...
  
  def append(self, msg: MessageParam) -> Conv:
    ...
  
  def respond(self, msg: str, msg_handler: MsgHandler | None = ..., response_format: Type | None = ...) -> Conv:
    ...
  
  async def get_parsed_response[T](self, message: Message, response_format: Type[T] | None) -> T | str | None:
    ...
  
  async def run(self) -> None:
    ...
  


async def oneshot_conv[ResponseType](client: anthropic.AsyncAnthropic, messages: List[MessageParam], response_format: Type[ResponseType] | None = ..., reasoning_effort: str = ..., tools: List | None = ..., sem: Optional[asyncio.Semaphore] = ..., log: Optional[Logger] = ..., conv_id: Optional[UUID] = ..., model: ModelParam = ..., temperature: float = ..., msg_failure_handler: MsgFailureHandler = ..., listener_msg_idx: int = ..., listener: Optional[ConvListener] = ..., debug: bool = ...) -> ResponseType | str | None:
  ...

