"""
This type stub file was generated by pyright.
"""

import asyncio
from dataclasses import dataclass
from logging import Logger
from typing import Awaitable, Callable, List, Optional, Type
from openai import AsyncOpenAI, NotGiven
from openai.types.chat import ChatCompletionMessageParam, ChatCompletionSystemMessageParam, ChatCompletionUserMessageParam, ParsedChatCompletionMessage
from openai.types.chat.chat_completion_reasoning_effort import ChatCompletionReasoningEffort
from alxai.base.generic_conv import ConvClassBase, ConvID, ConvListener
from alxai.openai.tool import ToolExecutor

MsgFailureHandler = Callable[['Conv', str, ParsedChatCompletionMessage], Awaitable[Optional[Conv]]]
MsgHandler = Callable[['Conv', ParsedChatCompletionMessage], Awaitable[Optional[Conv]]]
def usermsg(msg: str) -> ChatCompletionUserMessageParam:
  ...

def systemmsg(msg: str) -> ChatCompletionSystemMessageParam:
  ...

async def default_msg_handler(conv: Conv, message: ParsedChatCompletionMessage) -> Optional[Conv]:
  ...

async def default_msg_failure_handler(conv: Conv, finish_reason: str, message: ParsedChatCompletionMessage) -> Optional[Conv]:
  ...

def parsedMsgToParam(msg: ParsedChatCompletionMessage): # -> ChatCompletionAssistantMessageParam:
  ...

@dataclass
class Conv(ConvClassBase):
  client: AsyncOpenAI
  messages: List[ChatCompletionMessageParam]
  msg_handler: MsgHandler
  tools: List[ToolExecutor] | NotGiven
  model: str
  temperature: float | NotGiven
  response_format: Type | NotGiven
  msg_failure_handler: MsgFailureHandler = ...
  reasoning_effort: ChatCompletionReasoningEffort = ...
  def __post_init__(self): # -> None:
    ...
  
  def clone(self, msgs: List[ChatCompletionMessageParam]) -> Conv:
    ...
  
  def append(self, msg: ChatCompletionMessageParam) -> Conv:
    ...
  
  def respond(self, msg: str, msg_handler: MsgHandler | None = ..., response_format: Type | None = ...) -> Conv:
    ...
  
  async def get_parsed_response[T](self, message: ParsedChatCompletionMessage, response_format: Type[T] | None) -> T | str | None:
    ...
  
  async def run(self) -> None:
    ...
  


async def start_conv(client: AsyncOpenAI, msg_handler: MsgHandler, messages: List[ChatCompletionMessageParam], tools: List[ToolExecutor] | None = ..., sem: Optional[asyncio.Semaphore] = ..., log: Optional[Logger] = ..., conv_id: Optional[ConvID] = ..., model: str = ..., reasoning_effort: ChatCompletionReasoningEffort = ..., temperature: float | NotGiven = ..., msg_failure_handler: MsgFailureHandler = ..., listeners: Optional[List[ConvListener]] = ..., response_format: Type | NotGiven | None = ..., debug: bool = ...): # -> None:
  ...

async def oneshot_conv[ResponseType](client: AsyncOpenAI, messages: List[ChatCompletionMessageParam], response_format: Type[ResponseType] | None = ..., reasoning_effort: ChatCompletionReasoningEffort = ..., tools: List[ToolExecutor] | NotGiven | None = ..., sem: Optional[asyncio.Semaphore] = ..., log: Optional[Logger] = ..., conv_id: Optional[ConvID] = ..., model: str = ..., temperature: float | NotGiven = ..., msg_failure_handler: MsgFailureHandler = ..., listeners: Optional[List[ConvListener]] = ..., debug: bool = ...) -> ResponseType | str | None:
  ...

async def structured_oneshot[ResponseType](client: AsyncOpenAI, messages: List[ChatCompletionMessageParam], response_format: Type[ResponseType], reasoning_effort: ChatCompletionReasoningEffort = ..., tools: List[ToolExecutor] | NotGiven | None = ..., sem: Optional[asyncio.Semaphore] = ..., log: Optional[Logger] = ..., conv_id: Optional[ConvID] = ..., model: str = ..., temperature: float | NotGiven = ..., msg_failure_handler: MsgFailureHandler = ..., listeners: Optional[List[ConvListener]] = ..., debug: bool = ...) -> ResponseType:
  ...

