# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['metricflow',
 'metricflow.api',
 'metricflow.cli',
 'metricflow.configuration',
 'metricflow.constraints',
 'metricflow.dag',
 'metricflow.dataflow',
 'metricflow.dataflow.builder',
 'metricflow.dataflow.optimizer',
 'metricflow.dataflow.optimizer.source_scan',
 'metricflow.dataset',
 'metricflow.engine',
 'metricflow.errors',
 'metricflow.execution',
 'metricflow.inference',
 'metricflow.inference.context',
 'metricflow.inference.renderer',
 'metricflow.inference.rule',
 'metricflow.inference.solver',
 'metricflow.logging',
 'metricflow.model',
 'metricflow.model.dbt_mapping_rules',
 'metricflow.model.objects',
 'metricflow.model.objects.constraints',
 'metricflow.model.objects.elements',
 'metricflow.model.parsing',
 'metricflow.model.semantics',
 'metricflow.model.transformations',
 'metricflow.model.validations',
 'metricflow.naming',
 'metricflow.plan_conversion',
 'metricflow.protocols',
 'metricflow.query',
 'metricflow.sql',
 'metricflow.sql.optimizer',
 'metricflow.sql.render',
 'metricflow.sql_clients',
 'metricflow.telemetry',
 'metricflow.telemetry.handlers',
 'metricflow.test',
 'metricflow.test.api',
 'metricflow.test.cli',
 'metricflow.test.constraints',
 'metricflow.test.dataflow',
 'metricflow.test.dataflow.builder',
 'metricflow.test.dataflow.optimizer',
 'metricflow.test.dataflow.optimizer.source_scan',
 'metricflow.test.dataset',
 'metricflow.test.examples',
 'metricflow.test.execution',
 'metricflow.test.fixtures',
 'metricflow.test.inference',
 'metricflow.test.inference.context',
 'metricflow.test.inference.renderer',
 'metricflow.test.inference.rule',
 'metricflow.test.inference.solver',
 'metricflow.test.integration',
 'metricflow.test.model',
 'metricflow.test.model.dbt_cloud_parsing',
 'metricflow.test.model.parsing',
 'metricflow.test.model.semantics',
 'metricflow.test.model.transformations',
 'metricflow.test.model.validations',
 'metricflow.test.plan_conversion',
 'metricflow.test.plan_conversion.dataflow_to_sql',
 'metricflow.test.plan_conversion.instance_converters',
 'metricflow.test.query',
 'metricflow.test.sql',
 'metricflow.test.sql.optimizer',
 'metricflow.test.sql_clients',
 'metricflow.test.telemetry',
 'metricflow.test.time',
 'metricflow.time']

package_data = \
{'': ['*'],
 'metricflow.cli': ['sample_models/*'],
 'metricflow.model.parsing': ['schemas/*'],
 'metricflow.test': ['snapshots/test_cm_branch_combiner.py/DataflowPlan/*',
                     'snapshots/test_column_pruner.py/SqlQueryPlan/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/BigQuerySqlClient/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/DatabricksSqlClient/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/DuckDbSqlClient/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/PostgresSqlClient/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/RedshiftSqlClient/*',
                     'snapshots/test_convert_data_source.py/SqlQueryPlan/SnowflakeSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/BigQuerySqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/DatabricksSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/DuckDbSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/PostgresSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/RedshiftSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/SnowflakeSqlClient/*',
                     'snapshots/test_data_warehouse_tasks.py/data_warehouse_validation_model/SqliteSqlClient/*',
                     'snapshots/test_dataflow_plan_builder.py/DataflowPlan/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/BigQuerySqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/DatabricksSqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/DuckDbSqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/PostgresSqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/RedshiftSqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/SnowflakeSqlClient/*',
                     'snapshots/test_dataflow_to_execution.py/ExecutionPlan/SqliteSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/DataflowPlan/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/BigQuerySqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/DatabricksSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/DuckDbSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/PostgresSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/RedshiftSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/SnowflakeSqlClient/*',
                     'snapshots/test_dataflow_to_sql_plan.py/SqlQueryPlan/SqliteSqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/BigQuerySqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/DatabricksSqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/DuckDbSqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/PostgresSqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/RedshiftSqlClient/*',
                     'snapshots/test_engine_specific_rendering.py/SqlQueryPlan/SnowflakeSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/BigQuerySqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/DatabricksSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/DuckDbSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/PostgresSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/RedshiftSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/SnowflakeSqlClient/*',
                     'snapshots/test_metric_time_dimension_to_sql.py/SqlQueryPlan/SqliteSqlClient/*',
                     'snapshots/test_plot_time_dimension_to_sql.py/SqlQueryPlan/*',
                     'snapshots/test_plot_time_dimension_to_sql.py/SqlQueryPlan/SqliteSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/BigQuerySqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/DatabricksSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/DuckDbSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/PostgresSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/RedshiftSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/SnowflakeSqlClient/*',
                     'snapshots/test_rendered_query.py/MetricFlowExplainResult/SqliteSqlClient/*',
                     'snapshots/test_rewriting_sub_query_reducer.py/SqlQueryPlan/*',
                     'snapshots/test_source_scan_optimizer.py/DataflowPlan/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/BigQuerySqlClient/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/DatabricksSqlClient/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/DuckDbSqlClient/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/PostgresSqlClient/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/RedshiftSqlClient/*',
                     'snapshots/test_sql_plan_render.py/SqlQueryPlan/SnowflakeSqlClient/*',
                     'snapshots/test_sub_query_reducer.py/SqlQueryPlan/*',
                     'snapshots/test_table_alias_simplifier.py/SqlQueryPlan/*'],
 'metricflow.test.fixtures': ['model_yamls/composite_identifier_model/*',
                              'model_yamls/config_linter_model/*',
                              'model_yamls/data_warehouse_validation_model/data_sources/*',
                              'model_yamls/extended_date_model/data_sources/*',
                              'model_yamls/extended_date_model/metrics/*',
                              'model_yamls/join_types_model/*',
                              'model_yamls/multi_hop_join_model/partitioned_data_sources/*',
                              'model_yamls/multi_hop_join_model/unpartitioned_data_sources/*',
                              'model_yamls/non_ds_model/*',
                              'model_yamls/scd_model/*',
                              'model_yamls/simple_model/*',
                              'model_yamls/simple_model/data_sources/*'],
 'metricflow.test.integration': ['test_cases/*']}

install_requires = \
['GitPython>=3.1.27,<4.0.0',
 'Jinja2>=2.11.3',
 'MarkupSafe==2.0.1',
 'PyYAML>=6.0,<7.0',
 'SQLAlchemy>=1.4.42,<2.0.0',
 'click>=7.1.2',
 'croniter>=1.3.4,<2.0.0',
 'databricks-sql-connector==2.0.3',
 'duckdb-engine>=0.1.8,<0.2.0',
 'duckdb==0.3.4',
 'fuzzywuzzy>=0.18.0,<0.19.0',
 'google-auth>=2.13.0,<3.0.0',
 'google-cloud-bigquery==2.34.2',
 'graphviz==0.18.2',
 'halo>=0.0.31,<0.0.32',
 'jsonschema==3.2.0',
 'mo-sql-parsing>=9.328.23003,<10.0.0',
 'more-itertools==8.10.0',
 'numpy>=1.22.2',
 'pandas>=1.3.0,<2.0.0',
 'psycopg2>=2.9.3,<3.0.0',
 'pycron>=3.0.0,<4.0.0',
 'pydantic>=1.9.0,<2.0.0',
 'python-dateutil==2.8.2',
 'requests>=2.27.1,<3.0.0',
 'ruamel.yaml>=0.17.21,<0.18.0',
 'rudder-sdk-python>=1.0.3,<2.0.0',
 'snowflake-connector-python>=2.7.8',
 'snowflake-sqlalchemy>=1.4.3,<2.0.0',
 'sqlalchemy-bigquery>=1.4.3,<2.0.0',
 'sqlalchemy-redshift==0.8.1',
 'sqlalchemy2-stubs>=0.0.2-alpha.21,<0.0.3',
 'tabulate==0.8.9',
 'typing_extensions>=4.0.0',
 'update-checker>=0.18.0,<0.19.0',
 'yamllint>=1.26.3,<2.0.0']

extras_require = \
{'dbt-bigquery': ['dbt-bigquery>=1.3.0,<2.0.0'],
 'dbt-cloud': ['dbt-metadata-client>=0.1.0,<0.2.0'],
 'dbt-postgres': ['dbt-postgres>=1.3.0,<2.0.0'],
 'dbt-redshift': ['dbt-redshift>=1.3.0,<2.0.0'],
 'dbt-snowflake': ['dbt-snowflake>=1.3.0,<2.0.0']}

entry_points = \
{'console_scripts': ['mf = metricflow.cli.main:cli']}

setup_kwargs = {
    'name': 'metricflow',
    'version': '0.140.0',
    'description': 'Translates a simple metric definition into reusable SQL and executes it against the SQL engine of your choice.',
    'long_description': '<p align="center">\n  <a target="_blank" href="https://transform.co/metricflow">\n    <picture>\n      <img  alt="metricflow logo" src="https://github.com/transform-data/metricflow/raw/main/assets/MetricFlow_logo.png" width="auto" height="120">\n    </picture>\n  </a>\n  <br /><br />\n  <b>Build and maintain all of your metric logic in code.</b>\n  <br /><br />\n  <a target="_blank" href="https://twitter.com/transformio">\n    <img src="https://img.shields.io/twitter/follow/transformio?labelColor=image.png&color=163B36&logo=twitter&style=flat">\n  </a>\n  <a target="_blank" href="http://community.transform.co/metricflow-signup">\n    <img src="https://img.shields.io/badge/Slack-join-163B36">\n  </a>\n  <a target="_blank" href="https://github.com/transform-data/metricflow">\n    <img src="https://img.shields.io/github/stars/transform-data/metricflow?labelColor=image.png&color=163B36&logo=github">\n  </a>\n  <br />\n  <a target="_blank" href="https://github.com/transform-data/metricflow/blob/master/LICENSE">\n    <img src="https://img.shields.io/pypi/l/metricflow?color=163B36&logo=AGPL-3.0">\n  </a>\n  <a target="_blank" href="https://pypi.org/project/metricflow/">\n    <img src="https://img.shields.io/pypi/v/metricflow?labelColor=&color=163B36">\n  </a>\n  <img src="https://img.shields.io/pypi/pyversions/metricflow?labelColor=&color=163B36">\n</p>\n\n# Welcome to MetricFlow\n\nSee our latest updates in the [Metricflow Changelog](https://github.com/transform-data/metricflow/blob/main/CHANGELOG.md)!\n\nMetricFlow is a semantic layer that makes it easy to organize metric definitions. It takes those definitions and generates legible and reusable SQL. This makes it easy to get consistent metrics output broken down by attributes (dimensions) of interest.\n\nThe name comes from the approach taken to generate metrics. A query is compiled into a query plan (represented below) called a dataflow that constructs metrics. The plan is then optimized and rendered to engine-specific SQL.\n\n<p align="center">\n<img src="https://github.com/transform-data/metricflow/raw/main/assets/example_plan.svg" height="500"/>\n<br /><br />\n</p>\n\nMetricFlow provides a set of abstractions that help you construct complicated logic and dynamically generate queries to handle:\n\n- Multi-hop joins between fact and dimension sources\n- Complex metric types such as ratio, expression, and cumulative\n- Metric aggregation to different time granularities\n- And so much more\n\nAs a developer, you can also use MetricFlow\'s interfaces to construct APIs for integrations to bring metrics into downstream tools in your data stack.\n\nTo get up and running with your own metrics, you should rely on MetricFlow’s documentation available at [MetricFlow docs](https://docs.transform.co/docs/metricflow/guides/introduction).\n\n## Getting Started\n\n### Install MetricFlow\n\nMetricFlow can be installed from PyPi for use as a Python library with the following command:\n\n```\npip install metricflow\n```\n\nOnce installed, MetricFlow can be setup and connected to a data warehouse by following the instructions after issuing the command:\n\n```\nmf setup\n```\n\nIn case you don\'t have a connection to a data warehouse available and want a self-contained demo, DuckDB can be selected.\n\nYou may need to install Postgres or Graphviz. You can do so by following the install instructions for [Postgres](https://www.postgresql.org/download/) or [Graphviz](https://www.graphviz.org/download/). Mac users may prefer to use brew: `brew install postgresql` or `brew install graphviz`.\n\n### Tutorial\n\nThe best way to get started is to follow the [tutorial](https://docs.transform.co/docs/metricflow/metricflow-tutorial) steps:\n\n```\nmf tutorial\n```\n\nThere are several examples of MetricFlow configs on common data sets in the [config-templates](https://github.com/transform-data/metricflow/tree/main/config-templates) folder. The tutorial will rely on a small set of [sample configs](https://github.com/transform-data/metricflow/tree/main/metricflow/cli/sample_models).\n\n## Resources\n\n- [Website](https://transform.co/metricflow)\n- [Documentation](https://docs.transform.co/docs/overview/metricflow-overview)\n- [Slack Community](https://community.transform.co/metricflow-signup)\n- [MetricFlow Git Repository](https://github.com/transform-data/metricflow)\n- [CHANGELOG.md](https://github.com/transform-data/metricflow/blob/main/CHANGELOG.md)\n- [ROADMAP.md](https://github.com/transform-data/metricflow/blob/main/ROADMAP.md)\n- [TENETS.md](https://github.com/transform-data/metricflow/blob/main/TENETS.md)\n\n## Contributing and Code of Conduct\n\nThis project will be a place where people can easily contribute high-quality updates in a supportive environment.\n\nYou might wish to read our [code of conduct](http://community.transform.co/metricflow-signup) and <LINK> engineering practices </LINK> before diving in.\n\nTo get started on direct contributions, head on over to our [contributor guide](https://github.com/transform-data/metricflow/blob/main/CONTRIBUTING.md).\n\n## License\n\nMetricFlow is open source software. The project relies on several licenses including AGPL-3.0-or-later and Apache (specified at folder level).\n\nMetricFlow is built by [Transform](https://transform.co/).\n',
    'author': 'Transform',
    'author_email': 'hello@transformdata.io',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://transform.co/metricflow',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<3.10',
}


setup(**setup_kwargs)
