from .fun import ispump

import IPython
import pandas as pd
import numpy as np
import os,time
import warnings
warnings.filterwarnings("ignore")

class check(object):

    def demo():
        demostr = '''
import clubear as cb
#clubear.csv is generated by cb.manager.demo()
pm=cb.pump('clubear.csv') #start a new pump
pm.keep #check the head lists
cb.check(pm).stats() #check the for stats
pm.qlist=['age','height','weight','price','logsales']
cb.check(pm).stats(niter=20,keep=['price']) 
cb.check(pm).corr() #check for correlation
cb.check(pm).table(tv=True) #check table
pm.subsize=10000 #check the subsize
df=pm.go #start to pump data
'''
        print(demostr)

    def __init__(self, pp):
        self.pp = pp
        
        '''check whether the input is a pump first'''
        pump_check=ispump(self.pp)
        if pump_check != 'YES': print(pump_check); return
        
        '''initialization'''
        self.Stats=[];self.Table=[]

    def stats(self, niter=10,keep=[]):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(niter,int): print('check.table: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.stats: The keep list must be a list.'); return
        if niter<1: print('check.table: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pp.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]!='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.stats: No variable can be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        N = np.zeros(niter)
        MU = np.zeros([niter, ncov])
        Min = np.zeros([niter, ncov])
        Med = np.zeros([niter, ncov])
        Max = np.zeros([niter, ncov])
        SD = np.zeros([niter, ncov])
        Skew = np.zeros([niter, ncov])
        Kurt = np.zeros([niter, ncov])
        Prob = np.zeros([niter,ncov])
        start_time=time.time()
        for i in range(niter):
            '''get data and make it float'''
            df = self.pp.go()[mylist]
            
            '''create non-missing flag'''
            flag=(np.abs(df)<1.0e+15)*(np.abs(df)>=0)
            Prob[i]=np.mean(flag,axis=0)+1.0e-15
            
            '''The 1st bach of stat *without* central'''
            N[i] = df.shape[0]
            MU[i] = np.nanmean(df, axis=0)
            Min[i] = np.nanmin(df, axis=0)
            Med[i] = np.nanmedian(df, axis=0)
            Max[i] = np.nanmax(df, axis=0)

            '''The 2nd batch of stat *with* central'''
            df =df-MU[i]
            SD[i] = np.nanmean(df**2, axis=0)
            Skew[i] = np.nanmean(df**3, axis=0)
            Kurt[i] = np.nanmean(df**4, axis=0)
            

            '''organize for interactive output'''
            MyN = np.mean(N[:(i+1)])
            MyMU = np.mean(MU[:(i+1)], axis=0)
            MyMin = np.min(Min[:(i+1)], axis=0)
            MyMed = np.median(Med[:(i+1)], axis=0)
            MyMax = np.max(Max[:(i+1)], axis=0)
            MySD = np.sqrt(np.mean(SD[:(i+1)], axis=0))+1.0e-12
            MySkew = np.mean(Skew[:(i+1)], axis=0)/MySD**3
            MyKurt = np.mean(Kurt[:(i+1)], axis=0)/MySD**4
            MyProb = np.mean(Prob[:(i+1)],axis=0)
            output = pd.DataFrame(list(zip(MyMU,MySD,MyMin, MyMed, MyMax, MySkew,MyKurt,100*MyProb)))
            output.columns = ['Mu','SD','Min','Med', 'Max','Skew','Kurt','rp']
            output.index = mylist
            self.Stats=output
            
            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            progress = np.round((i+1)/niter*100, 2)
            print('Time elapsed:',np.round(elapse_time,3),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', progress,
                  '% for a total of ', niter, 'random replications.')
            print('');print(np.round(output, 3));print('')
            print('* Mu: the averaged subsample mean; SD: the averaged subsample standard deviation.')
            print('* Min: the minimum of the subsample minimum; Med: the median of the subsample median.')
            print('* Max: the maximum of the subsample maximum; Kurt: the averaged sample kurtosis.')
            print('* rp: the averaged subsample response probability in percentage (0%~100%).')
            
        self.Stats=output
        
    def corr(self, niter=10,keep=[]):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(niter,int): print('check.corr: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.corr: The keep list must be a list.'); return
        if niter<1: print('check.corr: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pp.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]!='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.corr: No variable can be checked!'); return
        
        '''main part for computing statistics'''
        ncov = len(mylist)
        corr_total=np.zeros([ncov,ncov])
        start_time=time.time()
        for n in range(niter):
            '''get data and make it float'''
            df = np.array(self.pp.go()[mylist])
            MyN=df.shape[0] 
            
            '''The 1st bach of stat *without* central'''
            df = df-np.nanmean(df, axis=0)
            SD = np.sqrt(np.nanmean(df**2,axis=0))
            df = df/SD
            mycorr=np.zeros([ncov,ncov])
            for j1 in range(ncov):
                for j2 in range(ncov):
                    mycorr[j1,j2]=np.nanmean(df[:,j1]*df[:,j2])
            corr_total=corr_total+mycorr
            self.Corr=pd.DataFrame(corr_total/(n+1))*100
            self.Corr.index=['['+str(each)+']'+mylist[each] for each in range(ncov)]
            self.Corr.columns=['['+str(each)+']' for each in range(ncov)]
            
            '''output to screen for interactive analysis'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            progress = np.round((n+1)/niter*100, 2)
            print('Time elapsed:',np.round(elapse_time,3),'seconds',end=' ')
            print('with subsample sizes', int(MyN), '.')
            print('Task accomplished: ', progress,
                  '% for a total of ', niter, 'random replications.')
            print('')
            print(np.round(self.Corr, 1))
            print('')
            print('* the averaged subsample correlation coefficients in percentage (0%~100%).')

        
    def table(self, tv=False,niter=10,keep=[]):
        
        '''check carefully all the pre-conditions'''
        if not isinstance(tv,bool): print('check.table: The tv must be a bool'); return
        if not isinstance(niter,int): print('check.table: The niter must be an int.'); return
        if not isinstance(keep,list): print('check.table: The keep list must be a list.'); return
        if niter<1: print('check.table: The niter must be no less than one.'); return
        
        '''check whether we have something to stats'''
        df=self.pp.go();
        heads = list(df.columns);ncolumns=len(heads)
        mylist=[each for each in heads if df.dtypes[each]=='object']
        if len(keep)>0: mylist=[each for each in mylist if each in keep]
        if len(mylist)==0: print('check.table: No variable can be checked!'); return
        
        ncov = len(mylist)

        '''a lists of sets for level values'''
        value_sets = [set() for each in range(ncov)]
        
        '''a list of Series for level counts'''
        counts = [pd.Series() for each in range(ncov)]
        
        start_time=time.time()
        for n in range(niter):
            df = self.pp.go()[mylist]
            for j in range(ncov):
                '''current subsample data computing'''
                new = list(df[mylist[j]].astype('str'))
                value_sets[j] = value_sets[j] | set(new)
                value_list = sorted(list(value_sets[j]))
                value_counts = [new.count(each) for each in value_list]
                
                '''for current count results into Series'''
                pds = pd.Series(value_counts)
                pds.index = value_list
                
                '''merge the current result with the history'''
                current_index = counts[j].index
                pds[current_index] = pds[current_index]+counts[j][current_index]
                counts[j] = pds

            '''for interactive outputs'''
            end_time=time.time();elapse_time=end_time-start_time            
            IPython.display.clear_output(wait=True)
            pd.set_option('display.float_format', lambda x: '%.1f' % x)
            total_counts = int(np.mean([sum(counts[each]) for each in range(ncov)]))
            print('Time elapsed:',int(elapse_time),'seconds.')
            print("Task Completed: ", np.round(100.0*(n+1)/niter, 2), '% for a total of',
                  niter, 'iterations for totally', total_counts, 'counts.')
            print("  ")
            for j in range(ncov):
                args = np.argsort(-counts[j])
                counts[j] = counts[j][args]
                clevels = list(counts[j].index)
                cvalues = list(counts[j])
                print('[', j, '] Total', len(clevels),
                      'levels detected for *', mylist[j], '*')
                if tv == True:
                    prob = cvalues/np.sum(cvalues)*100
                    max_output_number = np.min([len(clevels), 100])
                    for k in range(max_output_number):
                        print(clevels[k], '=', np.round(
                            prob[k], 2), '%', end='|')
                    if len(clevels) > 100:
                        print('*** Note: only top 100 levels displayed...')
                    print('')
                    print('')
                    
        self.counts = counts
        self.levels = value_sets
        
        self.Table=pd.Series([len(each) for each in counts])
        self.Table.index=mylist
        
