import { aws_apigateway as apigateway, aws_dynamodb as dynamodb, aws_ec2 as ec2, aws_iam as iam, aws_secretsmanager as secretsmanager } from "aws-cdk-lib";
import { Construct } from "constructs";
export declare class StacIngestor extends Construct {
    table: dynamodb.Table;
    constructor(scope: Construct, id: string, props: StacIngestorProps);
    private buildTable;
    private buildApiLambda;
    private buildIngestor;
    private buildApiEndpoint;
    private registerSsmParameter;
}
export interface StacIngestorProps {
    /**
     * ARN of AWS Role used to validate access to S3 data
     */
    readonly dataAccessRole: iam.IRole;
    /**
     * URL of STAC API
     */
    readonly stacUrl: string;
    /**
     * Stage of deployment (e.g. `dev`, `prod`)
     */
    readonly stage: string;
    /**
     * Secret containing pgSTAC DB connection information
     */
    readonly stacDbSecret: secretsmanager.ISecret;
    /**
     * VPC running pgSTAC DB
     */
    readonly vpc: ec2.IVpc;
    /**
     * Security Group used by pgSTAC DB
     */
    readonly stacDbSecurityGroup: ec2.ISecurityGroup;
    /**
     * Boolean indicating whether or not pgSTAC DB is in a public subnet
     */
    readonly subnetSelection: ec2.SubnetSelection;
    /**
     * Environment variables to be sent to Lambda.
     */
    readonly apiEnv?: Record<string, string>;
    /**
     * API Endpoint Configuration, useful for creating private APIs.
     */
    readonly apiEndpointConfiguration?: apigateway.EndpointConfiguration;
    /**
     * API Policy Document, useful for creating private APIs.
     */
    readonly apiPolicy?: iam.PolicyDocument;
}
