import re

__CODES = (
    ('aar', 'aa', 'Afar'),
    ('abk', 'ab', 'Abkhazian'),
    ('afr', 'af', 'Afrikaans'),
    ('aka', 'ak', 'Akan'),
    ('amh', 'am', 'Amharic'),
    ('ara', 'ar', 'Arabic'),
    ('arg', 'an', 'Aragonese'),
    ('asm', 'as', 'Assamese'),
    ('ava', 'av', 'Avaric'),
    ('ave', 'ae', 'Avestan'),
    ('aym', 'ay', 'Aymara'),
    ('aze', 'az', 'Azerbaijani'),
    ('bak', 'ba', 'Bashkir'),
    ('bam', 'bm', 'Bambara'),
    ('bel', 'be', 'Belarusian'),
    ('ben', 'bn', 'Bengali'),
    ('bis', 'bi', 'Bislama'),
    ('bos', 'bs', 'Bosnian'),
    ('bre', 'br', 'Breton'),
    ('bul', 'bg', 'Bulgarian'),
    ('cha', 'ch', 'Chamorro'),
    ('che', 'ce', 'Chechen'),
    ('chv', 'cv', 'Chuvash'),
    ('cor', 'kw', 'Cornish'),
    ('cos', 'co', 'Corsican'),
    ('cre', 'cr', 'Cree'),
    ('dan', 'da', 'Danish'),
    ('dzo', 'dz', 'Dzongkha'),
    ('eng', 'en', 'English'),
    ('epo', 'eo', 'Esperanto'),
    ('est', 'et', 'Estonian'),
    ('ewe', 'ee', 'Ewe'),
    ('fao', 'fo', 'Faroese'),
    ('fij', 'fj', 'Fijian'),
    ('fin', 'fi', 'Finnish'),
    ('fry', 'fy', 'Western Frisian'),
    ('ful', 'ff', 'Fulah'),
    ('gle', 'ga', 'Irish'),
    ('glg', 'gl', 'Galician'),
    ('grn', 'gn', 'Guarani'),
    ('guj', 'gu', 'Gujarati'),
    ('hau', 'ha', 'Hausa'),
    ('heb', 'he', 'Hebrew'),
    ('her', 'hz', 'Herero'),
    ('hin', 'hi', 'Hindi'),
    ('hmo', 'ho', 'Hiri Motu'),
    ('hrv', 'hr', 'Croatian'),
    ('hun', 'hu', 'Hungarian'),
    ('ibo', 'ig', 'Igbo'),
    ('ido', 'io', 'Ido'),
    ('iku', 'iu', 'Inuktitut'),
    ('ind', 'id', 'Indonesian'),
    ('ipk', 'ik', 'Inupiaq'),
    ('ita', 'it', 'Italian'),
    ('jav', 'jv', 'Javanese'),
    ('jpn', 'ja', 'Japanese'),
    ('kan', 'kn', 'Kannada'),
    ('kas', 'ks', 'Kashmiri'),
    ('kau', 'kr', 'Kanuri'),
    ('kaz', 'kk', 'Kazakh'),
    ('khm', 'km', 'Central Khmer'),
    ('kin', 'rw', 'Kinyarwanda'),
    ('kom', 'kv', 'Komi'),
    ('kon', 'kg', 'Kongo'),
    ('kor', 'ko', 'Korean'),
    ('kur', 'ku', 'Kurdish'),
    ('lao', 'lo', 'Lao'),
    ('lat', 'la', 'Latin'),
    ('lav', 'lv', 'Latvian'),
    ('lin', 'ln', 'Lingala'),
    ('lit', 'lt', 'Lithuanian'),
    ('lub', 'lu', 'Luba-Katanga'),
    ('lug', 'lg', 'Ganda'),
    ('mah', 'mh', 'Marshallese'),
    ('mal', 'ml', 'Malayalam'),
    ('mar', 'mr', 'Marathi'),
    ('mlg', 'mg', 'Malagasy'),
    ('mlt', 'mt', 'Maltese'),
    ('mon', 'mn', 'Mongolian'),
    ('nau', 'na', 'Nauru'),
    ('ndo', 'ng', 'Ndonga'),
    ('nep', 'ne', 'Nepali'),
    ('nor', 'no', 'Norwegian'),
    ('oji', 'oj', 'Ojibwa'),
    ('ori', 'or', 'Oriya'),
    ('orm', 'om', 'Oromo'),
    ('pli', 'pi', 'Pali'),
    ('pol', 'pl', 'Polish'),
    ('por', 'pt', 'Portuguese'),
    ('que', 'qu', 'Quechua'),
    ('roh', 'rm', 'Romansh'),
    ('run', 'rn', 'Rundi'),
    ('rus', 'ru', 'Russian'),
    ('sag', 'sg', 'Sango'),
    ('san', 'sa', 'Sanskrit'),
    ('slv', 'sl', 'Slovenian'),
    ('sme', 'se', 'Northern Sami'),
    ('smo', 'sm', 'Samoan'),
    ('sna', 'sn', 'Shona'),
    ('snd', 'sd', 'Sindhi'),
    ('som', 'so', 'Somali'),
    ('sot', 'st', 'Sotho, Southern'),
    ('spa', 'es', 'Spanish'),
    ('srd', 'sc', 'Sardinian'),
    ('srp', 'sr', 'Serbian'),
    ('ssw', 'ss', 'Swati'),
    ('sun', 'su', 'Sundanese'),
    ('swa', 'sw', 'Swahili'),
    ('swe', 'sv', 'Swedish'),
    ('tah', 'ty', 'Tahitian'),
    ('tam', 'ta', 'Tamil'),
    ('tat', 'tt', 'Tatar'),
    ('tel', 'te', 'Telugu'),
    ('tgk', 'tg', 'Tajik'),
    ('tgl', 'tl', 'Tagalog'),
    ('tha', 'th', 'Thai'),
    ('tir', 'ti', 'Tigrinya'),
    ('tsn', 'tn', 'Tswana'),
    ('tso', 'ts', 'Tsonga'),
    ('tuk', 'tk', 'Turkmen'),
    ('tur', 'tr', 'Turkish'),
    ('twi', 'tw', 'Twi'),
    ('ukr', 'uk', 'Ukrainian'),
    ('urd', 'ur', 'Urdu'),
    ('uzb', 'uz', 'Uzbek'),
    ('ven', 've', 'Venda'),
    ('vie', 'vi', 'Vietnamese'),
    ('wln', 'wa', 'Walloon'),
    ('wol', 'wo', 'Wolof'),
    ('xho', 'xh', 'Xhosa'),
    ('yid', 'yi', 'Yiddish'),
    ('yor', 'yo', 'Yoruba'),
    ('zul', 'zu', 'Zulu')
)


def __find_by(file, element_position):
    def match_language(language):
        regex = r'(^|\.)' + language[element_position] + r'\.'
        matches = re.findall(regex, file)
        return len(matches) > 0

    return next((language for language in __CODES if match_language(language)), None)


def find_by_three_letter_code(file):
    return __find_by(file, 0)


def find_by_language(file):
    return __find_by(file, 2)
