# Adansonia

<div align="center">
  <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/cb/Adansonia_grandidieri03.jpg/640px-Adansonia_grandidieri03.jpg">
</div>

_Adansonia_ is a genus of deciduous trees known as baobabs. They are found in arid regions of Madagascar, mainland Africa, Arabia, and Australia. The generic name honours [Michel Adanson](https://fr.wikipedia.org/wiki/Michel_Adanson), the French naturalist and explorer who described Adansonia digitata.

| **`Documentation`**                                                                                                                      |
|------------------------------------------------------------------------------------------------------------------------------------------|
| [![Documentation](https://img.shields.io/badge/api-reference-blue.svg)](https://github.com/baobab-group/Adansonia/blob/master/README.md) |

## Installation

To install the current release:

```python
pip install adansonia
```

### *Try your first Adansonia program*

```shell
$ python
```

```python
>>> from adansonia.utils import reduce_mem_usage
>>> reduce_mem_usage(your DataFrame)

```

## Continous Integration

| Build Type            | Status |
| ---                   | ---    |
|**CII Best Practices** |[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/2928/badge)](https://bestpractices.coreinfrastructure.org/projects/2928)|
| **Travis Linux**      | [![Build Status](https://travis-ci.com/baobab-group/Adansonia.svg?branch=master)](https://travis-ci.com/baobab-group/Adansonia)|
|**CircleCi**           |[![CircleCI](https://circleci.com/gh/baobab-group/Adansonia.svg?style=svg)](https://circleci.com/gh/baobab-group/Adansonia)|
|**Codacy**             |[![Codacy Badge](https://api.codacy.com/project/badge/Grade/50ca4252879542d984be6c1b91e73622)](https://www.codacy.com/app/mickael.labarrere/Adansonia?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=baobab-group/Adansonia&amp;utm_campaign=Badge_Grade)|
|**CodeCov**            |-|
|**CodeFactor**         |[![CodeFactor](https://www.codefactor.io/repository/github/baobab-group/adansonia/badge)](https://www.codefactor.io/repository/github/baobab-group/adansonia)|
|**Better Code Hub**    |[![BCH compliance](https://bettercodehub.com/edge/badge/baobab-group/Adansonia?branch=master)](https://bettercodehub.com/)|

## License

[Apache License 2.0](LICENSE)
