"""AIMemory Client - Lightweight Python client for AIMemory Server.

A simple, lightweight client for interacting with self-hosted AIMemory servers.
No heavy dependencies - just httpx!

Usage:
    from aimemory_client import AIMemoryClient

    # Sync client
    client = AIMemoryClient(host="http://localhost:8080")
    client.add("I love pizza", user_id="user123")
    results = client.search("What food do I like?", user_id="user123")

    # Async client
    from aimemory_client import AsyncAIMemoryClient

    async with AsyncAIMemoryClient(host="http://localhost:8080") as client:
        await client.add("I love pizza", user_id="user123")
"""

__version__ = "1.0.2"

from aimemory_client.client import AIMemoryClient, AsyncAIMemoryClient

__all__ = [
    "AIMemoryClient",
    "AsyncAIMemoryClient",
    "__version__",
]
