# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['plexy']

package_data = \
{'': ['*']}

install_requires = \
['PlexAPI>=4.12.1,<5.0.0',
 'appdirs>=1.4.4,<2.0.0',
 'babelfish>=0.6.0,<0.7.0',
 'click>=8.1.3,<9.0.0',
 'trakit>=0.2.1,<0.3.0']

setup_kwargs = {
    'name': 'plexy',
    'version': '0.1.1',
    'description': 'Your Plex, your way',
    'long_description': '# Plexy\nYour Plex, your way\n\n[![Latest\nVersion](https://img.shields.io/pypi/v/plexy.svg)](https://pypi.python.org/pypi/plexy)\n\n[![tests](https://github.com/ratoaq2/plexy/actions/workflows/test.yml/badge.svg)](https://github.com/ratoaq2/plexy/actions/workflows/test.yml)\n\n[![License](https://img.shields.io/github/license/ratoaq2/plexy.svg)](https://github.com/ratoaq2/plexy/blob/master/LICENSE)\n\n  - Project page  \n    <https://github.com/ratoaq2/plexy>\n\n## Info\n\n**Plexy** is a command line tool to save your watching preferences in Plex.\n\n**Dubbed** or **Original audio**, it\'s up to you.\n\n- For **Dubbed** preference, Plexy will auto-select the audio track with your desired language.\nIf no audio track is found, Plexy will auto-select the subtitle track with your desired language.\n- For **Original** preference, Plexy will auto-select the default/original audio track \nand the subtitle track in your desired language.\n\nPriorities:\n- Commentary audio tracks have lower priority when selecting audio tracks\n- Closed caption and SDH subtitle tracks also have lower priority when selecting subtitles\n\n\nTo select Brazilian Portuguese language with original audio\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language pt-BR original\n```\n\nTo select English language with dubbed audio\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language en dubbed\n```\n\nTo select French language with original audio only for Game of Thrones\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language fr --title "Game of Thrones" original\n```\n\nTo select German language with dubbed audio only for Mandalorian Season 2\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language fr --title "Mandalorian s02" dubbed\n```\n\nTo select German language with dubbed audio only for Game of Thrones, season 3 and episode 9\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language fr --title "Game of Thrones s03e09" dubbed\n```\n\nTo select Spanish language with dubbed audio only for all Matrix movies and the first Avatar movie\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language es --title "Matrix" --title "Avatar (2009)" dubbed\n```\n\nTo select Portuguese language with original audio for everything added to your libraries in the last week\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language pt --newer 1w original\n```\n\nTo select Brazilian Portuguese language with original audio for everything added to your "Movie" library before the last week\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --library Movie --language pt-BR --older 1w original\n```\n\nYou can also select or exclude tracks based on their codec/format.\nFor instance, you have a Chromecast with Google TV which doesn\'t support Dolby TrueHD audio codec.\nYou can exclude this codec when saving your preferences: \n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language pt-BR -A truehd original\n```\n\nAnd print the full summary of changes:\n```bash\n>> plexy --url http://mylocalplex:32400 --token ABCDEFGHIJ1234567890 preferences -f -l en --title "The Matrix (1999)" original\nConfiguring watching preferences  [####################################]  100%\n1 movie changed out of 1 selected movie\nThe Matrix (1999) changed from pt-BR: Português (SRT External) to no subtitles\n```\n\n\nYou can also define your configuration options in a `json` or `yaml` file:\n```yaml\nurl: http://myplexserver:32400\ntoken: ABCDEFGHIJ1234567890\npreferences:\n  library:\n    - Movies\n    - TV Shows\n  excluded_subtitle_codec:\n    - eia_608\n  full_summary: True\n  language: pt-BR\n  watching_preference: original\n```\n\nBy default, plexy will load `config.json`, `config.yaml` or `config.yml` file from the folders:\n- Mac OS: `~/Library/Preferences/plexy`\n- Linux: `~/.config/plexy/`\n- Windows: `C:\\Users\\<USER>\\AppData\\Local\\plexy\\plexy`\n\nAnd then update the configuration with data from `plexy.json`, `plexy.yaml` or `plexy.yml` in the current working directory.\n\nYou can pass the configuration to use with the `--config` parameter:\n```bash\n>> plexy --config myconfig.yml preferences\nConfiguring watching preferences  [####################################]  100%\n1 movie changed out of 1 selected movie\nThe Matrix (1999) changed from pt-BR: Português (SRT External) to no subtitles\n```\n\n\nAll available CLI options:\n```bash\n>> plexy --url <PLEX_URL> --token <USER_TOKEN> preferences --help\nUsage: plexy preferences [OPTIONS] {original|dubbed}\n\n  Your watching preferences\n\n  Dubbed prefers an audio track with the desired language.\n  Original prefers the original audio and an additional subtitle track if the audio is not in the desired language.\n\nOptions:\n  -L, --library TEXT              Library to be used. e.g: Movies, Shows\n  -t, --title TITLE               Filter for titles in your library. It could refer to a movie, a\n                                  show, a season or an episode. e.g: Avatar, The Matrix (1999),\n                                  The Boys s2, Chernobyl s01e03, Game of Thrones (2011) s03e09\n  -l, --language LANGUAGE         Desired watching language as IETF code, e.g.: en, pt-BR\n  -a, --audio-codec [dca|aac|ac3|eac3|truehd|flac|mp2|mp3|vorbis|pcm]\n                                  Accepted audio codec\n  -A, --excluded-audio-codec [dca|aac|ac3|eac3|truehd|flac|mp2|mp3|vorbis|pcm]\n                                  Excluded audio codec\n  -s, --subtitle-codec [srt|pgs|vobsub|ass|mov_text|eia_608|dvb_subtitle]\n                                  Accepted subtitle codec\n  -S, --excluded-subtitle-codec [srt|pgs|vobsub|ass|mov_text|eia_608|dvb_subtitle]\n                                  Excluded subtitle codec\n  -n, --newer AGE                 Filter movies/episodes newer than AGE, e.g. 12h, 1w2d.\n  -o, --older AGE                 Filter movies/episodes older than AGE, e.g. 12h, 1w2d.\n  -f, --full-summary              Print the full summary of changed preferences.\n  --debug                         Print useful information for debugging and for reporting bugs.\n  --help                          Show this message and exit.\n```\n\n\n## Using Docker\n\n\n    docker run -it --rm plexy --url http://mylocalplex:32400 --token ABCDEF1234567890 preferences --language pt-BR -A truehd original\n\n\n## Installation\n\n**Plexy** can be installed as a regular python module by running:\n\n    $ [sudo] pip install plexy\n\nFor a better isolation with your system you should use a dedicated\nvirtualenv or install for your user only using the `--user` flag.\n\n## Dependencies\n* [Diaoul/babelfish](https://github.com/Diaoul/babelfish)\n* [pkkid/python-plexapi](https://github.com/pkkid/python-plexapi)\n* [ratoaq2/trakit](https://github.com/ratoaq2/trakit)\n',
    'author': 'Rato',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/ratoaq2/plexy',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
