[![Build Status](https://travis-ci.org/danforthcenter/plantcv.svg?branch=master)](https://travis-ci.org/danforthcenter/plantcv)
[![Coverage Status](https://coveralls.io/repos/github/danforthcenter/plantcv/badge.svg)](https://coveralls.io/github/danforthcenter/plantcv)
[![Documentation Status](http://readthedocs.org/projects/plantcv/badge/?version=latest)](http://plantcv.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/danforthcenter/plantcv-binder.git/master?filepath=index.ipynb)
[![Docker Pulls](https://img.shields.io/docker/pulls/danforthcenter/plantcv.svg)](https://hub.docker.com/r/danforthcenter/plantcv/)
[![GitHub release](https://img.shields.io/github/release/danforthcenter/plantcv.svg)](https://github.com/danforthcenter/plantcv/releases)
[![PyPI version](https://badge.fury.io/py/plantcv.svg)](https://badge.fury.io/py/plantcv)
![Conda](https://img.shields.io/conda/v/bioconda/plantcv.svg)
[![license](https://img.shields.io/github/license/danforthcenter/plantcv.svg)](https://github.com/danforthcenter/plantcv/blob/master/LICENSE)

# PlantCV: Plant phenotyping using computer vision

Please use, cite, and [contribute to](http://plantcv.readthedocs.io/en/latest/CONTRIBUTING/) PlantCV!
If you have questions, please submit them via the
[GitHub issues page](https://github.com/danforthcenter/plantcv/issues).
Follow us on twitter [@plantcv](https://twitter.com/plantcv).

---

## Introduction to PlantCV

PlantCV [1] is an imaging processing and trait extraction package designed for plant biology research
that is built upon open-source software platforms [OpenCV](http://opencv.org) [2], [NumPy](http://www.numpy.org) [3], 
and [MatPlotLib](http://matplotlib.org) [4].

If you use PlantCV please cite us [1].

*  The project website can be found at [plantcv.danforthcenter.org](http://plantcv.danforthcenter.org)

*  Installation instructions can be found [here](http://plantcv.readthedocs.io/en/latest/installation/)

*  Further documentation for PlantCV functions and use can be found at the 
[PlantCV Read the Docs site](http://plantcv.readthedocs.io/) and we have added
[interactive documentation](https://mybinder.org/v2/gh/danforthcenter/plantcv-binder.git/master?filepath=index.ipynb).

*  Test image sets can be found on our [Data page](http://plantcv.danforthcenter.org/pages/data.html). 
We recommend first testing with sets from the Danforth Center.

*  We recommend reading Reference [1], the first publication to detail PlantCV and provide examples of functionality.

* To contribute, please see the [contribution guide](http://plantcv.readthedocs.io/en/latest/CONTRIBUTING/)

### Citations:

1. Fahlgren N, Feldman M, Gehan MA, Wilson MS, Shyu C, Bryant DW, Hill ST, McEntee CJ, Warnasooriya SN, Kumar I, 
Ficor T, Turnipseed S, Gilbert KB, Brutnell TP, Carrington JC, Mockler TC, Baxter I. (2015) A versatile phenotyping
system and analytics platform reveals diverse temporal responses to water availability in *Setaria*. Molecular Plant 8:
1520-1535. http://doi.org/10.1016/j.molp.2015.06.005

2. Bradski G (2000) The OpenCV library. Dr. Dobb's Journal 25(11): 120-126.
http://www.drdobbs.com/open-source/the-opencv-library/184404319

3. Oliphant TE (2007) Python for Scientific Computing. Computing in Science & Engineering 9: 10-20.
http://doi.org/10.1109/MCSE.2007.58

4. Hunter JD (2007) Matplotlib: A 2D graphics environment. Computing in Science & Engineering 9: 90-95.
http://doi.org/10.1109/MCSE.2007.55

___

## Issues with PlantCV?

Please file any PlantCV suggestions/issues/bugs via our 
[GitHub issues page](https://github.com/danforthcenter/plantcv/issues). Please check to see if any related 
issues have already been filed.

---
