# Color palette returns an array of colors (rainbow)

from random import randrange


def color_palette(num):
    """color_palette: Returns a list of colors length num

    Inputs:
    num        = number of colors to return. If num = 1 a random color is returned,
                 otherwise, evenly spaced colors are returned.

    Returns:
    colors     = a list of color tuples (RGB values)

    :param num: int
    :return colors: list
    """
    # Rainbow color scheme (red->red)
    rainbow = (
        (0, 0, 255), (0, 6, 255), (0, 12, 255), (0, 18, 255), (0, 24, 255), (0, 30, 255), (0, 36, 255), (0, 42, 255),
        (0, 48, 255), (0, 54, 255), (0, 60, 255), (0, 66, 255), (0, 72, 255), (0, 78, 255), (0, 84, 255), (0, 90, 255),
        (0, 96, 255), (0, 102, 255), (0, 108, 255), (0, 114, 255), (0, 120, 255), (0, 126, 255), (0, 131, 255),
        (0, 137, 255), (0, 143, 255), (0, 149, 255), (0, 155, 255), (0, 161, 255), (0, 167, 255), (0, 173, 255),
        (0, 179, 255), (0, 185, 255), (0, 191, 255), (0, 197, 255), (0, 203, 255), (0, 209, 255), (0, 215, 255),
        (0, 221, 255), (0, 227, 255), (0, 233, 255), (0, 239, 255), (0, 245, 255), (0, 251, 255), (0, 255, 253),
        (0, 255, 247), (0, 255, 241), (0, 255, 235), (0, 255, 229), (0, 255, 223), (0, 255, 217), (0, 255, 211),
        (0, 255, 205), (0, 255, 199), (0, 255, 193), (0, 255, 187), (0, 255, 181), (0, 255, 175), (0, 255, 169),
        (0, 255, 163), (0, 255, 157), (0, 255, 151), (0, 255, 145), (0, 255, 139), (0, 255, 133), (0, 255, 128),
        (0, 255, 122), (0, 255, 116), (0, 255, 110), (0, 255, 104), (0, 255, 98), (0, 255, 92), (0, 255, 86),
        (0, 255, 80),
        (0, 255, 74), (0, 255, 68), (0, 255, 62), (0, 255, 56), (0, 255, 50), (0, 255, 44), (0, 255, 38), (0, 255, 32),
        (0, 255, 26), (0, 255, 20), (0, 255, 14), (0, 255, 8), (0, 255, 2), (4, 255, 0), (10, 255, 0), (16, 255, 0),
        (22, 255, 0), (28, 255, 0), (34, 255, 0), (40, 255, 0), (46, 255, 0), (52, 255, 0), (58, 255, 0), (64, 255, 0),
        (70, 255, 0), (76, 255, 0), (82, 255, 0), (88, 255, 0), (94, 255, 0), (100, 255, 0), (106, 255, 0),
        (112, 255, 0),
        (118, 255, 0), (124, 255, 0), (129, 255, 0), (135, 255, 0), (141, 255, 0), (147, 255, 0), (153, 255, 0),
        (159, 255, 0), (165, 255, 0), (171, 255, 0), (177, 255, 0), (183, 255, 0), (189, 255, 0), (195, 255, 0),
        (201, 255, 0), (207, 255, 0), (213, 255, 0), (219, 255, 0), (225, 255, 0), (231, 255, 0), (237, 255, 0),
        (243, 255, 0), (249, 255, 0), (255, 255, 0), (255, 249, 0), (255, 243, 0), (255, 237, 0), (255, 231, 0),
        (255, 225, 0), (255, 219, 0), (255, 213, 0), (255, 207, 0), (255, 201, 0), (255, 195, 0), (255, 189, 0),
        (255, 183, 0), (255, 177, 0), (255, 171, 0), (255, 165, 0), (255, 159, 0), (255, 153, 0), (255, 147, 0),
        (255, 141, 0), (255, 135, 0), (255, 129, 0), (255, 124, 0), (255, 118, 0), (255, 112, 0), (255, 106, 0),
        (255, 100, 0), (255, 94, 0), (255, 88, 0), (255, 82, 0), (255, 76, 0), (255, 70, 0), (255, 64, 0), (255, 58, 0),
        (255, 52, 0), (255, 46, 0), (255, 40, 0), (255, 34, 0), (255, 28, 0), (255, 22, 0), (255, 16, 0), (255, 10, 0),
        (255, 4, 0), (255, 0, 2), (255, 0, 8), (255, 0, 14), (255, 0, 20), (255, 0, 26), (255, 0, 32), (255, 0, 38),
        (255, 0, 44), (255, 0, 50), (255, 0, 56), (255, 0, 62), (255, 0, 68), (255, 0, 74), (255, 0, 80), (255, 0, 86),
        (255, 0, 92), (255, 0, 98), (255, 0, 104), (255, 0, 110), (255, 0, 116), (255, 0, 122), (255, 0, 128),
        (255, 0, 133), (255, 0, 139), (255, 0, 145), (255, 0, 151), (255, 0, 157), (255, 0, 163), (255, 0, 169),
        (255, 0, 175), (255, 0, 181), (255, 0, 187), (255, 0, 193), (255, 0, 199), (255, 0, 205), (255, 0, 211),
        (255, 0, 217), (255, 0, 223), (255, 0, 229), (255, 0, 235), (255, 0, 241), (255, 0, 247), (255, 0, 253),
        (251, 0, 255), (245, 0, 255), (239, 0, 255), (233, 0, 255), (227, 0, 255), (221, 0, 255), (215, 0, 255),
        (209, 0, 255), (203, 0, 255), (197, 0, 255), (191, 0, 255), (185, 0, 255), (179, 0, 255), (173, 0, 255),
        (167, 0, 255), (161, 0, 255), (155, 0, 255), (149, 0, 255), (143, 0, 255), (137, 0, 255), (131, 0, 255),
        (126, 0, 255), (120, 0, 255), (114, 0, 255), (108, 0, 255), (102, 0, 255), (96, 0, 255), (90, 0, 255),
        (84, 0, 255),
        (78, 0, 255), (72, 0, 255), (66, 0, 255), (60, 0, 255), (54, 0, 255), (48, 0, 255), (42, 0, 255), (36, 0, 255),
        (30, 0, 255), (24, 0, 255), (18, 0, 255), (12, 0, 255), (6, 0, 255))

    if num == 1:
        color = rainbow[randrange(0, 255)]
        return [color]
    else:
        dist = int(len(rainbow) / num)
        colors = []
        index = 0
        for i in range(1, num + 1):
            colors.append(rainbow[index])
            index += dist
        return colors
