"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpPrivateIntegration = void 0;
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
/**
 * The HTTP Private integration resource for HTTP API
 *
 * @internal
 */
class HttpPrivateIntegration {
    constructor() {
        /**
         * @experimental
         */
        this.httpMethod = aws_apigatewayv2_alpha_1.HttpMethod.ANY;
        /**
         * @experimental
         */
        this.payloadFormatVersion = aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_1_0; // 1.0 is required and is the only supported format
        /**
         * @experimental
         */
        this.integrationType = aws_apigatewayv2_alpha_1.HttpIntegrationType.HTTP_PROXY;
        /**
         * @experimental
         */
        this.connectionType = aws_apigatewayv2_alpha_1.HttpConnectionType.VPC_LINK;
    }
    /**
     * Adds a vpcLink to the API if not passed in the options
     *
     * @internal
     */
    _configureVpcLink(bindOptions, configOptions) {
        let vpcLink = configOptions.vpcLink;
        if (!vpcLink) {
            if (!configOptions.vpc) {
                throw new Error('One of vpcLink or vpc should be provided for private integration');
            }
            vpcLink = bindOptions.route.httpApi.addVpcLink({ vpc: configOptions.vpc });
        }
        return vpcLink;
    }
}
exports.HttpPrivateIntegration = HttpPrivateIntegration;
//# sourceMappingURL=data:application/json;base64,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