import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * A short description of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role#description Role#description}
    */
    readonly description?: string;
    /**
    * Name of the role.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role#name Role#name}
    */
    readonly name: string;
    /**
    * privileges block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role#privileges Role#privileges}
    */
    readonly privileges: RolePrivileges[] | cdktf.IResolvable;
}
export interface RolePrivileges {
    /**
    * The name of the privilege.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role#privilege_name Role#privilege_name}
    */
    readonly privilegeName: string;
    /**
    * The obfuscated ID of the service this privilege is for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/role#service_id Role#service_id}
    */
    readonly serviceId: string;
}
export declare function rolePrivilegesToTerraform(struct?: RolePrivileges | cdktf.IResolvable): any;
export declare class RolePrivilegesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): RolePrivileges | cdktf.IResolvable | undefined;
    set internalValue(value: RolePrivileges | cdktf.IResolvable | undefined);
    private _privilegeName?;
    get privilegeName(): string;
    set privilegeName(value: string);
    get privilegeNameInput(): string | undefined;
    private _serviceId?;
    get serviceId(): string;
    set serviceId(value: string);
    get serviceIdInput(): string | undefined;
}
export declare class RolePrivilegesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: RolePrivileges[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): RolePrivilegesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/role googleworkspace_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/role googleworkspace_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get etag(): string;
    get id(): string;
    get isSuperAdminRole(): cdktf.IResolvable;
    get isSystemRole(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _privileges;
    get privileges(): RolePrivilegesList;
    putPrivileges(value: RolePrivileges[] | cdktf.IResolvable): void;
    get privilegesInput(): cdktf.IResolvable | RolePrivileges[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
