import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface UserConfig extends cdktf.TerraformMetaArguments {
    /**
    * asps.list of the user's alias email addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#aliases User#aliases}
    */
    readonly aliases?: string[];
    /**
    * Indicates if user is archived.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#archived User#archived}
    */
    readonly archived?: boolean | cdktf.IResolvable;
    /**
    * Indicates if the user is forced to change their password at next login. This setting doesn't apply when the user signs in via a third-party identity provider.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#change_password_at_next_login User#change_password_at_next_login}
    */
    readonly changePasswordAtNextLogin?: boolean | cdktf.IResolvable;
    /**
    * Stores the hash format of the password property. We recommend sending the password property value as a base 16 bit hexadecimal-encoded hash value. Set the hashFunction values as either the SHA-1, MD5, or crypt hash format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#hash_function User#hash_function}
    */
    readonly hashFunction?: string;
    /**
    * Defaults to `true`. Indicates if the user's profile is visible in the Google Workspace global address list when the contact sharing feature is enabled for the domain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#include_in_global_address_list User#include_in_global_address_list}
    */
    readonly includeInGlobalAddressList?: boolean | cdktf.IResolvable;
    /**
    * If true, the user's IP address is added to the allow list.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#ip_allowlist User#ip_allowlist}
    */
    readonly ipAllowlist?: boolean | cdktf.IResolvable;
    /**
    * Indicates a user with super admininistrator privileges.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#is_admin User#is_admin}
    */
    readonly isAdmin?: boolean | cdktf.IResolvable;
    /**
    * The full path of the parent organization associated with the user. If the parent organization is the top-level, it is represented as a forward slash (/).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#org_unit_path User#org_unit_path}
    */
    readonly orgUnitPath?: string;
    /**
    * Stores the password for the user account. A password can contain any combination of ASCII characters. A minimum of 8 characters is required. The maximum length is 100 characters. As the API does not return the value of password, this field is write-only, and the value stored in the state will be what is provided in the configuration. The field is required on create and will be empty on import.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#password User#password}
    */
    readonly password?: string;
    /**
    * The user's primary email address. The primaryEmail must be unique and cannot be an alias of another user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary_email User#primary_email}
    */
    readonly primaryEmail: string;
    /**
    * Recovery email of the user.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#recovery_email User#recovery_email}
    */
    readonly recoveryEmail?: string;
    /**
    * Recovery phone of the user. The phone number must be in the E.164 format, starting with the plus sign (+). Example: +16506661212.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#recovery_phone User#recovery_phone}
    */
    readonly recoveryPhone?: string;
    /**
    * Indicates if user is suspended.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#suspended User#suspended}
    */
    readonly suspended?: boolean | cdktf.IResolvable;
    /**
    * addresses block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#addresses User#addresses}
    */
    readonly addresses?: UserAddresses[] | cdktf.IResolvable;
    /**
    * custom_schemas block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_schemas User#custom_schemas}
    */
    readonly customSchemas?: UserCustomSchemas[] | cdktf.IResolvable;
    /**
    * emails block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#emails User#emails}
    */
    readonly emails?: UserEmails[] | cdktf.IResolvable;
    /**
    * external_ids block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#external_ids User#external_ids}
    */
    readonly externalIds?: UserExternalIds[] | cdktf.IResolvable;
    /**
    * ims block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#ims User#ims}
    */
    readonly ims?: UserIms[] | cdktf.IResolvable;
    /**
    * keywords block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#keywords User#keywords}
    */
    readonly keywords?: UserKeywords[] | cdktf.IResolvable;
    /**
    * languages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#languages User#languages}
    */
    readonly languages?: UserLanguages[] | cdktf.IResolvable;
    /**
    * locations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#locations User#locations}
    */
    readonly locations?: UserLocations[] | cdktf.IResolvable;
    /**
    * name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#name User#name}
    */
    readonly name: UserName;
    /**
    * organizations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#organizations User#organizations}
    */
    readonly organizations?: UserOrganizations[] | cdktf.IResolvable;
    /**
    * phones block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#phones User#phones}
    */
    readonly phones?: UserPhones[] | cdktf.IResolvable;
    /**
    * posix_accounts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#posix_accounts User#posix_accounts}
    */
    readonly posixAccounts?: UserPosixAccounts[] | cdktf.IResolvable;
    /**
    * relations block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#relations User#relations}
    */
    readonly relations?: UserRelations[] | cdktf.IResolvable;
    /**
    * ssh_public_keys block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#ssh_public_keys User#ssh_public_keys}
    */
    readonly sshPublicKeys?: UserSshPublicKeys[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#timeouts User#timeouts}
    */
    readonly timeouts?: UserTimeouts;
    /**
    * websites block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#websites User#websites}
    */
    readonly websites?: UserWebsites[] | cdktf.IResolvable;
}
export interface UserAddresses {
    /**
    * Country
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#country User#country}
    */
    readonly country?: string;
    /**
    * The country code. Uses the ISO 3166-1 standard.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#country_code User#country_code}
    */
    readonly countryCode?: string;
    /**
    * If the address type is custom, this property contains the custom value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * For extended addresses, such as an address that includes a sub-region.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#extended_address User#extended_address}
    */
    readonly extendedAddress?: string;
    /**
    * A full and unstructured postal address. This is not synced with the structured address fields.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#formatted User#formatted}
    */
    readonly formatted?: string;
    /**
    * The town or city of the address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#locality User#locality}
    */
    readonly locality?: string;
    /**
    * The post office box, if present.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#po_box User#po_box}
    */
    readonly poBox?: string;
    /**
    * The ZIP or postal code, if applicable.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#postal_code User#postal_code}
    */
    readonly postalCode?: string;
    /**
    * If this is the user's primary address. The addresses list may contain only one primary address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * The abbreviated province or state.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#region User#region}
    */
    readonly region?: string;
    /**
    * Indicates if the user-supplied address was formatted. Formatted addresses are not currently supported.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#source_is_structured User#source_is_structured}
    */
    readonly sourceIsStructured?: boolean | cdktf.IResolvable;
    /**
    * The street address, such as 1600 Amphitheatre Parkway. Whitespace within the string is ignored; however, newlines are significant.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#street_address User#street_address}
    */
    readonly streetAddress?: string;
    /**
    * The address type. Acceptable values: `custom`, `home`, `other`, `work`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
}
export declare function userAddressesToTerraform(struct?: UserAddresses | cdktf.IResolvable): any;
export declare class UserAddressesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserAddresses | cdktf.IResolvable | undefined;
    set internalValue(value: UserAddresses | cdktf.IResolvable | undefined);
    private _country?;
    get country(): string;
    set country(value: string);
    resetCountry(): void;
    get countryInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _extendedAddress?;
    get extendedAddress(): string;
    set extendedAddress(value: string);
    resetExtendedAddress(): void;
    get extendedAddressInput(): string | undefined;
    private _formatted?;
    get formatted(): string;
    set formatted(value: string);
    resetFormatted(): void;
    get formattedInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _poBox?;
    get poBox(): string;
    set poBox(value: string);
    resetPoBox(): void;
    get poBoxInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _sourceIsStructured?;
    get sourceIsStructured(): boolean | cdktf.IResolvable;
    set sourceIsStructured(value: boolean | cdktf.IResolvable);
    resetSourceIsStructured(): void;
    get sourceIsStructuredInput(): boolean | cdktf.IResolvable | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class UserAddressesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserAddresses[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserAddressesOutputReference;
}
export interface UserCustomSchemas {
    /**
    * The name of the schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#schema_name User#schema_name}
    */
    readonly schemaName: string;
    /**
    * JSON encoded map that represents key/value pairs that correspond to the given schema.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#schema_values User#schema_values}
    */
    readonly schemaValues: {
        [key: string]: string;
    };
}
export declare function userCustomSchemasToTerraform(struct?: UserCustomSchemas | cdktf.IResolvable): any;
export declare class UserCustomSchemasOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserCustomSchemas | cdktf.IResolvable | undefined;
    set internalValue(value: UserCustomSchemas | cdktf.IResolvable | undefined);
    private _schemaName?;
    get schemaName(): string;
    set schemaName(value: string);
    get schemaNameInput(): string | undefined;
    private _schemaValues?;
    get schemaValues(): {
        [key: string]: string;
    };
    set schemaValues(value: {
        [key: string]: string;
    });
    get schemaValuesInput(): {
        [key: string]: string;
    } | undefined;
}
export declare class UserCustomSchemasList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserCustomSchemas[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserCustomSchemasOutputReference;
}
export interface UserEmails {
    /**
    * The user's email address. Also serves as the email ID. This value can be the user's primary email address or an alias.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#address User#address}
    */
    readonly address?: string;
    /**
    * If the value of type is custom, this property contains the custom type string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * Defaults to `false`. Indicates if this is the user's primary email. Only one entry can be marked as primary.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * The type of the email account. Acceptable values: `custom`, `home`, `other`, `work`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
}
export declare function userEmailsToTerraform(struct?: UserEmails | cdktf.IResolvable): any;
export declare class UserEmailsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserEmails | cdktf.IResolvable | undefined;
    set internalValue(value: UserEmails | cdktf.IResolvable | undefined);
    private _address?;
    get address(): string;
    set address(value: string);
    resetAddress(): void;
    get addressInput(): string | undefined;
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class UserEmailsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserEmails[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserEmailsOutputReference;
}
export interface UserExternalIds {
    /**
    * If the external ID type is custom, this property contains the custom value and must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * The type of external ID. If set to custom, customType must also be set. Acceptable values: `account`, `custom`, `customer`, `login_id`, `network`, `organization`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
    /**
    * The value of the ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#value User#value}
    */
    readonly value: string;
}
export declare function userExternalIdsToTerraform(struct?: UserExternalIds | cdktf.IResolvable): any;
export declare class UserExternalIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserExternalIds | cdktf.IResolvable | undefined;
    set internalValue(value: UserExternalIds | cdktf.IResolvable | undefined);
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserExternalIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserExternalIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserExternalIdsOutputReference;
}
export interface UserIms {
    /**
    * If the protocol value is custom_protocol, this property holds the custom protocol's string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_protocol User#custom_protocol}
    */
    readonly customProtocol?: string;
    /**
    * If the IM type is custom, this property holds the custom type string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * The user's IM network ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#im User#im}
    */
    readonly im?: string;
    /**
    * If this is the user's primary IM. Only one entry in the IM list can have a value of true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * An IM protocol identifies the IM network. The value can be a custom network or the standard network. Acceptable values: `aim`, `custom_protocol`, `gtalk`, `icq`, `jabber`, `msn`, `net_meeting`, `qq`, `skype`, `yahoo`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#protocol User#protocol}
    */
    readonly protocol: string;
    /**
    * Acceptable values: `custom`, `home`, `other`, `work`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
}
export declare function userImsToTerraform(struct?: UserIms | cdktf.IResolvable): any;
export declare class UserImsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserIms | cdktf.IResolvable | undefined;
    set internalValue(value: UserIms | cdktf.IResolvable | undefined);
    private _customProtocol?;
    get customProtocol(): string;
    set customProtocol(value: string);
    resetCustomProtocol(): void;
    get customProtocolInput(): string | undefined;
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _im?;
    get im(): string;
    set im(value: string);
    resetIm(): void;
    get imInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class UserImsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserIms[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserImsOutputReference;
}
export interface UserKeywords {
    /**
    * Custom Type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * Each entry can have a type which indicates standard type of that entry. For example, keyword could be of type occupation or outlook. In addition to the standard type, an entry can have a custom type and can give it any name. Such types should have the CUSTOM value as type and also have a customType value. Acceptable values: `custom`, `mission`, `occupation`, `outlook`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
    /**
    * Keyword.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#value User#value}
    */
    readonly value: string;
}
export declare function userKeywordsToTerraform(struct?: UserKeywords | cdktf.IResolvable): any;
export declare class UserKeywordsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserKeywords | cdktf.IResolvable | undefined;
    set internalValue(value: UserKeywords | cdktf.IResolvable | undefined);
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserKeywordsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserKeywords[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserKeywordsOutputReference;
}
export interface UserLanguages {
    /**
    * Other language. A user can provide their own language name if there is no corresponding Google III language code. If this is set, LanguageCode can't be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_language User#custom_language}
    */
    readonly customLanguage?: string;
    /**
    * Defaults to `en`. Language Code. Should be used for storing Google III LanguageCode string representation for language. Illegal values cause SchemaException.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#language_code User#language_code}
    */
    readonly languageCode?: string;
    /**
    * Defaults to `preferred`. If present, controls whether the specified languageCode is the user's preferred language. Allowed values are `preferred` and `not_preferred`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#preference User#preference}
    */
    readonly preference?: string;
}
export declare function userLanguagesToTerraform(struct?: UserLanguages | cdktf.IResolvable): any;
export declare class UserLanguagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserLanguages | cdktf.IResolvable | undefined;
    set internalValue(value: UserLanguages | cdktf.IResolvable | undefined);
    private _customLanguage?;
    get customLanguage(): string;
    set customLanguage(value: string);
    resetCustomLanguage(): void;
    get customLanguageInput(): string | undefined;
    private _languageCode?;
    get languageCode(): string;
    set languageCode(value: string);
    resetLanguageCode(): void;
    get languageCodeInput(): string | undefined;
    private _preference?;
    get preference(): string;
    set preference(value: string);
    resetPreference(): void;
    get preferenceInput(): string | undefined;
}
export declare class UserLanguagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserLanguages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserLanguagesOutputReference;
}
export interface UserLocations {
    /**
    * Textual location. This is most useful for display purposes to concisely describe the location. For example, Mountain View, CA or Near Seattle.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#area User#area}
    */
    readonly area?: string;
    /**
    * Building identifier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#building_id User#building_id}
    */
    readonly buildingId?: string;
    /**
    * If the location type is custom, this property contains the custom value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * Most specific textual code of individual desk location.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#desk_code User#desk_code}
    */
    readonly deskCode?: string;
    /**
    * Floor name/number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#floor_name User#floor_name}
    */
    readonly floorName?: string;
    /**
    * Floor section. More specific location within the floor. For example, if a floor is divided into sections A, B, and C, this field would identify one of those values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#floor_section User#floor_section}
    */
    readonly floorSection?: string;
    /**
    * The location type. Acceptable values: `custom`, `default`, `desk`
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
}
export declare function userLocationsToTerraform(struct?: UserLocations | cdktf.IResolvable): any;
export declare class UserLocationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserLocations | cdktf.IResolvable | undefined;
    set internalValue(value: UserLocations | cdktf.IResolvable | undefined);
    private _area?;
    get area(): string;
    set area(value: string);
    resetArea(): void;
    get areaInput(): string | undefined;
    private _buildingId?;
    get buildingId(): string;
    set buildingId(value: string);
    resetBuildingId(): void;
    get buildingIdInput(): string | undefined;
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _deskCode?;
    get deskCode(): string;
    set deskCode(value: string);
    resetDeskCode(): void;
    get deskCodeInput(): string | undefined;
    private _floorName?;
    get floorName(): string;
    set floorName(value: string);
    resetFloorName(): void;
    get floorNameInput(): string | undefined;
    private _floorSection?;
    get floorSection(): string;
    set floorSection(value: string);
    resetFloorSection(): void;
    get floorSectionInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class UserLocationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserLocations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserLocationsOutputReference;
}
export interface UserName {
    /**
    * The user's last name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#family_name User#family_name}
    */
    readonly familyName: string;
    /**
    * The user's first name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#given_name User#given_name}
    */
    readonly givenName?: string;
}
export declare function userNameToTerraform(struct?: UserNameOutputReference | UserName): any;
export declare class UserNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): UserName | undefined;
    set internalValue(value: UserName | undefined);
    private _familyName?;
    get familyName(): string;
    set familyName(value: string);
    get familyNameInput(): string | undefined;
    get fullName(): string;
    private _givenName?;
    get givenName(): string;
    set givenName(value: string);
    resetGivenName(): void;
    get givenNameInput(): string | undefined;
}
export interface UserOrganizations {
    /**
    * The cost center of the user's organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#cost_center User#cost_center}
    */
    readonly costCenter?: string;
    /**
    * If the value of type is custom, this property contains the custom value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * Specifies the department within the organization, such as sales or engineering.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#department User#department}
    */
    readonly department?: string;
    /**
    * The description of the organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#description User#description}
    */
    readonly description?: string;
    /**
    * The domain the organization belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#domain User#domain}
    */
    readonly domain?: string;
    /**
    * The full-time equivalent millipercent within the organization (100000 = 100%)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#full_time_equivalent User#full_time_equivalent}
    */
    readonly fullTimeEquivalent?: number;
    /**
    * The physical location of the organization. This does not need to be a fully qualified address.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#location User#location}
    */
    readonly location?: string;
    /**
    * The name of the organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#name User#name}
    */
    readonly name?: string;
    /**
    * Indicates if this is the user's primary organization. A user may only have one primary organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Text string symbol of the organization. For example, the text symbol for Google is GOOG.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#symbol User#symbol}
    */
    readonly symbol?: string;
    /**
    * The user's title within the organization. For example, member or engineer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#title User#title}
    */
    readonly title?: string;
    /**
    * The type of organization. Acceptable values: `domain_only`, `school`, `unknown`, `work`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
}
export declare function userOrganizationsToTerraform(struct?: UserOrganizations | cdktf.IResolvable): any;
export declare class UserOrganizationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserOrganizations | cdktf.IResolvable | undefined;
    set internalValue(value: UserOrganizations | cdktf.IResolvable | undefined);
    private _costCenter?;
    get costCenter(): string;
    set costCenter(value: string);
    resetCostCenter(): void;
    get costCenterInput(): string | undefined;
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _department?;
    get department(): string;
    set department(value: string);
    resetDepartment(): void;
    get departmentInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _domain?;
    get domain(): string;
    set domain(value: string);
    resetDomain(): void;
    get domainInput(): string | undefined;
    private _fullTimeEquivalent?;
    get fullTimeEquivalent(): number;
    set fullTimeEquivalent(value: number);
    resetFullTimeEquivalent(): void;
    get fullTimeEquivalentInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _symbol?;
    get symbol(): string;
    set symbol(value: string);
    resetSymbol(): void;
    get symbolInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class UserOrganizationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserOrganizations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserOrganizationsOutputReference;
}
export interface UserPhones {
    /**
    * If the phone number type is custom, this property contains the custom value and must be set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * Indicates if this is the user's primary phone number. A user may only have one primary phone number.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * The type of phone number. Acceptable values: `assistant`, `callback`, `car`, `company_main` , `custom`, `grand_central`, `home`, `home_fax`, `isdn`, `main`, `mobile`, `other`, `other_fax`, `pager`, `radio`, `telex`, `tty_tdd`, `work`, `work_fax`, `work_mobile`, `work_pager`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
    /**
    * A human-readable phone number. It may be in any telephone number format.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#value User#value}
    */
    readonly value: string;
}
export declare function userPhonesToTerraform(struct?: UserPhones | cdktf.IResolvable): any;
export declare class UserPhonesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserPhones | cdktf.IResolvable | undefined;
    set internalValue(value: UserPhones | cdktf.IResolvable | undefined);
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserPhonesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserPhones[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserPhonesOutputReference;
}
export interface UserPosixAccounts {
    /**
    * A POSIX account field identifier.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#account_id User#account_id}
    */
    readonly accountId?: string;
    /**
    * The GECOS (user information) for this account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#gecos User#gecos}
    */
    readonly gecos?: string;
    /**
    * The default group ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#gid User#gid}
    */
    readonly gid?: string;
    /**
    * The path to the home directory for this account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#home_directory User#home_directory}
    */
    readonly homeDirectory?: string;
    /**
    * The operating system type for this account. Acceptable values: `linux`, `unspecified`, `windows`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#operating_system_type User#operating_system_type}
    */
    readonly operatingSystemType?: string;
    /**
    * If this is user's primary account within the SystemId.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * The path to the login shell for this account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#shell User#shell}
    */
    readonly shell?: string;
    /**
    * System identifier for which account Username or Uid apply to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#system_id User#system_id}
    */
    readonly systemId?: string;
    /**
    * The POSIX compliant user ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#uid User#uid}
    */
    readonly uid?: string;
    /**
    * The username of the account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#username User#username}
    */
    readonly username?: string;
}
export declare function userPosixAccountsToTerraform(struct?: UserPosixAccounts | cdktf.IResolvable): any;
export declare class UserPosixAccountsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserPosixAccounts | cdktf.IResolvable | undefined;
    set internalValue(value: UserPosixAccounts | cdktf.IResolvable | undefined);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    resetAccountId(): void;
    get accountIdInput(): string | undefined;
    private _gecos?;
    get gecos(): string;
    set gecos(value: string);
    resetGecos(): void;
    get gecosInput(): string | undefined;
    private _gid?;
    get gid(): string;
    set gid(value: string);
    resetGid(): void;
    get gidInput(): string | undefined;
    private _homeDirectory?;
    get homeDirectory(): string;
    set homeDirectory(value: string);
    resetHomeDirectory(): void;
    get homeDirectoryInput(): string | undefined;
    private _operatingSystemType?;
    get operatingSystemType(): string;
    set operatingSystemType(value: string);
    resetOperatingSystemType(): void;
    get operatingSystemTypeInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _shell?;
    get shell(): string;
    set shell(value: string);
    resetShell(): void;
    get shellInput(): string | undefined;
    private _systemId?;
    get systemId(): string;
    set systemId(value: string);
    resetSystemId(): void;
    get systemIdInput(): string | undefined;
    private _uid?;
    get uid(): string;
    set uid(value: string);
    resetUid(): void;
    get uidInput(): string | undefined;
    private _username?;
    get username(): string;
    set username(value: string);
    resetUsername(): void;
    get usernameInput(): string | undefined;
}
export declare class UserPosixAccountsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserPosixAccounts[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserPosixAccountsOutputReference;
}
export interface UserRelations {
    /**
    * If the value of type is custom, this property contains the custom type string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * The type of relation. Acceptable values: `admin_assistant`, `assistant`, `brother`, `child`, `custom`, `domestic_partner`, `dotted_line_manager`, `exec_assistant`, `father`, `friend`, `manager`, `mother`, `parent`, `partner`, `referred_by`, `relative`, `sister`, `spouse`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
    /**
    * The name of the person the user is related to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#value User#value}
    */
    readonly value: string;
}
export declare function userRelationsToTerraform(struct?: UserRelations | cdktf.IResolvable): any;
export declare class UserRelationsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserRelations | cdktf.IResolvable | undefined;
    set internalValue(value: UserRelations | cdktf.IResolvable | undefined);
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserRelationsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserRelations[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserRelationsOutputReference;
}
export interface UserSshPublicKeys {
    /**
    * An expiration time in microseconds since epoch.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#expiration_time_usec User#expiration_time_usec}
    */
    readonly expirationTimeUsec?: string;
    /**
    * An SSH public key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#key User#key}
    */
    readonly key: string;
}
export declare function userSshPublicKeysToTerraform(struct?: UserSshPublicKeys | cdktf.IResolvable): any;
export declare class UserSshPublicKeysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserSshPublicKeys | cdktf.IResolvable | undefined;
    set internalValue(value: UserSshPublicKeys | cdktf.IResolvable | undefined);
    private _expirationTimeUsec?;
    get expirationTimeUsec(): string;
    set expirationTimeUsec(value: string);
    resetExpirationTimeUsec(): void;
    get expirationTimeUsecInput(): string | undefined;
    get fingerprint(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
}
export declare class UserSshPublicKeysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserSshPublicKeys[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserSshPublicKeysOutputReference;
}
export interface UserTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#create User#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#update User#update}
    */
    readonly update?: string;
}
export declare function userTimeoutsToTerraform(struct?: UserTimeoutsOutputReference | UserTimeouts | cdktf.IResolvable): any;
export declare class UserTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): UserTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: UserTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface UserWebsites {
    /**
    * The custom type. Only used if the type is custom.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#custom_type User#custom_type}
    */
    readonly customType?: string;
    /**
    * If this is user's primary website or not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#primary User#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * The type or purpose of the website. For example, a website could be labeled as home or blog. Alternatively, an entry can have a custom type Custom types must have a customType value. Acceptable values: `app_install_page`, `blog`, `custom`, `ftp` , `home`, `home_page`, `other`, `profile`, `reservations`, `resume`, `work`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#type User#type}
    */
    readonly type: string;
    /**
    * The URL of the website.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/googleworkspace/r/user#value User#value}
    */
    readonly value: string;
}
export declare function userWebsitesToTerraform(struct?: UserWebsites | cdktf.IResolvable): any;
export declare class UserWebsitesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): UserWebsites | cdktf.IResolvable | undefined;
    set internalValue(value: UserWebsites | cdktf.IResolvable | undefined);
    private _customType?;
    get customType(): string;
    set customType(value: string);
    resetCustomType(): void;
    get customTypeInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class UserWebsitesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: UserWebsites[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): UserWebsitesOutputReference;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/googleworkspace/r/user googleworkspace_user}
*/
export declare class User extends cdktf.TerraformResource {
    static readonly tfResourceType = "googleworkspace_user";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/googleworkspace/r/user googleworkspace_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options UserConfig
    */
    constructor(scope: Construct, id: string, config: UserConfig);
    get agreedToTerms(): cdktf.IResolvable;
    private _aliases?;
    get aliases(): string[];
    set aliases(value: string[]);
    resetAliases(): void;
    get aliasesInput(): string[] | undefined;
    private _archived?;
    get archived(): boolean | cdktf.IResolvable;
    set archived(value: boolean | cdktf.IResolvable);
    resetArchived(): void;
    get archivedInput(): boolean | cdktf.IResolvable | undefined;
    private _changePasswordAtNextLogin?;
    get changePasswordAtNextLogin(): boolean | cdktf.IResolvable;
    set changePasswordAtNextLogin(value: boolean | cdktf.IResolvable);
    resetChangePasswordAtNextLogin(): void;
    get changePasswordAtNextLoginInput(): boolean | cdktf.IResolvable | undefined;
    get creationTime(): string;
    get customerId(): string;
    get deletionTime(): string;
    get etag(): string;
    private _hashFunction?;
    get hashFunction(): string;
    set hashFunction(value: string);
    resetHashFunction(): void;
    get hashFunctionInput(): string | undefined;
    get id(): string;
    private _includeInGlobalAddressList?;
    get includeInGlobalAddressList(): boolean | cdktf.IResolvable;
    set includeInGlobalAddressList(value: boolean | cdktf.IResolvable);
    resetIncludeInGlobalAddressList(): void;
    get includeInGlobalAddressListInput(): boolean | cdktf.IResolvable | undefined;
    private _ipAllowlist?;
    get ipAllowlist(): boolean | cdktf.IResolvable;
    set ipAllowlist(value: boolean | cdktf.IResolvable);
    resetIpAllowlist(): void;
    get ipAllowlistInput(): boolean | cdktf.IResolvable | undefined;
    private _isAdmin?;
    get isAdmin(): boolean | cdktf.IResolvable;
    set isAdmin(value: boolean | cdktf.IResolvable);
    resetIsAdmin(): void;
    get isAdminInput(): boolean | cdktf.IResolvable | undefined;
    get isDelegatedAdmin(): cdktf.IResolvable;
    get isEnforcedIn2StepVerification(): cdktf.IResolvable;
    get isEnrolledIn2StepVerification(): cdktf.IResolvable;
    get isMailboxSetup(): cdktf.IResolvable;
    get lastLoginTime(): string;
    get nonEditableAliases(): string[];
    private _orgUnitPath?;
    get orgUnitPath(): string;
    set orgUnitPath(value: string);
    resetOrgUnitPath(): void;
    get orgUnitPathInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _primaryEmail?;
    get primaryEmail(): string;
    set primaryEmail(value: string);
    get primaryEmailInput(): string | undefined;
    private _recoveryEmail?;
    get recoveryEmail(): string;
    set recoveryEmail(value: string);
    resetRecoveryEmail(): void;
    get recoveryEmailInput(): string | undefined;
    private _recoveryPhone?;
    get recoveryPhone(): string;
    set recoveryPhone(value: string);
    resetRecoveryPhone(): void;
    get recoveryPhoneInput(): string | undefined;
    private _suspended?;
    get suspended(): boolean | cdktf.IResolvable;
    set suspended(value: boolean | cdktf.IResolvable);
    resetSuspended(): void;
    get suspendedInput(): boolean | cdktf.IResolvable | undefined;
    get suspensionReason(): string;
    get thumbnailPhotoEtag(): string;
    get thumbnailPhotoUrl(): string;
    private _addresses;
    get addresses(): UserAddressesList;
    putAddresses(value: UserAddresses[] | cdktf.IResolvable): void;
    resetAddresses(): void;
    get addressesInput(): cdktf.IResolvable | UserAddresses[] | undefined;
    private _customSchemas;
    get customSchemas(): UserCustomSchemasList;
    putCustomSchemas(value: UserCustomSchemas[] | cdktf.IResolvable): void;
    resetCustomSchemas(): void;
    get customSchemasInput(): cdktf.IResolvable | UserCustomSchemas[] | undefined;
    private _emails;
    get emails(): UserEmailsList;
    putEmails(value: UserEmails[] | cdktf.IResolvable): void;
    resetEmails(): void;
    get emailsInput(): cdktf.IResolvable | UserEmails[] | undefined;
    private _externalIds;
    get externalIds(): UserExternalIdsList;
    putExternalIds(value: UserExternalIds[] | cdktf.IResolvable): void;
    resetExternalIds(): void;
    get externalIdsInput(): cdktf.IResolvable | UserExternalIds[] | undefined;
    private _ims;
    get ims(): UserImsList;
    putIms(value: UserIms[] | cdktf.IResolvable): void;
    resetIms(): void;
    get imsInput(): cdktf.IResolvable | UserIms[] | undefined;
    private _keywords;
    get keywords(): UserKeywordsList;
    putKeywords(value: UserKeywords[] | cdktf.IResolvable): void;
    resetKeywords(): void;
    get keywordsInput(): cdktf.IResolvable | UserKeywords[] | undefined;
    private _languages;
    get languages(): UserLanguagesList;
    putLanguages(value: UserLanguages[] | cdktf.IResolvable): void;
    resetLanguages(): void;
    get languagesInput(): cdktf.IResolvable | UserLanguages[] | undefined;
    private _locations;
    get locations(): UserLocationsList;
    putLocations(value: UserLocations[] | cdktf.IResolvable): void;
    resetLocations(): void;
    get locationsInput(): cdktf.IResolvable | UserLocations[] | undefined;
    private _name;
    get name(): UserNameOutputReference;
    putName(value: UserName): void;
    get nameInput(): UserName | undefined;
    private _organizations;
    get organizations(): UserOrganizationsList;
    putOrganizations(value: UserOrganizations[] | cdktf.IResolvable): void;
    resetOrganizations(): void;
    get organizationsInput(): cdktf.IResolvable | UserOrganizations[] | undefined;
    private _phones;
    get phones(): UserPhonesList;
    putPhones(value: UserPhones[] | cdktf.IResolvable): void;
    resetPhones(): void;
    get phonesInput(): cdktf.IResolvable | UserPhones[] | undefined;
    private _posixAccounts;
    get posixAccounts(): UserPosixAccountsList;
    putPosixAccounts(value: UserPosixAccounts[] | cdktf.IResolvable): void;
    resetPosixAccounts(): void;
    get posixAccountsInput(): cdktf.IResolvable | UserPosixAccounts[] | undefined;
    private _relations;
    get relations(): UserRelationsList;
    putRelations(value: UserRelations[] | cdktf.IResolvable): void;
    resetRelations(): void;
    get relationsInput(): cdktf.IResolvable | UserRelations[] | undefined;
    private _sshPublicKeys;
    get sshPublicKeys(): UserSshPublicKeysList;
    putSshPublicKeys(value: UserSshPublicKeys[] | cdktf.IResolvable): void;
    resetSshPublicKeys(): void;
    get sshPublicKeysInput(): cdktf.IResolvable | UserSshPublicKeys[] | undefined;
    private _timeouts;
    get timeouts(): UserTimeoutsOutputReference;
    putTimeouts(value: UserTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | UserTimeouts | undefined;
    private _websites;
    get websites(): UserWebsitesList;
    putWebsites(value: UserWebsites[] | cdktf.IResolvable): void;
    resetWebsites(): void;
    get websitesInput(): cdktf.IResolvable | UserWebsites[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
