#!/usr/bin/env python
"""
Setup script for the edx-django-release-util package.
"""

import io

from setuptools import find_packages, setup

import release_util


def load_requirements(*requirements_paths):
    """
    Load all requirements from the specified requirements files.

    Returns:
        list: Requirements file relative path strings
    """
    requirements = set()
    for path in requirements_paths:
        requirements.update(
            line.split('#')[0].strip() for line in open(path).readlines()
            if is_requirement(line.strip())
        )
    return list(requirements)


def is_requirement(line):
    """
    Return True if the requirement line is a package requirement.

    Returns:
        bool: True if the line is not blank, a comment, a URL, or an included file
    """
    return line and not line.startswith(('-r', '#', '-e', 'git+', '-c'))


LONG_DESCRIPTION = io.open('README.rst', encoding='utf-8').read()

setup(
    name='edx-django-release-util',
    version=release_util.__version__,
    description='edx-django-release-util',
    author='edX',
    author_email='oscm@edx.org',
    long_description=LONG_DESCRIPTION,
    license='AGPL 3.0',
    url='http://github.com/edx/edx-django-release-util',
    install_requires=load_requirements('requirements/base.in'),
    packages=find_packages(exclude=['*.test', '*.tests']),
    include_package_data=True,
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Environment :: Web Environment',
        'Topic :: Internet',
        'License :: OSI Approved :: GNU Affero General Public License v3',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.8',
        'Framework :: Django',
        'Framework :: Django :: 2.2',
    ],
)
