# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['knex']

package_data = \
{'': ['*']}

install_requires = \
['regex>=2021.8.28,<2022.0.0']

setup_kwargs = {
    'name': 'knex',
    'version': '0.1.10',
    'description': 'Python library for building composable text parsers',
    'long_description': '# KNEX\n\nPython library for creating chainable data transformers.\n\n## Installation\n\n`pip install knex`\n\n## Supported Transformers\n\n:x: - Planned\n\n:heavy_check_mark: - Implemented\n\n<!-- markdownlint-disable MD013 -->\n| General                           | String                               | Number        | Date                      | Other          |\n| --------------------------------- | ------------------------------------ | ------------- | ------------------------- | -------------- |\n| :heavy_check_mark: Append       | :heavy_check_mark: Base64Decode    | :x: Absolute  | :x: BetweenDates          | :x: ThisOrThat |\n| :heavy_check_mark: Count        | :heavy_check_mark: Base64Encode    | :x: Add       | :x: BetweenHours          | :x: URLDecode  |\n| :heavy_check_mark: FirstElement | :heavy_check_mark: Concat          | :x: Ceil      | :x: DateStringToISOFormat | :x: URLEncode  |\n| :heavy_check_mark: GetField     | :x: Cut                              | :x: Divide    | :x: DateToEpoch           |                |\n| :heavy_check_mark: GetIndex     | :x: DumpJSON                         | :x: Floor     | :x: DateToString          |                |\n| :x: If-Then-Else                  | :x: FromString                       | :x: Modulus   | :x: FormattedDateToEpoch  |\n| :x: IndexOf                       | :x: JSONUnescape                     | :x: Multiply  | :x: ModifyDateTime        |                |\n| :x: Join                          | :heavy_check_mark: Length          | :x: Round     | :x: TimeStampToDate       |                |\n| :x: Jq                            | :x: LoadJSON                         | :x: Subtract  |                           |                |\n| :x: JsonToTable                   | :heavy_check_mark: RegexExtractAll | :x: SumList   |                           |                |\n| :heavy_check_mark: LastElement  | :x: RegexReplace                     | :x: ToPercent |                           |\n| :x: ReverseList                   | :heavy_check_mark: Split           |               |                           |                |\n| :x: SetIfEmpty                    | :x: Substring                        |               |                           |                |\n| :x: Slice                         | :heavy_check_mark: ToLower         |               |                           |                |\n| :x: Sort                          | :x: ToString                         |               |                           |                |\n| :x: Stringify                     | :heavy_check_mark: ToUpper         |               |                           |                |\n| :x: Unique                        | :x: Trim                             |               |                           |                |\n| :x: WhereFieldEquals              |                                      |               |                           |                |\n<!-- markdownlint-enable MD013 -->\n\n## Usage\n\n```python\n>>> from knex.parsers import *\n>>>\n>>> input_data = """\n... Interface             IP-Address      OK?    Method Status          Protocol\n... GigabitEthernet0/1    unassigned      YES    unset  up              up\n... GigabitEthernet0/2    192.168.190.235 YES    unset  up              up\n... GigabitEthernet0/3    unassigned      YES    unset  up              up\n... GigabitEthernet0/4    192.168.191.2   YES    unset  up              up\n... TenGigabitEthernet2/1 unassigned      YES    unset  up              up\n... Virtual36             unassigned      YES    unset  up              up\n... """\n>>>\n>>> pattern = r"\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b"\n>>>\n>>> end = (\n                Start(input_data)\n                > RegexExtractAll(pattern)\n                > GetIndex(0)\n                > Concat("", "/24")\n                > IpNetwork()\n             )\n>>>\n>>> print(end.result)\n192.168.190.0/24\n>>> print(json.dumps(end.history, indent=4))\n[\n    {\n        "parser": "RegexExtractAll",\n        "input": "...omitted for brevity...",\n        "args": {\n            "pattern": "\\\\b\\\\d{1,3}\\\\.\\\\d{1,3}\\\\.\\\\d{1,3}\\\\.\\\\d{1,3}\\\\b"\n        },\n        "error": false,\n        "output": [\n            "192.168.190.235",\n            "192.168.191.2"\n        ]\n    },\n    {\n        "parser": "GetIndex",\n        "input": [\n            "192.168.190.235",\n            "192.168.191.2"\n        ],\n        "args": {\n            "idx": 0\n        },\n        "error": false,\n        "output": "192.168.190.235"\n    },\n    {\n        "parser": "Concat",\n        "input": "192.168.190.235",\n        "args": {\n            "prefix": "",\n            "suffix": "/24"\n        },\n        "error": false,\n        "output": "192.168.190.235/24"\n    },\n    {\n        "parser": "IpNetwork",\n        "input": "192.168.190.235/24",\n        "args": {},\n        "error": false,\n        "output": "192.168.190.0/24"\n    }\n]\n>>>\n\n```\n\n## Development\n\n### Environment Setup\n\n1. Install Poetry\n2. Clone the repo: `git clone https://github.com/clay584/knex && cd knex`\n3. Install pre-requisits for developement: `poetry install`\n4. Install PyPI API Key: `poetry config pypi-token.pypi <token>`\n5. Activate the environment: `poetry shell`\n6. Install git pre-commit hook: `pre-commit install && pre-commit autoupdate`\n\n### Publishing to PyPI\n\n1. Run tests and validate coverage: `pytest -v --cov=knex --cov-report html tests`\n2. Commit all changes, and have clean git repo on `main` branch.\n3. Bump version: `bump2version <major|minor|patch>`\n4. Push to git: `git push && git push --tags`\n5. Build for PyPI: `poetry build`\n6. Publish to PyPI: `poetry publish`\n',
    'author': 'Clay Curtis',
    'author_email': 'clay584@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/clay584/knex',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
