# DynamoDB Types
TYPE_STRING = "S"
TYPE_NUMBER = "N"
TYPE_BINARY = "B"
TYPE_STRING_SET = "SS"
TYPE_NUMBER_SET = "NS"
TYPE_BINARY_SET = "BS"
TYPE_NULL = "NULL"
TYPE_BOOLEAN = "BOOL"
TYPE_MAP = "M"
TYPE_LIST = "L"
TYPE_ANY = "?"

ATTRIBUTE_TYPES = (
    TYPE_STRING,
    TYPE_NUMBER,
    TYPE_BINARY,
    TYPE_STRING_SET,
    TYPE_NUMBER_SET,
    TYPE_BINARY_SET,
    TYPE_NULL,
    TYPE_BOOLEAN,
    TYPE_MAP,
    TYPE_LIST,
)

# Condition
CONDITION_COMPARATOR_EQ = "="
CONDITION_COMPARATOR_NEQ = "<>"
CONDITION_COMPARATOR_LT = "<"
CONDITION_COMPARATOR_LTE = "<="
CONDITION_COMPARATOR_GT = ">"
CONDITION_COMPARATOR_GTE = ">="

CONDITION_LOGICAL_AND = "AND"
CONDITION_LOGICAL_OR = "OR"
CONDITION_LOGICAL_NOT = "NOT"

CONDITIONAL_COMPARATOR_IN = "IN"
CONDITIONAL_COMPARATOR_BETWEEN = "BETWEEN"

CONDITION_FUNCTION_ATTRIBUTE_EXISTS = "attribute_exists"
CONDITION_FUNCTION_ATTRIBUTE_NOT_EXISTS = "attribute_not_exists"
CONDITION_FUNCTION_BEGINS_WITH = "begins_with"
CONDITION_FUNCTION_CONTAINS = "contains"
CONDITION_FUNCTION_SIZE = "size"

# DynamoDB Indexes
GLOBAL_SECONDARY_INDEXES = "GlobalSecondaryIndexes"
GLOBAL_SECONDARY_INDEX = "GlobalSecondaryIndex"
LOCAL_SECONDARY_INDEXES = "LocalSecondaryIndexes"
LOCAL_SECONDARY_INDEX = "LocalSecondaryIndex"

TABLE_NAME = "TableName"
TABLE_ITEM = "Item"
CONDITION_EXPRESSION = "ConditionExpression"
CONDITION_EXPRESSION_CHECK_FAILED = "ConditionalCheckFailedException"

RESPONSE_METADATA = "ResponseMetadata"
RESPONSE_HTTP_STATUS = "HTTPStatusCode"
RESPONSE_ERROR = "Error"
RESPONSE_CODE = "Code"

INDEX_STATUS = "IndexStatus"

KEY_SCHEMA = "KeySchema"
KEY_TYPE = "KeyType"
KEY_TYPE_HASH = "HASH"
KEY_TYPE_RANGE = "RANGE"
INDEX_NAME = "IndexName"
ATTRIBUTE_NAME = "AttributeName"
PRIMARY_KEY_NAME = "#"

# Projection constants
PROJECTION = "Projection"
PROJECTION_TYPE = "ProjectionType"
PROJECTION_TYPE_KEYS_ONLY = "KEYS_ONLY"
PROJECTION_TYPE_ALL = "ALL"
PROJECTION_TYPE_INCLUDE = "INCLUDE"
PROJECTION_TYPES = (
    PROJECTION_TYPE_KEYS_ONLY,
    PROJECTION_TYPE_ALL,
    PROJECTION_TYPE_INCLUDE,
)

# Select Types
SELECT_ALL_ATTRIBUTES = "ALL_ATTRIBUTES"
SELECT_ALL_PROJECTED_ATTRIBUTES = "ALL_PROJECTED_ATTRIBUTES"
SELECT_COUNT = "COUNT"
SELECT_SPECIFIC_ATTRIBUTES = "SPECIFIC_ATTRIBUTES"
SELECT_TYPES = (
    SELECT_ALL_ATTRIBUTES,
    SELECT_ALL_PROJECTED_ATTRIBUTES,
    SELECT_COUNT,
    SELECT_SPECIFIC_ATTRIBUTES,
)
