# Generated by Django 2.2.22 on 2021-05-25 11:51

from django.db import migrations

def ensure_slug_unique(apps, schema_editor):
    Chapter = apps.get_model("chapters", "Chapter")
    for chapter in Chapter.objects.all().order_by('-id'):
        slug = chapter.slug
        if Chapter.objects.filter(slug=slug).exclude(id=chapter.id).exists():
            if len(slug) + len(str(chapter.id)) + 1 > 100:
                chapter.slug = f'{slug[:(100-len(str(chapter.id))-1)]}-{chapter.id}'
            else:
                chapter.slug = f'{slug}-{chapter.id}'
            chapter.save(update_fields=['slug'])

class Migration(migrations.Migration):

    dependencies = [
        ('chapters', '0003_officer_email'),
    ]

    operations = [
        migrations.RunPython(ensure_slug_unique),
    ]
