# -*- coding: utf-8 -*-


from django.db import models, migrations
import datetime
import timezone_field.fields
import tagging.fields
import tendenci.apps.user_groups.utils
import django.db.models.deletion
from django.conf import settings


class Migration(migrations.Migration):

    dependencies = [
        ('payments', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('files', '0001_initial'),
        ('user_groups', '0001_initial'),
        ('emails', '0001_initial'),
        ('entities', '0001_initial'),
        ('invoices', '0001_initial'),
        ('meta', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='StandardRegForm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
            options={
                'verbose_name': 'Standard Registration Form',
                'managed': False,
                'verbose_name_plural': 'Standard Registration Form',
            },
        ),
        migrations.CreateModel(
            name='Addon',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=50)),
                ('price', models.DecimalField(default=0, verbose_name='Price', max_digits=21, decimal_places=2)),
                ('allow_anonymous', models.BooleanField(default=False, verbose_name='Public can use')),
                ('allow_user', models.BooleanField(default=False, verbose_name='Signed in user can use')),
                ('allow_member', models.BooleanField(default=False, verbose_name='All members can use')),
                ('status', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='AddonOption',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('title', models.CharField(max_length=100)),
                ('addon', models.ForeignKey(related_name='options', to='events.Addon', on_delete=django.db.models.deletion.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='CustomRegField',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('position', models.IntegerField(default=0, null=True, verbose_name='Position', blank=True)),
                ('label', models.CharField(max_length=255, verbose_name='Label')),
                ('map_to_field', models.CharField(blank=True, max_length=64, null=True, verbose_name='Map to User Field', choices=[('first_name', 'First Name'), ('last_name', 'Last Name'), ('mail_name', 'Mailing Name'), ('address', 'Address'), ('city', 'City'), ('state', 'State'), ('zip', 'Zip Code'), ('country', 'Country'), ('phone', 'Phone'), ('email', 'Email'), ('position_title', 'Position Title'), ('company_name', 'Company Name'), ('meal_option', 'Meal Option'), ('comments', 'Comments')])),
                ('field_type', models.CharField(max_length=64, verbose_name='Type', choices=[('CharField', 'Text'), ('DecimalField', 'Number'), ('CharField/django.forms.Textarea', 'Paragraph Text'), ('BooleanField', 'Checkbox'), ('ChoiceField/django.forms.RadioSelect', 'Single-select - Radio Button'), ('ChoiceField', 'Single-select - From a List'), ('MultipleChoiceField/django.forms.CheckboxSelectMultiple', 'Multi-select - Checkboxes'), ('MultipleChoiceField', 'Multi-select - From a List'), ('EmailVerificationField', 'Email'), ('DateField/django.forms.widgets.SelectDateWidget', 'Date'), ('DateTimeField', 'Date/time'), ('CharField/tendenci.apps.forms_builder.forms.widgets.Description', 'Description'), ('CharField/tendenci.apps.forms_builder.forms.widgets.Header', 'Section Heading')])),
                ('field_function', models.CharField(blank=True, max_length=64, null=True, verbose_name='Special Functionality', choices=[('GroupSubscription', 'Subscribe to Group')])),
                ('required', models.BooleanField(default=True, verbose_name='Required')),
                ('visible', models.BooleanField(default=True, verbose_name='Visible')),
                ('choices', models.CharField(help_text='Comma separated options where applicable', max_length=1000, verbose_name='Choices', blank=True)),
                ('default', models.CharField(help_text='Default value of the field', max_length=1000, verbose_name='Default', blank=True)),
                ('display_on_roster', models.BooleanField(default=False, verbose_name='Show on Roster')),
            ],
            options={
                'ordering': ('position',),
                'verbose_name': 'Field',
                'verbose_name_plural': 'Fields',
            },
        ),
        migrations.CreateModel(
            name='CustomRegFieldEntry',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('value', models.CharField(max_length=2000)),
            ],
        ),
        migrations.CreateModel(
            name='CustomRegForm',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=50, verbose_name='Name')),
                ('notes', models.TextField(max_length=2000, verbose_name='Notes', blank=True)),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('creator_username', models.CharField(max_length=50)),
                ('owner_username', models.CharField(max_length=50)),
                ('status', models.CharField(default='active', max_length=50)),
                ('first_name', models.BooleanField(default=False, verbose_name='First Name')),
                ('last_name', models.BooleanField(default=False, verbose_name='Last Name')),
                ('mail_name', models.BooleanField(default=False, verbose_name='Mail Name')),
                ('address', models.BooleanField(default=False, verbose_name='Address')),
                ('city', models.BooleanField(default=False, verbose_name='City')),
                ('state', models.BooleanField(default=False, verbose_name='State')),
                ('zip', models.BooleanField(default=False, verbose_name='Zip')),
                ('country', models.BooleanField(default=False, verbose_name='Country')),
                ('phone', models.BooleanField(default=False, verbose_name='Phone')),
                ('email', models.BooleanField(default=False, verbose_name='Email')),
                ('position_title', models.BooleanField(default=False, verbose_name='Position Title')),
                ('company_name', models.BooleanField(default=False, verbose_name='Company')),
                ('meal_option', models.BooleanField(default=False, verbose_name='Meal Option')),
                ('comments', models.BooleanField(default=False, verbose_name='Comments')),
                ('creator', models.ForeignKey(related_name='custom_reg_creator', on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, null=True)),
                ('owner', models.ForeignKey(related_name='custom_reg_owner', on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, null=True)),
            ],
            options={
                'verbose_name': 'Custom Registration Form',
                'verbose_name_plural': 'Custom Registration Forms',
            },
        ),
        migrations.CreateModel(
            name='CustomRegFormEntry',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('entry_time', models.DateTimeField(verbose_name='Date/time')),
                ('form', models.ForeignKey(related_name='entries', to='events.CustomRegForm', on_delete=django.db.models.deletion.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='Discount',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=50)),
                ('code', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Event',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('allow_anonymous_view', models.BooleanField(default=True, verbose_name='Public can view')),
                ('allow_user_view', models.BooleanField(default=True, verbose_name='Signed in user can view')),
                ('allow_member_view', models.BooleanField(default=True)),
                ('allow_user_edit', models.BooleanField(default=False, verbose_name='Signed in user can change')),
                ('allow_member_edit', models.BooleanField(default=False)),
                ('create_dt', models.DateTimeField(auto_now_add=True, verbose_name='Created On')),
                ('update_dt', models.DateTimeField(auto_now=True, verbose_name='Last Updated')),
                ('creator_username', models.CharField(max_length=50)),
                ('owner_username', models.CharField(max_length=50)),
                ('status', models.BooleanField(default=True, verbose_name='Active')),
                ('status_detail', models.CharField(default='active', max_length=50)),
                ('guid', models.CharField(max_length=40, editable=False)),
                ('title', models.CharField(max_length=150, blank=True)),
                ('description', models.TextField(blank=True)),
                ('all_day', models.BooleanField(default=False)),
                ('start_dt', models.DateTimeField(default=datetime.datetime(2015, 7, 30, 14, 47, 38, 7993))),
                ('end_dt', models.DateTimeField(default=datetime.datetime(2015, 7, 30, 16, 47, 38, 8026))),
                ('timezone', timezone_field.fields.TimeZoneField(default='US/Central', max_length=100, verbose_name='Time Zone', choices=[('Pacific/Midway', '(GMT-1100) Pacific/Midway'), ('Pacific/Niue', '(GMT-1100) Pacific/Niue'), ('Pacific/Pago_Pago', '(GMT-1100) Pacific/Pago_Pago'), ('Pacific/Honolulu', '(GMT-1000) Pacific/Honolulu'), ('Pacific/Johnston', '(GMT-1000) Pacific/Johnston'), ('Pacific/Rarotonga', '(GMT-1000) Pacific/Rarotonga'), ('Pacific/Tahiti', '(GMT-1000) Pacific/Tahiti'), ('US/Hawaii', '(GMT-1000) US/Hawaii'), ('Pacific/Marquesas', '(GMT-0930) Pacific/Marquesas'), ('America/Adak', '(GMT-0900) America/Adak'), ('Pacific/Gambier', '(GMT-0900) Pacific/Gambier'), ('America/Anchorage', '(GMT-0800) America/Anchorage'), ('America/Juneau', '(GMT-0800) America/Juneau'), ('America/Metlakatla', '(GMT-0800) America/Metlakatla'), ('America/Nome', '(GMT-0800) America/Nome'), ('America/Sitka', '(GMT-0800) America/Sitka'), ('America/Yakutat', '(GMT-0800) America/Yakutat'), ('Pacific/Pitcairn', '(GMT-0800) Pacific/Pitcairn'), ('US/Alaska', '(GMT-0800) US/Alaska'), ('America/Creston', '(GMT-0700) America/Creston'), ('America/Dawson', '(GMT-0700) America/Dawson'), ('America/Dawson_Creek', '(GMT-0700) America/Dawson_Creek'), ('America/Hermosillo', '(GMT-0700) America/Hermosillo'), ('America/Los_Angeles', '(GMT-0700) America/Los_Angeles'), ('America/Phoenix', '(GMT-0700) America/Phoenix'), ('America/Santa_Isabel', '(GMT-0700) America/Santa_Isabel'), ('America/Tijuana', '(GMT-0700) America/Tijuana'), ('America/Vancouver', '(GMT-0700) America/Vancouver'), ('America/Whitehorse', '(GMT-0700) America/Whitehorse'), ('Canada/Pacific', '(GMT-0700) Canada/Pacific'), ('US/Arizona', '(GMT-0700) US/Arizona'), ('US/Pacific', '(GMT-0700) US/Pacific'), ('America/Belize', '(GMT-0600) America/Belize'), ('America/Boise', '(GMT-0600) America/Boise'), ('America/Cambridge_Bay', '(GMT-0600) America/Cambridge_Bay'), ('America/Chihuahua', '(GMT-0600) America/Chihuahua'), ('America/Costa_Rica', '(GMT-0600) America/Costa_Rica'), ('America/Denver', '(GMT-0600) America/Denver'), ('America/Edmonton', '(GMT-0600) America/Edmonton'), ('America/El_Salvador', '(GMT-0600) America/El_Salvador'), ('America/Guatemala', '(GMT-0600) America/Guatemala'), ('America/Inuvik', '(GMT-0600) America/Inuvik'), ('America/Managua', '(GMT-0600) America/Managua'), ('America/Mazatlan', '(GMT-0600) America/Mazatlan'), ('America/Ojinaga', '(GMT-0600) America/Ojinaga'), ('America/Regina', '(GMT-0600) America/Regina'), ('America/Swift_Current', '(GMT-0600) America/Swift_Current'), ('America/Tegucigalpa', '(GMT-0600) America/Tegucigalpa'), ('America/Yellowknife', '(GMT-0600) America/Yellowknife'), ('Canada/Mountain', '(GMT-0600) Canada/Mountain'), ('Pacific/Galapagos', '(GMT-0600) Pacific/Galapagos'), ('US/Mountain', '(GMT-0600) US/Mountain'), ('America/Atikokan', '(GMT-0500) America/Atikokan'), ('America/Bahia_Banderas', '(GMT-0500) America/Bahia_Banderas'), ('America/Bogota', '(GMT-0500) America/Bogota'), ('America/Cancun', '(GMT-0500) America/Cancun'), ('America/Cayman', '(GMT-0500) America/Cayman'), ('America/Chicago', '(GMT-0500) America/Chicago'), ('America/Eirunepe', '(GMT-0500) America/Eirunepe'), ('America/Guayaquil', '(GMT-0500) America/Guayaquil'), ('America/Indiana/Knox', '(GMT-0500) America/Indiana/Knox'), ('America/Indiana/Tell_City', '(GMT-0500) America/Indiana/Tell_City'), ('America/Jamaica', '(GMT-0500) America/Jamaica'), ('America/Lima', '(GMT-0500) America/Lima'), ('America/Matamoros', '(GMT-0500) America/Matamoros'), ('America/Menominee', '(GMT-0500) America/Menominee'), ('America/Merida', '(GMT-0500) America/Merida'), ('America/Mexico_City', '(GMT-0500) America/Mexico_City'), ('America/Monterrey', '(GMT-0500) America/Monterrey'), ('America/North_Dakota/Beulah', '(GMT-0500) America/North_Dakota/Beulah'), ('America/North_Dakota/Center', '(GMT-0500) America/North_Dakota/Center'), ('America/North_Dakota/New_Salem', '(GMT-0500) America/North_Dakota/New_Salem'), ('America/Panama', '(GMT-0500) America/Panama'), ('America/Rainy_River', '(GMT-0500) America/Rainy_River'), ('America/Rankin_Inlet', '(GMT-0500) America/Rankin_Inlet'), ('America/Resolute', '(GMT-0500) America/Resolute'), ('America/Rio_Branco', '(GMT-0500) America/Rio_Branco'), ('America/Winnipeg', '(GMT-0500) America/Winnipeg'), ('Canada/Central', '(GMT-0500) Canada/Central'), ('Pacific/Easter', '(GMT-0500) Pacific/Easter'), ('US/Central', '(GMT-0500) US/Central'), ('America/Caracas', '(GMT-0430) America/Caracas'), ('America/Anguilla', '(GMT-0400) America/Anguilla'), ('America/Antigua', '(GMT-0400) America/Antigua'), ('America/Aruba', '(GMT-0400) America/Aruba'), ('America/Asuncion', '(GMT-0400) America/Asuncion'), ('America/Barbados', '(GMT-0400) America/Barbados'), ('America/Blanc-Sablon', '(GMT-0400) America/Blanc-Sablon'), ('America/Boa_Vista', '(GMT-0400) America/Boa_Vista'), ('America/Campo_Grande', '(GMT-0400) America/Campo_Grande'), ('America/Cuiaba', '(GMT-0400) America/Cuiaba'), ('America/Curacao', '(GMT-0400) America/Curacao'), ('America/Detroit', '(GMT-0400) America/Detroit'), ('America/Dominica', '(GMT-0400) America/Dominica'), ('America/Grand_Turk', '(GMT-0400) America/Grand_Turk'), ('America/Grenada', '(GMT-0400) America/Grenada'), ('America/Guadeloupe', '(GMT-0400) America/Guadeloupe'), ('America/Guyana', '(GMT-0400) America/Guyana'), ('America/Havana', '(GMT-0400) America/Havana'), ('America/Indiana/Indianapolis', '(GMT-0400) America/Indiana/Indianapolis'), ('America/Indiana/Marengo', '(GMT-0400) America/Indiana/Marengo'), ('America/Indiana/Petersburg', '(GMT-0400) America/Indiana/Petersburg'), ('America/Indiana/Vevay', '(GMT-0400) America/Indiana/Vevay'), ('America/Indiana/Vincennes', '(GMT-0400) America/Indiana/Vincennes'), ('America/Indiana/Winamac', '(GMT-0400) America/Indiana/Winamac'), ('America/Iqaluit', '(GMT-0400) America/Iqaluit'), ('America/Kentucky/Louisville', '(GMT-0400) America/Kentucky/Louisville'), ('America/Kentucky/Monticello', '(GMT-0400) America/Kentucky/Monticello'), ('America/Kralendijk', '(GMT-0400) America/Kralendijk'), ('America/La_Paz', '(GMT-0400) America/La_Paz'), ('America/Lower_Princes', '(GMT-0400) America/Lower_Princes'), ('America/Manaus', '(GMT-0400) America/Manaus'), ('America/Marigot', '(GMT-0400) America/Marigot'), ('America/Martinique', '(GMT-0400) America/Martinique'), ('America/Montserrat', '(GMT-0400) America/Montserrat'), ('America/Nassau', '(GMT-0400) America/Nassau'), ('America/New_York', '(GMT-0400) America/New_York'), ('America/Nipigon', '(GMT-0400) America/Nipigon'), ('America/Pangnirtung', '(GMT-0400) America/Pangnirtung'), ('America/Port-au-Prince', '(GMT-0400) America/Port-au-Prince'), ('America/Port_of_Spain', '(GMT-0400) America/Port_of_Spain'), ('America/Porto_Velho', '(GMT-0400) America/Porto_Velho'), ('America/Puerto_Rico', '(GMT-0400) America/Puerto_Rico'), ('America/Santo_Domingo', '(GMT-0400) America/Santo_Domingo'), ('America/St_Barthelemy', '(GMT-0400) America/St_Barthelemy'), ('America/St_Kitts', '(GMT-0400) America/St_Kitts'), ('America/St_Lucia', '(GMT-0400) America/St_Lucia'), ('America/St_Thomas', '(GMT-0400) America/St_Thomas'), ('America/St_Vincent', '(GMT-0400) America/St_Vincent'), ('America/Thunder_Bay', '(GMT-0400) America/Thunder_Bay'), ('America/Toronto', '(GMT-0400) America/Toronto'), ('America/Tortola', '(GMT-0400) America/Tortola'), ('Canada/Eastern', '(GMT-0400) Canada/Eastern'), ('US/Eastern', '(GMT-0400) US/Eastern'), ('America/Araguaina', '(GMT-0300) America/Araguaina'), ('America/Argentina/Buenos_Aires', '(GMT-0300) America/Argentina/Buenos_Aires'), ('America/Argentina/Catamarca', '(GMT-0300) America/Argentina/Catamarca'), ('America/Argentina/Cordoba', '(GMT-0300) America/Argentina/Cordoba'), ('America/Argentina/Jujuy', '(GMT-0300) America/Argentina/Jujuy'), ('America/Argentina/La_Rioja', '(GMT-0300) America/Argentina/La_Rioja'), ('America/Argentina/Mendoza', '(GMT-0300) America/Argentina/Mendoza'), ('America/Argentina/Rio_Gallegos', '(GMT-0300) America/Argentina/Rio_Gallegos'), ('America/Argentina/Salta', '(GMT-0300) America/Argentina/Salta'), ('America/Argentina/San_Juan', '(GMT-0300) America/Argentina/San_Juan'), ('America/Argentina/San_Luis', '(GMT-0300) America/Argentina/San_Luis'), ('America/Argentina/Tucuman', '(GMT-0300) America/Argentina/Tucuman'), ('America/Argentina/Ushuaia', '(GMT-0300) America/Argentina/Ushuaia'), ('America/Bahia', '(GMT-0300) America/Bahia'), ('America/Belem', '(GMT-0300) America/Belem'), ('America/Cayenne', '(GMT-0300) America/Cayenne'), ('America/Fortaleza', '(GMT-0300) America/Fortaleza'), ('America/Glace_Bay', '(GMT-0300) America/Glace_Bay'), ('America/Goose_Bay', '(GMT-0300) America/Goose_Bay'), ('America/Halifax', '(GMT-0300) America/Halifax'), ('America/Maceio', '(GMT-0300) America/Maceio'), ('America/Moncton', '(GMT-0300) America/Moncton'), ('America/Montevideo', '(GMT-0300) America/Montevideo'), ('America/Paramaribo', '(GMT-0300) America/Paramaribo'), ('America/Recife', '(GMT-0300) America/Recife'), ('America/Santarem', '(GMT-0300) America/Santarem'), ('America/Santiago', '(GMT-0300) America/Santiago'), ('America/Sao_Paulo', '(GMT-0300) America/Sao_Paulo'), ('America/Thule', '(GMT-0300) America/Thule'), ('Antarctica/Palmer', '(GMT-0300) Antarctica/Palmer'), ('Antarctica/Rothera', '(GMT-0300) Antarctica/Rothera'), ('Atlantic/Bermuda', '(GMT-0300) Atlantic/Bermuda'), ('Atlantic/Stanley', '(GMT-0300) Atlantic/Stanley'), ('Canada/Atlantic', '(GMT-0300) Canada/Atlantic'), ('America/St_Johns', '(GMT-0230) America/St_Johns'), ('Canada/Newfoundland', '(GMT-0230) Canada/Newfoundland'), ('America/Godthab', '(GMT-0200) America/Godthab'), ('America/Miquelon', '(GMT-0200) America/Miquelon'), ('America/Noronha', '(GMT-0200) America/Noronha'), ('Atlantic/South_Georgia', '(GMT-0200) Atlantic/South_Georgia'), ('Atlantic/Cape_Verde', '(GMT-0100) Atlantic/Cape_Verde'), ('Africa/Abidjan', '(GMT+0000) Africa/Abidjan'), ('Africa/Accra', '(GMT+0000) Africa/Accra'), ('Africa/Bamako', '(GMT+0000) Africa/Bamako'), ('Africa/Banjul', '(GMT+0000) Africa/Banjul'), ('Africa/Bissau', '(GMT+0000) Africa/Bissau'), ('Africa/Casablanca', '(GMT+0000) Africa/Casablanca'), ('Africa/Conakry', '(GMT+0000) Africa/Conakry'), ('Africa/Dakar', '(GMT+0000) Africa/Dakar'), ('Africa/El_Aaiun', '(GMT+0000) Africa/El_Aaiun'), ('Africa/Freetown', '(GMT+0000) Africa/Freetown'), ('Africa/Lome', '(GMT+0000) Africa/Lome'), ('Africa/Monrovia', '(GMT+0000) Africa/Monrovia'), ('Africa/Nouakchott', '(GMT+0000) Africa/Nouakchott'), ('Africa/Ouagadougou', '(GMT+0000) Africa/Ouagadougou'), ('Africa/Sao_Tome', '(GMT+0000) Africa/Sao_Tome'), ('America/Danmarkshavn', '(GMT+0000) America/Danmarkshavn'), ('America/Scoresbysund', '(GMT+0000) America/Scoresbysund'), ('Atlantic/Azores', '(GMT+0000) Atlantic/Azores'), ('Atlantic/Reykjavik', '(GMT+0000) Atlantic/Reykjavik'), ('Atlantic/St_Helena', '(GMT+0000) Atlantic/St_Helena'), ('GMT', '(GMT+0000) GMT'), ('UTC', '(GMT+0000) UTC'), ('Africa/Algiers', '(GMT+0100) Africa/Algiers'), ('Africa/Bangui', '(GMT+0100) Africa/Bangui'), ('Africa/Brazzaville', '(GMT+0100) Africa/Brazzaville'), ('Africa/Douala', '(GMT+0100) Africa/Douala'), ('Africa/Kinshasa', '(GMT+0100) Africa/Kinshasa'), ('Africa/Lagos', '(GMT+0100) Africa/Lagos'), ('Africa/Libreville', '(GMT+0100) Africa/Libreville'), ('Africa/Luanda', '(GMT+0100) Africa/Luanda'), ('Africa/Malabo', '(GMT+0100) Africa/Malabo'), ('Africa/Ndjamena', '(GMT+0100) Africa/Ndjamena'), ('Africa/Niamey', '(GMT+0100) Africa/Niamey'), ('Africa/Porto-Novo', '(GMT+0100) Africa/Porto-Novo'), ('Africa/Tunis', '(GMT+0100) Africa/Tunis'), ('Africa/Windhoek', '(GMT+0100) Africa/Windhoek'), ('Atlantic/Canary', '(GMT+0100) Atlantic/Canary'), ('Atlantic/Faroe', '(GMT+0100) Atlantic/Faroe'), ('Atlantic/Madeira', '(GMT+0100) Atlantic/Madeira'), ('Europe/Dublin', '(GMT+0100) Europe/Dublin'), ('Europe/Guernsey', '(GMT+0100) Europe/Guernsey'), ('Europe/Isle_of_Man', '(GMT+0100) Europe/Isle_of_Man'), ('Europe/Jersey', '(GMT+0100) Europe/Jersey'), ('Europe/Lisbon', '(GMT+0100) Europe/Lisbon'), ('Europe/London', '(GMT+0100) Europe/London'), ('Africa/Blantyre', '(GMT+0200) Africa/Blantyre'), ('Africa/Bujumbura', '(GMT+0200) Africa/Bujumbura'), ('Africa/Cairo', '(GMT+0200) Africa/Cairo'), ('Africa/Ceuta', '(GMT+0200) Africa/Ceuta'), ('Africa/Gaborone', '(GMT+0200) Africa/Gaborone'), ('Africa/Harare', '(GMT+0200) Africa/Harare'), ('Africa/Johannesburg', '(GMT+0200) Africa/Johannesburg'), ('Africa/Kigali', '(GMT+0200) Africa/Kigali'), ('Africa/Lubumbashi', '(GMT+0200) Africa/Lubumbashi'), ('Africa/Lusaka', '(GMT+0200) Africa/Lusaka'), ('Africa/Maputo', '(GMT+0200) Africa/Maputo'), ('Africa/Maseru', '(GMT+0200) Africa/Maseru'), ('Africa/Mbabane', '(GMT+0200) Africa/Mbabane'), ('Africa/Tripoli', '(GMT+0200) Africa/Tripoli'), ('Antarctica/Troll', '(GMT+0200) Antarctica/Troll'), ('Arctic/Longyearbyen', '(GMT+0200) Arctic/Longyearbyen'), ('Europe/Amsterdam', '(GMT+0200) Europe/Amsterdam'), ('Europe/Andorra', '(GMT+0200) Europe/Andorra'), ('Europe/Belgrade', '(GMT+0200) Europe/Belgrade'), ('Europe/Berlin', '(GMT+0200) Europe/Berlin'), ('Europe/Bratislava', '(GMT+0200) Europe/Bratislava'), ('Europe/Brussels', '(GMT+0200) Europe/Brussels'), ('Europe/Budapest', '(GMT+0200) Europe/Budapest'), ('Europe/Busingen', '(GMT+0200) Europe/Busingen'), ('Europe/Copenhagen', '(GMT+0200) Europe/Copenhagen'), ('Europe/Gibraltar', '(GMT+0200) Europe/Gibraltar'), ('Europe/Kaliningrad', '(GMT+0200) Europe/Kaliningrad'), ('Europe/Ljubljana', '(GMT+0200) Europe/Ljubljana'), ('Europe/Luxembourg', '(GMT+0200) Europe/Luxembourg'), ('Europe/Madrid', '(GMT+0200) Europe/Madrid'), ('Europe/Malta', '(GMT+0200) Europe/Malta'), ('Europe/Monaco', '(GMT+0200) Europe/Monaco'), ('Europe/Oslo', '(GMT+0200) Europe/Oslo'), ('Europe/Paris', '(GMT+0200) Europe/Paris'), ('Europe/Podgorica', '(GMT+0200) Europe/Podgorica'), ('Europe/Prague', '(GMT+0200) Europe/Prague'), ('Europe/Rome', '(GMT+0200) Europe/Rome'), ('Europe/San_Marino', '(GMT+0200) Europe/San_Marino'), ('Europe/Sarajevo', '(GMT+0200) Europe/Sarajevo'), ('Europe/Skopje', '(GMT+0200) Europe/Skopje'), ('Europe/Stockholm', '(GMT+0200) Europe/Stockholm'), ('Europe/Tirane', '(GMT+0200) Europe/Tirane'), ('Europe/Vaduz', '(GMT+0200) Europe/Vaduz'), ('Europe/Vatican', '(GMT+0200) Europe/Vatican'), ('Europe/Vienna', '(GMT+0200) Europe/Vienna'), ('Europe/Warsaw', '(GMT+0200) Europe/Warsaw'), ('Europe/Zagreb', '(GMT+0200) Europe/Zagreb'), ('Europe/Zurich', '(GMT+0200) Europe/Zurich'), ('Africa/Addis_Ababa', '(GMT+0300) Africa/Addis_Ababa'), ('Africa/Asmara', '(GMT+0300) Africa/Asmara'), ('Africa/Dar_es_Salaam', '(GMT+0300) Africa/Dar_es_Salaam'), ('Africa/Djibouti', '(GMT+0300) Africa/Djibouti'), ('Africa/Juba', '(GMT+0300) Africa/Juba'), ('Africa/Kampala', '(GMT+0300) Africa/Kampala'), ('Africa/Khartoum', '(GMT+0300) Africa/Khartoum'), ('Africa/Mogadishu', '(GMT+0300) Africa/Mogadishu'), ('Africa/Nairobi', '(GMT+0300) Africa/Nairobi'), ('Antarctica/Syowa', '(GMT+0300) Antarctica/Syowa'), ('Asia/Aden', '(GMT+0300) Asia/Aden'), ('Asia/Amman', '(GMT+0300) Asia/Amman'), ('Asia/Baghdad', '(GMT+0300) Asia/Baghdad'), ('Asia/Bahrain', '(GMT+0300) Asia/Bahrain'), ('Asia/Beirut', '(GMT+0300) Asia/Beirut'), ('Asia/Damascus', '(GMT+0300) Asia/Damascus'), ('Asia/Gaza', '(GMT+0300) Asia/Gaza'), ('Asia/Hebron', '(GMT+0300) Asia/Hebron'), ('Asia/Jerusalem', '(GMT+0300) Asia/Jerusalem'), ('Asia/Kuwait', '(GMT+0300) Asia/Kuwait'), ('Asia/Nicosia', '(GMT+0300) Asia/Nicosia'), ('Asia/Qatar', '(GMT+0300) Asia/Qatar'), ('Asia/Riyadh', '(GMT+0300) Asia/Riyadh'), ('Europe/Athens', '(GMT+0300) Europe/Athens'), ('Europe/Bucharest', '(GMT+0300) Europe/Bucharest'), ('Europe/Chisinau', '(GMT+0300) Europe/Chisinau'), ('Europe/Helsinki', '(GMT+0300) Europe/Helsinki'), ('Europe/Istanbul', '(GMT+0300) Europe/Istanbul'), ('Europe/Kiev', '(GMT+0300) Europe/Kiev'), ('Europe/Mariehamn', '(GMT+0300) Europe/Mariehamn'), ('Europe/Minsk', '(GMT+0300) Europe/Minsk'), ('Europe/Moscow', '(GMT+0300) Europe/Moscow'), ('Europe/Riga', '(GMT+0300) Europe/Riga'), ('Europe/Simferopol', '(GMT+0300) Europe/Simferopol'), ('Europe/Sofia', '(GMT+0300) Europe/Sofia'), ('Europe/Tallinn', '(GMT+0300) Europe/Tallinn'), ('Europe/Uzhgorod', '(GMT+0300) Europe/Uzhgorod'), ('Europe/Vilnius', '(GMT+0300) Europe/Vilnius'), ('Europe/Volgograd', '(GMT+0300) Europe/Volgograd'), ('Europe/Zaporozhye', '(GMT+0300) Europe/Zaporozhye'), ('Indian/Antananarivo', '(GMT+0300) Indian/Antananarivo'), ('Indian/Comoro', '(GMT+0300) Indian/Comoro'), ('Indian/Mayotte', '(GMT+0300) Indian/Mayotte'), ('Asia/Dubai', '(GMT+0400) Asia/Dubai'), ('Asia/Muscat', '(GMT+0400) Asia/Muscat'), ('Asia/Tbilisi', '(GMT+0400) Asia/Tbilisi'), ('Asia/Yerevan', '(GMT+0400) Asia/Yerevan'), ('Europe/Samara', '(GMT+0400) Europe/Samara'), ('Indian/Mahe', '(GMT+0400) Indian/Mahe'), ('Indian/Mauritius', '(GMT+0400) Indian/Mauritius'), ('Indian/Reunion', '(GMT+0400) Indian/Reunion'), ('Asia/Kabul', '(GMT+0430) Asia/Kabul'), ('Asia/Tehran', '(GMT+0430) Asia/Tehran'), ('Antarctica/Mawson', '(GMT+0500) Antarctica/Mawson'), ('Asia/Aqtau', '(GMT+0500) Asia/Aqtau'), ('Asia/Aqtobe', '(GMT+0500) Asia/Aqtobe'), ('Asia/Ashgabat', '(GMT+0500) Asia/Ashgabat'), ('Asia/Baku', '(GMT+0500) Asia/Baku'), ('Asia/Dushanbe', '(GMT+0500) Asia/Dushanbe'), ('Asia/Karachi', '(GMT+0500) Asia/Karachi'), ('Asia/Oral', '(GMT+0500) Asia/Oral'), ('Asia/Samarkand', '(GMT+0500) Asia/Samarkand'), ('Asia/Tashkent', '(GMT+0500) Asia/Tashkent'), ('Asia/Yekaterinburg', '(GMT+0500) Asia/Yekaterinburg'), ('Indian/Kerguelen', '(GMT+0500) Indian/Kerguelen'), ('Indian/Maldives', '(GMT+0500) Indian/Maldives'), ('Asia/Colombo', '(GMT+0530) Asia/Colombo'), ('Asia/Kolkata', '(GMT+0530) Asia/Kolkata'), ('Asia/Kathmandu', '(GMT+0545) Asia/Kathmandu'), ('Antarctica/Vostok', '(GMT+0600) Antarctica/Vostok'), ('Asia/Almaty', '(GMT+0600) Asia/Almaty'), ('Asia/Bishkek', '(GMT+0600) Asia/Bishkek'), ('Asia/Dhaka', '(GMT+0600) Asia/Dhaka'), ('Asia/Novosibirsk', '(GMT+0600) Asia/Novosibirsk'), ('Asia/Omsk', '(GMT+0600) Asia/Omsk'), ('Asia/Qyzylorda', '(GMT+0600) Asia/Qyzylorda'), ('Asia/Thimphu', '(GMT+0600) Asia/Thimphu'), ('Asia/Urumqi', '(GMT+0600) Asia/Urumqi'), ('Indian/Chagos', '(GMT+0600) Indian/Chagos'), ('Asia/Rangoon', '(GMT+0630) Asia/Rangoon'), ('Indian/Cocos', '(GMT+0630) Indian/Cocos'), ('Antarctica/Davis', '(GMT+0700) Antarctica/Davis'), ('Asia/Bangkok', '(GMT+0700) Asia/Bangkok'), ('Asia/Ho_Chi_Minh', '(GMT+0700) Asia/Ho_Chi_Minh'), ('Asia/Jakarta', '(GMT+0700) Asia/Jakarta'), ('Asia/Krasnoyarsk', '(GMT+0700) Asia/Krasnoyarsk'), ('Asia/Novokuznetsk', '(GMT+0700) Asia/Novokuznetsk'), ('Asia/Phnom_Penh', '(GMT+0700) Asia/Phnom_Penh'), ('Asia/Pontianak', '(GMT+0700) Asia/Pontianak'), ('Asia/Vientiane', '(GMT+0700) Asia/Vientiane'), ('Indian/Christmas', '(GMT+0700) Indian/Christmas'), ('Antarctica/Casey', '(GMT+0800) Antarctica/Casey'), ('Asia/Brunei', '(GMT+0800) Asia/Brunei'), ('Asia/Chita', '(GMT+0800) Asia/Chita'), ('Asia/Hong_Kong', '(GMT+0800) Asia/Hong_Kong'), ('Asia/Hovd', '(GMT+0800) Asia/Hovd'), ('Asia/Irkutsk', '(GMT+0800) Asia/Irkutsk'), ('Asia/Kuala_Lumpur', '(GMT+0800) Asia/Kuala_Lumpur'), ('Asia/Kuching', '(GMT+0800) Asia/Kuching'), ('Asia/Macau', '(GMT+0800) Asia/Macau'), ('Asia/Makassar', '(GMT+0800) Asia/Makassar'), ('Asia/Manila', '(GMT+0800) Asia/Manila'), ('Asia/Shanghai', '(GMT+0800) Asia/Shanghai'), ('Asia/Singapore', '(GMT+0800) Asia/Singapore'), ('Asia/Taipei', '(GMT+0800) Asia/Taipei'), ('Australia/Perth', '(GMT+0800) Australia/Perth'), ('Australia/Eucla', '(GMT+0845) Australia/Eucla'), ('Asia/Choibalsan', '(GMT+0900) Asia/Choibalsan'), ('Asia/Dili', '(GMT+0900) Asia/Dili'), ('Asia/Jayapura', '(GMT+0900) Asia/Jayapura'), ('Asia/Khandyga', '(GMT+0900) Asia/Khandyga'), ('Asia/Pyongyang', '(GMT+0900) Asia/Pyongyang'), ('Asia/Seoul', '(GMT+0900) Asia/Seoul'), ('Asia/Tokyo', '(GMT+0900) Asia/Tokyo'), ('Asia/Ulaanbaatar', '(GMT+0900) Asia/Ulaanbaatar'), ('Asia/Yakutsk', '(GMT+0900) Asia/Yakutsk'), ('Pacific/Palau', '(GMT+0900) Pacific/Palau'), ('Australia/Adelaide', '(GMT+0930) Australia/Adelaide'), ('Australia/Broken_Hill', '(GMT+0930) Australia/Broken_Hill'), ('Australia/Darwin', '(GMT+0930) Australia/Darwin'), ('Antarctica/DumontDUrville', '(GMT+1000) Antarctica/DumontDUrville'), ('Asia/Magadan', '(GMT+1000) Asia/Magadan'), ('Asia/Sakhalin', '(GMT+1000) Asia/Sakhalin'), ('Asia/Ust-Nera', '(GMT+1000) Asia/Ust-Nera'), ('Asia/Vladivostok', '(GMT+1000) Asia/Vladivostok'), ('Australia/Brisbane', '(GMT+1000) Australia/Brisbane'), ('Australia/Currie', '(GMT+1000) Australia/Currie'), ('Australia/Hobart', '(GMT+1000) Australia/Hobart'), ('Australia/Lindeman', '(GMT+1000) Australia/Lindeman'), ('Australia/Melbourne', '(GMT+1000) Australia/Melbourne'), ('Australia/Sydney', '(GMT+1000) Australia/Sydney'), ('Pacific/Chuuk', '(GMT+1000) Pacific/Chuuk'), ('Pacific/Guam', '(GMT+1000) Pacific/Guam'), ('Pacific/Port_Moresby', '(GMT+1000) Pacific/Port_Moresby'), ('Pacific/Saipan', '(GMT+1000) Pacific/Saipan'), ('Australia/Lord_Howe', '(GMT+1030) Australia/Lord_Howe'), ('Antarctica/Macquarie', '(GMT+1100) Antarctica/Macquarie'), ('Asia/Srednekolymsk', '(GMT+1100) Asia/Srednekolymsk'), ('Pacific/Bougainville', '(GMT+1100) Pacific/Bougainville'), ('Pacific/Efate', '(GMT+1100) Pacific/Efate'), ('Pacific/Guadalcanal', '(GMT+1100) Pacific/Guadalcanal'), ('Pacific/Kosrae', '(GMT+1100) Pacific/Kosrae'), ('Pacific/Noumea', '(GMT+1100) Pacific/Noumea'), ('Pacific/Pohnpei', '(GMT+1100) Pacific/Pohnpei'), ('Pacific/Norfolk', '(GMT+1130) Pacific/Norfolk'), ('Antarctica/McMurdo', '(GMT+1200) Antarctica/McMurdo'), ('Asia/Anadyr', '(GMT+1200) Asia/Anadyr'), ('Asia/Kamchatka', '(GMT+1200) Asia/Kamchatka'), ('Pacific/Auckland', '(GMT+1200) Pacific/Auckland'), ('Pacific/Fiji', '(GMT+1200) Pacific/Fiji'), ('Pacific/Funafuti', '(GMT+1200) Pacific/Funafuti'), ('Pacific/Kwajalein', '(GMT+1200) Pacific/Kwajalein'), ('Pacific/Majuro', '(GMT+1200) Pacific/Majuro'), ('Pacific/Nauru', '(GMT+1200) Pacific/Nauru'), ('Pacific/Tarawa', '(GMT+1200) Pacific/Tarawa'), ('Pacific/Wake', '(GMT+1200) Pacific/Wake'), ('Pacific/Wallis', '(GMT+1200) Pacific/Wallis'), ('Pacific/Chatham', '(GMT+1245) Pacific/Chatham'), ('Pacific/Apia', '(GMT+1300) Pacific/Apia'), ('Pacific/Enderbury', '(GMT+1300) Pacific/Enderbury'), ('Pacific/Fakaofo', '(GMT+1300) Pacific/Fakaofo'), ('Pacific/Tongatapu', '(GMT+1300) Pacific/Tongatapu'), ('Pacific/Kiritimati', '(GMT+1400) Pacific/Kiritimati')])),
                ('mark_registration_ended', models.BooleanField(default=False, verbose_name='Registration Ended')),
                ('enable_private_slug', models.BooleanField(blank=True, default=False, verbose_name='Enable Private URL')),
                ('private_slug', models.CharField(default='', max_length=500, blank=True)),
                ('password', models.CharField(max_length=50, blank=True)),
                ('on_weekend', models.BooleanField(default=True, help_text='This event occurs on weekends')),
                ('external_url', models.URLField(default='', verbose_name='External URL', blank=True)),
                ('tags', tagging.fields.TagField(max_length=255, blank=True)),
                ('priority', models.BooleanField(default=False, help_text='Priority events will show up at the top of the event calendar day list and single day list. They will be featured with a star icon on the monthly calendar and the list view.')),
                ('is_recurring_event', models.BooleanField(default=False, verbose_name='Is Recurring Event')),
                ('display_event_registrants', models.BooleanField(default=False, verbose_name='Display Attendees')),
                ('display_registrants_to', models.CharField(default='admin', max_length=6, choices=[('public', 'Everyone'), ('user', 'Users Only'), ('member', 'Members Only'), ('admin', 'Admin Only')])),
                ('creator', models.ForeignKey(related_name='events_event_creator', on_delete=django.db.models.deletion.SET_NULL, default=None, editable=False, to=settings.AUTH_USER_MODEL, null=True)),
                ('entity', models.ForeignKey(related_name='events_event_entity', on_delete=django.db.models.deletion.SET_NULL, default=None, blank=True, to='entities.Entity', null=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, default=tendenci.apps.user_groups.utils.get_default_group, to='user_groups.Group', null=True)),
            ],
            options={
            },
        ),
        migrations.CreateModel(
            name='EventPhoto',
            fields=[
                ('file_ptr', models.OneToOneField(parent_link=True, auto_created=True, primary_key=True, serialize=False, on_delete=django.db.models.deletion.CASCADE, to='files.File')),
            ],
            bases=('files.file',),
        ),
        migrations.CreateModel(
            name='Organizer',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100, blank=True)),
                ('description', models.TextField(blank=True)),
                ('event', models.ManyToManyField(to='events.Event', blank=True)),
                ('user', models.OneToOneField(null=True, blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Payment',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
            ],
        ),
        migrations.CreateModel(
            name='PaymentMethod',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('label', models.CharField(max_length=50)),
            ],
        ),
        migrations.CreateModel(
            name='Place',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=150, blank=True)),
                ('description', models.TextField(blank=True)),
                ('address', models.CharField(max_length=150, blank=True)),
                ('city', models.CharField(max_length=150, blank=True)),
                ('state', models.CharField(max_length=150, blank=True)),
                ('zip', models.CharField(max_length=150, blank=True)),
                ('country', models.CharField(max_length=150, blank=True)),
                ('url', models.URLField(blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='RecurringEvent',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('repeat_type', models.IntegerField(verbose_name='Repeats', choices=[(1, 'Day(s)'), (2, 'Week(s)'), (3, 'Month(s)'), (4, 'Year(s)')])),
                ('frequency', models.IntegerField(verbose_name='Repeats every')),
                ('starts_on', models.DateTimeField(default=datetime.datetime(2015, 7, 30, 14, 47, 38, 7206))),
                ('ends_on', models.DateTimeField()),
            ],
            options={
                'verbose_name': 'Recurring Event',
                'verbose_name_plural': 'Recurring Events',
            },
        ),
        migrations.CreateModel(
            name='RegAddon',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('amount', models.DecimalField(default=0, verbose_name='Amount', max_digits=21, decimal_places=2)),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('addon', models.ForeignKey(to='events.Addon', on_delete=django.db.models.deletion.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='RegAddonOption',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('option', models.ForeignKey(to='events.AddonOption', on_delete=django.db.models.deletion.CASCADE)),
                ('regaddon', models.ForeignKey(to='events.RegAddon', on_delete=django.db.models.deletion.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='RegConfPricing',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('position', models.IntegerField(default=0, null=True, verbose_name='Position', blank=True)),
                ('title', models.CharField(max_length=500, verbose_name='Pricing display name', blank=True)),
                ('description', models.TextField(verbose_name='Pricing description', blank=True)),
                ('quantity', models.IntegerField(default=1, help_text='Total people included in each registration for this pricing group. Ex: Table or Team.', verbose_name='Number of attendees', blank=True)),
                ('price', models.DecimalField(default=0, verbose_name='Price', max_digits=21, decimal_places=2)),
                ('include_tax', models.BooleanField(default=False)),
                ('tax_rate', models.DecimalField(default=0, help_text='Example: 0.0825 for 8.25%.', max_digits=5, decimal_places=4, blank=True)),
                ('payment_required', models.BooleanField(default=False, help_text='A payment required before registration is accepted.')),
                ('start_dt', models.DateTimeField(verbose_name='Start Date')),
                ('end_dt', models.DateTimeField(verbose_name='End Date')),
                ('allow_anonymous', models.BooleanField(default=False, verbose_name='Public can use this pricing')),
                ('allow_user', models.BooleanField(default=False, verbose_name='Signed in user can use this pricing')),
                ('allow_member', models.BooleanField(default=False, verbose_name='All members can use this pricing')),
                ('status', models.BooleanField(default=True)),
                ('groups', models.ManyToManyField(to='user_groups.Group', blank=True)),
            ],
        ),
        migrations.CreateModel(
            name='Registrant',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('amount', models.DecimalField(default=0, verbose_name='Amount', max_digits=21, decimal_places=2, blank=True)),
                ('name', models.CharField(max_length=100)),
                ('first_name', models.CharField(max_length=100)),
                ('last_name', models.CharField(max_length=100)),
                ('mail_name', models.CharField(max_length=100, blank=True)),
                ('address', models.CharField(max_length=200, blank=True)),
                ('city', models.CharField(max_length=100, blank=True)),
                ('state', models.CharField(max_length=100, blank=True)),
                ('zip', models.CharField(max_length=50, blank=True)),
                ('country', models.CharField(max_length=100, blank=True)),
                ('phone', models.CharField(max_length=50, blank=True)),
                ('email', models.CharField(max_length=100)),
                ('groups', models.CharField(max_length=100)),
                ('position_title', models.CharField(max_length=100, blank=True)),
                ('company_name', models.CharField(max_length=100, blank=True)),
                ('meal_option', models.CharField(default='', max_length=200, blank=True)),
                ('comments', models.TextField(default='', blank=True)),
                ('is_primary', models.BooleanField(default=False, verbose_name='Is primary registrant')),
                ('override', models.BooleanField(default=False, verbose_name='Admin Price Override?')),
                ('override_price', models.DecimalField(default=0, verbose_name='Override Price', max_digits=21, decimal_places=2, blank=True)),
                ('discount_amount', models.DecimalField(default=0, verbose_name='Discount Amount', max_digits=10, decimal_places=2)),
                ('cancel_dt', models.DateTimeField(null=True, editable=False)),
                ('memberid', models.CharField(max_length=50, null=True, verbose_name='Member ID', blank=True)),
                ('use_free_pass', models.BooleanField(default=False)),
                ('checked_in', models.BooleanField(default=False, verbose_name='Is Checked In?')),
                ('checked_in_dt', models.DateTimeField(null=True)),
                ('reminder', models.BooleanField(default=False, verbose_name='Receive event reminders')),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('custom_reg_form_entry', models.ForeignKey(related_name='registrants', to='events.CustomRegFormEntry', null=True, on_delete=django.db.models.deletion.CASCADE)),
                ('pricing', models.ForeignKey(to='events.RegConfPricing', null=True, on_delete=django.db.models.deletion.CASCADE)),
            ],
            options={
            },
        ),
        migrations.CreateModel(
            name='Registration',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('guid', models.TextField(max_length=40, editable=False)),
                ('note', models.TextField(blank=True)),
                ('reminder', models.BooleanField(default=False)),
                ('amount_paid', models.DecimalField(verbose_name='Amount Paid', max_digits=21, decimal_places=2)),
                ('is_table', models.BooleanField(default=False, verbose_name='Is table registration')),
                ('quantity', models.IntegerField(default=1, verbose_name='Number of registrants for a table')),
                ('override_table', models.BooleanField(default=False, verbose_name='Admin Price Override?')),
                ('override_price_table', models.DecimalField(default=0, verbose_name='Override Price', max_digits=21, decimal_places=2, blank=True)),
                ('canceled', models.BooleanField(default=False, verbose_name='Canceled')),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('addons_added', models.TextField(null=True, blank=True)),
                ('creator', models.ForeignKey(related_name='created_registrations', on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, null=True)),
                ('event', models.ForeignKey(to='events.Event', on_delete=django.db.models.deletion.CASCADE)),
                ('invoice', models.ForeignKey(blank=True, to='invoices.Invoice', null=True, on_delete=django.db.models.deletion.CASCADE)),
                ('owner', models.ForeignKey(related_name='owned_registrations', on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL, null=True)),
                ('payment_method', models.ForeignKey(to='payments.PaymentMethod', null=True, on_delete=django.db.models.deletion.CASCADE)),
                ('reg_conf_price', models.ForeignKey(to='events.RegConfPricing', null=True, on_delete=django.db.models.deletion.CASCADE)),
            ],
            options={
            },
        ),
        migrations.CreateModel(
            name='RegistrationConfiguration',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('payment_required', models.BooleanField(default=True, help_text='A payment required before registration is accepted.')),
                ('limit', models.IntegerField(default=0, verbose_name='Registration Limit')),
                ('enabled', models.BooleanField(default=False, verbose_name='Enable Registration')),
                ('require_guests_info', models.BooleanField(default=False, help_text='If checked, the required fields in registration form are also required for guests.  ', verbose_name='Require Guests Info')),
                ('is_guest_price', models.BooleanField(default=False, verbose_name='Guests Pay Registrant Price')),
                ('discount_eligible', models.BooleanField(default=True)),
                ('allow_free_pass', models.BooleanField(default=False)),
                ('display_registration_stats', models.BooleanField(default=False, help_text='Display the number of spots registered and the number of spots left to the public.', verbose_name='Publicly Show Registration Stats')),
                ('use_custom_reg_form', models.BooleanField(default=False, verbose_name='Use Custom Registration Form')),
                ('bind_reg_form_to_conf_only', models.BooleanField(default=True, verbose_name=' ', choices=[(True, 'Use one form for all pricings'), (False, 'Use separate form for each pricing')])),
                ('send_reminder', models.BooleanField(default=False, verbose_name='Send Email Reminder to attendees')),
                ('reminder_days', models.CharField(help_text='Comma delimited. Ex: 7,1', max_length=20, null=True, verbose_name='Specify when (? days before the event starts) the reminder should be sent ', blank=True)),
                ('registration_email_type', models.CharField(default='default', max_length=20, verbose_name='Registration Email', choices=[('default', 'Default Email Only'), ('custom', 'Custom Email Only'), ('both', 'Default and Custom Email')])),
                ('registration_email_text', models.TextField(verbose_name='Registration Email Text', blank=True)),
                ('create_dt', models.DateTimeField(auto_now_add=True)),
                ('update_dt', models.DateTimeField(auto_now=True)),
                ('email', models.ForeignKey(to='emails.Email', null=True, on_delete=django.db.models.deletion.CASCADE)),
                ('payment_method', models.ManyToManyField(to='payments.PaymentMethod')),
                ('reg_form', models.ForeignKey(related_name='regconfs', blank=True, to='events.CustomRegForm', help_text="You'll have the chance to edit the selected form", null=True, verbose_name='Custom Registration Form', on_delete=django.db.models.deletion.CASCADE)),
            ],
        ),
        migrations.CreateModel(
            name='Speaker',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=100, verbose_name='Speaker Name', blank=True)),
                ('description', models.TextField(blank=True)),
                ('featured', models.BooleanField(default=False, help_text='All speakers marked as featured will be displayed when viewing the event.')),
                ('event', models.ManyToManyField(to='events.Event', blank=True)),
                ('user', models.OneToOneField(null=True, blank=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Sponsor',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('event', models.ManyToManyField(to='events.Event')),
            ],
        ),
        migrations.CreateModel(
            name='Type',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('name', models.CharField(max_length=50)),
                ('slug', models.SlugField(editable=False)),
            ],
        ),
        migrations.CreateModel(
            name='TypeColorSet',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('fg_color', models.CharField(max_length=20)),
                ('bg_color', models.CharField(max_length=20)),
                ('border_color', models.CharField(max_length=20)),
            ],
        ),
        migrations.AddField(
            model_name='type',
            name='color_set',
            field=models.ForeignKey(to='events.TypeColorSet', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='registrant',
            name='registration',
            field=models.ForeignKey(to='events.Registration', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='registrant',
            name='user',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AddField(
            model_name='regconfpricing',
            name='reg_conf',
            field=models.ForeignKey(blank=True, to='events.RegistrationConfiguration', null=True, on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='regconfpricing',
            name='reg_form',
            field=models.ForeignKey(related_name='regconfpricings', blank=True, to='events.CustomRegForm', help_text="You'll have the chance to edit the selected form", null=True, verbose_name='Custom Registration Form', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='regaddon',
            name='registration',
            field=models.ForeignKey(to='events.Registration', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='payment',
            name='registration',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='events.Registration'),
        ),
        migrations.AddField(
            model_name='event',
            name='image',
            field=models.ForeignKey(blank=True, to='events.EventPhoto', help_text='Photo that represents this event.', null=True, on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='event',
            name='meta',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='meta.Meta'),
        ),
        migrations.AddField(
            model_name='event',
            name='owner',
            field=models.ForeignKey(related_name='events_event_owner', on_delete=django.db.models.deletion.SET_NULL, default=None, to=settings.AUTH_USER_MODEL, null=True),
        ),
        migrations.AddField(
            model_name='event',
            name='place',
            field=models.ForeignKey(to='events.Place', null=True, on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='event',
            name='recurring_event',
            field=models.ForeignKey(to='events.RecurringEvent', null=True, on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='event',
            name='registration_configuration',
            field=models.OneToOneField(null=True, editable=False, on_delete=django.db.models.deletion.CASCADE, to='events.RegistrationConfiguration'),
        ),
        migrations.AddField(
            model_name='event',
            name='type',
            field=models.ForeignKey(on_delete=django.db.models.deletion.SET_NULL, blank=True, to='events.Type', null=True),
        ),
        migrations.AddField(
            model_name='discount',
            name='event',
            field=models.ForeignKey(to='events.Event', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='customregfieldentry',
            name='entry',
            field=models.ForeignKey(related_name='field_entries', to='events.CustomRegFormEntry', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='customregfieldentry',
            name='field',
            field=models.ForeignKey(related_name='entries', to='events.CustomRegField', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='customregfield',
            name='form',
            field=models.ForeignKey(related_name='fields', to='events.CustomRegForm', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='addon',
            name='event',
            field=models.ForeignKey(to='events.Event', on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AddField(
            model_name='addon',
            name='group',
            field=models.ForeignKey(blank=True, to='user_groups.Group', null=True, on_delete=django.db.models.deletion.CASCADE),
        ),
        migrations.AlterUniqueTogether(
            name='regaddonoption',
            unique_together=set([('regaddon', 'option')]),
        ),
    ]
